/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.PublicKey;
import cn.com.westone.wcspsdk.baseservice.co.Verifier;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.SignatureImpl;

public class VerifierImpl
extends SignatureImpl
implements Verifier {
    private long hContext = 0L;
    private long updated = 0L;

    @Override
    public void update(byte[] input) throws WCSPException {
        if (null == input || input.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("Verify object has been finished");
        }
        WCSPCO.WCSP_CO_VerifyUpdate(this.hContext, input);
        this.updated += (long)input.length;
    }

    @Override
    public boolean doFinal(byte[] signature) throws WCSPException {
        if (this.updated < 1L || null == signature || signature.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" or \"signature\" is null");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("Verify object has been finished");
        }
        int[] pResult = new int[]{0};
        try {
            WCSPCO.WCSP_CO_VerifyFinal(this.hContext, new byte[0], signature, pResult);
        }
        finally {
            this.updated = 0L;
            this.hContext = 0L;
        }
        return 1 == pResult[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doFinal(byte[] input, byte[] signature) throws WCSPException {
        if (null == input || input.length < 1 || null == signature || signature.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" or \"signature\" is null");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("Verify object has been finished");
        }
        int[] pResult = new int[]{0};
        try {
            WCSPCO.WCSP_CO_VerifyFinal(this.hContext, input, signature, pResult);
        }
        finally {
            this.updated = 0L;
            this.hContext = 0L;
        }
        return 1 == pResult[0];
    }

    @Override
    public void reset() throws WCSPException {
        if (0L == this.hPublicKey()) {
            throw new IllegalStateException("Verify object has been finalized");
        }
        if (0L != this.hContext) {
            if (this.updated < 1L) {
                return;
            }
            try {
                WCSPCO.WCSP_CO_VerifyFinal(this.hContext, new byte[0], new byte[this.getSignatureLength()], new int[1]);
            }
            finally {
                this.updated = 0L;
                this.hContext = 0L;
            }
        }
        long[] phContext = new long[]{0L};
        WCSPCO.WCSP_CO_VerifyInit(this.hPublicKey(), phContext);
        this.hContext = phContext[0];
        this.updated = 0L;
    }

    @Override
    public void close() {
        if (0L != this.hContext) {
            try {
                WCSPCO.WCSP_CO_FreeContext(this.hContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updated = 0L;
            this.hContext = 0L;
        }
        super.close();
    }

    VerifierImpl(String algorithm, COServiceImpl coService) {
        super(algorithm, coService);
    }

    @Override
    void init(PublicKey publicKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        super.init(publicKey);
        long[] phContext = new long[]{0L};
        WCSPCO.WCSP_CO_VerifyInit(this.hPublicKey(), phContext);
        this.hContext = phContext[0];
        this.updated = 0L;
    }
}

