/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.Decryptor;
import cn.com.westone.wcspsdk.baseservice.co.SecretKey;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.SymmCipherImpl;

public class SymmDecryptorImpl
extends SymmCipherImpl
implements Decryptor {
    private long hContext = 0L;
    private long updated = 0L;

    @Override
    public byte[] update(byte[] input) throws WCSPException {
        if (null == input || input.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("Decryptor object has been finished");
        }
        byte[][] pData = new byte[][]{null};
        WCSPCO.WCSP_CO_SymmDecryptUpdate(this.hContext, input, pData);
        this.updated += (long)input.length;
        return pData[0];
    }

    @Override
    public byte[] doFinal() throws WCSPException {
        if (this.updated < 1L) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("Decryptor object has been finished");
        }
        byte[][] pData = new byte[][]{null};
        try {
            WCSPCO.WCSP_CO_SymmDecryptFinal(this.hContext, pData);
        }
        finally {
            this.updated = 0L;
            this.hContext = 0L;
        }
        return pData[0];
    }

    @Override
    public byte[] doFinal(byte[] input) throws WCSPException {
        if (null == input || input.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("Decryptor object has been finished");
        }
        byte[][] pData = new byte[][]{null};
        try {
            WCSPCO.WCSP_CO_SymmDecryptFinal(this.hContext, input, pData);
        }
        finally {
            this.updated = 0L;
            this.hContext = 0L;
        }
        return pData[0];
    }

    @Override
    public void reset() throws WCSPException {
        if (0L == this.hSecretKey()) {
            throw new IllegalStateException("Decryptor object has been finalized");
        }
        if (0L != this.hContext) {
            if (this.updated < 1L) {
                return;
            }
            try {
                WCSPCO.WCSP_CO_FreeContext(this.hContext);
            }
            finally {
                this.updated = 0L;
                this.hContext = 0L;
            }
        }
        long[] phContext = new long[]{0L};
        WCSPCO.WCSP_CO_SymmDecryptInit(this.hSecretKey(), this.iv(), this.paddingType(), phContext);
        this.hContext = phContext[0];
        this.updated = 0L;
    }

    @Override
    public void close() {
        if (0L != this.hContext) {
            try {
                WCSPCO.WCSP_CO_FreeContext(this.hContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updated = 0L;
            this.hContext = 0L;
        }
        super.close();
    }

    SymmDecryptorImpl(String padding, String mode, String algorithm, COServiceImpl coService) {
        super(padding, mode, algorithm, coService);
    }

    @Override
    void init(SecretKey secretKey, byte[] iv) throws InvalidParameterException, InvalidKeyException, WCSPException {
        super.init(secretKey, iv);
        long[] phContext = new long[]{0L};
        WCSPCO.WCSP_CO_SymmDecryptInit(this.hSecretKey(), this.iv(), this.paddingType(), phContext);
        this.hContext = phContext[0];
        this.updated = 0L;
    }
}

