/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.SecretKey;
import cn.com.westone.wcspsdk.baseservice.km.KMSecretKey;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.COObjectImpl;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.SecretKeyImpl;

abstract class SymmCipherImpl
extends COObjectImpl {
    private long hSecretKey = 0L;
    private SecretKey secretKey = null;
    private byte[] iv = null;
    private int paddingType = 0;
    private final String padding;
    private final String mode;

    public SecretKey key() {
        return this.secretKey;
    }

    public byte[] iv() {
        return this.iv;
    }

    public String padding() {
        return this.padding;
    }

    public String mode() {
        return this.mode;
    }

    SymmCipherImpl(String padding, String mode, String algorithm, COServiceImpl coService) {
        super(algorithm, coService);
        if (null == mode || mode.isEmpty() || null == padding || padding.isEmpty()) {
            throw new IllegalArgumentException("Argument \"mode\" or \"padding\" is null");
        }
        this.padding = padding;
        this.mode = mode;
    }

    void init(SecretKey secretKey, byte[] iv) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == secretKey || null == iv) {
            throw new IllegalArgumentException("Argument \"secretKey\" or \"iv\" is null");
        }
        switch (this.padding) {
            case "NoPadding": {
                this.paddingType = 0;
                break;
            }
            case "PKCS7Padding": {
                this.paddingType = 1;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid padding: " + this.padding);
            }
        }
        if (secretKey instanceof SecretKeyImpl) {
            this.getAlgorithmId(secretKey, iv);
            this.hSecretKey = ((SecretKeyImpl)secretKey).handle();
        } else if (secretKey instanceof KMSecretKey) {
            int algorithmId = this.getAlgorithmId((KMSecretKey)secretKey, iv);
            long[] phSecretKey = new long[]{0L};
            WCSPCO.WCSP_CO_ImportSessionKeyFromKms(this.service().handle(), algorithmId, ((KMSecretKey)secretKey).keyId(), phSecretKey);
            this.hSecretKey = phSecretKey[0];
        } else {
            throw new InvalidKeyException("Invalid secretKey object");
        }
        this.secretKey = secretKey;
        this.iv = iv;
    }

    long hSecretKey() {
        return this.hSecretKey;
    }

    int paddingType() {
        return this.paddingType;
    }

    @Override
    void close() {
        if (0L != this.hSecretKey) {
            try {
                if (!(this.secretKey instanceof SecretKeyImpl)) {
                    WCSPCO.WCSP_CO_CloseHandle(this.hSecretKey);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hSecretKey = 0L;
        }
        super.close();
    }

    private int getAlgorithmId(SecretKey secretKey, byte[] iv) throws InvalidParameterException, InvalidKeyException {
        int algorithmId;
        block3 : switch (this.algorithm()) {
            case "SM4": {
                block10 : switch (this.mode) {
                    case "ECB": {
                        algorithmId = 1025;
                        if (iv.length > 0) {
                            throw new InvalidKeyException("Invalid iv");
                        }
                        switch (secretKey.algorithm()) {
                            case "SM4_ECB": {
                                break block10;
                            }
                        }
                        throw new InvalidKeyException("Invalid secretKey algorithm: " + secretKey.algorithm());
                    }
                    case "CBC": {
                        algorithmId = 1026;
                        if (secretKey.length() != iv.length) {
                            throw new InvalidKeyException("Invalid iv");
                        }
                        switch (secretKey.algorithm()) {
                            case "SM4_CBC": {
                                break block10;
                            }
                        }
                        throw new InvalidKeyException("Invalid secretKey algorithm: " + secretKey.algorithm());
                    }
                    default: {
                        throw new InvalidParameterException("Invalid mode: " + this.mode);
                    }
                }
                switch (secretKey.usage()) {
                    case "ENC": {
                        break block3;
                    }
                }
                throw new InvalidKeyException("Invalid secretKey usage: " + secretKey.usage());
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + this.algorithm());
            }
        }
        return algorithmId;
    }

    private int getAlgorithmId(KMSecretKey secretKey, byte[] iv) throws InvalidParameterException, InvalidKeyException {
        int algorithmId;
        block3 : switch (this.algorithm()) {
            case "SM4": {
                switch (this.mode) {
                    case "ECB": {
                        algorithmId = 1025;
                        if (iv.length <= 0) break;
                        throw new InvalidKeyException("Invalid iv");
                    }
                    case "CBC": {
                        algorithmId = 1026;
                        if (secretKey.length() == iv.length) break;
                        throw new InvalidKeyException("Invalid iv");
                    }
                    default: {
                        throw new InvalidParameterException("Invalid mode: " + this.mode);
                    }
                }
                switch (secretKey.algorithm()) {
                    case "SM4": {
                        break;
                    }
                    default: {
                        throw new InvalidKeyException("Invalid secretKey algorithm: " + secretKey.algorithm());
                    }
                }
                switch (secretKey.usage()) {
                    case "ENC": {
                        break block3;
                    }
                }
                throw new InvalidKeyException("Invalid secretKey usage: " + secretKey.usage());
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + this.algorithm());
            }
        }
        return algorithmId;
    }
}

