/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.PrivateKey;
import cn.com.westone.wcspsdk.baseservice.co.Signer;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.SignatureImpl;

public class SignerImpl
extends SignatureImpl
implements Signer {
    private long hContext = 0L;
    private long updated = 0L;

    @Override
    public void update(byte[] input) throws WCSPException {
        if (null == input || input.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("Sign object has been finished");
        }
        WCSPCO.WCSP_CO_SignUpdate(this.hContext, input);
        this.updated += (long)input.length;
    }

    @Override
    public byte[] doFinal() throws WCSPException {
        if (this.updated < 1L) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("Sign object has been finished");
        }
        byte[][] pSignature = new byte[][]{null};
        try {
            WCSPCO.WCSP_CO_SignFinal(this.hContext, new byte[0], pSignature);
        }
        finally {
            this.updated = 0L;
            this.hContext = 0L;
        }
        return pSignature[0];
    }

    @Override
    public byte[] doFinal(byte[] input) throws WCSPException {
        if (null == input || input.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("Sign object has been finished");
        }
        byte[][] pSignature = new byte[][]{null};
        try {
            WCSPCO.WCSP_CO_SignFinal(this.hContext, input, pSignature);
        }
        finally {
            this.updated = 0L;
            this.hContext = 0L;
        }
        return pSignature[0];
    }

    @Override
    public void reset() throws WCSPException {
        if (0L == this.hPrivateKey()) {
            throw new IllegalStateException("Sign object has been finalized");
        }
        if (0L != this.hContext) {
            if (this.updated < 1L) {
                return;
            }
            try {
                WCSPCO.WCSP_CO_FreeContext(this.hContext);
            }
            finally {
                this.updated = 0L;
                this.hContext = 0L;
            }
        }
        long[] phContext = new long[]{0L};
        WCSPCO.WCSP_CO_SignInit(this.hPrivateKey(), phContext);
        this.hContext = phContext[0];
        this.updated = 0L;
    }

    @Override
    public void close() {
        if (0L != this.hContext) {
            try {
                WCSPCO.WCSP_CO_FreeContext(this.hContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updated = 0L;
            this.hContext = 0L;
        }
        super.close();
    }

    SignerImpl(String algorithm, COServiceImpl coService) {
        super(algorithm, coService);
    }

    @Override
    void init(PrivateKey privateKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        super.init(privateKey);
        long[] phContext = new long[]{0L};
        WCSPCO.WCSP_CO_SignInit(this.hPrivateKey(), phContext);
        this.hContext = phContext[0];
        this.updated = 0L;
    }
}

