/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.Key;
import cn.com.westone.wcspsdk.impl.ServiceImpl;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;

public abstract class KeyImpl
implements Key {
    private long handle;
    private final String usage;
    private final String name;
    private final String algorithm;
    private final COServiceImpl coService;

    @Override
    public String usage() {
        return this.usage;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String algorithm() {
        return this.algorithm;
    }

    @Override
    public COServiceImpl service() {
        return this.coService;
    }

    @Override
    public void close() {
        if (0L != this.handle) {
            try {
                WCSPCO.WCSP_CO_CloseHandle(this.handle);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.handle = 0L;
        }
    }

    protected void finalize() {
        try (ServiceImpl.StateKeeper keeper = this.coService.keepState();){
            if (keeper.hasFinalized()) {
                return;
            }
            this.close();
        }
    }

    KeyImpl(long handle, String usage, String name, String algorithm, COServiceImpl coService) {
        this.handle = handle;
        this.usage = usage;
        this.name = name;
        this.algorithm = algorithm;
        this.coService = coService;
    }

    long handle() {
        return this.handle;
    }

    void remove() throws WCSPException {
        if (0L != this.handle) {
            try {
                WCSPCO.WCSP_CO_CloseHandle(this.handle);
            }
            finally {
                this.handle = 0L;
            }
        }
    }
}

