/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.SecretKey;
import cn.com.westone.wcspsdk.baseservice.km.KMSecretKey;
import cn.com.westone.wcspsdk.impl.ServiceImpl;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.SecretKeyImpl;
import cn.com.westone.wcspsdk.impl.jni.FileJNI;
import cn.com.westone.wcspsdk.impl.jni.JNIUtils;

public class FileIOCipherImpl
implements AutoCloseable {
    private long hSecretKey = 0L;
    private long hFile = 0L;
    private SecretKey secretKey = null;
    private COServiceImpl coService;

    public void write(byte[] data) throws WCSPException {
        if (0L == this.hFile) {
            throw new IllegalStateException("FileCipher object has been finished");
        }
        JNIUtils.WCSP_LOG_D("WCSP_File_Write IN hFile[{}{}] data[{}]", "0x", this.hFile, data);
        JNIUtils.WCSP_CHECK("WCSP_File_Write", FileJNI.wcsp_File_Write(this.hFile, data), new int[0]);
    }

    public byte[] read(int length) throws WCSPException {
        if (0L == this.hFile) {
            throw new IllegalStateException("FileCipher object has been finished");
        }
        JNIUtils.WCSP_LOG_D("WCSP_File_Eof IN", new Object[0]);
        if (0 != FileJNI.wcsp_File_Eof(this.hFile)) {
            return null;
        }
        JNIUtils.WCSP_LOG_D("WCSP_File_Eof OUT 0", new Object[0]);
        byte[][] pData = new byte[][]{null};
        JNIUtils.WCSP_LOG_D("WCSP_File_Read IN hFile[{}{}] length[{}]", "0x", this.hFile, length);
        JNIUtils.WCSP_CHECK("WCSP_File_Read", FileJNI.wcsp_File_Read(this.hFile, pData, length), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_File_Read OUT data[{}]", new Object[]{pData[0]});
        return pData[0];
    }

    @Override
    public void close() {
        if (0L != this.hFile) {
            try {
                JNIUtils.WCSP_LOG_D("WCSP_File_Close IN hFile[{}{}]", "0x", this.hFile);
                JNIUtils.WCSP_CHECK("WCSP_File_Close", FileJNI.wcsp_File_Close(this.hFile), new int[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hFile = 0L;
        }
        if (0L != this.hSecretKey) {
            try {
                if (!(this.secretKey instanceof SecretKeyImpl)) {
                    WCSPCO.WCSP_CO_CloseHandle(this.hSecretKey);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hSecretKey = 0L;
        }
    }

    protected void finalize() {
        try (ServiceImpl.StateKeeper keeper = this.coService.keepState();){
            if (keeper.hasFinalized()) {
                return;
            }
            this.close();
        }
    }

    FileIOCipherImpl(COServiceImpl coService) {
        this.coService = coService;
    }

    void init(SecretKey secretKey, String fileName, OPMode opMode) throws InvalidKeyException, WCSPException {
        if (null == secretKey || null == fileName || fileName.isEmpty() || null == opMode) {
            throw new IllegalArgumentException("Argument \"secretKey\" or \"fileName\" or \"fileName\" is null");
        }
        switch (secretKey.usage()) {
            case "ENC": {
                break;
            }
            default: {
                throw new InvalidKeyException("Invalid secretKey usage: " + secretKey.usage());
            }
        }
        if (secretKey instanceof SecretKeyImpl) {
            this.hSecretKey = ((SecretKeyImpl)secretKey).handle();
        } else if (secretKey instanceof KMSecretKey) {
            long[] phSecretKey = new long[]{0L};
            WCSPCO.WCSP_CO_ImportSessionKeyFromKms(this.coService.handle(), 1025, ((KMSecretKey)secretKey).keyId(), phSecretKey);
            this.hSecretKey = phSecretKey[0];
        } else {
            throw new InvalidKeyException("Invalid secretKey object");
        }
        this.secretKey = secretKey;
        JNIUtils.WCSP_LOG_D("WCSP_File_OpenWithSessionkey IN fileName[{}] hCOService[{}{}] hKey[{}{}] mode[{}]", fileName, "0x", this.coService.handle(), "0x", this.hSecretKey, opMode.value);
        long hFileRes = FileJNI.wcsp_File_OpenWithSessionkey(fileName, this.coService.handle(), this.hSecretKey, opMode.value);
        if (0L == hFileRes) {
            throw new WCSPException("WCSP_File_OpenWithSessionkey failed");
        }
        JNIUtils.WCSP_LOG_D("WCSP_File_OpenWithSessionkey OUT hFile[{}{}]", "0x", hFileRes);
        this.hFile = hFileRes;
    }

    public static enum OPMode {
        EncryptFileInput("rp"),
        EncryptFileOutput("wc"),
        DecryptFileInput("rc"),
        DecryptFileOutput("wp");

        private final String value;

        private OPMode(String value) {
            this.value = value;
        }
    }
}

