/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.Digest;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.COObjectImpl;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.jni.COServiceJNI;
import cn.com.westone.wcspsdk.impl.jni.JNIUtils;

public class DigestImpl
extends COObjectImpl
implements Digest {
    private long hContext = 0L;
    private long updated = 0L;
    private int algorithmId = 1;

    @Override
    public void update(byte[] input) throws WCSPException {
        if (null == input || input.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("Digest object has been finished");
        }
        JNIUtils.WCSP_LOG_D("WCSP_CO_DigestUpdate IN hContext[{}{}] data[{}]", "0x", this.hContext, input);
        JNIUtils.WCSP_CHECK("WCSP_CO_DigestUpdate", COServiceJNI.wcsp_CO_DigestUpdate(this.hContext, input), new int[0]);
        this.updated += (long)input.length;
    }

    @Override
    public byte[] doFinal() throws WCSPException {
        if (this.updated < 1L) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("Digest object has been finished");
        }
        byte[][] pDigestData = new byte[][]{null};
        JNIUtils.WCSP_LOG_D("WCSP_CO_DigestFinal IN hContext[{}{}]", "0x", this.hContext);
        try {
            JNIUtils.WCSP_CHECK("WCSP_CO_DigestFinal", COServiceJNI.wcsp_CO_DigestFinal(this.hContext, new byte[0], pDigestData), new int[0]);
        }
        finally {
            this.updated = 0L;
            this.hContext = 0L;
        }
        JNIUtils.WCSP_LOG_D("WCSP_CO_DigestFinal OUT digestData[{}]", new Object[]{pDigestData[0]});
        return pDigestData[0];
    }

    @Override
    public byte[] doFinal(byte[] input) throws WCSPException {
        if (null == input || input.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("Digest object has been finished");
        }
        byte[][] pDigestData = new byte[][]{null};
        JNIUtils.WCSP_LOG_D("WCSP_CO_DigestFinal IN hContext[{}{}] data[{}]", "0x", this.hContext, input);
        try {
            JNIUtils.WCSP_CHECK("WCSP_CO_DigestFinal", COServiceJNI.wcsp_CO_DigestFinal(this.hContext, input, pDigestData), new int[0]);
        }
        finally {
            this.updated = 0L;
            this.hContext = 0L;
        }
        JNIUtils.WCSP_LOG_D("WCSP_CO_DigestFinal OUT digestData[{}]", new Object[]{pDigestData[0]});
        return pDigestData[0];
    }

    @Override
    public void reset() throws WCSPException {
        if (0L != this.hContext) {
            if (this.updated < 1L) {
                return;
            }
            try {
                WCSPCO.WCSP_CO_FreeContext(this.hContext);
            }
            finally {
                this.updated = 0L;
                this.hContext = 0L;
            }
        }
        long[] phContext = new long[]{0L};
        JNIUtils.WCSP_LOG_D("WCSP_CO_DigestInit IN hCOService[{}{}] algorithmId[{}{}]", "0x", this.service().handle(), "0x", this.algorithmId);
        JNIUtils.WCSP_CHECK("WCSP_CO_DigestInit", COServiceJNI.wcsp_CO_DigestInit(this.service().handle(), this.algorithmId, phContext), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_CO_DigestInit OUT hContext[{}{}]", "0x", phContext[0]);
        this.hContext = phContext[0];
        this.updated = 0L;
    }

    @Override
    public int getDigestLength() {
        return 32;
    }

    @Override
    public void close() {
        if (0L != this.hContext) {
            try {
                WCSPCO.WCSP_CO_FreeContext(this.hContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updated = 0L;
            this.hContext = 0L;
        }
    }

    DigestImpl(String algorithm, COServiceImpl coService) {
        super(algorithm, coService);
    }

    void init() throws InvalidParameterException, WCSPException {
        switch (this.algorithm()) {
            case "SM3": {
                this.algorithmId = 1;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + this.algorithm());
            }
        }
        long[] phContext = new long[]{0L};
        JNIUtils.WCSP_LOG_D("WCSP_CO_DigestInit IN hCOService[{}{}] algorithmId[{}{}]", "0x", this.service().handle(), "0x", this.algorithmId);
        JNIUtils.WCSP_CHECK("WCSP_CO_DigestInit", COServiceJNI.wcsp_CO_DigestInit(this.service().handle(), this.algorithmId, phContext), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_CO_DigestInit OUT hContext[{}{}]", "0x", phContext[0]);
        this.hContext = phContext[0];
        this.updated = 0L;
    }
}

