/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.COService;
import cn.com.westone.wcspsdk.baseservice.co.Identifier;
import cn.com.westone.wcspsdk.baseservice.co.KeyPair;
import cn.com.westone.wcspsdk.baseservice.co.PrivateKey;
import cn.com.westone.wcspsdk.baseservice.co.PublicKey;
import cn.com.westone.wcspsdk.baseservice.co.SecretKey;
import cn.com.westone.wcspsdk.baseservice.km.KMPrivateKey;
import cn.com.westone.wcspsdk.baseservice.km.KMPublicKey;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.ServiceImpl;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.AsymDecryptorImpl;
import cn.com.westone.wcspsdk.impl.co.AsymEncryptorImpl;
import cn.com.westone.wcspsdk.impl.co.AsymShortDataDecryptorImpl;
import cn.com.westone.wcspsdk.impl.co.AsymShortDataEncryptorImpl;
import cn.com.westone.wcspsdk.impl.co.DigestImpl;
import cn.com.westone.wcspsdk.impl.co.DigestSignerImpl;
import cn.com.westone.wcspsdk.impl.co.DigestVerifierImpl;
import cn.com.westone.wcspsdk.impl.co.FPEDecryptorImpl;
import cn.com.westone.wcspsdk.impl.co.FPEEncryptorImpl;
import cn.com.westone.wcspsdk.impl.co.FileDecryptorImpl;
import cn.com.westone.wcspsdk.impl.co.FileEncryptorImpl;
import cn.com.westone.wcspsdk.impl.co.FileIOCipherImpl;
import cn.com.westone.wcspsdk.impl.co.FileTransformEncryptorImpl;
import cn.com.westone.wcspsdk.impl.co.KeyPairImpl;
import cn.com.westone.wcspsdk.impl.co.MacImpl;
import cn.com.westone.wcspsdk.impl.co.PrivateKeyImpl;
import cn.com.westone.wcspsdk.impl.co.PublicKeyImpl;
import cn.com.westone.wcspsdk.impl.co.SecretKeyImpl;
import cn.com.westone.wcspsdk.impl.co.SessionKeyImpl;
import cn.com.westone.wcspsdk.impl.co.ShortDataMacImpl;
import cn.com.westone.wcspsdk.impl.co.ShortDataSignerImpl;
import cn.com.westone.wcspsdk.impl.co.ShortDataVerifierImpl;
import cn.com.westone.wcspsdk.impl.co.SignImpl;
import cn.com.westone.wcspsdk.impl.co.SignerImpl;
import cn.com.westone.wcspsdk.impl.co.SymmDecryptorImpl;
import cn.com.westone.wcspsdk.impl.co.SymmEncryptorImpl;
import cn.com.westone.wcspsdk.impl.co.SymmShortDataDecryptorImpl;
import cn.com.westone.wcspsdk.impl.co.SymmShortDataEncryptorImpl;
import cn.com.westone.wcspsdk.impl.co.VerifierImpl;
import cn.com.westone.wcspsdk.impl.co.VerifyImpl;
import cn.com.westone.wcspsdk.impl.jni.COServiceJNI;
import cn.com.westone.wcspsdk.impl.jni.JNIUtils;
import cn.com.westone.wcspsdk.util.ConversionUtils;
import cn.com.westone.wcspsdk.util.KeyUtils;
import cn.com.westone.wcspsdk.util.SignatureUtils;
import cn.com.westone.wcspsdk.util.cert.PKCS10CSRequest;
import cn.com.westone.wcspsdk.util.cert.X501DName;
import cn.com.westone.wcspsdk.util.cms.CMSEnvelopedData;
import cn.com.westone.wcspsdk.util.cms.CMSException;
import cn.com.westone.wcspsdk.util.cms.CMSSignedAndEnvelopedData;
import cn.com.westone.wcspsdk.util.cms.CMSSignedData;

public class COServiceImpl
extends ServiceImpl
implements COService {
    public static COServiceImpl getInstance(PlatformImpl platform) throws WCSPException {
        if (null == platform) {
            throw new IllegalArgumentException("Argument \"platform\" is null");
        }
        return new COServiceImpl(platform);
    }

    public static COServiceImpl getInstance(String type, PlatformImpl platform) throws InvalidParameterException, WCSPException {
        int serviceId;
        if (null == type || type.isEmpty() || null == platform) {
            throw new IllegalArgumentException("Argument \"type\" or \"platform\" is null");
        }
        switch (type) {
            case "CO": 
            case "CO-LOCAL": {
                serviceId = 3;
                break;
            }
            case "CO-REMOTE": {
                serviceId = 4;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid type: " + type);
            }
        }
        return new COServiceImpl(serviceId, type, platform);
    }

    @Override
    public void init(Object ... args) {
    }

    @Override
    public void verifyPIN(String pin) throws WCSPException {
        if (null == pin || pin.isEmpty()) {
            throw new IllegalArgumentException("Argument \"pin\" is null");
        }
        WCSPCO.WCSP_CO_VerifyPin(this.handle(), pin);
    }

    @Override
    public KeyPairImpl generateKeyPair(String algorithm, String usage, String name) throws InvalidParameterException, WCSPException {
        int algorithmId;
        if (null == algorithm || algorithm.isEmpty() || null == usage || usage.isEmpty() || null == name || name.isEmpty()) {
            throw new IllegalArgumentException("Argument \"algorithm\" or \"usage\" or \"name\" is null");
        }
        if (!this.type().equals("CO") && !this.type().equals("CO-LOCAL")) {
            throw new UnsupportedOperationException("Only support Local COService");
        }
        block3 : switch (algorithm) {
            case "SM2": {
                switch (usage) {
                    case "SIGN": {
                        algorithmId = 131584;
                        break block3;
                    }
                }
                throw new InvalidParameterException("Invalid usage: " + usage);
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + algorithm);
            }
        }
        WCSPCO.WCSP_CO_GenerateKeyPair(this.handle(), algorithmId, name);
        return this.getKeyPair(algorithm, usage, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyPairImpl importKeyPair(String algorithm, String usage, byte[] envelopedKeyPairData, PrivateKey deprotectionKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        int algorithmId;
        if (null == algorithm || algorithm.isEmpty() || null == usage || usage.isEmpty() || null == envelopedKeyPairData || envelopedKeyPairData.length < 1 || null == deprotectionKey) {
            throw new IllegalArgumentException("Argument \"algorithm\" or \"usage\" or \"envelopedKeyPairData\" or \"deprotectionKey\" is null");
        }
        if (!this.type().equals("CO") && !this.type().equals("CO-LOCAL")) {
            throw new UnsupportedOperationException("Only support Local COService");
        }
        block6 : switch (algorithm) {
            case "SM2": {
                switch (usage) {
                    case "ENC": {
                        algorithmId = 133120;
                        break block6;
                    }
                }
                throw new InvalidParameterException("Invalid usage: " + usage);
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + algorithm);
            }
        }
        if (deprotectionKey instanceof PrivateKeyImpl) {
            switch (deprotectionKey.algorithm()) {
                case "SM2": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid deprotectionKey algorithm: " + deprotectionKey.algorithm());
                }
            }
            switch (deprotectionKey.usage()) {
                case "SIGN": 
                case "ENC": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid deprotectionKey usage: " + deprotectionKey.usage());
                }
            }
        } else {
            throw new InvalidKeyException("Invalid deprotectionKey object");
        }
        long hDeprotectionKey = ((PrivateKeyImpl)deprotectionKey).handle();
        try {
            WCSPCO.WCSP_CO_ImportKeyPair(this.handle(), algorithmId, hDeprotectionKey, envelopedKeyPairData);
        }
        finally {
            try {
                if (!(deprotectionKey instanceof PrivateKeyImpl)) {
                    WCSPCO.WCSP_CO_CloseHandle(hDeprotectionKey);
                }
            }
            catch (Exception exception) {}
        }
        return this.getKeyPair(algorithm, usage, deprotectionKey.name());
    }

    @Override
    public KeyPairImpl getKeyPair(String algorithm, String usage, String name) throws InvalidParameterException, WCSPException {
        int usageId;
        if (null == algorithm || algorithm.isEmpty() || null == usage || usage.isEmpty() || null == name || name.isEmpty()) {
            throw new IllegalArgumentException("Argument \"algorithm\" or \"usage\" or \"name\" is null");
        }
        switch (algorithm) {
            case "SM2": {
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + algorithm);
            }
        }
        switch (usage) {
            case "SIGN": {
                usageId = 0;
                break;
            }
            case "ENC": {
                usageId = 1;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid usage: " + usage);
            }
        }
        long[] phPublicKey = new long[]{0L};
        JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandle IN hCOService[{}{}] name[{}] usageId[{}]", "0x", this.handle(), name, usageId);
        JNIUtils.WCSP_CHECK("WCSP_CO_GetPublicKeyHandle", COServiceJNI.wcsp_CO_GetPublicKeyHandle(this.handle(), name, usageId, phPublicKey), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandle OUT hPublicKey[{}{}]", "0x", phPublicKey[0]);
        long[] phPrivateKey = new long[]{0L};
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPrivateKeyHandle IN hCOService[{}{}] name[{}] usageId[{}]", "0x", this.handle(), name, usageId);
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPrivateKeyHandle", COServiceJNI.wcsp_CO_GetPrivateKeyHandle(this.handle(), name, usageId, phPrivateKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPrivateKeyHandle OUT hPrivateKey{}{}]", "0x", phPrivateKey[0]);
        }
        catch (Exception e) {
            try {
                WCSPCO.WCSP_CO_CloseHandle(phPublicKey[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        return new KeyPairImpl(new PublicKeyImpl(phPublicKey[0], usage, name, algorithm, this), new PrivateKeyImpl(phPrivateKey[0], usage, name, algorithm, this));
    }

    @Override
    public KeyPair getKeyPair(String algorithm, String usage) throws InvalidParameterException, WCSPException {
        return this.type().equals("CO-REMOTE") ? this.getKeyPair(algorithm, usage, "1") : this.getKeyPair(algorithm, usage, "default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionKeyImpl generateSessionKey(String algorithm, PublicKey protectionKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        Object phPublicKey;
        Object hProtectionKey;
        int algorithmId;
        if (null == algorithm || algorithm.isEmpty() || null == protectionKey) {
            throw new IllegalArgumentException("Argument \"algorithm\" or \"protectionKey\" is null");
        }
        switch (algorithm) {
            case "SM4_ECB": {
                algorithmId = 1025;
                break;
            }
            case "SM4_CBC": {
                algorithmId = 1026;
                break;
            }
            case "SM4_MAC": {
                algorithmId = 1040;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + algorithm);
            }
        }
        if (protectionKey instanceof PublicKeyImpl) {
            switch (protectionKey.algorithm()) {
                case "SM2": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid protectionKey algorithm: " + protectionKey.algorithm());
                }
            }
            switch (protectionKey.usage()) {
                case "ENC": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid protectionKey usage: " + protectionKey.usage());
                }
            }
            hProtectionKey = ((PublicKeyImpl)protectionKey).handle();
        } else if (protectionKey instanceof KMPublicKey) {
            switch (protectionKey.algorithm()) {
                case "SM2": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid protectionKey algorithm: " + protectionKey.algorithm());
                }
            }
            switch (protectionKey.usage()) {
                case "ENC": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid protectionKey usage: " + protectionKey.usage());
                }
            }
            phPublicKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromKms IN hCOService[{}{}] publicKeyId[{}]", "0x", this.handle(), ((KMPublicKey)protectionKey).keyId());
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPublicKeyHandleFromKms", COServiceJNI.wcsp_CO_GetPublicKeyHandleFromKms(this.handle(), ((KMPublicKey)protectionKey).keyId(), (long[])phPublicKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromKms OUT hPublicKey[{}{}]", "0x", (long)phPublicKey[0]);
            hProtectionKey = phPublicKey[0];
        } else if (protectionKey instanceof Identifier) {
            switch (protectionKey.algorithm()) {
                case "SM9": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid protectionKey algorithm: " + protectionKey.algorithm());
                }
            }
            switch (protectionKey.usage()) {
                case "ENC": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid protectionKey usage: " + protectionKey.usage());
                }
            }
            phPublicKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromSM9IdByVersion IN hCOService[{}{}] algorithmId[{}{}] usage[{}] version[{}] identity[{}]", "0x", this.handle(), "0x", 264192, 1, ((Identifier)((Object)protectionKey)).version(), ((Identifier)((Object)protectionKey)).identity());
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPublicKeyHandleFromSM9IdByVersion", COServiceJNI.wcsp_CO_GetPublicKeyHandleFromSM9IdByVersion(this.handle(), 264192, 1, ((Identifier)((Object)protectionKey)).version(), ((Identifier)((Object)protectionKey)).identity(), (long[])phPublicKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromSM9IdByVersion OUT hPublicKey[{}{}]", "0x", (long)phPublicKey[0]);
            hProtectionKey = phPublicKey[0];
        } else {
            switch (protectionKey.algorithm()) {
                case "SM2": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid protectionKey algorithm: " + protectionKey.algorithm());
                }
            }
            switch (protectionKey.usage()) {
                case "ENC": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid protectionKey usage: " + protectionKey.usage());
                }
            }
            phPublicKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromData IN hCOService[{}{}] publicKeyData[{}]", "0x", this.handle(), protectionKey.getKeyData());
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPublicKeyHandleFromData", COServiceJNI.wcsp_CO_GetPublicKeyHandleFromData(this.handle(), protectionKey.getKeyData(), (long[])phPublicKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromData OUT hPublicKey[{}{}]", "0x", (long)phPublicKey[0]);
            hProtectionKey = phPublicKey[0];
        }
        long[] phSecretKey = new long[]{0L};
        byte[][] pWrappedKeyData = new byte[][]{null};
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CO_GenerateAndExportSessionKey IN hCOService[{}{}] algorithmId[{}{}] hProtectionKey[{}{}]", "0x", this.handle(), "0x", algorithmId, "0x", hProtectionKey);
            JNIUtils.WCSP_CHECK("WCSP_CO_GenerateAndExportSessionKey", COServiceJNI.wcsp_CO_GenerateAndExportSessionKey(this.handle(), algorithmId, hProtectionKey, phSecretKey, pWrappedKeyData), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GenerateAndExportSessionKey OUT hSecretKey[{}{}] wrappedKeyData[{}]", "0x", phSecretKey[0], pWrappedKeyData[0]);
        }
        finally {
            try {
                if (!(protectionKey instanceof PublicKeyImpl)) {
                    WCSPCO.WCSP_CO_CloseHandle(hProtectionKey);
                }
            }
            catch (Exception exception) {}
        }
        return new SessionKeyImpl(phSecretKey[0], algorithm, this, pWrappedKeyData[0], protectionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionKeyImpl importSessionKey(String algorithm, byte[] wrappedKeyData, PrivateKey deprotectionKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        Object phPrivateKey;
        Object hDeprotectionKey;
        int algorithmId;
        if (null == algorithm || algorithm.isEmpty() || null == wrappedKeyData || wrappedKeyData.length < 1 || null == deprotectionKey) {
            throw new IllegalArgumentException("Argument \"algorithm\" or \"wrappedKeyData\" or \"deprotectionKey\" is null");
        }
        switch (algorithm) {
            case "SM4_ECB": {
                algorithmId = 1025;
                break;
            }
            case "SM4_CBC": {
                algorithmId = 1026;
                break;
            }
            case "SM4_MAC": {
                algorithmId = 1040;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + algorithm);
            }
        }
        if (deprotectionKey instanceof PrivateKeyImpl) {
            switch (deprotectionKey.algorithm()) {
                case "SM2": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid deprotectionKey algorithm: " + deprotectionKey.algorithm());
                }
            }
            switch (deprotectionKey.usage()) {
                case "ENC": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid deprotectionKey usage: " + deprotectionKey.usage());
                }
            }
            hDeprotectionKey = ((PrivateKeyImpl)deprotectionKey).handle();
        } else if (deprotectionKey instanceof KMPrivateKey) {
            switch (deprotectionKey.algorithm()) {
                case "SM2": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid deprotectionKey algorithm: " + deprotectionKey.algorithm());
                }
            }
            switch (deprotectionKey.usage()) {
                case "ENC": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid deprotectionKey usage: " + deprotectionKey.usage());
                }
            }
            phPrivateKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPrivateKeyHandleFromKms IN hCOService[{}{}] privateKeyId[{}]", "0x", this.handle(), ((KMPrivateKey)deprotectionKey).keyId());
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPrivateKeyHandleFromKms", COServiceJNI.wcsp_CO_GetPrivateKeyHandleFromKms(this.handle(), ((KMPrivateKey)deprotectionKey).keyId(), (long[])phPrivateKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPrivateKeyHandleFromKms OUT hPrivateKey[{}{}]", "0x", (long)phPrivateKey[0]);
            hDeprotectionKey = phPrivateKey[0];
        } else if (deprotectionKey instanceof Identifier) {
            switch (deprotectionKey.algorithm()) {
                case "SM9": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid deprotectionKey algorithm: " + deprotectionKey.algorithm());
                }
            }
            switch (deprotectionKey.usage()) {
                case "ENC": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid deprotectionKey usage: " + deprotectionKey.usage());
                }
            }
            phPrivateKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPrivateKeyHandleFromSM9IdByVersion IN hCOService[{}{}] algorithmId[{}{}] usage[{}] version[{}] identity[{}]", "0x", this.handle(), "0x", 264192, 1, ((Identifier)((Object)deprotectionKey)).version(), ((Identifier)((Object)deprotectionKey)).identity());
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPrivateKeyHandleFromSM9IdByVersion", COServiceJNI.wcsp_CO_GetPrivateKeyHandleFromSM9IdByVersion(this.handle(), 264192, 1, ((Identifier)((Object)deprotectionKey)).version(), ((Identifier)((Object)deprotectionKey)).identity(), (long[])phPrivateKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPrivateKeyHandleFromSM9IdByVersion OUT hPrivateKey[{}{}]", "0x", (long)phPrivateKey[0]);
            hDeprotectionKey = phPrivateKey[0];
        } else {
            throw new InvalidKeyException("Invalid deprotectionKey object");
        }
        long[] phSecretKey = new long[]{0L};
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CO_ImportSessionKey IN hCOService[{}{}] algorithmId[{}{}] hDeprotectionKey[{}{}] wrappedKeyData[{}]", "0x", this.handle(), "0x", algorithmId, "0x", hDeprotectionKey, wrappedKeyData);
            JNIUtils.WCSP_CHECK("WCSP_CO_ImportSessionKey", COServiceJNI.wcsp_CO_ImportSessionKey(this.handle(), algorithmId, hDeprotectionKey, wrappedKeyData, phSecretKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_ImportSessionKey OUT hSecretKey[{}{}]", "0x", phSecretKey[0]);
        }
        finally {
            try {
                if (!(deprotectionKey instanceof PrivateKeyImpl)) {
                    WCSPCO.WCSP_CO_CloseHandle(hDeprotectionKey);
                }
            }
            catch (Exception exception) {}
        }
        return new SessionKeyImpl(phSecretKey[0], algorithm, this, wrappedKeyData, deprotectionKey);
    }

    @Override
    public SymmEncryptorImpl getEncryptor(SecretKey secretKey, String padding) throws InvalidParameterException, InvalidKeyException, WCSPException {
        return this.getEncryptor(secretKey, new byte[0], "ECB", padding);
    }

    @Override
    public SymmDecryptorImpl getDecryptor(SecretKey secretKey, String padding) throws InvalidParameterException, InvalidKeyException, WCSPException {
        return this.getDecryptor(secretKey, new byte[0], "ECB", padding);
    }

    @Override
    public SymmEncryptorImpl getEncryptor(SecretKey secretKey, byte[] iv, String padding) throws InvalidParameterException, InvalidKeyException, WCSPException {
        return this.getEncryptor(secretKey, iv, "CBC", padding);
    }

    @Override
    public SymmDecryptorImpl getDecryptor(SecretKey secretKey, byte[] iv, String padding) throws InvalidParameterException, InvalidKeyException, WCSPException {
        return this.getDecryptor(secretKey, iv, "CBC", padding);
    }

    @Override
    public SymmEncryptorImpl getEncryptor(SecretKey secretKey, byte[] iv, String mode, String padding) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == iv) {
            iv = new byte[]{};
        }
        if (null == secretKey) {
            throw new IllegalArgumentException("Argument \"secretKey\" is null");
        }
        SymmEncryptorImpl encryptor = new SymmEncryptorImpl(padding, mode, secretKey.algorithm().split("_", 2)[0], this);
        try {
            encryptor.init(secretKey, iv);
        }
        catch (Exception e) {
            encryptor.close();
            throw e;
        }
        return encryptor;
    }

    @Override
    public SymmDecryptorImpl getDecryptor(SecretKey secretKey, byte[] iv, String mode, String padding) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == iv) {
            iv = new byte[]{};
        }
        if (null == secretKey) {
            throw new IllegalArgumentException("Argument \"secretKey\" is null");
        }
        SymmDecryptorImpl decryptor = new SymmDecryptorImpl(padding, mode, secretKey.algorithm().split("_", 2)[0], this);
        try {
            decryptor.init(secretKey, iv);
        }
        catch (Exception e) {
            decryptor.close();
            throw e;
        }
        return decryptor;
    }

    @Override
    public AsymEncryptorImpl getEncryptor(PublicKey publicKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        return this.getEncryptor(publicKey, "XOR");
    }

    @Override
    public AsymDecryptorImpl getDecryptor(PrivateKey privateKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        return this.getDecryptor(privateKey, "XOR");
    }

    @Override
    public AsymEncryptorImpl getEncryptor(PublicKey publicKey, String mode) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == publicKey) {
            throw new IllegalArgumentException("Argument \"publicKey\" is null");
        }
        AsymEncryptorImpl encryptor = new AsymEncryptorImpl(mode, publicKey.algorithm() + "_" + "ENC", this);
        try {
            encryptor.init(publicKey);
        }
        catch (Exception e) {
            encryptor.close();
            throw e;
        }
        return encryptor;
    }

    @Override
    public AsymDecryptorImpl getDecryptor(PrivateKey privateKey, String mode) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == privateKey) {
            throw new IllegalArgumentException("Argument \"privateKey\" is null");
        }
        AsymDecryptorImpl decryptor = new AsymDecryptorImpl(mode, privateKey.algorithm() + "_" + "ENC", this);
        try {
            decryptor.init(privateKey);
        }
        catch (Exception e) {
            decryptor.close();
            throw e;
        }
        return decryptor;
    }

    @Override
    public SymmShortDataEncryptorImpl getShortDataEncryptor(SecretKey secretKey, byte[] iv, String mode, String padding) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == iv) {
            iv = new byte[]{};
        }
        if (null == secretKey) {
            throw new IllegalArgumentException("Argument \"secretKey\" is null");
        }
        SymmShortDataEncryptorImpl encryptor = new SymmShortDataEncryptorImpl(padding, mode, secretKey.algorithm().split("_", 2)[0], this);
        try {
            encryptor.init(secretKey, iv);
        }
        catch (Exception e) {
            encryptor.close();
            throw e;
        }
        return encryptor;
    }

    @Override
    public SymmShortDataDecryptorImpl getShortDataDecryptor(SecretKey secretKey, byte[] iv, String mode, String padding) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == iv) {
            iv = new byte[]{};
        }
        if (null == secretKey) {
            throw new IllegalArgumentException("Argument \"secretKey\" is null");
        }
        SymmShortDataDecryptorImpl decryptor = new SymmShortDataDecryptorImpl(padding, mode, secretKey.algorithm().split("_", 2)[0], this);
        try {
            decryptor.init(secretKey, iv);
        }
        catch (Exception e) {
            decryptor.close();
            throw e;
        }
        return decryptor;
    }

    @Override
    public AsymShortDataEncryptorImpl getShortDataEncryptor(PublicKey publicKey, String mode) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == publicKey) {
            throw new IllegalArgumentException("Argument \"publicKey\" is null");
        }
        AsymShortDataEncryptorImpl encryptor = new AsymShortDataEncryptorImpl(mode, publicKey.algorithm() + "_" + "ENC", this);
        try {
            encryptor.init(publicKey);
        }
        catch (Exception e) {
            encryptor.close();
            throw e;
        }
        return encryptor;
    }

    @Override
    public AsymShortDataDecryptorImpl getShortDataDecryptor(PrivateKey privateKey, String mode) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == privateKey) {
            throw new IllegalArgumentException("Argument \"privateKey\" is null");
        }
        AsymShortDataDecryptorImpl decryptor = new AsymShortDataDecryptorImpl(mode, privateKey.algorithm() + "_" + "ENC", this);
        try {
            decryptor.init(privateKey);
        }
        catch (Exception e) {
            decryptor.close();
            throw e;
        }
        return decryptor;
    }

    @Override
    public byte[] encryptShortData(SecretKey secretKey, String padding, byte[] data) throws InvalidParameterException, InvalidKeyException, WCSPException {
        return this.encryptShortData(secretKey, new byte[0], "ECB", padding, data);
    }

    @Override
    public byte[] decryptShortData(SecretKey secretKey, String padding, byte[] encData) throws InvalidParameterException, InvalidKeyException, WCSPException {
        return this.decryptShortData(secretKey, new byte[0], "ECB", padding, encData);
    }

    @Override
    public byte[] encryptShortData(SecretKey secretKey, byte[] iv, String padding, byte[] data) throws InvalidParameterException, InvalidKeyException, WCSPException {
        return this.encryptShortData(secretKey, iv, "CBC", padding, data);
    }

    @Override
    public byte[] decryptShortData(SecretKey secretKey, byte[] iv, String padding, byte[] encData) throws InvalidParameterException, InvalidKeyException, WCSPException {
        return this.decryptShortData(secretKey, iv, "CBC", padding, encData);
    }

    @Override
    public byte[] encryptShortData(SecretKey secretKey, byte[] iv, String mode, String padding, byte[] data) throws InvalidParameterException, InvalidKeyException, WCSPException {
        try (SymmShortDataEncryptorImpl encryptor = this.getShortDataEncryptor(secretKey, iv, mode, padding);){
            byte[] byArray = encryptor.encrypt(data);
            return byArray;
        }
    }

    @Override
    public byte[] decryptShortData(SecretKey secretKey, byte[] iv, String mode, String padding, byte[] encData) throws InvalidParameterException, InvalidKeyException, WCSPException {
        try (SymmShortDataDecryptorImpl decryptor = this.getShortDataDecryptor(secretKey, iv, mode, padding);){
            byte[] byArray = decryptor.decrypt(encData);
            return byArray;
        }
    }

    @Override
    public byte[] encryptShortData(PublicKey publicKey, byte[] data) throws InvalidParameterException, InvalidKeyException, WCSPException {
        return this.encryptShortData(publicKey, "XOR", data);
    }

    @Override
    public byte[] decryptShortData(PrivateKey privateKey, byte[] encData) throws InvalidParameterException, InvalidKeyException, WCSPException {
        return this.decryptShortData(privateKey, "XOR", encData);
    }

    @Override
    public byte[] encryptShortData(PublicKey publicKey, String mode, byte[] data) throws InvalidParameterException, InvalidKeyException, WCSPException {
        try (AsymShortDataEncryptorImpl encryptor = this.getShortDataEncryptor(publicKey, mode);){
            byte[] byArray = encryptor.encrypt(data);
            return byArray;
        }
    }

    @Override
    public byte[] decryptShortData(PrivateKey privateKey, String mode, byte[] encData) throws InvalidParameterException, InvalidKeyException, WCSPException {
        try (AsymShortDataDecryptorImpl decryptor = this.getShortDataDecryptor(privateKey, mode);){
            byte[] byArray = decryptor.decrypt(encData);
            return byArray;
        }
    }

    @Override
    public FPEEncryptorImpl getFPEEncryptor(SecretKey secretKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == secretKey) {
            throw new IllegalArgumentException("Argument \"secretKey\" is null");
        }
        String mode = "ECB";
        if (secretKey instanceof SecretKeyImpl) {
            mode = secretKey.algorithm().split("_", 2)[1];
        }
        FPEEncryptorImpl encryptor = new FPEEncryptorImpl(mode, secretKey.algorithm().split("_", 2)[0], this);
        try {
            encryptor.init(secretKey);
        }
        catch (Exception e) {
            encryptor.close();
            throw e;
        }
        return encryptor;
    }

    @Override
    public FPEDecryptorImpl getFPEDecryptor(SecretKey secretKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == secretKey) {
            throw new IllegalArgumentException("Argument \"secretKey\" is null");
        }
        String mode = "ECB";
        if (secretKey instanceof SecretKeyImpl) {
            mode = secretKey.algorithm().split("_", 2)[1];
        }
        FPEDecryptorImpl decryptor = new FPEDecryptorImpl(mode, secretKey.algorithm().split("_", 2)[0], this);
        try {
            decryptor.init(secretKey);
        }
        catch (Exception e) {
            decryptor.close();
            throw e;
        }
        return decryptor;
    }

    public FileEncryptorImpl getFileEncryptor(SecretKey secretKey) throws InvalidKeyException, WCSPException {
        FileEncryptorImpl fileEncryptor = new FileEncryptorImpl("SM4_CBC_SM4_MAC", this);
        try {
            fileEncryptor.init(secretKey);
        }
        catch (Exception e) {
            fileEncryptor.close();
            throw e;
        }
        return fileEncryptor;
    }

    public FileEncryptorImpl getFileEncryptor(PublicKey publicKey) throws InvalidKeyException, WCSPException {
        FileEncryptorImpl fileEncryptor = new FileEncryptorImpl("SM4_CBC_SM4_MAC", this);
        try {
            fileEncryptor.init(publicKey);
        }
        catch (Exception e) {
            fileEncryptor.close();
            throw e;
        }
        return fileEncryptor;
    }

    public FileDecryptorImpl getFileDecryptor() throws WCSPException {
        FileDecryptorImpl fileDecryptor = new FileDecryptorImpl("SM4_CBC_SM4_MAC", this);
        try {
            fileDecryptor.init();
        }
        catch (Exception e) {
            fileDecryptor.close();
            throw e;
        }
        return fileDecryptor;
    }

    public FileTransformEncryptorImpl getFileTransformEncryptor(SecretKey secretKey) throws InvalidKeyException, WCSPException {
        FileTransformEncryptorImpl fileEncryptor = new FileTransformEncryptorImpl("SM4_CBC_SM4_MAC", this);
        try {
            fileEncryptor.init(secretKey);
        }
        catch (Exception e) {
            fileEncryptor.close();
            throw e;
        }
        return fileEncryptor;
    }

    public FileTransformEncryptorImpl getFileTransformEncryptor(PublicKey publicKey) throws InvalidKeyException, WCSPException {
        FileTransformEncryptorImpl fileEncryptor = new FileTransformEncryptorImpl("SM4_CBC_SM4_MAC", this);
        try {
            fileEncryptor.init(publicKey);
        }
        catch (Exception e) {
            fileEncryptor.close();
            throw e;
        }
        return fileEncryptor;
    }

    @Override
    public MacImpl getCBCMac(SecretKey secretKey, byte[] iv, String padding) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == iv) {
            iv = new byte[]{};
        }
        MacImpl mac = new MacImpl(padding, "SM4_MAC", this);
        try {
            mac.init(secretKey, iv);
        }
        catch (Exception e) {
            mac.close();
            throw e;
        }
        return mac;
    }

    @Override
    public ShortDataMacImpl getShortDataCBCMac(SecretKey secretKey, byte[] iv, String padding) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == iv) {
            iv = new byte[]{};
        }
        ShortDataMacImpl mac = new ShortDataMacImpl(padding, "SM4_MAC", this);
        try {
            mac.init(secretKey, iv);
        }
        catch (Exception e) {
            mac.close();
            throw e;
        }
        return mac;
    }

    @Override
    public SignerImpl getSigner(PrivateKey privateKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == privateKey) {
            throw new IllegalArgumentException("Argument \"privateKey\" is null");
        }
        SignerImpl signer = new SignerImpl("SM3_" + privateKey.algorithm() + "_" + "SIGN", this);
        try {
            signer.init(privateKey);
        }
        catch (Exception e) {
            signer.close();
            throw e;
        }
        return signer;
    }

    @Override
    public VerifierImpl getVerifier(PublicKey publicKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == publicKey) {
            throw new IllegalArgumentException("Argument \"publicKey\" is null");
        }
        VerifierImpl verifier = new VerifierImpl("SM3_" + publicKey.algorithm() + "_" + "SIGN", this);
        try {
            verifier.init(publicKey);
        }
        catch (Exception e) {
            verifier.close();
            throw e;
        }
        return verifier;
    }

    @Override
    public ShortDataSignerImpl getShortDataSigner(PrivateKey privateKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == privateKey) {
            throw new IllegalArgumentException("Argument \"privateKey\" is null");
        }
        ShortDataSignerImpl shortDataSigner = new ShortDataSignerImpl("SM3_" + privateKey.algorithm() + "_" + "SIGN", this);
        try {
            shortDataSigner.init(privateKey);
        }
        catch (Exception e) {
            shortDataSigner.close();
            throw e;
        }
        return shortDataSigner;
    }

    @Override
    public ShortDataVerifierImpl getShortDataVerifier(PublicKey publicKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == publicKey) {
            throw new IllegalArgumentException("Argument \"publicKey\" is null");
        }
        ShortDataVerifierImpl shortDataVerifier = new ShortDataVerifierImpl("SM3_" + publicKey.algorithm() + "_" + "SIGN", this);
        try {
            shortDataVerifier.init(publicKey);
        }
        catch (Exception e) {
            shortDataVerifier.close();
            throw e;
        }
        return shortDataVerifier;
    }

    @Override
    public byte[] signShortData(PrivateKey privateKey, byte[] data) throws InvalidParameterException, InvalidKeyException, WCSPException {
        try (ShortDataSignerImpl shortDataSigner = this.getShortDataSigner(privateKey);){
            byte[] byArray = shortDataSigner.sign(data);
            return byArray;
        }
    }

    @Override
    public boolean verifyShortData(PublicKey publicKey, byte[] data, byte[] signatureData) throws InvalidParameterException, InvalidKeyException, WCSPException {
        try (ShortDataVerifierImpl shortDataVerifier = this.getShortDataVerifier(publicKey);){
            boolean bl = shortDataVerifier.verify(data, signatureData);
            return bl;
        }
    }

    @Override
    public DigestSignerImpl getDigestSigner(PrivateKey privateKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == privateKey) {
            throw new IllegalArgumentException("Argument \"privateKey\" is null");
        }
        DigestSignerImpl digestSigner = new DigestSignerImpl(privateKey.algorithm() + "_" + "SIGN", this);
        try {
            digestSigner.init(privateKey);
        }
        catch (Exception e) {
            digestSigner.close();
            throw e;
        }
        return digestSigner;
    }

    @Override
    public DigestVerifierImpl getDigestVerifier(PublicKey publicKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == publicKey) {
            throw new IllegalArgumentException("Argument \"publicKey\" is null");
        }
        DigestVerifierImpl digestVerifier = new DigestVerifierImpl(publicKey.algorithm() + "_" + "SIGN", this);
        try {
            digestVerifier.init(publicKey);
        }
        catch (Exception e) {
            digestVerifier.close();
            throw e;
        }
        return digestVerifier;
    }

    @Override
    public byte[] signDigest(PrivateKey privateKey, byte[] digestData) throws InvalidParameterException, InvalidKeyException, WCSPException {
        try (DigestSignerImpl digestSigner = this.getDigestSigner(privateKey);){
            byte[] byArray = digestSigner.signDigest(digestData);
            return byArray;
        }
    }

    @Override
    public boolean verifyDigest(PublicKey publicKey, byte[] digestData, byte[] signatureData) throws InvalidParameterException, InvalidKeyException, WCSPException {
        try (DigestVerifierImpl digestVerifier = this.getDigestVerifier(publicKey);){
            boolean bl = digestVerifier.verifyDigest(digestData, signatureData);
            return bl;
        }
    }

    @Override
    @Deprecated
    public SignImpl getSign(PrivateKey privateKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == privateKey) {
            throw new IllegalArgumentException("Argument \"privateKey\" is null");
        }
        SignImpl sign = new SignImpl("SM3_" + privateKey.algorithm() + "_" + "SIGN", this);
        try {
            sign.init(privateKey);
        }
        catch (Exception e) {
            sign.close();
            throw e;
        }
        return sign;
    }

    @Override
    @Deprecated
    public VerifyImpl getVerify(PublicKey publicKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == publicKey) {
            throw new IllegalArgumentException("Argument \"publicKey\" is null");
        }
        VerifyImpl verify = new VerifyImpl("SM3_" + publicKey.algorithm() + "_" + "SIGN", this);
        try {
            verify.init(publicKey);
        }
        catch (Exception e) {
            verify.close();
            throw e;
        }
        return verify;
    }

    @Override
    public DigestImpl getDigest(String algorithm) throws InvalidParameterException, WCSPException {
        DigestImpl digest = new DigestImpl(algorithm, this);
        try {
            digest.init();
        }
        catch (Exception e) {
            digest.close();
            throw e;
        }
        return digest;
    }

    @Override
    public byte[] digestShortData(String algorithm, byte[] data) throws InvalidParameterException, WCSPException {
        int algorithmId;
        if (null == algorithm || algorithm.isEmpty()) {
            throw new IllegalArgumentException("Argument \"algorithm\" is null");
        }
        if (data.length > 1023) {
            throw new InvalidParameterException("Input data is too long");
        }
        switch (algorithm) {
            case "SM3": {
                algorithmId = 1;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + algorithm);
            }
        }
        byte[][] pDigestData = new byte[][]{null};
        JNIUtils.WCSP_LOG_D("WCSP_CO_Digest IN hCOService[{}{}] algorithmId[{}{}] data[{}]", "0x", this.handle(), "0x", algorithmId, data);
        JNIUtils.WCSP_CHECK("WCSP_CO_Digest", COServiceJNI.wcsp_CO_Digest(this.handle(), algorithmId, data, pDigestData), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_CO_Digest OUT digestData[{}]", new Object[]{pDigestData[0]});
        return pDigestData[0];
    }

    @Override
    public byte[] generateRandom(int length) throws WCSPException {
        if (length < 1) {
            throw new IllegalArgumentException("Argument \"length\" is null");
        }
        byte[] random = new byte[length];
        JNIUtils.WCSP_LOG_D("WCSP_CO_GenerateRandom IN hCOService[{}{}] randomLen[{}]", "0x", this.handle(), length);
        JNIUtils.WCSP_CHECK("WCSP_CO_GenerateRandom", COServiceJNI.wcsp_CO_GenerateRandom(this.handle(), random), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_CO_GenerateRandom OUT random[{}]", new Object[]{random});
        return random;
    }

    @Override
    public byte[] buildPKCS10CSRequest(KeyPair keyPair, String subjectDN) throws WCSPException {
        if (null == subjectDN || subjectDN.isEmpty()) {
            throw new IllegalArgumentException("Argument \"subjectDN\" is null");
        }
        return this.buildPKCS10CSRequest(keyPair, X501DName.getInstance(subjectDN));
    }

    @Override
    public byte[] buildPKCS10CSRequest(KeyPair keyPair, X501DName subjectDN) throws WCSPException {
        if (null == keyPair || null == keyPair.publicKey() || null == keyPair.privateKey() || null == subjectDN) {
            throw new IllegalArgumentException("Argument \"keyPair\" or \"subjectDN\" is null");
        }
        byte[] publicKeyData = ConversionUtils.SM2PublicKeyData.fromGMT0016(keyPair.publicKey().getKeyData());
        return new PKCS10CSRequest.Builder().build(subjectDN, publicKeyData, data -> {
            try {
                return ConversionUtils.SM2SignatureData.fromGMT0016(this.signDigest(keyPair.privateKey(), SignatureUtils.sm2PreprocessSM3(publicKeyData, data)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).getEncoded();
    }

    @Override
    public void importSignCert(String name, byte[] signCertData) throws WCSPException {
        if (null == name || name.isEmpty() || null == signCertData || signCertData.length < 1) {
            throw new IllegalArgumentException("Argument \"name\" or \"signCertData\" is null");
        }
        if (!this.type().equals("CO") && !this.type().equals("CO-LOCAL")) {
            throw new UnsupportedOperationException("Only support Local COService");
        }
        WCSPCO.WCSP_CO_ImportSignCert(this.handle(), name, signCertData);
    }

    @Override
    public void importEncCert(String name, byte[] encCertData) throws WCSPException {
        if (null == name || name.isEmpty() || null == encCertData || encCertData.length < 1) {
            throw new IllegalArgumentException("Argument \"name\" or \"encCertData\" is null");
        }
        if (!this.type().equals("CO") && !this.type().equals("CO-LOCAL")) {
            throw new UnsupportedOperationException("Only support Local COService");
        }
        WCSPCO.WCSP_CO_ImportEncCert(this.handle(), name, encCertData);
    }

    @Override
    public byte[] exportSignCert(String name) throws WCSPException {
        if (null == name || name.isEmpty()) {
            throw new IllegalArgumentException("Argument \"name\" is null");
        }
        if (!this.type().equals("CO") && !this.type().equals("CO-LOCAL")) {
            throw new UnsupportedOperationException("Only support Local COService");
        }
        byte[][] pSignCertData = new byte[][]{null};
        WCSPCO.WCSP_CO_ExportSignCert(this.handle(), name, pSignCertData);
        return pSignCertData[0];
    }

    @Override
    public byte[] exportEncCert(String name) throws WCSPException {
        if (null == name || name.isEmpty()) {
            throw new IllegalArgumentException("Argument \"name\" is null");
        }
        if (!this.type().equals("CO") && !this.type().equals("CO-LOCAL")) {
            throw new UnsupportedOperationException("Only support Local COService");
        }
        byte[][] pEncCertData = new byte[][]{null};
        WCSPCO.WCSP_CO_ExportEncCert(this.handle(), name, pEncCertData);
        return pEncCertData[0];
    }

    @Override
    public byte[] generateCMSAttachedSignedData(byte[] signerCertificateData, PrivateKey signerPrivateKey, byte[] content) throws CMSException {
        return this.generateCMSSignedData(signerCertificateData, signerPrivateKey, content, true);
    }

    @Override
    public byte[] generateCMSDetachedSignedData(byte[] signerCertificateData, PrivateKey signerPrivateKey, byte[] content) throws CMSException {
        return this.generateCMSSignedData(signerCertificateData, signerPrivateKey, content, false);
    }

    @Override
    public boolean verifyCMSSignedData(byte[] signedDataData) throws CMSException {
        if (null == signedDataData || signedDataData.length < 1) {
            throw new IllegalArgumentException("Argument \"signedDataData\" is null");
        }
        CMSSignedData signedData = CMSSignedData.getInstance(signedDataData);
        byte[] content = signedData.getContent();
        if (null == content) {
            throw new CMSException("Content not encapsulated in CMSSignedData");
        }
        return this.verifyCMSSignedData(signedData, content);
    }

    @Override
    public boolean verifyCMSSignedData(byte[] signedDataData, byte[] content) throws CMSException {
        if (null == signedDataData || signedDataData.length < 1) {
            throw new IllegalArgumentException("Argument \"signedDataData\" is null");
        }
        CMSSignedData signedData = CMSSignedData.getInstance(signedDataData);
        return this.verifyCMSSignedData(signedData, content);
    }

    @Override
    public byte[] encryptCMSEnvelopedData(byte[] recipientCertificateData, byte[] content) throws CMSException {
        if (null == recipientCertificateData || recipientCertificateData.length < 1) {
            throw new IllegalArgumentException("Argument \"recipientCertificateData\" is null");
        }
        CMSEnvelopedData.Generator generator = new CMSEnvelopedData.Generator();
        generator.addRecipient(recipientCertificateData);
        return generator.generate(publicKeyData -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).getEncoded();
    }

    @Override
    public byte[] decryptCMSEnvelopedData(byte[] recipientCertificateData, PrivateKey recipientPrivateKey, byte[] envelopedDataData) throws CMSException {
        if (null == recipientCertificateData || recipientCertificateData.length < 1 || null == envelopedDataData || envelopedDataData.length < 1) {
            throw new IllegalArgumentException("Argument \"recipientCertificateData\" or \"envelopedDataData\" is null");
        }
        CMSEnvelopedData envelopedData = CMSEnvelopedData.getInstance(envelopedDataData);
        return envelopedData.getContent(recipientCertificateData, encryptedDatas -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Override
    public byte[] encryptCMSSignedAndEnvelopedData(byte[] signerCertificateData, PrivateKey signerPrivateKey, byte[] recipientCertificateData, byte[] content) throws CMSException {
        if (null == recipientCertificateData || recipientCertificateData.length < 1 || null == signerCertificateData || signerCertificateData.length < 1 || null == content || content.length < 1) {
            throw new IllegalArgumentException("Argument \"recipientCertificateData\" or \"signerCertificateData\" or \"content\" is null");
        }
        CMSSignedAndEnvelopedData.Generator generator = new CMSSignedAndEnvelopedData.Generator();
        generator.addRecipient(recipientCertificateData).addSigner(signerCertificateData);
        return generator.generate(content, publicKeyData -> {
            try {
                return ConversionUtils.SM2SignatureData.fromGMT0016(this.signDigest(signerPrivateKey, SignatureUtils.sm2PreprocessSM3(publicKeyData, content)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (publicKeyData, signatureData) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }).getEncoded();
    }

    @Override
    public byte[] decryptCMSSignedAndEnvelopedData(byte[] recipientCertificateData, PrivateKey recipientPrivateKey, byte[] signedAndEnvelopedDataData) throws CMSException {
        if (null == recipientCertificateData || recipientCertificateData.length < 1 || null == signedAndEnvelopedDataData || signedAndEnvelopedDataData.length < 1) {
            throw new IllegalArgumentException("Argument \"recipientCertificateData\" or \"signedAndEnvelopedDataData\" is null");
        }
        CMSSignedAndEnvelopedData signedAndEnvelopedData = CMSSignedAndEnvelopedData.getInstance(signedAndEnvelopedDataData);
        byte[][] certificates = signedAndEnvelopedData.getCertificates();
        if (certificates.length < 1) {
            throw new CMSException("There is no certificate in CMSSignedAndEnvelopedData");
        }
        if (certificates.length > 1) {
            throw new CMSException("There are too many certificates in CMSSignedAndEnvelopedData");
        }
        return signedAndEnvelopedData.getContent(certificates[0], recipientCertificateData, verifyParameters -> {
            try {
                return this.verifyDigest(KeyUtils.createPublicKeySM2("SIGN", ConversionUtils.SM2PublicKeyData.toGMT0016(verifyParameters[0])), SignatureUtils.sm2PreprocessSM3(verifyParameters[0], verifyParameters[1]), ConversionUtils.SM2SignatureData.toGMT0016(verifyParameters[2]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, encryptedDatas -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public FileIOCipherImpl getFileIOCipher(SecretKey secretKey, String fileName, FileIOCipherImpl.OPMode opMode) throws InvalidKeyException, WCSPException {
        FileIOCipherImpl fileCipher = new FileIOCipherImpl(this);
        try {
            fileCipher.init(secretKey, fileName, opMode);
        }
        catch (Exception e) {
            fileCipher.close();
            throw e;
        }
        return fileCipher;
    }

    @Override
    protected ServiceImpl.StateKeeper keepState() {
        return super.keepState();
    }

    @Override
    protected long handle() {
        return super.handle();
    }

    private COServiceImpl(PlatformImpl platform) throws WCSPException {
        super(3, "CO", platform);
    }

    private COServiceImpl(int serviceId, String type, PlatformImpl platform) throws WCSPException {
        super(serviceId, type, platform);
    }

    private byte[] generateCMSSignedData(byte[] signerCertificateData, PrivateKey signerPrivateKey, byte[] content, boolean encapsulated) throws CMSException {
        if (null == signerCertificateData || signerCertificateData.length < 1 || null == content || content.length < 1) {
            throw new IllegalArgumentException("Argument \"signerCertificateData\" or \"content\" is null");
        }
        CMSSignedData.Generator generator = new CMSSignedData.Generator();
        generator.addSigner(signerCertificateData);
        return generator.generate(content, (i, publicKeyData) -> {
            try {
                return ConversionUtils.SM2SignatureData.fromGMT0016(this.signDigest(signerPrivateKey, SignatureUtils.sm2PreprocessSM3(publicKeyData, content)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, encapsulated).getEncoded();
    }

    private boolean verifyCMSSignedData(CMSSignedData signedData, byte[] content) throws CMSException {
        if (null == content || content.length < 1) {
            throw new IllegalArgumentException("Argument \"content\" is null");
        }
        byte[][] certificates = signedData.getCertificates();
        if (certificates.length < 1) {
            throw new CMSException("There is no certificate in CMSSignedData");
        }
        if (certificates.length > 1) {
            throw new CMSException("There are too many certificates in CMSSignedData");
        }
        return signedData.verify(content, certificates[0], verifyParameters -> {
            try {
                return this.verifyDigest(KeyUtils.createPublicKeySM2("SIGN", ConversionUtils.SM2PublicKeyData.toGMT0016(verifyParameters[0])), SignatureUtils.sm2PreprocessSM3(verifyParameters[0], verifyParameters[1]), ConversionUtils.SM2SignatureData.toGMT0016(verifyParameters[2]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

