/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.PublicKey;
import cn.com.westone.wcspsdk.baseservice.co.ShortDataEncryptor;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.AsymCipherImpl;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;

public class AsymShortDataEncryptorImpl
extends AsymCipherImpl
implements ShortDataEncryptor {
    @Override
    public byte[] encrypt(byte[] data) throws InvalidParameterException, WCSPException {
        if (null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"data\" is null");
        }
        if (data.length > 1023) {
            throw new InvalidParameterException("Input data is too long");
        }
        byte[][] pEncryptedData = new byte[][]{null};
        WCSPCO.WCSP_CO_AsymEncrypt(this.hPublicKey(), data, pEncryptedData);
        return pEncryptedData[0];
    }

    @Override
    public byte[][] encrypt(byte[][] datas) throws InvalidParameterException, WCSPException {
        if (null == datas || datas.length < 1) {
            throw new IllegalArgumentException("Argument \"datas\" is null");
        }
        byte[][] encryptedDatas = new byte[datas.length][];
        for (int i = 0; i < datas.length; ++i) {
            encryptedDatas[i] = this.encrypt(datas[i]);
        }
        return encryptedDatas;
    }

    @Override
    public PublicKey key() {
        return this.publicKey();
    }

    @Override
    public void close() {
        super.close();
    }

    AsymShortDataEncryptorImpl(String mode, String algorithm, COServiceImpl coService) {
        super(mode, algorithm, coService);
    }
}

