/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.Decryptor;
import cn.com.westone.wcspsdk.baseservice.co.PrivateKey;
import cn.com.westone.wcspsdk.impl.base.Utils;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.AsymCipherImpl;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;

public class AsymDecryptorImpl
extends AsymCipherImpl
implements Decryptor {
    private byte[] cache = null;

    @Override
    public byte[] update(byte[] input) {
        if (null == input || input.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hPrivateKey()) {
            throw new IllegalStateException("Decryptor object has been finalized");
        }
        this.cache = null == this.cache || this.cache.length < 1 ? input : Utils.arrayConcatenate(this.cache, input, new byte[0][]);
        return new byte[0];
    }

    @Override
    public byte[] doFinal() throws WCSPException {
        if (null == this.cache || this.cache.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hPrivateKey()) {
            throw new IllegalStateException("Decryptor object has been finalized");
        }
        byte[][] pData = new byte[][]{null};
        try {
            WCSPCO.WCSP_CO_AsymDecrypt(this.hPrivateKey(), this.cache, pData);
        }
        finally {
            this.cache = null;
        }
        return pData[0];
    }

    @Override
    public byte[] doFinal(byte[] input) throws WCSPException {
        if (null == input || input.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hPrivateKey()) {
            throw new IllegalStateException("Decryptor object has been finalized");
        }
        this.cache = null == this.cache || this.cache.length < 1 ? input : Utils.arrayConcatenate(this.cache, input, new byte[0][]);
        byte[][] pData = new byte[][]{null};
        try {
            WCSPCO.WCSP_CO_AsymDecrypt(this.hPrivateKey(), this.cache, pData);
        }
        finally {
            this.cache = null;
        }
        return pData[0];
    }

    @Override
    public void reset() throws WCSPException {
        if (0L == this.hPrivateKey()) {
            throw new IllegalStateException("Decryptor object has been finalized");
        }
        this.cache = null;
    }

    @Override
    public PrivateKey key() {
        return this.privateKey();
    }

    @Override
    public void close() {
        this.cache = null;
        super.close();
    }

    AsymDecryptorImpl(String mode, String algorithm, COServiceImpl coService) {
        super(mode, algorithm, coService);
    }

    @Override
    void init(PrivateKey privateKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        super.init(privateKey);
        this.cache = null;
    }
}

