/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.base;

import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.impl.base.JNAWCSPSDK;
import cn.com.westone.wcspsdk.impl.base.JNIWCSPKE;
import cn.com.westone.wcspsdk.impl.base.Utils;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;

public final class WCSPKE {
    public static void WCSP_KE_RequestSignKeyPair(long hKEService, String pin, String[] pKeyId, byte[][] pPublicKeyData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] pin[{}]", "0x", hKEService, pin);
        Pointer jnahKEService = new Pointer(hKEService);
        int PIN_SIZE = pin.length() + 1;
        int KEYID_SIZE = 128;
        int PUBLICKEY_SIZE = 65;
        Memory jnaMemory = new Memory(PIN_SIZE + 128 + 65);
        long offset = 0L;
        Pointer jnaPIN = jnaMemory.share(offset, PIN_SIZE);
        jnaPIN.clear(PIN_SIZE);
        jnaPIN.setString(0L, pin);
        Pointer jnapKeyId = jnaMemory.share(offset += (long)PIN_SIZE, 128L);
        jnapKeyId.clear(128L);
        Pointer jnapPublicKeyData = jnaMemory.share(offset += 128L, 65L);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_RequestSignKeyPair(jnahKEService, jnaPIN, jnapKeyId, jnapPublicKeyData), 0, new int[0]);
        pKeyId[0] = jnapKeyId.getString(0L);
        pPublicKeyData[0] = jnapPublicKeyData.getByteArray(0L, 65);
        Utils.WCSP_LOG_D("OUT keyId[{}] publicKeyData[{}]", pKeyId[0], pPublicKeyData[0]);
    }

    public static void WCSP_KE_RequestSignKeyPairByKeyLabel(long hKEService, String label, String pin, String[] pKeyId, byte[][] pPublicKeyData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] label[{}] pin[{}]", "0x", hKEService, label, pin);
        Pointer jnahKEService = new Pointer(hKEService);
        int LABEL_SIZE = label.length() + 1;
        int PIN_SIZE = pin.length() + 1;
        int KEYID_SIZE = 128;
        int PUBLICKEY_SIZE = 65;
        Memory jnaMemory = new Memory(LABEL_SIZE + PIN_SIZE + 128 + 65);
        long offset = 0L;
        Pointer jnaLabel = jnaMemory.share(offset, LABEL_SIZE);
        jnaLabel.clear(LABEL_SIZE);
        jnaLabel.setString(0L, label);
        Pointer jnaPIN = jnaMemory.share(offset += (long)LABEL_SIZE, PIN_SIZE);
        jnaPIN.clear(PIN_SIZE);
        jnaPIN.setString(0L, pin);
        Pointer jnapKeyId = jnaMemory.share(offset += (long)PIN_SIZE, 128L);
        jnapKeyId.clear(128L);
        Pointer jnapPublicKeyData = jnaMemory.share(offset += 128L, 65L);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_RequestSignKeyPairByKeyLabel(jnahKEService, jnaLabel, jnaPIN, jnapKeyId, jnapPublicKeyData), 0, new int[0]);
        pKeyId[0] = jnapKeyId.getString(0L);
        pPublicKeyData[0] = jnapPublicKeyData.getByteArray(0L, 65);
        Utils.WCSP_LOG_D("OUT keyId[{}] publicKeyData[{}]", pKeyId[0], pPublicKeyData[0]);
    }

    public static void WCSP_KE_RequestSignKeyPairWithP10(long hKEService, String pin, String subjectDN, String attributes, String[] pKeyId, byte[][] pPublicKeyData, byte[][] pCSRData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] pin[{}] subjectDN[{}] attributes[{}]", "0x", hKEService, pin, subjectDN, attributes);
        Pointer jnahKEService = new Pointer(hKEService);
        int PIN_SIZE = pin.length() + 1;
        int SUBJECTDN_SIZE = subjectDN.length() + 1;
        int ATTRIBUTES_SIZE = attributes.length() + 1;
        int KEYID_SIZE = 128;
        int PUBLICKEY_SIZE = 65;
        int CSRDATA_SIZE = ((SUBJECTDN_SIZE + ATTRIBUTES_SIZE + 1023) / 1024 + 1) * 1024;
        int LENGTH_SIZE = 4;
        Memory jnaMemory = new Memory(PIN_SIZE + SUBJECTDN_SIZE + ATTRIBUTES_SIZE + 128 + 65 + CSRDATA_SIZE + 4);
        long offset = 0L;
        Pointer jnaPIN = jnaMemory.share(offset, PIN_SIZE);
        jnaPIN.clear(PIN_SIZE);
        jnaPIN.setString(0L, pin);
        Pointer jnaSubjectDN = jnaMemory.share(offset += (long)PIN_SIZE, SUBJECTDN_SIZE);
        jnaSubjectDN.clear(SUBJECTDN_SIZE);
        jnaSubjectDN.setString(0L, subjectDN);
        Pointer jnaAttributes = jnaMemory.share(offset += (long)SUBJECTDN_SIZE, ATTRIBUTES_SIZE);
        jnaAttributes.clear(ATTRIBUTES_SIZE);
        jnaAttributes.setString(0L, attributes);
        Pointer jnapKeyId = jnaMemory.share(offset += (long)ATTRIBUTES_SIZE, 128L);
        jnapKeyId.clear(128L);
        Pointer jnapPublicKeyData = jnaMemory.share(offset += 128L, 65L);
        Pointer jnapCSRData = jnaMemory.share(offset += 65L, CSRDATA_SIZE);
        Pointer jnapCSRDataLength = jnaMemory.share(offset += (long)CSRDATA_SIZE, 4L);
        jnapCSRDataLength.setInt(0L, CSRDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_RequestSignKeyPairWithP10(jnahKEService, jnaPIN, jnaSubjectDN, jnaAttributes, jnapKeyId, jnapPublicKeyData, jnapCSRData, jnapCSRDataLength), 0, new int[0]);
        int csrDataLength = jnapCSRDataLength.getInt(0L);
        if (csrDataLength < 0) {
            throw new WCSPException("WCSP_KE_RequestSignKeyPairWithP10 failed", 655363);
        }
        if (csrDataLength > CSRDATA_SIZE) {
            throw new WCSPException("WCSP_KE_RequestSignKeyPairWithP10 failed", 655362);
        }
        pKeyId[0] = jnapKeyId.getString(0L);
        pPublicKeyData[0] = jnapPublicKeyData.getByteArray(0L, 65);
        pCSRData[0] = jnapCSRData.getByteArray(0L, csrDataLength);
        Utils.WCSP_LOG_D("OUT keyId[{}] publicKeyData[{}] csrData[{}]", pKeyId[0], pPublicKeyData[0], pCSRData[0]);
    }

    public static void WCSP_KE_RequestSignKeyPairWithP10ByKeyLabel(long hKEService, String label, String pin, String subjectDN, String attributes, String[] pKeyId, byte[][] pPublicKeyData, byte[][] pCSRData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] label[{}] pin[{}] subjectDN[{}] attributes[{}]", "0x", hKEService, label, pin, subjectDN, attributes);
        Pointer jnahKEService = new Pointer(hKEService);
        int LABEL_SIZE = label.length() + 1;
        int PIN_SIZE = pin.length() + 1;
        int SUBJECTDN_SIZE = subjectDN.length() + 1;
        int ATTRIBUTES_SIZE = attributes.length() + 1;
        int KEYID_SIZE = 128;
        int PUBLICKEY_SIZE = 65;
        int CSRDATA_SIZE = ((SUBJECTDN_SIZE + ATTRIBUTES_SIZE + 1023) / 1024 + 1) * 1024;
        int LENGTH_SIZE = 4;
        Memory jnaMemory = new Memory(LABEL_SIZE + PIN_SIZE + SUBJECTDN_SIZE + ATTRIBUTES_SIZE + 128 + 65 + CSRDATA_SIZE + 4);
        long offset = 0L;
        Pointer jnaLabel = jnaMemory.share(offset, LABEL_SIZE);
        jnaLabel.clear(LABEL_SIZE);
        jnaLabel.setString(0L, label);
        Pointer jnaPIN = jnaMemory.share(offset += (long)LABEL_SIZE, PIN_SIZE);
        jnaPIN.clear(PIN_SIZE);
        jnaPIN.setString(0L, pin);
        Pointer jnaSubjectDN = jnaMemory.share(offset += (long)PIN_SIZE, SUBJECTDN_SIZE);
        jnaSubjectDN.clear(SUBJECTDN_SIZE);
        jnaSubjectDN.setString(0L, subjectDN);
        Pointer jnaAttributes = jnaMemory.share(offset += (long)SUBJECTDN_SIZE, ATTRIBUTES_SIZE);
        jnaAttributes.clear(ATTRIBUTES_SIZE);
        jnaAttributes.setString(0L, attributes);
        Pointer jnapKeyId = jnaMemory.share(offset += (long)ATTRIBUTES_SIZE, 128L);
        jnapKeyId.clear(128L);
        Pointer jnapPublicKeyData = jnaMemory.share(offset += 128L, 65L);
        Pointer jnapCSRData = jnaMemory.share(offset += 65L, CSRDATA_SIZE);
        Pointer jnapCSRDataLength = jnaMemory.share(offset += (long)CSRDATA_SIZE, 4L);
        jnapCSRDataLength.setInt(0L, CSRDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_RequestSignKeyPairWithP10ByKeyLabel(jnahKEService, jnaLabel, jnaPIN, jnaSubjectDN, jnaAttributes, jnapKeyId, jnapPublicKeyData, jnapCSRData, jnapCSRDataLength), 0, new int[0]);
        int csrDataLength = jnapCSRDataLength.getInt(0L);
        if (csrDataLength < 0) {
            throw new WCSPException("WCSP_KE_RequestSignKeyPairWithP10ByKeyLabel failed", 655363);
        }
        if (csrDataLength > CSRDATA_SIZE) {
            throw new WCSPException("WCSP_KE_RequestSignKeyPairWithP10ByKeyLabel failed", 655362);
        }
        pKeyId[0] = jnapKeyId.getString(0L);
        pPublicKeyData[0] = jnapPublicKeyData.getByteArray(0L, 65);
        pCSRData[0] = jnapCSRData.getByteArray(0L, csrDataLength);
        Utils.WCSP_LOG_D("OUT keyId[{}] publicKeyData[{}] csrData[{}]", pKeyId[0], pPublicKeyData[0], pCSRData[0]);
    }

    public static void WCSP_KE_ModifyPin(long hKEService, String keyId, String oldPIN, String newPIN) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] keyId[{}] oldPIN[{}] newPIN[{}]", "0x", hKEService, keyId, oldPIN, newPIN);
        Pointer jnahKEService = new Pointer(hKEService);
        int KEYID_SIZE = keyId.length() + 1;
        int OLDPIN_SIZE = oldPIN.length() + 1;
        int NEWPIN_SIZE = newPIN.length() + 1;
        Memory jnaMemory = new Memory(KEYID_SIZE + OLDPIN_SIZE + NEWPIN_SIZE);
        long offset = 0L;
        Pointer jnaKeyId = jnaMemory.share(offset, KEYID_SIZE);
        jnaKeyId.clear(KEYID_SIZE);
        jnaKeyId.setString(0L, keyId);
        Pointer jnaOldPIN = jnaMemory.share(offset += (long)KEYID_SIZE, OLDPIN_SIZE);
        jnaOldPIN.clear(OLDPIN_SIZE);
        jnaOldPIN.setString(0L, oldPIN);
        Pointer jnaNewPIN = jnaMemory.share(offset += (long)OLDPIN_SIZE, NEWPIN_SIZE);
        jnaNewPIN.clear(NEWPIN_SIZE);
        jnaNewPIN.setString(0L, newPIN);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_ModifyPin(jnahKEService, jnaKeyId, jnaOldPIN, jnaNewPIN), 0, new int[0]);
    }

    public static void WCSP_KE_ModifyPinByKeyLabel(long hKEService, String label, String oldPIN, String newPIN) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] label[{}] oldPIN[{}] newPIN[{}]", "0x", hKEService, label, oldPIN, newPIN);
        Pointer jnahKEService = new Pointer(hKEService);
        int LABEL_SIZE = label.length() + 1;
        int OLDPIN_SIZE = oldPIN.length() + 1;
        int NEWPIN_SIZE = newPIN.length() + 1;
        Memory jnaMemory = new Memory(LABEL_SIZE + OLDPIN_SIZE + NEWPIN_SIZE);
        long offset = 0L;
        Pointer jnaLabel = jnaMemory.share(offset, LABEL_SIZE);
        jnaLabel.clear(LABEL_SIZE);
        jnaLabel.setString(0L, label);
        Pointer jnaOldPIN = jnaMemory.share(offset += (long)LABEL_SIZE, OLDPIN_SIZE);
        jnaOldPIN.clear(OLDPIN_SIZE);
        jnaOldPIN.setString(0L, oldPIN);
        Pointer jnaNewPIN = jnaMemory.share(offset += (long)OLDPIN_SIZE, NEWPIN_SIZE);
        jnaNewPIN.clear(NEWPIN_SIZE);
        jnaNewPIN.setString(0L, newPIN);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_ModifyPinByKeyLabel(jnahKEService, jnaLabel, jnaOldPIN, jnaNewPIN), 0, new int[0]);
    }

    public static void WCSP_KE_UploadCert(long hKEService, String keyId, byte[] signCertData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] keyId[{}] signCertData[{}]", "0x", hKEService, keyId, signCertData);
        Pointer jnahKEService = new Pointer(hKEService);
        int KEYID_SIZE = keyId.length() + 1;
        int SIGNCERTDATA_SIZE = signCertData.length;
        Memory jnaMemory = new Memory(KEYID_SIZE + SIGNCERTDATA_SIZE);
        long offset = 0L;
        Pointer jnaKeyId = jnaMemory.share(offset, KEYID_SIZE);
        jnaKeyId.clear(KEYID_SIZE);
        jnaKeyId.setString(0L, keyId);
        Pointer jnaSignCertData = jnaMemory.share(offset += (long)KEYID_SIZE, SIGNCERTDATA_SIZE);
        jnaSignCertData.write(0L, signCertData, 0, SIGNCERTDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_UploadCert(jnahKEService, jnaKeyId, jnaSignCertData, SIGNCERTDATA_SIZE), 0, new int[0]);
    }

    public static void WCSP_KE_UploadCertByKeyLabel(long hKEService, String label, byte[] signCertData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] label[{}] signCertData[{}]", "0x", hKEService, label, signCertData);
        Pointer jnahKEService = new Pointer(hKEService);
        int LABEL_SIZE = label.length() + 1;
        int SIGNCERTDATA_SIZE = signCertData.length;
        Memory jnaMemory = new Memory(LABEL_SIZE + SIGNCERTDATA_SIZE);
        long offset = 0L;
        Pointer jnaLabel = jnaMemory.share(offset, LABEL_SIZE);
        jnaLabel.clear(LABEL_SIZE);
        jnaLabel.setString(0L, label);
        Pointer jnaSignCertData = jnaMemory.share(offset += (long)LABEL_SIZE, SIGNCERTDATA_SIZE);
        jnaSignCertData.write(0L, signCertData, 0, SIGNCERTDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_UploadCertByKeyLabel(jnahKEService, jnaLabel, jnaSignCertData, SIGNCERTDATA_SIZE), 0, new int[0]);
    }

    public static void WCSP_KE_UploadSignAndEncCert(long hKEService, String keyId, String pin, byte[] signCertData, byte[] encCertData, byte[] envelopedEncKeyPairData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] keyId[{}] pin[{}]", "0x", hKEService, keyId, pin);
        Utils.WCSP_LOG_D("IN signCertData[{}]", new Object[]{signCertData});
        Utils.WCSP_LOG_D("IN encCertData[{}]", new Object[]{encCertData});
        Utils.WCSP_LOG_D("IN envelopedEncKeyPairData[{}]", new Object[]{envelopedEncKeyPairData});
        Pointer jnahKEService = new Pointer(hKEService);
        int KEYID_SIZE = keyId.length() + 1;
        int PIN_SIZE = pin.length() + 1;
        int SIGNCERTDATA_SIZE = signCertData.length;
        int ENCCERTDATA_SIZE = encCertData.length;
        int ENVELOPEDKEYPAIRDATA_SIZE = envelopedEncKeyPairData.length;
        Memory jnaMemory = new Memory(KEYID_SIZE + PIN_SIZE + SIGNCERTDATA_SIZE + ENCCERTDATA_SIZE + ENVELOPEDKEYPAIRDATA_SIZE);
        long offset = 0L;
        Pointer jnaKeyId = jnaMemory.share(offset, KEYID_SIZE);
        jnaKeyId.clear(KEYID_SIZE);
        jnaKeyId.setString(0L, keyId);
        Pointer jnaPIN = jnaMemory.share(offset += (long)KEYID_SIZE, PIN_SIZE);
        jnaPIN.clear(PIN_SIZE);
        jnaPIN.setString(0L, pin);
        Pointer jnaSignCertData = jnaMemory.share(offset += (long)PIN_SIZE, SIGNCERTDATA_SIZE);
        jnaSignCertData.write(0L, signCertData, 0, SIGNCERTDATA_SIZE);
        Pointer jnaEncCertData = jnaMemory.share(offset += (long)SIGNCERTDATA_SIZE, ENCCERTDATA_SIZE);
        jnaEncCertData.write(0L, encCertData, 0, ENCCERTDATA_SIZE);
        Pointer jnaEnvelopedEncKeyPairData = jnaMemory.share(offset += (long)ENCCERTDATA_SIZE, ENVELOPEDKEYPAIRDATA_SIZE);
        jnaEnvelopedEncKeyPairData.write(0L, envelopedEncKeyPairData, 0, ENVELOPEDKEYPAIRDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_UploadSignAndEncCert(jnahKEService, jnaKeyId, jnaPIN, jnaSignCertData, SIGNCERTDATA_SIZE, jnaEncCertData, ENCCERTDATA_SIZE, jnaEnvelopedEncKeyPairData, ENVELOPEDKEYPAIRDATA_SIZE), 0, new int[0]);
    }

    public static void WCSP_KE_UploadSignAndEncCertByKeyLabel(long hKEService, String label, String pin, byte[] signCertData, byte[] encCertData, byte[] envelopedEncKeyPairData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] label[{}] pin[{}]", "0x", hKEService, label, pin);
        Utils.WCSP_LOG_D("IN signCertData[{}]", new Object[]{signCertData});
        Utils.WCSP_LOG_D("IN encCertData[{}]", new Object[]{encCertData});
        Utils.WCSP_LOG_D("IN envelopedEncKeyPairData[{}]", new Object[]{envelopedEncKeyPairData});
        Pointer jnahKEService = new Pointer(hKEService);
        int LABEL_SIZE = label.length() + 1;
        int PIN_SIZE = pin.length() + 1;
        int SIGNCERTDATA_SIZE = signCertData.length;
        int ENCCERTDATA_SIZE = encCertData.length;
        int ENVELOPEDKEYPAIRDATA_SIZE = envelopedEncKeyPairData.length;
        Memory jnaMemory = new Memory(LABEL_SIZE + PIN_SIZE + SIGNCERTDATA_SIZE + ENCCERTDATA_SIZE + ENVELOPEDKEYPAIRDATA_SIZE);
        long offset = 0L;
        Pointer jnaLabel = jnaMemory.share(offset, LABEL_SIZE);
        jnaLabel.clear(LABEL_SIZE);
        jnaLabel.setString(0L, label);
        Pointer jnaPIN = jnaMemory.share(offset += (long)LABEL_SIZE, PIN_SIZE);
        jnaPIN.clear(PIN_SIZE);
        jnaPIN.setString(0L, pin);
        Pointer jnaSignCertData = jnaMemory.share(offset += (long)PIN_SIZE, SIGNCERTDATA_SIZE);
        jnaSignCertData.write(0L, signCertData, 0, SIGNCERTDATA_SIZE);
        Pointer jnaEncCertData = jnaMemory.share(offset += (long)SIGNCERTDATA_SIZE, ENCCERTDATA_SIZE);
        jnaEncCertData.write(0L, encCertData, 0, ENCCERTDATA_SIZE);
        Pointer jnaEnvelopedEncKeyPairData = jnaMemory.share(offset += (long)ENCCERTDATA_SIZE, ENVELOPEDKEYPAIRDATA_SIZE);
        jnaEnvelopedEncKeyPairData.write(0L, envelopedEncKeyPairData, 0, ENVELOPEDKEYPAIRDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_UploadSignAndEncCertByKeyLabel(jnahKEService, jnaLabel, jnaPIN, jnaSignCertData, SIGNCERTDATA_SIZE, jnaEncCertData, ENCCERTDATA_SIZE, jnaEnvelopedEncKeyPairData, ENVELOPEDKEYPAIRDATA_SIZE), 0, new int[0]);
    }

    public static void WCSP_KE_Sign(long hKEService, String keyId, String pin, byte[] data, byte[][] pSignatureData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] keyId[{}] pin[{}] data[{}]", "0x", hKEService, keyId, pin, data);
        Pointer jnahKEService = new Pointer(hKEService);
        int KEYID_SIZE = keyId.length() + 1;
        int PIN_SIZE = pin.length() + 1;
        int DATA_SIZE = data.length;
        int SIGNATUREDATA_SIZE = 64;
        Memory jnaMemory = new Memory(KEYID_SIZE + PIN_SIZE + DATA_SIZE + 64);
        long offset = 0L;
        Pointer jnaKeyId = jnaMemory.share(offset, KEYID_SIZE);
        jnaKeyId.clear(KEYID_SIZE);
        jnaKeyId.setString(0L, keyId);
        Pointer jnaPIN = jnaMemory.share(offset += (long)KEYID_SIZE, PIN_SIZE);
        jnaPIN.clear(PIN_SIZE);
        jnaPIN.setString(0L, pin);
        Pointer jnaData = jnaMemory.share(offset += (long)PIN_SIZE, DATA_SIZE);
        jnaData.write(0L, data, 0, DATA_SIZE);
        Pointer jnapSignatureData = jnaMemory.share(offset += (long)DATA_SIZE, 64L);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_Sign(jnahKEService, jnaKeyId, jnaPIN, jnaData, DATA_SIZE, jnapSignatureData), 0, new int[0]);
        pSignatureData[0] = jnapSignatureData.getByteArray(0L, 64);
        Utils.WCSP_LOG_D("OUT signatureData[{}]", new Object[]{pSignatureData[0]});
    }

    public static void WCSP_KE_SignByKeyLabel(long hKEService, String label, String pin, byte[] data, byte[][] pSignatureData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] label[{}] pin[{}] data[{}]", "0x", hKEService, label, pin, data);
        Pointer jnahKEService = new Pointer(hKEService);
        int LABEL_SIZE = label.length() + 1;
        int PIN_SIZE = pin.length() + 1;
        int DATA_SIZE = data.length;
        int SIGNATUREDATA_SIZE = 64;
        Memory jnaMemory = new Memory(LABEL_SIZE + PIN_SIZE + DATA_SIZE + 64);
        long offset = 0L;
        Pointer jnaLabel = jnaMemory.share(offset, LABEL_SIZE);
        jnaLabel.clear(LABEL_SIZE);
        jnaLabel.setString(0L, label);
        Pointer jnaPIN = jnaMemory.share(offset += (long)LABEL_SIZE, PIN_SIZE);
        jnaPIN.clear(PIN_SIZE);
        jnaPIN.setString(0L, pin);
        Pointer jnaData = jnaMemory.share(offset += (long)PIN_SIZE, DATA_SIZE);
        jnaData.write(0L, data, 0, DATA_SIZE);
        Pointer jnapSignatureData = jnaMemory.share(offset += (long)DATA_SIZE, 64L);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_SignByKeyLabel(jnahKEService, jnaLabel, jnaPIN, jnaData, DATA_SIZE, jnapSignatureData), 0, new int[0]);
        pSignatureData[0] = jnapSignatureData.getByteArray(0L, 64);
        Utils.WCSP_LOG_D("OUT signatureData[{}]", new Object[]{pSignatureData[0]});
    }

    public static void WCSP_KE_SignDigest(long hKEService, String keyId, String pin, byte[] digestData, byte[][] pSignatureData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] keyId[{}] pin[{}] digestData[{}]", "0x", hKEService, keyId, pin, digestData);
        Pointer jnahKEService = new Pointer(hKEService);
        int KEYID_SIZE = keyId.length() + 1;
        int PIN_SIZE = pin.length() + 1;
        int DIGESTDATA_SIZE = digestData.length;
        int SIGNATUREDATA_SIZE = 64;
        Memory jnaMemory = new Memory(KEYID_SIZE + PIN_SIZE + DIGESTDATA_SIZE + 64);
        long offset = 0L;
        Pointer jnaKeyId = jnaMemory.share(offset, KEYID_SIZE);
        jnaKeyId.clear(KEYID_SIZE);
        jnaKeyId.setString(0L, keyId);
        Pointer jnaPIN = jnaMemory.share(offset += (long)KEYID_SIZE, PIN_SIZE);
        jnaPIN.clear(PIN_SIZE);
        jnaPIN.setString(0L, pin);
        Pointer jnaDigestData = jnaMemory.share(offset += (long)PIN_SIZE, DIGESTDATA_SIZE);
        jnaDigestData.write(0L, digestData, 0, DIGESTDATA_SIZE);
        Pointer jnapSignatureData = jnaMemory.share(offset += (long)DIGESTDATA_SIZE, 64L);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_SignDigest(jnahKEService, jnaKeyId, jnaPIN, jnaDigestData, jnapSignatureData), 0, new int[0]);
        pSignatureData[0] = jnapSignatureData.getByteArray(0L, 64);
        Utils.WCSP_LOG_D("OUT signatureData[{}]", new Object[]{pSignatureData[0]});
    }

    public static void WCSP_KE_SignDigestByKeyLabel(long hKEService, String label, String pin, byte[] digestData, byte[][] pSignatureData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] label[{}] pin[{}] digestData[{}]", "0x", hKEService, label, pin, digestData);
        Pointer jnahKEService = new Pointer(hKEService);
        int LABEL_SIZE = label.length() + 1;
        int PIN_SIZE = pin.length() + 1;
        int DIGESTDATA_SIZE = digestData.length;
        int SIGNATUREDATA_SIZE = 64;
        Memory jnaMemory = new Memory(LABEL_SIZE + PIN_SIZE + DIGESTDATA_SIZE + 64);
        long offset = 0L;
        Pointer jnaLabel = jnaMemory.share(offset, LABEL_SIZE);
        jnaLabel.clear(LABEL_SIZE);
        jnaLabel.setString(0L, label);
        Pointer jnaPIN = jnaMemory.share(offset += (long)LABEL_SIZE, PIN_SIZE);
        jnaPIN.clear(PIN_SIZE);
        jnaPIN.setString(0L, pin);
        Pointer jnaDigestData = jnaMemory.share(offset += (long)PIN_SIZE, DIGESTDATA_SIZE);
        jnaDigestData.write(0L, digestData, 0, DIGESTDATA_SIZE);
        Pointer jnapSignatureData = jnaMemory.share(offset += (long)DIGESTDATA_SIZE, 64L);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_SignDigestByKeyLabel(jnahKEService, jnaLabel, jnaPIN, jnaDigestData, jnapSignatureData), 0, new int[0]);
        pSignatureData[0] = jnapSignatureData.getByteArray(0L, 64);
        Utils.WCSP_LOG_D("OUT signatureData[{}]", new Object[]{pSignatureData[0]});
    }

    public static void WCSP_KE_Encrypt(long hKEService, String keyId, byte[] data, byte[][] pEncryptedData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] keyId[{}] data[{}]", "0x", hKEService, keyId, data);
        Pointer jnahKEService = new Pointer(hKEService);
        int KEYID_SIZE = keyId.length() + 1;
        int DATA_SIZE = data.length;
        int ENCRYPTEDDATA_SIZE = 164 + (DATA_SIZE + 15) / 16 * 16;
        int LENGTH_SIZE = 4;
        Memory jnaMemory = new Memory(KEYID_SIZE + DATA_SIZE + ENCRYPTEDDATA_SIZE + 4);
        long offset = 0L;
        Pointer jnaKeyId = jnaMemory.share(offset, KEYID_SIZE);
        jnaKeyId.clear(KEYID_SIZE);
        jnaKeyId.setString(0L, keyId);
        Pointer jnaData = jnaMemory.share(offset += (long)KEYID_SIZE, DATA_SIZE);
        jnaData.write(0L, data, 0, DATA_SIZE);
        Pointer jnapEncryptedData = jnaMemory.share(offset += (long)DATA_SIZE, ENCRYPTEDDATA_SIZE);
        Pointer jnapEncryptedDataLength = jnaMemory.share(offset += (long)ENCRYPTEDDATA_SIZE, 4L);
        jnapEncryptedDataLength.setInt(0L, ENCRYPTEDDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_Encrypt(jnahKEService, jnaKeyId, jnaData, DATA_SIZE, jnapEncryptedData, jnapEncryptedDataLength), 0, new int[0]);
        int encryptedDataLength = jnapEncryptedDataLength.getInt(0L);
        if (encryptedDataLength < 0) {
            throw new WCSPException("WCSP_KE_Encrypt failed", 655363);
        }
        if (encryptedDataLength > ENCRYPTEDDATA_SIZE) {
            throw new WCSPException("WCSP_KE_Encrypt failed", 655362);
        }
        pEncryptedData[0] = jnapEncryptedData.getByteArray(0L, encryptedDataLength);
        Utils.WCSP_LOG_D("OUT encryptedData[{}]", new Object[]{pEncryptedData[0]});
    }

    public static void WCSP_KE_EncryptByKeyLabel(long hKEService, String label, byte[] data, byte[][] pEncryptedData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] label[{}] data[{}]", "0x", hKEService, label, data);
        Pointer jnahKEService = new Pointer(hKEService);
        int LABEL_SIZE = label.length() + 1;
        int DATA_SIZE = data.length;
        int ENCRYPTEDDATA_SIZE = 164 + (DATA_SIZE + 15) / 16 * 16;
        int LENGTH_SIZE = 4;
        Memory jnaMemory = new Memory(LABEL_SIZE + DATA_SIZE + ENCRYPTEDDATA_SIZE + 4);
        long offset = 0L;
        Pointer jnaLabel = jnaMemory.share(offset, LABEL_SIZE);
        jnaLabel.clear(LABEL_SIZE);
        jnaLabel.setString(0L, label);
        Pointer jnaData = jnaMemory.share(offset += (long)LABEL_SIZE, DATA_SIZE);
        jnaData.write(0L, data, 0, DATA_SIZE);
        Pointer jnapEncryptedData = jnaMemory.share(offset += (long)DATA_SIZE, ENCRYPTEDDATA_SIZE);
        Pointer jnapEncryptedDataLength = jnaMemory.share(offset += (long)ENCRYPTEDDATA_SIZE, 4L);
        jnapEncryptedDataLength.setInt(0L, ENCRYPTEDDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_EncryptByKeyLabel(jnahKEService, jnaLabel, jnaData, DATA_SIZE, jnapEncryptedData, jnapEncryptedDataLength), 0, new int[0]);
        int encryptedDataLength = jnapEncryptedDataLength.getInt(0L);
        if (encryptedDataLength < 0) {
            throw new WCSPException("WCSP_KE_EncryptByKeyLabel failed", 655363);
        }
        if (encryptedDataLength > ENCRYPTEDDATA_SIZE) {
            throw new WCSPException("WCSP_KE_EncryptByKeyLabel failed", 655362);
        }
        pEncryptedData[0] = jnapEncryptedData.getByteArray(0L, encryptedDataLength);
        Utils.WCSP_LOG_D("OUT encryptedData[{}]", new Object[]{pEncryptedData[0]});
    }

    public static void WCSP_KE_Decrypt(long hKEService, String keyId, String pin, byte[] encryptedData, byte[][] pData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] keyId[{}] pin[{}] data[{}]", "0x", hKEService, keyId, pin, encryptedData);
        Pointer jnahKEService = new Pointer(hKEService);
        int KEYID_SIZE = keyId.length() + 1;
        int PIN_SIZE = pin.length() + 1;
        int ENCRYPTEDDATA_SIZE = encryptedData.length;
        int DATA_SIZE = (ENCRYPTEDDATA_SIZE + 15) / 16 * 16;
        int LENGTH_SIZE = 4;
        Memory jnaMemory = new Memory(KEYID_SIZE + PIN_SIZE + ENCRYPTEDDATA_SIZE + DATA_SIZE + 4);
        long offset = 0L;
        Pointer jnaKeyId = jnaMemory.share(offset, KEYID_SIZE);
        jnaKeyId.clear(KEYID_SIZE);
        jnaKeyId.setString(0L, keyId);
        Pointer jnaPIN = jnaMemory.share(offset += (long)KEYID_SIZE, PIN_SIZE);
        jnaPIN.clear(PIN_SIZE);
        jnaPIN.setString(0L, pin);
        Pointer jnapEncryptedData = jnaMemory.share(offset += (long)PIN_SIZE, ENCRYPTEDDATA_SIZE);
        jnapEncryptedData.write(0L, encryptedData, 0, ENCRYPTEDDATA_SIZE);
        Pointer jnaData = jnaMemory.share(offset += (long)ENCRYPTEDDATA_SIZE, DATA_SIZE);
        Pointer jnapDataLength = jnaMemory.share(offset += (long)DATA_SIZE, 4L);
        jnapDataLength.setInt(0L, DATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_Decrypt(jnahKEService, jnaKeyId, jnaPIN, jnapEncryptedData, ENCRYPTEDDATA_SIZE, jnaData, jnapDataLength), 0, new int[0]);
        int dataLength = jnapDataLength.getInt(0L);
        if (dataLength < 0) {
            throw new WCSPException("WCSP_KE_Decrypt failed", 655363);
        }
        if (dataLength > DATA_SIZE) {
            throw new WCSPException("WCSP_KE_Decrypt failed", 655362);
        }
        pData[0] = jnaData.getByteArray(0L, dataLength);
        Utils.WCSP_LOG_D("OUT data[{}]", new Object[]{pData[0]});
    }

    public static void WCSP_KE_DecryptByKeyLabel(long hKEService, String label, String pin, byte[] encryptedData, byte[][] pData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] label[{}] pin[{}] data[{}]", "0x", hKEService, label, pin, encryptedData);
        Pointer jnahKEService = new Pointer(hKEService);
        int LABEL_SIZE = label.length() + 1;
        int PIN_SIZE = pin.length() + 1;
        int ENCRYPTEDDATA_SIZE = encryptedData.length;
        int DATA_SIZE = (ENCRYPTEDDATA_SIZE + 15) / 16 * 16;
        int LENGTH_SIZE = 4;
        Memory jnaMemory = new Memory(LABEL_SIZE + PIN_SIZE + ENCRYPTEDDATA_SIZE + DATA_SIZE + 4);
        long offset = 0L;
        Pointer jnaLabel = jnaMemory.share(offset, LABEL_SIZE);
        jnaLabel.clear(LABEL_SIZE);
        jnaLabel.setString(0L, label);
        Pointer jnaPIN = jnaMemory.share(offset += (long)LABEL_SIZE, PIN_SIZE);
        jnaPIN.clear(PIN_SIZE);
        jnaPIN.setString(0L, pin);
        Pointer jnapEncryptedData = jnaMemory.share(offset += (long)PIN_SIZE, ENCRYPTEDDATA_SIZE);
        jnapEncryptedData.write(0L, encryptedData, 0, ENCRYPTEDDATA_SIZE);
        Pointer jnaData = jnaMemory.share(offset += (long)ENCRYPTEDDATA_SIZE, DATA_SIZE);
        Pointer jnapDataLength = jnaMemory.share(offset += (long)DATA_SIZE, 4L);
        jnapDataLength.setInt(0L, DATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_DecryptByKeyLabel(jnahKEService, jnaLabel, jnaPIN, jnapEncryptedData, ENCRYPTEDDATA_SIZE, jnaData, jnapDataLength), 0, new int[0]);
        int dataLength = jnapDataLength.getInt(0L);
        if (dataLength < 0) {
            throw new WCSPException("WCSP_KE_DecryptByKeyLabel failed", 655363);
        }
        if (dataLength > DATA_SIZE) {
            throw new WCSPException("WCSP_KE_DecryptByKeyLabel failed", 655362);
        }
        pData[0] = jnaData.getByteArray(0L, dataLength);
        Utils.WCSP_LOG_D("OUT data[{}]", new Object[]{pData[0]});
    }

    public static void WCSP_KE_GetCert(long hKEService, String keyId, byte[][] pSignCertData, byte[][] pEncCertData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] keyId[{}]", "0x", hKEService, keyId);
        Pointer jnahKEService = new Pointer(hKEService);
        int KEYID_SIZE = keyId.length() + 1;
        int LENGTH_SIZE = 4;
        Memory jnaMemory = new Memory(KEYID_SIZE + 4 + 4);
        long offset = 0L;
        Pointer jnaKeyId = jnaMemory.share(offset, KEYID_SIZE);
        jnaKeyId.clear(KEYID_SIZE);
        jnaKeyId.setString(0L, keyId);
        Pointer jnapSignCertDataLength = jnaMemory.share(offset += (long)KEYID_SIZE, 4L);
        Pointer jnapEncCertDataLength = jnaMemory.share(offset += 4L, 4L);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_GetCert(jnahKEService, jnaKeyId, null, jnapSignCertDataLength, null, jnapEncCertDataLength), 0, new int[0]);
        int SIGNCERTDATA_SIZE = jnapSignCertDataLength.getInt(0L);
        int ENCCERTDATA_SIZE = jnapEncCertDataLength.getInt(0L);
        if (SIGNCERTDATA_SIZE < 0 || ENCCERTDATA_SIZE < 0) {
            throw new WCSPException("WCSP_KE_GetCert failed", 655363);
        }
        Memory jnaOutMemory = new Memory(SIGNCERTDATA_SIZE + ENCCERTDATA_SIZE);
        offset = 0L;
        Pointer jnapSignCertData = jnaOutMemory.share(offset, SIGNCERTDATA_SIZE);
        Pointer jnapEncCertData = jnaOutMemory.share(offset += (long)SIGNCERTDATA_SIZE, ENCCERTDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_GetCert(jnahKEService, jnaKeyId, jnapSignCertData, jnapSignCertDataLength, jnapEncCertData, jnapEncCertDataLength), 0, new int[0]);
        int signCertDataLength = jnapSignCertDataLength.getInt(0L);
        int encCertDataLength = jnapEncCertDataLength.getInt(0L);
        if (signCertDataLength < 0 || encCertDataLength < 0) {
            throw new WCSPException("WCSP_KE_GetCert failed", 655363);
        }
        if (signCertDataLength > SIGNCERTDATA_SIZE || encCertDataLength > ENCCERTDATA_SIZE) {
            throw new WCSPException("WCSP_KE_GetCert failed", 655362);
        }
        pSignCertData[0] = jnapSignCertData.getByteArray(0L, signCertDataLength);
        pEncCertData[0] = jnapEncCertData.getByteArray(0L, encCertDataLength);
        Utils.WCSP_LOG_D("OUT signCertData[{}]", new Object[]{pSignCertData[0]});
        Utils.WCSP_LOG_D("OUT encCertData[{}]", new Object[]{pEncCertData[0]});
    }

    public static void WCSP_KE_GetCertByKeyLabel(long hKEService, String label, String[] pKeyId, byte[][] pSignCertData, byte[][] pEncCertData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] label[{}]", "0x", hKEService, label);
        Pointer jnahKEService = new Pointer(hKEService);
        int LABEL_SIZE = label.length() + 1;
        int KEYID_SIZE = 128;
        int LENGTH_SIZE = 4;
        Memory jnaMemory = new Memory(LABEL_SIZE + 128 + 4 + 4);
        long offset = 0L;
        Pointer jnaLabel = jnaMemory.share(offset, LABEL_SIZE);
        jnaLabel.clear(LABEL_SIZE);
        jnaLabel.setString(0L, label);
        Pointer jnaPKeyId = jnaMemory.share(offset += (long)LABEL_SIZE, 128L);
        jnaPKeyId.clear(128L);
        Pointer jnapSignCertDataLength = jnaMemory.share(offset += 128L, 4L);
        Pointer jnapEncCertDataLength = jnaMemory.share(offset += 4L, 4L);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_GetCertByKeyLabel(jnahKEService, jnaLabel, jnaPKeyId, null, jnapSignCertDataLength, null, jnapEncCertDataLength), 0, new int[0]);
        int SIGNCERTDATA_SIZE = jnapSignCertDataLength.getInt(0L);
        int ENCCERTDATA_SIZE = jnapEncCertDataLength.getInt(0L);
        if (SIGNCERTDATA_SIZE < 0 || ENCCERTDATA_SIZE < 0) {
            throw new WCSPException("WCSP_KE_GetCert failed", 655363);
        }
        Memory jnaOutMemory = new Memory(SIGNCERTDATA_SIZE + ENCCERTDATA_SIZE);
        offset = 0L;
        Pointer jnapSignCertData = jnaOutMemory.share(offset, SIGNCERTDATA_SIZE);
        Pointer jnapEncCertData = jnaOutMemory.share(offset += (long)SIGNCERTDATA_SIZE, ENCCERTDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_GetCertByKeyLabel(jnahKEService, jnaLabel, jnaPKeyId, jnapSignCertData, jnapSignCertDataLength, jnapEncCertData, jnapEncCertDataLength), 0, new int[0]);
        int signCertDataLength = jnapSignCertDataLength.getInt(0L);
        int encCertDataLength = jnapEncCertDataLength.getInt(0L);
        if (signCertDataLength < 0 || encCertDataLength < 0) {
            throw new WCSPException("WCSP_KE_GetCertByKeyLabel failed", 655363);
        }
        if (signCertDataLength > SIGNCERTDATA_SIZE || encCertDataLength > ENCCERTDATA_SIZE) {
            throw new WCSPException("WCSP_KE_GetCertByKeyLabel failed", 655362);
        }
        pKeyId[0] = jnaPKeyId.getString(0L);
        pSignCertData[0] = jnapSignCertData.getByteArray(0L, signCertDataLength);
        pEncCertData[0] = jnapEncCertData.getByteArray(0L, encCertDataLength);
        Utils.WCSP_LOG_D("OUT pKeyId[{}]", pKeyId[0]);
        Utils.WCSP_LOG_D("OUT signCertData[{}]", new Object[]{pSignCertData[0]});
        Utils.WCSP_LOG_D("OUT encCertData[{}]", new Object[]{pEncCertData[0]});
    }

    public static void WCSP_KE_GetCertCount(long hKEService, int[] pCertCount) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}]", "0x", hKEService);
        Pointer jnahKEService = new Pointer(hKEService);
        int CERTCOUNT_SIZE = 4;
        Memory jnaMemory = new Memory(4L);
        long offset = 0L;
        Pointer jnapCertCount = jnaMemory.share(offset, 4L);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KE_GetCertCount(jnahKEService, jnapCertCount), 0, new int[0]);
        pCertCount[0] = jnapCertCount.getInt(0L);
        Utils.WCSP_LOG_D("OUT certCount[{}]", pCertCount[0]);
    }

    public static void WCSP_KE_GetCertList(long hKEService, int pageSize, int pageIndex, String[][] pKeyIds, String[][] pSignSNs, String[][] pSignIssuers, String[][] pSignSubjects, String[][] pSignNotBefores, String[][] pSignNotAfters, String[][] pEncSNs, String[][] pEncIssuers, String[][] pEncSubjects, String[][] pEncNotBefores, String[][] pEncNotAfters) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKEService[{}{}] pageSize[{}] pageIndex[{}]", "0x", hKEService, pageSize, pageIndex);
        Utils.WCSP_CHECK(JNIWCSPKE.WCSP_KE_GetCertList(hKEService, pageSize, pageIndex, pKeyIds, pSignSNs, pSignIssuers, pSignSubjects, pSignNotBefores, pSignNotAfters, pEncSNs, pEncIssuers, pEncSubjects, pEncNotBefores, pEncNotAfters), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT keyIds[{}]", pKeyIds[0]);
        Utils.WCSP_LOG_D("OUT signSNs[{}]", pSignSNs[0]);
        Utils.WCSP_LOG_D("OUT signIssuers[{}]", pSignIssuers[0]);
        Utils.WCSP_LOG_D("OUT signSubjects[{}]", pSignSubjects[0]);
        Utils.WCSP_LOG_D("OUT signNotBefores[{}]", pSignNotBefores[0]);
        Utils.WCSP_LOG_D("OUT signNotAfters[{}]", pSignNotAfters[0]);
        Utils.WCSP_LOG_D("OUT encSNs[{}]", pEncSNs[0]);
        Utils.WCSP_LOG_D("OUT encIssuers[{}]", pEncIssuers[0]);
        Utils.WCSP_LOG_D("OUT encSubjects[{}]", pEncSubjects[0]);
        Utils.WCSP_LOG_D("OUT encNotBefores[{}]", pEncNotBefores[0]);
        Utils.WCSP_LOG_D("OUT encNotAfters[{}]", pEncNotAfters[0]);
    }

    private WCSPKE() {
    }
}

