/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.base;

import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.impl.base.JNAWCSPSDK;
import cn.com.westone.wcspsdk.impl.base.JNIWCSPCO;
import cn.com.westone.wcspsdk.impl.base.Utils;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;

public final class WCSPCO {
    public static final int WCSP_CO_SGD_SM3 = 1;
    public static final int WCSP_CO_SGD_SMS4_ECB = 1025;
    public static final int WCSP_CO_SGD_SMS4_CBC = 1026;
    public static final int WCSP_CO_SGD_SMS4_MAC = 1040;
    public static final int WCSP_CO_SGD_SM2 = 131328;
    public static final int WCSP_CO_SGD_SM2_1 = 131584;
    public static final int WCSP_CO_SGD_SM2_2 = 132096;
    public static final int WCSP_CO_SGD_SM2_3 = 133120;
    public static final int WCSP_CO_SGD_SM9 = 262400;
    public static final int WCSP_CO_SGD_SM9_1 = 262656;
    public static final int WCSP_CO_SGD_SM9_2 = 263168;
    public static final int WCSP_CO_SGD_SM9_3 = 264192;
    public static final int WCSP_CO_SGD_SM9_3_ECB = 264193;
    public static final int WCSP_CO_PADDING_NO = 0;
    public static final int WCSP_CO_PADDING_PKCS7 = 1;
    public static final int WCSP_CO_USAGE_SIGN = 0;
    public static final int WCSP_CO_USAGE_ENC = 1;
    public static final int WCSP_CO_SM4_KEY_LENGTH = 16;
    public static final int WCSP_CO_SM2_PUBLIC_KEY_LENGTH = 132;
    public static final int WCSP_CO_SM2_PRIVATE_KEY_LENGTH = 68;
    public static final int WCSP_CO_SM3_DIGEST_LENGTH = 32;
    public static final int WCSP_CO_SM4_BLOCK_LENGTH = 16;
    public static final int WCSP_CO_SM2_SIGNATURE_LENGTH = 128;
    public static final int WCSP_CO_SM2_CIPHER_HEADER_LENGTH = 164;
    public static final int WCSP_CO_MAX_SHORT_DATA_LENGTH = 1023;
    public static final int WCSP_CO_MAX_DATA_LENGTH = 64512;

    public static void WCSP_CO_VerifyPin(long hCOService, String pin) throws WCSPException {
        Utils.WCSP_LOG_D("IN hCOService[{}{}] pin[{}]", "0x", hCOService, pin);
        Pointer jnahCOService = new Pointer(hCOService);
        int PIN_SIZE = pin.length() + 1;
        Memory jnaMemory = new Memory(PIN_SIZE);
        long offset = 0L;
        Pointer jnaPIN = jnaMemory.share(offset, PIN_SIZE);
        jnaPIN.clear(PIN_SIZE);
        jnaPIN.setString(0L, pin);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_CO_VerifyPin(jnahCOService, jnaPIN), 0, new int[0]);
    }

    public static void WCSP_CO_GenerateKeyPair(long hCOService, int algorithmId, String name) throws WCSPException {
        Utils.WCSP_LOG_D("IN hCOService[{}{}] algorithmId[{}{}] name[{}]", "0x", hCOService, "0x", algorithmId, name);
        Pointer jnahCOService = new Pointer(hCOService);
        int NAME_SIZE = name.length() + 1;
        Memory jnaMemory = new Memory(NAME_SIZE);
        long offset = 0L;
        Pointer jnaName = jnaMemory.share(offset, NAME_SIZE);
        jnaName.clear(NAME_SIZE);
        jnaName.setString(0L, name);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_CO_GenerateKeyPair(jnahCOService, algorithmId, jnaName), 0, new int[0]);
    }

    public static void WCSP_CO_ImportKeyPair(long hCOService, int algorithmId, long hDeprotectionKey, byte[] envelopedKeyPairData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hCOService[{}{}] algorithmId[{}{}] hDeprotectionKey[{}{}] envelopedKeyPairData[{}]", "0x", hCOService, "0x", algorithmId, "0x", hDeprotectionKey, envelopedKeyPairData);
        Pointer jnahCOService = new Pointer(hCOService);
        Pointer jnahDeprotectionKey = new Pointer(hDeprotectionKey);
        int KEYPAIRDATA_SIZE = envelopedKeyPairData.length;
        Memory jnaMemory = new Memory(KEYPAIRDATA_SIZE);
        long offset = 0L;
        Pointer jnaEnvelopedKeyPairData = jnaMemory.share(offset, KEYPAIRDATA_SIZE);
        jnaEnvelopedKeyPairData.write(0L, envelopedKeyPairData, 0, KEYPAIRDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_CO_ImportKeyPair(jnahCOService, algorithmId, jnahDeprotectionKey, jnaEnvelopedKeyPairData, KEYPAIRDATA_SIZE), 0, new int[0]);
    }

    public static void WCSP_CO_ExportPublicKey(long hPublicKey, byte[][] pPublicKeyData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPublicKey[{}{}]", "0x", hPublicKey);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_ExportPublicKey(hPublicKey, pPublicKeyData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT publicKeyData[{}]", new Object[]{pPublicKeyData[0]});
    }

    public static void WCSP_CO_ImportSessionKeyFromKms(long hCOService, int algorithmId, String secretKeyId, long[] phSecretKey) throws WCSPException {
        Utils.WCSP_LOG_D("IN hCOService[{}{}] algorithmId[{}{}] secretKeyId[{}]", "0x", hCOService, "0x", algorithmId, secretKeyId);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_ImportSessionKeyFromKms(hCOService, algorithmId, secretKeyId, phSecretKey), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT hSecretKey[{}{}]", "0x", phSecretKey[0]);
    }

    public static void WCSP_CO_WrapKey(long hDeprotectionKey, byte[] wrappedKeyData, long hProtectionKey, byte[][] pWrappedKeyData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hDeprotectionKey[{}{}] wrappedKeyData[{}] hProtectionKey[{}{}]", "0x", hDeprotectionKey, wrappedKeyData, hProtectionKey);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_WrapKey(hDeprotectionKey, wrappedKeyData, hProtectionKey, pWrappedKeyData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT pWrappedKeyData[{}{}]", "0x", pWrappedKeyData[0]);
    }

    public static void WCSP_CO_CloseHandle(long hKey) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKey[{}{}]", "0x", hKey);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_CloseHandle(hKey), 0, new int[0]);
    }

    public static void WCSP_CO_AsymEncrypt(long hPublicKey, byte[] data, byte[][] pEncryptedData) throws WCSPException {
        if (data.length > 255) {
            throw new WCSPException("Input data is too long");
        }
        Utils.WCSP_LOG_D("IN hPublicKey[{}{}] data[{}]", "0x", hPublicKey, data);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_AsymEncrypt(hPublicKey, data, pEncryptedData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT encryptedData[{}]", new Object[]{pEncryptedData[0]});
    }

    public static void WCSP_CO_AsymDecrypt(long hPrivateKey, byte[] encryptedData, byte[][] pData) throws WCSPException {
        if (encryptedData.length > 419) {
            throw new WCSPException("Input data is too long");
        }
        Utils.WCSP_LOG_D("IN hPrivateKey[{}{}] encryptedData[{}]", "0x", hPrivateKey, encryptedData);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_AsymDecrypt(hPrivateKey, encryptedData, pData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT data[{}]", new Object[]{pData[0]});
    }

    public static void WCSP_CO_SymmEncrypt(long hSecretKey, byte[] iv, int paddingType, byte[] data, byte[][] pEncryptedData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] iv[{}] paddingType[{}] data[{}]", "0x", hSecretKey, iv, paddingType, data);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_SymmEncrypt(hSecretKey, iv, paddingType, data, pEncryptedData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT encryptedData[{}]", new Object[]{pEncryptedData[0]});
    }

    public static void WCSP_CO_SymmDecrypt(long hSecretKey, byte[] iv, int paddingType, byte[] encryptedData, byte[][] pData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] iv[{}] paddingType[{}] encryptedData[{}]", "0x", hSecretKey, iv, paddingType, encryptedData);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_SymmDecrypt(hSecretKey, iv, paddingType, encryptedData, pData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT data[{}]", new Object[]{pData[0]});
    }

    public static void WCSP_CO_SymmEncryptInit(long hSecretKey, byte[] iv, int paddingType, long[] phContext) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] iv[{}] paddingType[{}]", "0x", hSecretKey, iv, paddingType);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_SymmEncryptInit(hSecretKey, iv, paddingType, phContext), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT hContext[{}{}]", "0x", phContext[0]);
    }

    public static void WCSP_CO_SymmEncryptUpdate(long hContext, byte[] data, byte[][] pEncryptedData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] data[{}]", "0x", hContext, data);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_SymmEncryptUpdate(hContext, data, pEncryptedData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT encryptedData[{}]", new Object[]{pEncryptedData[0]});
    }

    public static void WCSP_CO_SymmEncryptFinal(long hContext, byte[][] pEncryptedData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}]", "0x", hContext);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_SymmEncryptFinal(hContext, new byte[0], pEncryptedData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT encryptedData[{}]", new Object[]{pEncryptedData[0]});
    }

    public static void WCSP_CO_SymmEncryptFinal(long hContext, byte[] data, byte[][] pEncryptedData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] data[{}]", "0x", hContext, data);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_SymmEncryptFinal(hContext, data, pEncryptedData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT encryptedData[{}]", new Object[]{pEncryptedData[0]});
    }

    public static void WCSP_CO_SymmDecryptInit(long hSecretKey, byte[] iv, int paddingType, long[] phContext) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] iv[{}] paddingType[{}]", "0x", hSecretKey, iv, paddingType);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_SymmDecryptInit(hSecretKey, iv, paddingType, phContext), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT hContext[{}{}]", "0x", phContext[0]);
    }

    public static void WCSP_CO_SymmDecryptUpdate(long hContext, byte[] encryptedData, byte[][] pData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] encryptedData[{}]", "0x", hContext, encryptedData);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_SymmDecryptUpdate(hContext, encryptedData, pData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT data[{}]", new Object[]{pData[0]});
    }

    public static void WCSP_CO_SymmDecryptFinal(long hContext, byte[][] pData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}]", "0x", hContext);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_SymmDecryptFinal(hContext, new byte[0], pData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT data[{}]", new Object[]{pData[0]});
    }

    public static void WCSP_CO_SymmDecryptFinal(long hContext, byte[] encryptedData, byte[][] pData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] encryptedData[{}]", "0x", hContext, encryptedData);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_SymmDecryptFinal(hContext, encryptedData, pData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT data[{}]", new Object[]{pData[0]});
    }

    public static void WCSP_CO_FPE_Phone_Encrypt(long hSecretKey, int style, String input, String[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] style[{}] input[{}]", "0x", hSecretKey, style, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_Phone_Encrypt(hSecretKey, style, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_Phone_Decrypt(long hSecretKey, int style, String input, String[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] style[{}] input[{}]", "0x", hSecretKey, style, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_Phone_Decrypt(hSecretKey, style, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_IdCard_Encrypt(long hSecretKey, int style, String input, String[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] style[{}] input[{}]", "0x", hSecretKey, style, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_IdCard_Encrypt(hSecretKey, style, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_IdCard_Decrypt(long hSecretKey, int style, String input, String[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] style[{}] input[{}]", "0x", hSecretKey, style, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_IdCard_Decrypt(hSecretKey, style, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_Bank_Encrypt(long hSecretKey, int style, String input, String[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] style[{}] input[{}]", "0x", hSecretKey, style, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_Bank_Encrypt(hSecretKey, style, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_Bank_Decrypt(long hSecretKey, int style, String input, String[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] style[{}] input[{}]", "0x", hSecretKey, style, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_Bank_Decrypt(hSecretKey, style, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_IP_Encrypt(long hSecretKey, int style, String input, String[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] style[{}] input[{}]", "0x", hSecretKey, style, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_IP_Encrypt(hSecretKey, style, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_IP_Decrypt(long hSecretKey, int style, String input, String[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] style[{}] input[{}]", "0x", hSecretKey, style, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_IP_Decrypt(hSecretKey, style, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_Email_Encrypt(long hSecretKey, int style, String input, String[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] style[{}] input[{}]", "0x", hSecretKey, style, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_Email_Encrypt(hSecretKey, style, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_Email_Decrypt(long hSecretKey, int style, String input, String[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] style[{}] input[{}]", "0x", hSecretKey, style, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_Email_Decrypt(hSecretKey, style, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_String_Encrypt(long hSecretKey, int style, String input, String[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] style[{}] input[{}]", "0x", hSecretKey, style, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_String_Encrypt(hSecretKey, style, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_String_Decrypt(long hSecretKey, int style, String input, String[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] style[{}] input[{}]", "0x", hSecretKey, style, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_String_Decrypt(hSecretKey, style, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_Int_Encrypt(long hSecretKey, int input, int[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] input[{}]", "0x", hSecretKey, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_Int_Encrypt(hSecretKey, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_Int_Decrypt(long hSecretKey, int input, int[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] input[{}]", "0x", hSecretKey, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_Int_Decrypt(hSecretKey, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_Double_Encrypt(long hSecretKey, double input, double[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] input[{}]", "0x", hSecretKey, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_Double_Encrypt(hSecretKey, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_FPE_Double_Decrypt(long hSecretKey, double input, double[] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] input[{}]", "0x", hSecretKey, input);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FPE_Double_Decrypt(hSecretKey, input, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", pOutput[0]);
    }

    public static void WCSP_CO_Mac(long hSecretKey, byte[] iv, int paddingType, byte[] data, byte[][] pMacData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] iv[{}] paddingType[{}] data[{}]", "0x", hSecretKey, iv, paddingType, data);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Mac(hSecretKey, iv, paddingType, data, pMacData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT pMacData[{}{}]", "0x", pMacData[0]);
    }

    public static void WCSP_CO_MacInit(long hSecretKey, byte[] iv, int paddingType, long[] phContext) throws WCSPException {
        Utils.WCSP_LOG_D("IN hSecretKey[{}{}] iv[{}] paddingType[{}]", "0x", hSecretKey, iv, paddingType);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_MacInit(hSecretKey, iv, paddingType, phContext), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT hContext[{}{}]", "0x", phContext[0]);
    }

    public static void WCSP_CO_MacUpdate(long hContext, byte[] data) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] data[{}]", "0x", hContext, data);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_MacUpdate(hContext, data), 0, new int[0]);
    }

    public static void WCSP_CO_MacFinal(long hContext, byte[][] pMacData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}]", "0x", hContext);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_MacFinal(hContext, new byte[0], pMacData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT macData[{}]", new Object[]{pMacData[0]});
    }

    public static void WCSP_CO_MacFinal(long hContext, byte[] data, byte[][] pMacData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] data[{}]", "0x", hContext, data);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_MacFinal(hContext, data, pMacData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT macData[{}]", new Object[]{pMacData[0]});
    }

    public static void WCSP_CO_Sign(long hPrivateKey, byte[] data, byte[][] pSignatureData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPrivateKey[{}{}] data[{}]", "0x", hPrivateKey, data);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Sign(hPrivateKey, data, pSignatureData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT pSignatureData[{}]", new Object[]{pSignatureData[0]});
    }

    public static void WCSP_CO_Verify(long hPublicKey, byte[] data, byte[] signatureData, int[] pResult) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPublicKey[{}{}] data[{}] signatureData[{}]", "0x", hPublicKey, data, signatureData);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Verify(hPublicKey, data, signatureData, pResult), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT pResult[{}]", pResult[0]);
    }

    public static void WCSP_CO_SignInit(long hPrivateKey, long[] phContext) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPrivateKey[{}{}]", "0x", hPrivateKey);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_SignInit(hPrivateKey, phContext), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT phContext[{}]", phContext[0]);
    }

    public static void WCSP_CO_SignUpdate(long hContext, byte[] data) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] data[{}]", "0x", hContext, data);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_SignUpdate(hContext, data), 0, new int[0]);
    }

    public static void WCSP_CO_SignFinal(long hContext, byte[] data, byte[][] pSignatureData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] data[{}]", "0x", hContext, data);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_SignFinal(hContext, data, pSignatureData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT pSignatureData[{}]", new Object[]{pSignatureData[0]});
    }

    public static void WCSP_CO_VerifyInit(long hPublicKey, long[] phContext) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPublicKey[{}{}]", "0x", hPublicKey);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_VerifyInit(hPublicKey, phContext), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT phContext[{}]", phContext[0]);
    }

    public static void WCSP_CO_VerifyUpdate(long hContext, byte[] data) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] data[{}]", "0x", hContext, data);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_VerifyUpdate(hContext, data), 0, new int[0]);
    }

    public static void WCSP_CO_VerifyFinal(long hContext, byte[] data, byte[] signatureData, int[] pResult) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] data[{}] signatureData[{}]", "0x", hContext, data, signatureData);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_VerifyFinal(hContext, data, signatureData, pResult), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT pResult[{}]", pResult[0]);
    }

    public static void WCSP_CO_DigestSign(long hPrivateKey, byte[] digestData, byte[][] pSignatureData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPrivateKey[{}{}] digestData[{}]", "0x", hPrivateKey, digestData);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_DigestSign(hPrivateKey, digestData, pSignatureData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT pSignatureData[{}]", new Object[]{pSignatureData[0]});
    }

    public static void WCSP_CO_DigestVerify(long hPublicKey, byte[] digestData, byte[] signatureData, int[] pResult) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPublicKey[{}{}] digestData[{}] signatureData[{}]", "0x", hPublicKey, digestData, signatureData);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_DigestVerify(hPublicKey, digestData, signatureData, pResult), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT pResult[{}]", pResult[0]);
    }

    public static void WCSP_CO_Stream_EncryptInit(long hKey, long[] phContext) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKey[{}{}]", "0x", hKey);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Stream_EncryptInit(hKey, phContext), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT hContext[{}{}]", "0x", phContext[0]);
    }

    public static void WCSP_CO_Stream_EncryptUpdate(long hContext, byte[] input, int inputOffset, int inputLength, byte[][] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] input[{}] inputOffset[{}] inputLength[{}]", "0x", hContext, input, inputOffset, inputLength);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Stream_EncryptUpdate(hContext, input, inputOffset, inputLength, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", new Object[]{pOutput[0]});
    }

    public static void WCSP_CO_Stream_EncryptFinal(long hContext, byte[][] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}]", "0x", hContext);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Stream_EncryptFinal(hContext, new byte[0], 0, 0, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", new Object[]{pOutput[0]});
    }

    public static void WCSP_CO_Stream_EncryptFinal(long hContext, byte[] input, int inputOffset, int inputLength, byte[][] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] input[{}] inputOffset[{}] inputLength[{}]", "0x", hContext, input, inputOffset, inputLength);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Stream_EncryptFinal(hContext, input, inputOffset, inputLength, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", new Object[]{pOutput[0]});
    }

    public static void WCSP_CO_Stream_DecryptInit(long hCOService, long[] phContext) throws WCSPException {
        Utils.WCSP_LOG_D("IN hCOService[{}{}]", "0x", hCOService);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Stream_DecryptInit(hCOService, phContext), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT hContext[{}{}]", "0x", phContext[0]);
    }

    public static void WCSP_CO_Stream_DecryptUpdate(long hContext, byte[] input, int inputOffset, int inputLength, byte[][] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] input[{}] inputOffset[{}] inputLength[{}]", "0x", hContext, input, inputOffset, inputLength);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Stream_DecryptUpdate(hContext, input, inputOffset, inputLength, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", new Object[]{pOutput[0]});
    }

    public static void WCSP_CO_Stream_DecryptFinal(long hContext, byte[][] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}]", "0x", hContext);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Stream_DecryptFinal(hContext, new byte[0], 0, 0, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", new Object[]{pOutput[0]});
    }

    public static void WCSP_CO_Stream_DecryptFinal(long hContext, byte[] input, int inputOffset, int inputLength, byte[][] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] input[{}] inputOffset[{}] inputLength[{}]", "0x", hContext, input, inputOffset, inputLength);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Stream_DecryptFinal(hContext, input, inputOffset, inputLength, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", new Object[]{pOutput[0]});
    }

    public static void WCSP_CO_Stream_TransformInit(long hTransformKey, long[] phContext) throws WCSPException {
        Utils.WCSP_LOG_D("IN hTransformKey[{}{}]", "0x", hTransformKey);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Stream_TransformInit(hTransformKey, phContext), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT hContext[{}{}]", "0x", phContext[0]);
    }

    public static void WCSP_CO_Stream_TransformUpdate(long hContext, byte[] input, int inputOffset, int inputLength, byte[][] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] input[{}] inputOffset[{}] inputLength[{}]", "0x", hContext, input, inputOffset, inputLength);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Stream_TransformUpdate(hContext, input, inputOffset, inputLength, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", new Object[]{pOutput[0]});
    }

    public static void WCSP_CO_Stream_TransformFinal(long hContext, byte[][] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}]", "0x", hContext);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Stream_TransformFinal(hContext, new byte[0], 0, 0, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", new Object[]{pOutput[0]});
    }

    public static void WCSP_CO_Stream_TransformFinal(long hContext, byte[] input, int inputOffset, int inputLength, byte[][] pOutput) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}] input[{}] inputOffset[{}] inputLength[{}]", "0x", hContext, input, inputOffset, inputLength);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_Stream_TransformFinal(hContext, input, inputOffset, inputLength, pOutput), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT output[{}]", new Object[]{pOutput[0]});
    }

    public static void WCSP_CO_FreeContext(long hContext) throws WCSPException {
        Utils.WCSP_LOG_D("IN hContext[{}{}]", "0x", hContext);
        Utils.WCSP_CHECK(JNIWCSPCO.WCSP_CO_FreeContext(hContext), 0, new int[0]);
    }

    public static void WCSP_CO_ImportSignCert(long hCOService, String name, byte[] signCertData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hCOService[{}{}] name[{}] signCertData[{}]", "0x", hCOService, name, signCertData);
        Pointer jnahCOService = new Pointer(hCOService);
        int NAME_SIZE = name.length() + 1;
        int SIGNCERTDATA_SIZE = signCertData.length;
        Memory jnaMemory = new Memory(NAME_SIZE + SIGNCERTDATA_SIZE);
        long offset = 0L;
        Pointer jnaName = jnaMemory.share(offset, NAME_SIZE);
        jnaName.clear(NAME_SIZE);
        jnaName.setString(0L, name);
        Pointer jnaSignCertData = jnaMemory.share(offset += (long)NAME_SIZE, SIGNCERTDATA_SIZE);
        jnaSignCertData.write(0L, signCertData, 0, SIGNCERTDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_CO_ImportSignCert(jnahCOService, jnaName, jnaSignCertData, SIGNCERTDATA_SIZE), 0, new int[0]);
    }

    public static void WCSP_CO_ImportEncCert(long hCOService, String name, byte[] encCertData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hCOService[{}{}] name[{}] signCertData[{}]", "0x", hCOService, name, encCertData);
        Pointer jnahCOService = new Pointer(hCOService);
        int NAME_SIZE = name.length() + 1;
        int ENCCERTDATA_SIZE = encCertData.length;
        Memory jnaMemory = new Memory(NAME_SIZE + ENCCERTDATA_SIZE);
        long offset = 0L;
        Pointer jnaName = jnaMemory.share(offset, NAME_SIZE);
        jnaName.clear(NAME_SIZE);
        jnaName.setString(0L, name);
        Pointer jnaEncCertData = jnaMemory.share(offset += (long)NAME_SIZE, ENCCERTDATA_SIZE);
        jnaEncCertData.write(0L, encCertData, 0, ENCCERTDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_CO_ImportEncCert(jnahCOService, jnaName, jnaEncCertData, ENCCERTDATA_SIZE), 0, new int[0]);
    }

    public static void WCSP_CO_ExportSignCert(long hCOService, String name, byte[][] pSignCertData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hCOService[{}{}] name[{}]", "0x", hCOService, name);
        Pointer jnahCOService = new Pointer(hCOService);
        int NAME_SIZE = name.length() + 1;
        int LENGTH_SIZE = 4;
        Memory jnaMemory = new Memory(NAME_SIZE + 4);
        long offset = 0L;
        Pointer jnaName = jnaMemory.share(offset, NAME_SIZE);
        jnaName.clear(NAME_SIZE);
        jnaName.setString(0L, name);
        Pointer jnapSignCertDataLength = jnaMemory.share(offset += (long)NAME_SIZE, 4L);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_CO_ExportSignCert(jnahCOService, jnaName, null, jnapSignCertDataLength), 0, new int[0]);
        int SIGNCERTDATA_SIZE = jnapSignCertDataLength.getInt(0L);
        Memory jnaOutMemory = new Memory(SIGNCERTDATA_SIZE);
        offset = 0L;
        Pointer jnapSignCertData = jnaOutMemory.share(offset, SIGNCERTDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_CO_ExportSignCert(jnahCOService, jnaName, jnapSignCertData, jnapSignCertDataLength), 0, new int[0]);
        int signCertDataLength = jnapSignCertDataLength.getInt(0L);
        if (signCertDataLength < 0) {
            throw new WCSPException("WCSP_CO_ExportSignCert failed", 655363);
        }
        if (signCertDataLength > SIGNCERTDATA_SIZE) {
            throw new WCSPException("WCSP_CO_ExportSignCert failed", 655362);
        }
        pSignCertData[0] = jnapSignCertData.getByteArray(0L, signCertDataLength);
        Utils.WCSP_LOG_D("OUT signCertData[{}]", new Object[]{pSignCertData[0]});
    }

    public static void WCSP_CO_ExportEncCert(long hCOService, String name, byte[][] pEncCertData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hCOService[{}{}] name[{}]", "0x", hCOService, name);
        Pointer jnahCOService = new Pointer(hCOService);
        int NAME_SIZE = name.length() + 1;
        int LENGTH_SIZE = 4;
        Memory jnaMemory = new Memory(NAME_SIZE + 4);
        long offset = 0L;
        Pointer jnaName = jnaMemory.share(offset, NAME_SIZE);
        jnaName.clear(NAME_SIZE);
        jnaName.setString(0L, name);
        Pointer jnapEncCertDataLength = jnaMemory.share(offset += (long)NAME_SIZE, 4L);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_CO_ExportEncCert(jnahCOService, jnaName, null, jnapEncCertDataLength), 0, new int[0]);
        int ENCCERTDATA_SIZE = jnapEncCertDataLength.getInt(0L);
        Memory jnaOutMemory = new Memory(ENCCERTDATA_SIZE);
        offset = 0L;
        Pointer jnapEncCertData = jnaOutMemory.share(offset, ENCCERTDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_CO_ExportEncCert(jnahCOService, jnaName, jnapEncCertData, jnapEncCertDataLength), 0, new int[0]);
        int encCertDataLength = jnapEncCertDataLength.getInt(0L);
        if (encCertDataLength < 0) {
            throw new WCSPException("WCSP_CO_ExportSignCert failed", 655363);
        }
        if (encCertDataLength > ENCCERTDATA_SIZE) {
            throw new WCSPException("WCSP_CO_ExportEncCert failed", 655362);
        }
        pEncCertData[0] = jnapEncCertData.getByteArray(0L, encCertDataLength);
        Utils.WCSP_LOG_D("OUT encCertData[{}]", new Object[]{pEncCertData[0]});
    }

    private WCSPCO() {
    }
}

