/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.base;

import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.impl.base.JNAWCSPSDK;
import cn.com.westone.wcspsdk.impl.base.Utils;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;

public final class WCSP {
    public static final int WCSP_KM_SERVICE_ID = 1;
    public static final int WCSP_CA_SERVICE_ID = 2;
    public static final int WCSP_CO_LOCAL_SERVICE_ID = 3;
    public static final int WCSP_CO_REMOTE_SERVICE_ID = 4;
    public static final int WCSP_TS_SERVICE_ID = 5;
    public static final int WCSP_SKE_SERVICE_ID = 7;
    public static final int WCSP_KE_SERVICE_ID = 7;
    public static final int WCSP_FC_SERVICE_ID = 8;
    public static final int WCSP_HTTP_PROTOCOL_1_1 = 1;
    public static final int WCSP_HTTP_PROTOCOL_2_0 = 2;
    public static final int WCSP_UNSUPPORTED_ALG = 655379;
    public static final int WCSP_USAGE_ERROR = 655381;
    public static final long WCSP_INVALID_HANDLE = 0L;
    public static final int WCSP_MAX_LIST_COUNT = 100;

    public static void loadJNA(String dir) {
        if (Boolean.getBoolean("jna.loaded")) {
            return;
        }
        String oldProperty = System.getProperty("jna.boot.library.path", "");
        System.setProperty("jna.boot.library.path", null == dir ? "." : dir);
        Native.getLastError();
        System.setProperty("jna.boot.library.path", oldProperty);
    }

    public static void loadJNA() {
        if (Boolean.getBoolean("jna.loaded")) {
            return;
        }
        String oldProperty = System.getProperty("jna.nosys", "true");
        System.setProperty("jna.nosys", "false");
        Native.getLastError();
        System.setProperty("jna.nosys", oldProperty);
    }

    public static void loadWCSP(String lib) {
        if (!Boolean.getBoolean("jna.loaded")) {
            throw new UnsatisfiedLinkError("JNA native support library has not been loaded");
        }
        Native.register(JNAWCSPSDK.class, lib);
    }

    public static void WCSP_Init(String tenantId, String appId, String workdir, long[] phPlatform) throws WCSPException {
        Utils.WCSP_LOG_D("IN tenantId[{}] appId[{}] workdir[{}]", tenantId, appId, workdir);
        int TENANTID_SIZE = tenantId.length() + 1;
        int APPID_SIZE = appId.length() + 1;
        int WORKDIR_SIZE = workdir.length() + 1;
        int HANDLE_SIZE = Native.POINTER_SIZE;
        Memory jnaMemory = new Memory(TENANTID_SIZE + APPID_SIZE + WORKDIR_SIZE + HANDLE_SIZE);
        long offset = 0L;
        Pointer jnaTenantId = jnaMemory.share(offset, TENANTID_SIZE);
        jnaTenantId.clear(TENANTID_SIZE);
        jnaTenantId.setString(0L, tenantId);
        Pointer jnaAppId = jnaMemory.share(offset += (long)TENANTID_SIZE, APPID_SIZE);
        jnaAppId.clear(APPID_SIZE);
        jnaAppId.setString(0L, appId);
        Pointer jnaWorkdir = jnaMemory.share(offset += (long)APPID_SIZE, WORKDIR_SIZE);
        jnaWorkdir.clear(WORKDIR_SIZE);
        jnaWorkdir.setString(0L, workdir);
        Pointer jnaphPlatform = jnaMemory.share(offset += (long)WORKDIR_SIZE, HANDLE_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_Init(jnaphPlatform, jnaTenantId, jnaAppId, jnaWorkdir), 0, new int[0]);
        phPlatform[0] = Pointer.nativeValue(jnaphPlatform.getPointer(0L));
        Utils.WCSP_LOG_D("OUT hPlatform[{}{}]", "0x", phPlatform[0]);
    }

    public static void WCSP_Finalize(long hPlatform) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPlatform[{}{}]", "0x", hPlatform);
        Pointer jnahPlatform = new Pointer(hPlatform);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_Finalize(jnahPlatform), 0, new int[0]);
    }

    public static void WCSP_GetService(long hPlatform, int serviceId, long[] phService) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPlatform[{}{}] serviceId[{}]", "0x", hPlatform, serviceId);
        Pointer jnahPlatform = new Pointer(hPlatform);
        int HANDLE_SIZE = Native.POINTER_SIZE;
        Memory jnaMemory = new Memory(HANDLE_SIZE);
        long offset = 0L;
        Pointer jnaphService = jnaMemory.share(offset, HANDLE_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_GetService(jnahPlatform, serviceId, jnaphService), 0, new int[0]);
        phService[0] = Pointer.nativeValue(jnaphService.getPointer(0L));
        Utils.WCSP_LOG_D("OUT hService[{}{}]", "0x", phService[0]);
    }

    public static void WCSP_SetUrl(long hPlatform, String url) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPlatform[{}{}] url[{}]", "0x", hPlatform, url);
        Pointer jnahPlatform = new Pointer(hPlatform);
        int URL_SIZE = url.length() + 1;
        Memory jnaMemory = new Memory(URL_SIZE);
        long offset = 0L;
        Pointer jnaURL = jnaMemory.share(offset, URL_SIZE);
        jnaURL.clear(URL_SIZE);
        jnaURL.setString(0L, url);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_SetUrl(jnahPlatform, jnaURL), 0, new int[0]);
    }

    public static void WCSP_SetHttpVersion(long hPlatform, int protocol) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPlatform[{}{}] protocol[{}]", "0x", hPlatform, protocol);
        Pointer jnahPlatform = new Pointer(hPlatform);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_SetHttpVersion(jnahPlatform, protocol), 0, new int[0]);
    }

    public static void WCSP_SetHttpsCert(long hPlatform, byte[] caCertData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPlatform[{}{}] caCertData[{}]", "0x", hPlatform, caCertData);
        Pointer jnahPlatform = new Pointer(hPlatform);
        int CACERTDATA_SIZE = caCertData.length;
        Memory jnaMemory = new Memory(CACERTDATA_SIZE);
        long offset = 0L;
        Pointer jnaCACertData = jnaMemory.share(offset, CACERTDATA_SIZE);
        jnaCACertData.write(0L, caCertData, 0, CACERTDATA_SIZE);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_SetHttpsCert(jnahPlatform, jnaCACertData, CACERTDATA_SIZE), 0, new int[0]);
    }

    public static void WCSP_SetHsmInfo(long hPlatform, String hsmIP, int hsmPort) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPlatform[{}{}] hsmIP[{}] hsmPort[{}]", "0x", hPlatform, hsmIP, hsmPort);
        Pointer jnahPlatform = new Pointer(hPlatform);
        int HSMIP_SIZE = hsmIP.length() + 1;
        Memory jnaMemory = new Memory(HSMIP_SIZE);
        long offset = 0L;
        Pointer jnaHSMIP = jnaMemory.share(offset, HSMIP_SIZE);
        jnaHSMIP.clear(HSMIP_SIZE);
        jnaHSMIP.setString(0L, hsmIP);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_SetHsmInfo(jnahPlatform, jnaHSMIP, hsmPort), 0, new int[0]);
    }

    public static void WCSP_AuthSecret(long hPlatform, String secret) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPlatform[{}{}] secret[{}]", "0x", hPlatform, secret);
        Pointer jnahPlatform = new Pointer(hPlatform);
        int SECRET_SIZE = secret.length() + 1;
        Memory jnaMemory = new Memory(SECRET_SIZE);
        long offset = 0L;
        Pointer jnaSecret = jnaMemory.share(offset, SECRET_SIZE);
        jnaSecret.clear(SECRET_SIZE);
        jnaSecret.setString(0L, secret);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_AuthSecret(jnahPlatform, jnaSecret), 0, new int[0]);
    }

    public static void WCSP_AuthAppUser(long hPlatform, String userId, String authCode) throws WCSPException {
        Utils.WCSP_LOG_D("IN hPlatform[{}{}] userId[{}] authCode[{}]", "0x", hPlatform, userId, authCode);
        Pointer jnahPlatform = new Pointer(hPlatform);
        int USERID_SIZE = userId.length() + 1;
        int AUTHCODE_SIZE = authCode.length() + 1;
        Memory jnaMemory = new Memory(USERID_SIZE + AUTHCODE_SIZE);
        long offset = 0L;
        Pointer jnaUserId = jnaMemory.share(offset, USERID_SIZE);
        jnaUserId.clear(USERID_SIZE);
        jnaUserId.setString(0L, userId);
        Pointer jnaAuthCode = jnaMemory.share(offset += (long)USERID_SIZE, AUTHCODE_SIZE);
        jnaAuthCode.clear(AUTHCODE_SIZE);
        jnaAuthCode.setString(0L, authCode);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_AuthAppUser(jnahPlatform, jnaUserId, jnaAuthCode), 0, new int[0]);
    }

    public static String WCSP_GetErrMessage(int errorCode) {
        Pointer jnaMessage = JNAWCSPSDK.WCSP_GetErrMessage(errorCode);
        return jnaMessage.getString(0L);
    }

    private WCSP() {
    }
}

