/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl;

import cn.com.westone.wcspsdk.CryptoService;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.base.WCSP;

public abstract class ServiceImpl
implements CryptoService {
    private final long handle;
    private final String type;
    private final PlatformImpl platform;

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public PlatformImpl platform() {
        return this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceImpl(int serviceId, String type, PlatformImpl platform) throws WCSPException {
        platform.stateLock().readLock().lock();
        try {
            if (0L == platform.handle()) {
                throw new IllegalStateException("CryptoServicePlatform object has been finished");
            }
            long[] phHandle = new long[]{0L};
            WCSP.WCSP_GetService(platform.handle(), serviceId, phHandle);
            this.handle = phHandle[0];
            this.type = type;
            this.platform = platform;
        }
        finally {
            platform.stateLock().readLock().unlock();
        }
    }

    protected StateKeeper keepState() {
        return new StateKeeper();
    }

    protected long handle() {
        return this.handle;
    }

    public class StateKeeper
    implements AutoCloseable {
        private boolean locked;

        public boolean hasFinalized() {
            return 0L == ServiceImpl.this.platform.handle();
        }

        @Override
        public void close() {
            if (this.locked) {
                this.locked = false;
                ServiceImpl.this.platform.stateLock().readLock().unlock();
            }
        }

        protected void finalize() {
            this.close();
        }

        private StateKeeper() {
            ServiceImpl.this.platform.stateLock().readLock().lock();
            this.locked = true;
        }
    }
}

