/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.baseservice.ske;

import cn.com.westone.wcspsdk.AuthSecretParameterSpec;
import cn.com.westone.wcspsdk.CryptoService;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import java.math.BigInteger;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public interface SKEService
extends CryptoService {
    public static final String SERVICE_TYPE_SKE = "SKE";

    public static SKEService getInstance(CryptoServicePlatform platform) throws WCSPException {
        if (null == platform) {
            throw new IllegalArgumentException("Argument \"platform\" is null");
        }
        if (platform instanceof PlatformImpl) {
            return null;
        }
        throw new UnsupportedOperationException("Unsupport CryptoServicePlatform");
    }

    public static SKEService getInstance(String tenantId, String appId, Map<String, Object> params, String secret) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthSecretParameterSpec.Builder().setSecret(secret).build());
        return null;
    }

    public static SKEService getInstance(String tenantId, String appId, String secret, String cfgFile) throws InvalidParameterException, WCSPException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cfgFile", cfgFile);
        return SKEService.getInstance(tenantId, appId, params, secret);
    }

    @Override
    public void init(Object ... var1);

    public KeyPairHolder requestSignKeyPair() throws WCSPException;

    public KeyPairHolder requestSignKeyPair(String var1, String var2) throws WCSPException;

    public void uploadSignCert(String var1, byte[] var2) throws InvalidParameterException, WCSPException;

    public void uploadSignCert(String var1, String var2) throws InvalidParameterException, WCSPException;

    public void uploadSignAndEncCert(String var1, byte[] var2, byte[] var3, byte[] var4) throws InvalidParameterException, WCSPException;

    public void uploadSignAndEncCert(String var1, String var2, String var3, byte[] var4) throws InvalidParameterException, WCSPException;

    public byte[] sign(String var1, byte[] var2) throws InvalidParameterException, WCSPException;

    public byte[] signDigest(String var1, byte[] var2) throws InvalidParameterException, WCSPException;

    public byte[] encrypt(String var1, byte[] var2) throws InvalidParameterException, WCSPException;

    public byte[] decrypt(String var1, byte[] var2) throws InvalidParameterException, WCSPException;

    public CertHolder getCert(String var1) throws InvalidParameterException, WCSPException;

    public int getCertCount() throws WCSPException;

    public CertInfoHolder[] getCertInfoList() throws WCSPException;

    public CertInfoHolder[] getCertInfoList(int var1, int var2) throws WCSPException;

    public static final class CertInfoHolder {
        private final String keyId;
        private final CertInfo signCertInfo;
        private final CertInfo encCertInfo;

        public String keyId() {
            return this.keyId;
        }

        public CertInfo signCertInfo() {
            return this.signCertInfo;
        }

        public CertInfo encCertInfo() {
            return this.encCertInfo;
        }

        public CertInfoHolder(String keyId, CertInfo signCertInfo, CertInfo encCertInfo) {
            this.keyId = keyId;
            this.signCertInfo = signCertInfo;
            this.encCertInfo = encCertInfo;
        }

        public static final class CertInfo {
            private final BigInteger serialNumber;
            private final String issuer;
            private final String subject;
            private final Instant notBefore;
            private final Instant notAfter;

            public BigInteger serialNumber() {
                return this.serialNumber;
            }

            public String issuer() {
                return this.issuer;
            }

            public String subject() {
                return this.subject;
            }

            public Instant notBefore() {
                return this.notBefore;
            }

            public Instant notAfter() {
                return this.notAfter;
            }

            public CertInfo(BigInteger serialNumber, String issuer, String subject, Instant notBefore, Instant notAfter) {
                this.serialNumber = serialNumber;
                this.issuer = issuer;
                this.subject = subject;
                this.notBefore = notBefore;
                this.notAfter = notAfter;
            }
        }
    }

    public static final class CertHolder {
        private final byte[] signCertData;
        private final byte[] encCertData;

        public byte[] signCertData() {
            return this.signCertData;
        }

        public byte[] encCertData() {
            return this.encCertData;
        }

        public CertHolder(byte[] signCertData, byte[] encCertData) {
            this.signCertData = signCertData;
            this.encCertData = encCertData;
        }
    }

    public static final class KeyPairHolder {
        private final String keyId;
        private final byte[] publicKeyData;
        private final byte[] csrData;

        public String keyId() {
            return this.keyId;
        }

        public byte[] publicKeyData() {
            return this.publicKeyData;
        }

        public byte[] csrData() {
            return this.csrData;
        }

        public KeyPairHolder(String keyId, byte[] publicKeyData, byte[] csrData) {
            this.keyId = keyId;
            this.publicKeyData = publicKeyData;
            this.csrData = csrData;
        }
    }
}

