/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.baseservice.km;

import cn.com.westone.wcspsdk.CryptoService;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.PublicKey;
import cn.com.westone.wcspsdk.baseservice.km.KMIdentifier;
import cn.com.westone.wcspsdk.baseservice.km.KMKeyPair;
import cn.com.westone.wcspsdk.baseservice.km.KMKeyPairImportHelper;
import cn.com.westone.wcspsdk.baseservice.km.KMSecretKey;
import cn.com.westone.wcspsdk.baseservice.km.KMSecretKeyImportHelper;
import cn.com.westone.wcspsdk.baseservice.km.KeyUpdateStrategySpec;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.km.KMServiceImpl;

public interface KMService
extends CryptoService {
    public static final String SERVICE_TYPE_KM = "KM";
    public static final String ALGORITHM_SM2 = "SM2";
    public static final String ALGORITHM_SM4 = "SM4";
    public static final String ALGORITHM_SM9 = "SM9";
    public static final String KEY_USAGE_SIGN = "SIGN";
    public static final String KEY_USAGE_ENC = "ENC";

    public static KMService getInstance(CryptoServicePlatform platform) throws WCSPException {
        if (platform instanceof PlatformImpl) {
            return KMServiceImpl.getInstance((PlatformImpl)platform);
        }
        throw new UnsupportedOperationException("Unsupport CryptoServicePlatform");
    }

    @Override
    public void init(Object ... var1);

    public KMKeyPair createKeyPair(String var1, String var2, String var3, String var4, KeyUpdateStrategySpec var5) throws InvalidParameterException, WCSPException;

    public KMKeyPair getKeyPair(String var1) throws WCSPException;

    public KMKeyPair getKeyPair(String var1, int var2) throws WCSPException;

    public KMKeyPair[] getKeyPairList(String var1, int var2) throws WCSPException;

    public KMKeyPair[] getKeyPairList(String var1) throws WCSPException;

    public KMKeyPair[] getKeyPairList(int var1, int var2) throws WCSPException;

    public KMKeyPair[] getKeyPairList() throws WCSPException;

    public byte[] getEnvelopedKeyPair(String var1, PublicKey var2) throws InvalidKeyException, WCSPException;

    public byte[][] getEnvelopedKeyPair(String var1, PublicKey[] var2) throws InvalidKeyException, WCSPException;

    public byte[][] getEnvelopedKeyPair(String var1, int[] var2, PublicKey var3) throws InvalidKeyException, WCSPException;

    public KMSecretKey createSecretKey(String var1, String var2, String var3, String var4, KeyUpdateStrategySpec var5) throws InvalidParameterException, WCSPException;

    public KMSecretKey getSecretKey(String var1) throws WCSPException;

    public KMSecretKey getSecretKey(String var1, int var2) throws WCSPException;

    public KMSecretKey[] getSecretKeyList(String var1, int var2) throws WCSPException;

    public KMSecretKey[] getSecretKeyList(String var1) throws WCSPException;

    public KMSecretKey[] getSecretKeyList(int var1, int var2) throws WCSPException;

    public KMSecretKey[] getSecretKeyList() throws WCSPException;

    public byte[] getWrappedSecretKey(String var1, PublicKey var2) throws InvalidKeyException, WCSPException;

    public byte[] getWrappedSecretKey(String var1, String var2, byte[] var3) throws WCSPException;

    public byte[][] getWrappedSecretKey(String var1, PublicKey[] var2) throws InvalidKeyException, WCSPException;

    public byte[][] getWrappedSecretKey(String var1, int[] var2, PublicKey var3) throws InvalidKeyException, WCSPException;

    public int getKeyLatestVersion(String var1) throws WCSPException;

    public void updateKeyAuthority(String var1, String[] var2, String[] var3) throws WCSPException;

    public void addKeyAuthority(String var1) throws WCSPException;

    public void removeKeyAuthority(String var1) throws WCSPException;

    public void setKeyUpdateStrategy(String var1, KeyUpdateStrategySpec var2) throws InvalidParameterException, WCSPException;

    public void disableKey(String var1) throws WCSPException;

    public void enableKey(String var1) throws WCSPException;

    public void scheduleKeyDeletion(String var1, int var2) throws WCSPException;

    public void cancleKeyDeletion(String var1) throws WCSPException;

    public void registerIdentifier(String var1, String var2) throws InvalidParameterException, WCSPException;

    public KMIdentifier getIdentifier(String var1, String var2) throws InvalidParameterException, WCSPException;

    public KMIdentifier getIdentifier(String var1, String var2, int var3) throws InvalidParameterException, WCSPException;

    public int getIdentifierLatestVersion(String var1, String var2) throws InvalidParameterException, WCSPException;

    public KMKeyPairImportHelper getKMKeyPairImportHelper() throws WCSPException;

    public KMSecretKeyImportHelper getKMSecretKeyImportHelper() throws WCSPException;
}

