/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.baseservice.ca;

import cn.com.westone.wcspsdk.CryptoService;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.KeyPair;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.ca.CAServiceImpl;
import cn.com.westone.wcspsdk.util.cert.X501DName;
import java.math.BigInteger;
import java.time.Instant;

public interface CAService
extends CryptoService {
    public static final String SERVICE_TYPE_CA = "CA";

    public static PKCS10CSRequestBuilder getPKCS10CSRequestBuilder() {
        return CAServiceImpl.getPKCS10CSRequestBuilder();
    }

    public static CAService getInstance(CryptoServicePlatform platform) throws WCSPException {
        if (platform instanceof PlatformImpl) {
            return CAServiceImpl.getInstance((PlatformImpl)platform);
        }
        throw new UnsupportedOperationException("Unsupport CryptoServicePlatform");
    }

    @Override
    public void init(Object ... var1);

    public SignCertHolder issueSignCert(byte[] var1, Instant var2, Instant var3) throws InvalidParameterException, WCSPException;

    public SignAndEncCertHolder issueSignAndEncCert(byte[] var1, Instant var2, Instant var3) throws InvalidParameterException, WCSPException;

    public SignCertHolder updateSignCert(BigInteger var1, byte[] var2, Instant var3, Instant var4) throws InvalidParameterException, WCSPException;

    public SignAndEncCertHolder updateSignAndEncCert(BigInteger var1, byte[] var2, Instant var3, Instant var4) throws InvalidParameterException, WCSPException;

    public SignCertHolder delaySignCert(BigInteger var1, Instant var2) throws WCSPException;

    public SignAndEncCertHolder delaySignAndEncCert(BigInteger var1, Instant var2) throws WCSPException;

    public void freezeSignCert(BigInteger var1) throws WCSPException;

    public void freezeSignAndEncCert(BigInteger var1) throws WCSPException;

    public void unfreezeSignCert(BigInteger var1) throws WCSPException;

    public void unfreezeSignAndEncCert(BigInteger var1) throws WCSPException;

    public void revokeSignCert(BigInteger var1, CRLReason var2) throws WCSPException;

    public void revokeSignAndEncCert(BigInteger var1, CRLReason var2) throws WCSPException;

    public SignAndEncCertHolder restoreSignAndEncCert(BigInteger var1, byte[] var2) throws WCSPException;

    public CertStatus checkCertVaild(BigInteger var1) throws WCSPException;

    public byte[] getCertChain() throws WCSPException;

    public static final class SignAndEncCertHolder {
        private final BigInteger signSN;
        private final byte[] signCertData;
        private final BigInteger encSN;
        private final byte[] encCertData;
        private final byte[] envelopedEncKeyPairData;

        public BigInteger signSN() {
            return this.signSN;
        }

        public byte[] signCertData() {
            return this.signCertData;
        }

        public BigInteger encSN() {
            return this.encSN;
        }

        public byte[] encCertData() {
            return this.encCertData;
        }

        public byte[] envelopedEncKeyPairData() {
            return this.envelopedEncKeyPairData;
        }

        public SignAndEncCertHolder(BigInteger signSN, byte[] signCertData, BigInteger encSN, byte[] encCertData, byte[] envelopedEncKeyPairData) {
            this.signSN = signSN;
            this.signCertData = signCertData;
            this.encSN = encSN;
            this.encCertData = encCertData;
            this.envelopedEncKeyPairData = envelopedEncKeyPairData;
        }
    }

    public static final class SignCertHolder {
        private final BigInteger signSN;
        private final byte[] signCertData;

        public BigInteger signSN() {
            return this.signSN;
        }

        public byte[] signCertData() {
            return this.signCertData;
        }

        public SignCertHolder(BigInteger signSN, byte[] signCertData) {
            this.signSN = signSN;
            this.signCertData = signCertData;
        }
    }

    public static interface PKCS10CSRequestBuilder {
        public PKCS10CSRequestBuilder addAttribute(String var1, String var2);

        public PKCS10CSRequestBuilder addAttribute(String var1, String[] var2);

        public PKCS10CSRequestBuilder addAttribute(String var1, byte[] var2);

        public PKCS10CSRequestBuilder addAttribute(String var1, byte[][] var2);

        public byte[] build(KeyPair var1, String var2) throws InvalidKeyException, WCSPException;

        public byte[] build(KeyPair var1, X501DName var2) throws InvalidKeyException, WCSPException;
    }

    public static enum CertStatus {
        GOOD(0),
        REVOKED(1),
        UNKNOWN(2);

        public final int value;

        private CertStatus(int value) {
            this.value = value;
        }
    }

    public static enum CRLReason {
        UNSPECIFIED(0),
        KEY_COMPROMISE(1),
        CA_COMPROMISE(2),
        AFFILIATION_CHANGED(3),
        SUPERSEDED(4),
        CESSATION_OF_OPERATION(5),
        CERTIFICATE_HOLD(6),
        REMOVE_FROM_CRL(8),
        PRIVILEGE_WITHDRAWN(9),
        AA_COMPROMISE(10);

        public final int value;

        private CRLReason(int value) {
            this.value = value;
        }
    }
}

