/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.util;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import org.bouncycastle.pqc.asn1.XMSSKeyParams;
import org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import org.bouncycastle.pqc.asn1.XMSSMTPrivateKey;
import org.bouncycastle.pqc.asn1.XMSSPrivateKey;
import org.bouncycastle.pqc.crypto.lms.Composer;
import org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.util.Utils;
import org.bouncycastle.pqc.crypto.xmss.BDS;
import org.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import org.bouncycastle.util.Encodable;
import org.bouncycastle.util.Pack;

/*
 * Exception performing whole class analysis ignored.
 */
public class PrivateKeyInfoFactory {
    private PrivateKeyInfoFactory() {
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        return PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)asymmetricKeyParameter, null);
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter, ASN1Set aSN1Set) throws IOException {
        if (asymmetricKeyParameter instanceof QTESLAPrivateKeyParameters) {
            QTESLAPrivateKeyParameters qTESLAPrivateKeyParameters = (QTESLAPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = Utils.qTeslaLookupAlgID((int)qTESLAPrivateKeyParameters.getSecurityCategory());
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(qTESLAPrivateKeyParameters.getSecret()), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof SPHINCSPrivateKeyParameters) {
            SPHINCSPrivateKeyParameters sPHINCSPrivateKeyParameters = (SPHINCSPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, (ASN1Encodable)new SPHINCS256KeyParams(Utils.sphincs256LookupTreeAlgID((String)sPHINCSPrivateKeyParameters.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(sPHINCSPrivateKeyParameters.getKeyData()));
        }
        if (asymmetricKeyParameter instanceof NHPrivateKeyParameters) {
            NHPrivateKeyParameters nHPrivateKeyParameters = (NHPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            short[] sArray = nHPrivateKeyParameters.getSecData();
            byte[] byArray = new byte[sArray.length * 2];
            for (int i = 0; i != sArray.length; ++i) {
                Pack.shortToLittleEndian((short)sArray[i], (byte[])byArray, (int)(i * 2));
            }
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(byArray));
        }
        if (asymmetricKeyParameter instanceof LMSPrivateKeyParameters) {
            LMSPrivateKeyParameters lMSPrivateKeyParameters = (LMSPrivateKeyParameters)asymmetricKeyParameter;
            byte[] byArray = Composer.compose().u32str(1).bytes((Encodable)lMSPrivateKeyParameters).build();
            byte[] byArray2 = Composer.compose().u32str(1).bytes((Encodable)lMSPrivateKeyParameters.getPublicKey()).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(byArray), aSN1Set, byArray2);
        }
        if (asymmetricKeyParameter instanceof HSSPrivateKeyParameters) {
            HSSPrivateKeyParameters hSSPrivateKeyParameters = (HSSPrivateKeyParameters)asymmetricKeyParameter;
            byte[] byArray = Composer.compose().u32str(hSSPrivateKeyParameters.getL()).bytes((Encodable)hSSPrivateKeyParameters).build();
            byte[] byArray3 = Composer.compose().u32str(hSSPrivateKeyParameters.getL()).bytes((Encodable)hSSPrivateKeyParameters.getPublicKey().getLMSPublicKey()).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)new DEROctetString(byArray), aSN1Set, byArray3);
        }
        if (asymmetricKeyParameter instanceof XMSSPrivateKeyParameters) {
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters = (XMSSPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, (ASN1Encodable)new XMSSKeyParams(xMSSPrivateKeyParameters.getParameters().getHeight(), Utils.xmssLookupTreeAlgID((String)xMSSPrivateKeyParameters.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)PrivateKeyInfoFactory.xmssCreateKeyStructure((XMSSPrivateKeyParameters)xMSSPrivateKeyParameters), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof XMSSMTPrivateKeyParameters) {
            XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = (XMSSMTPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, (ASN1Encodable)new XMSSMTKeyParams(xMSSMTPrivateKeyParameters.getParameters().getHeight(), xMSSMTPrivateKeyParameters.getParameters().getLayers(), Utils.xmssLookupTreeAlgID((String)xMSSMTPrivateKeyParameters.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)PrivateKeyInfoFactory.xmssmtCreateKeyStructure((XMSSMTPrivateKeyParameters)xMSSMTPrivateKeyParameters), aSN1Set);
        }
        throw new IOException("key parameters not recognized");
    }

    private static XMSSPrivateKey xmssCreateKeyStructure(XMSSPrivateKeyParameters xMSSPrivateKeyParameters) throws IOException {
        byte[] byArray = xMSSPrivateKeyParameters.getEncoded();
        int n = xMSSPrivateKeyParameters.getParameters().getTreeDigestSize();
        int n2 = xMSSPrivateKeyParameters.getParameters().getHeight();
        int n3 = 4;
        int n4 = n;
        int n5 = n;
        int n6 = n;
        int n7 = n;
        int n8 = 0;
        int n9 = (int)XMSSUtil.bytesToXBigEndian((byte[])byArray, (int)n8, (int)n3);
        if (!XMSSUtil.isIndexValid((int)n2, (long)n9)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n3), (int)n4);
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n4), (int)n5);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n5), (int)n6);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n6), (int)n7);
        byte[] byArray6 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n7), (int)(byArray.length - n8));
        BDS bDS = null;
        try {
            bDS = (BDS)XMSSUtil.deserialize((byte[])byArray6, BDS.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("cannot parse BDS: " + classNotFoundException.getMessage());
        }
        if (bDS.getMaxIndex() != (1 << n2) - 1) {
            return new XMSSPrivateKey(n9, byArray2, byArray3, byArray4, byArray5, byArray6, bDS.getMaxIndex());
        }
        return new XMSSPrivateKey(n9, byArray2, byArray3, byArray4, byArray5, byArray6);
    }

    private static XMSSMTPrivateKey xmssmtCreateKeyStructure(XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters) throws IOException {
        byte[] byArray = xMSSMTPrivateKeyParameters.getEncoded();
        int n = xMSSMTPrivateKeyParameters.getParameters().getTreeDigestSize();
        int n2 = xMSSMTPrivateKeyParameters.getParameters().getHeight();
        int n3 = (n2 + 7) / 8;
        int n4 = n;
        int n5 = n;
        int n6 = n;
        int n7 = n;
        int n8 = 0;
        int n9 = (int)XMSSUtil.bytesToXBigEndian((byte[])byArray, (int)n8, (int)n3);
        if (!XMSSUtil.isIndexValid((int)n2, (long)n9)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n3), (int)n4);
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n4), (int)n5);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n5), (int)n6);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n6), (int)n7);
        byte[] byArray6 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n8 += n7), (int)(byArray.length - n8));
        BDSStateMap bDSStateMap = null;
        try {
            bDSStateMap = (BDSStateMap)XMSSUtil.deserialize((byte[])byArray6, BDSStateMap.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("cannot parse BDSStateMap: " + classNotFoundException.getMessage());
        }
        if (bDSStateMap.getMaxIndex() != (1L << n2) - 1L) {
            return new XMSSMTPrivateKey((long)n9, byArray2, byArray3, byArray4, byArray5, byArray6, bDSStateMap.getMaxIndex());
        }
        return new XMSSMTPrivateKey((long)n9, byArray2, byArray3, byArray4, byArray5, byArray6);
    }
}

