/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.asn1;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class XMSSMTPrivateKey
extends ASN1Object {
    private final int version;
    private final long index;
    private final long maxIndex;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private final byte[] bdsState;

    public XMSSMTPrivateKey(long l, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        this.version = 0;
        this.index = l;
        this.secretKeySeed = Arrays.clone((byte[])byArray);
        this.secretKeyPRF = Arrays.clone((byte[])byArray2);
        this.publicSeed = Arrays.clone((byte[])byArray3);
        this.root = Arrays.clone((byte[])byArray4);
        this.bdsState = Arrays.clone((byte[])byArray5);
        this.maxIndex = -1L;
    }

    public XMSSMTPrivateKey(long l, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, long l2) {
        this.version = 1;
        this.index = l;
        this.secretKeySeed = Arrays.clone((byte[])byArray);
        this.secretKeyPRF = Arrays.clone((byte[])byArray2);
        this.publicSeed = Arrays.clone((byte[])byArray3);
        this.root = Arrays.clone((byte[])byArray4);
        this.bdsState = Arrays.clone((byte[])byArray5);
        this.maxIndex = l2;
    }

    private XMSSMTPrivateKey(ASN1Sequence aSN1Sequence) {
        ASN1Integer aSN1Integer = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0));
        if (!aSN1Integer.hasValue(BigIntegers.ZERO) && !aSN1Integer.hasValue(BigIntegers.ONE)) {
            throw new IllegalArgumentException("unknown version of sequence");
        }
        this.version = aSN1Integer.intValueExact();
        if (aSN1Sequence.size() != 2 && aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("key sequence wrong size");
        }
        ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance((Object)aSN1Sequence.getObjectAt(1));
        this.index = ASN1Integer.getInstance((Object)aSN1Sequence2.getObjectAt(0)).longValueExact();
        this.secretKeySeed = Arrays.clone((byte[])DEROctetString.getInstance((Object)aSN1Sequence2.getObjectAt(1)).getOctets());
        this.secretKeyPRF = Arrays.clone((byte[])DEROctetString.getInstance((Object)aSN1Sequence2.getObjectAt(2)).getOctets());
        this.publicSeed = Arrays.clone((byte[])DEROctetString.getInstance((Object)aSN1Sequence2.getObjectAt(3)).getOctets());
        this.root = Arrays.clone((byte[])DEROctetString.getInstance((Object)aSN1Sequence2.getObjectAt(4)).getOctets());
        if (aSN1Sequence2.size() == 6) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance((Object)aSN1Sequence2.getObjectAt(5));
            if (aSN1TaggedObject.getTagNo() != 0) {
                throw new IllegalArgumentException("unknown tag in XMSSPrivateKey");
            }
            this.maxIndex = ASN1Integer.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false).longValueExact();
        } else if (aSN1Sequence2.size() == 5) {
            this.maxIndex = -1L;
        } else {
            throw new IllegalArgumentException("keySeq should be 5 or 6 in length");
        }
        this.bdsState = (byte[])(aSN1Sequence.size() == 3 ? Arrays.clone((byte[])DEROctetString.getInstance((ASN1TaggedObject)ASN1TaggedObject.getInstance((Object)aSN1Sequence.getObjectAt(2)), (boolean)true).getOctets()) : null);
    }

    public static XMSSMTPrivateKey getInstance(Object object) {
        if (object instanceof XMSSMTPrivateKey) {
            return (XMSSMTPrivateKey)object;
        }
        if (object != null) {
            return new XMSSMTPrivateKey(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public int getVersion() {
        return this.version;
    }

    public long getIndex() {
        return this.index;
    }

    public long getMaxIndex() {
        return this.maxIndex;
    }

    public byte[] getSecretKeySeed() {
        return Arrays.clone((byte[])this.secretKeySeed);
    }

    public byte[] getSecretKeyPRF() {
        return Arrays.clone((byte[])this.secretKeyPRF);
    }

    public byte[] getPublicSeed() {
        return Arrays.clone((byte[])this.publicSeed);
    }

    public byte[] getRoot() {
        return Arrays.clone((byte[])this.root);
    }

    public byte[] getBdsState() {
        return Arrays.clone((byte[])this.bdsState);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.maxIndex >= 0L) {
            aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(1L));
        } else {
            aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(0L));
        }
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add((ASN1Encodable)new ASN1Integer(this.index));
        aSN1EncodableVector2.add((ASN1Encodable)new DEROctetString(this.secretKeySeed));
        aSN1EncodableVector2.add((ASN1Encodable)new DEROctetString(this.secretKeyPRF));
        aSN1EncodableVector2.add((ASN1Encodable)new DEROctetString(this.publicSeed));
        aSN1EncodableVector2.add((ASN1Encodable)new DEROctetString(this.root));
        if (this.maxIndex >= 0L) {
            aSN1EncodableVector2.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new ASN1Integer(this.maxIndex)));
        }
        aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
        aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DEROctetString(this.bdsState)));
        return new DERSequence(aSN1EncodableVector);
    }
}

