/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.custom.sec.SecP160R1Field;
import org.bouncycastle.math.raw.Nat160;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class SecP160R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict((String)"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFF"));
    protected int[] x;

    public SecP160R1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP160R1FieldElement");
        }
        this.x = SecP160R1Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecP160R1FieldElement() {
        this.x = Nat160.create();
    }

    protected SecP160R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    public boolean isZero() {
        return Nat160.isZero((int[])this.x);
    }

    public boolean isOne() {
        return Nat160.isOne((int[])this.x);
    }

    public boolean testBitZero() {
        return Nat160.getBit((int[])this.x, (int)0) == 1;
    }

    public BigInteger toBigInteger() {
        return Nat160.toBigInteger((int[])this.x);
    }

    public String getFieldName() {
        return "SecP160R1Field";
    }

    public int getFieldSize() {
        return Q.bitLength();
    }

    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat160.create();
        SecP160R1Field.add((int[])this.x, (int[])((SecP160R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP160R1FieldElement(nArray);
    }

    public ECFieldElement addOne() {
        int[] nArray = Nat160.create();
        SecP160R1Field.addOne((int[])this.x, (int[])nArray);
        return new SecP160R1FieldElement(nArray);
    }

    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat160.create();
        SecP160R1Field.subtract((int[])this.x, (int[])((SecP160R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP160R1FieldElement(nArray);
    }

    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat160.create();
        SecP160R1Field.multiply((int[])this.x, (int[])((SecP160R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP160R1FieldElement(nArray);
    }

    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat160.create();
        SecP160R1Field.inv((int[])((SecP160R1FieldElement)eCFieldElement).x, (int[])nArray);
        SecP160R1Field.multiply((int[])nArray, (int[])this.x, (int[])nArray);
        return new SecP160R1FieldElement(nArray);
    }

    public ECFieldElement negate() {
        int[] nArray = Nat160.create();
        SecP160R1Field.negate((int[])this.x, (int[])nArray);
        return new SecP160R1FieldElement(nArray);
    }

    public ECFieldElement square() {
        int[] nArray = Nat160.create();
        SecP160R1Field.square((int[])this.x, (int[])nArray);
        return new SecP160R1FieldElement(nArray);
    }

    public ECFieldElement invert() {
        int[] nArray = Nat160.create();
        SecP160R1Field.inv((int[])this.x, (int[])nArray);
        return new SecP160R1FieldElement(nArray);
    }

    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat160.isZero((int[])nArray) || Nat160.isOne((int[])nArray)) {
            return this;
        }
        int[] nArray2 = Nat160.create();
        SecP160R1Field.square((int[])nArray, (int[])nArray2);
        SecP160R1Field.multiply((int[])nArray2, (int[])nArray, (int[])nArray2);
        int[] nArray3 = Nat160.create();
        SecP160R1Field.squareN((int[])nArray2, (int)2, (int[])nArray3);
        SecP160R1Field.multiply((int[])nArray3, (int[])nArray2, (int[])nArray3);
        int[] nArray4 = nArray2;
        SecP160R1Field.squareN((int[])nArray3, (int)4, (int[])nArray4);
        SecP160R1Field.multiply((int[])nArray4, (int[])nArray3, (int[])nArray4);
        int[] nArray5 = nArray3;
        SecP160R1Field.squareN((int[])nArray4, (int)8, (int[])nArray5);
        SecP160R1Field.multiply((int[])nArray5, (int[])nArray4, (int[])nArray5);
        int[] nArray6 = nArray4;
        SecP160R1Field.squareN((int[])nArray5, (int)16, (int[])nArray6);
        SecP160R1Field.multiply((int[])nArray6, (int[])nArray5, (int[])nArray6);
        int[] nArray7 = nArray5;
        SecP160R1Field.squareN((int[])nArray6, (int)32, (int[])nArray7);
        SecP160R1Field.multiply((int[])nArray7, (int[])nArray6, (int[])nArray7);
        int[] nArray8 = nArray6;
        SecP160R1Field.squareN((int[])nArray7, (int)64, (int[])nArray8);
        SecP160R1Field.multiply((int[])nArray8, (int[])nArray7, (int[])nArray8);
        int[] nArray9 = nArray7;
        SecP160R1Field.square((int[])nArray8, (int[])nArray9);
        SecP160R1Field.multiply((int[])nArray9, (int[])nArray, (int[])nArray9);
        int[] nArray10 = nArray9;
        SecP160R1Field.squareN((int[])nArray10, (int)29, (int[])nArray10);
        int[] nArray11 = nArray8;
        SecP160R1Field.square((int[])nArray10, (int[])nArray11);
        return Nat160.eq((int[])nArray, (int[])nArray11) ? new SecP160R1FieldElement(nArray10) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP160R1FieldElement)) {
            return false;
        }
        SecP160R1FieldElement secP160R1FieldElement = (SecP160R1FieldElement)object;
        return Nat160.eq((int[])this.x, (int[])secP160R1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode((int[])this.x, (int)0, (int)5);
    }
}

