/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.util;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Enumeration;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECNamedDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Fingerprint;
import org.bouncycastle.util.Strings;

/*
 * Exception performing whole class analysis ignored.
 */
public class ECUtil {
    static int[] convertMidTerms(int[] nArray) {
        int[] nArray2 = new int[3];
        if (nArray.length == 1) {
            nArray2[0] = nArray[0];
        } else {
            if (nArray.length != 3) {
                throw new IllegalArgumentException("Only Trinomials and pentanomials supported");
            }
            if (nArray[0] < nArray[1] && nArray[0] < nArray[2]) {
                nArray2[0] = nArray[0];
                if (nArray[1] < nArray[2]) {
                    nArray2[1] = nArray[1];
                    nArray2[2] = nArray[2];
                } else {
                    nArray2[1] = nArray[2];
                    nArray2[2] = nArray[1];
                }
            } else if (nArray[1] < nArray[2]) {
                nArray2[0] = nArray[1];
                if (nArray[0] < nArray[2]) {
                    nArray2[1] = nArray[0];
                    nArray2[2] = nArray[2];
                } else {
                    nArray2[1] = nArray[2];
                    nArray2[2] = nArray[0];
                }
            } else {
                nArray2[0] = nArray[2];
                if (nArray[0] < nArray[1]) {
                    nArray2[1] = nArray[0];
                    nArray2[2] = nArray[1];
                } else {
                    nArray2[1] = nArray[1];
                    nArray2[2] = nArray[0];
                }
            }
        }
        return nArray2;
    }

    public static ECDomainParameters getDomainParameters(ProviderConfiguration providerConfiguration, org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters;
        if (eCParameterSpec instanceof ECNamedCurveParameterSpec) {
            ECNamedCurveParameterSpec eCNamedCurveParameterSpec = (ECNamedCurveParameterSpec)eCParameterSpec;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ECUtil.getNamedCurveOid((String)eCNamedCurveParameterSpec.getName());
            eCDomainParameters = new ECNamedDomainParameters(aSN1ObjectIdentifier, eCNamedCurveParameterSpec.getCurve(), eCNamedCurveParameterSpec.getG(), eCNamedCurveParameterSpec.getN(), eCNamedCurveParameterSpec.getH(), eCNamedCurveParameterSpec.getSeed());
        } else if (eCParameterSpec == null) {
            org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec2 = providerConfiguration.getEcImplicitlyCa();
            eCDomainParameters = new ECDomainParameters(eCParameterSpec2.getCurve(), eCParameterSpec2.getG(), eCParameterSpec2.getN(), eCParameterSpec2.getH(), eCParameterSpec2.getSeed());
        } else {
            eCDomainParameters = new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed());
        }
        return eCDomainParameters;
    }

    public static ECDomainParameters getDomainParameters(ProviderConfiguration providerConfiguration, X962Parameters x962Parameters) {
        ECNamedDomainParameters eCNamedDomainParameters;
        if (x962Parameters.isNamedCurve()) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance((Object)x962Parameters.getParameters());
            X9ECParameters x9ECParameters = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            if (x9ECParameters == null) {
                Map map = providerConfiguration.getAdditionalECParameters();
                x9ECParameters = (X9ECParameters)map.get(aSN1ObjectIdentifier);
            }
            eCNamedDomainParameters = new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters);
        } else if (x962Parameters.isImplicitlyCA()) {
            org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = providerConfiguration.getEcImplicitlyCa();
            eCNamedDomainParameters = new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed());
        } else {
            X9ECParameters x9ECParameters = X9ECParameters.getInstance((Object)x962Parameters.getParameters());
            eCNamedDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        }
        return eCNamedDomainParameters;
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof org.bouncycastle.jce.interfaces.ECPublicKey) {
            org.bouncycastle.jce.interfaces.ECPublicKey eCPublicKey = (org.bouncycastle.jce.interfaces.ECPublicKey)publicKey;
            org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = eCPublicKey.getParameters();
            return new ECPublicKeyParameters(eCPublicKey.getQ(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
        }
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = EC5Util.convertSpec((ECParameterSpec)eCPublicKey.getParams());
            return new ECPublicKeyParameters(EC5Util.convertPoint((ECParameterSpec)eCPublicKey.getParams(), (ECPoint)eCPublicKey.getW()), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
        }
        try {
            byte[] byArray = publicKey.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("no encoding for EC public key");
            }
            PublicKey publicKey2 = BouncyCastleProvider.getPublicKey((SubjectPublicKeyInfo)SubjectPublicKeyInfo.getInstance((Object)byArray));
            if (publicKey2 instanceof ECPublicKey) {
                return ECUtil.generatePublicKeyParameter((PublicKey)publicKey2);
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException("cannot identify EC public key: " + exception.toString());
        }
        throw new InvalidKeyException("cannot identify EC public key.");
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof ECPrivateKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
            org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = eCPrivateKey.getParameters();
            if (eCParameterSpec == null) {
                eCParameterSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            }
            if (eCPrivateKey.getParameters() instanceof ECNamedCurveParameterSpec) {
                String string = ((ECNamedCurveParameterSpec)eCPrivateKey.getParameters()).getName();
                return new ECPrivateKeyParameters(eCPrivateKey.getD(), (ECDomainParameters)new ECNamedDomainParameters(ECNamedCurveTable.getOID((String)string), eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
            }
            return new ECPrivateKeyParameters(eCPrivateKey.getD(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
        }
        if (privateKey instanceof java.security.interfaces.ECPrivateKey) {
            java.security.interfaces.ECPrivateKey eCPrivateKey = (java.security.interfaces.ECPrivateKey)privateKey;
            org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = EC5Util.convertSpec((ECParameterSpec)eCPrivateKey.getParams());
            return new ECPrivateKeyParameters(eCPrivateKey.getS(), new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed()));
        }
        try {
            byte[] byArray = privateKey.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("no encoding for EC private key");
            }
            PrivateKey privateKey2 = BouncyCastleProvider.getPrivateKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)byArray));
            if (privateKey2 instanceof java.security.interfaces.ECPrivateKey) {
                return ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey2);
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException("cannot identify EC private key: " + exception.toString());
        }
        throw new InvalidKeyException("can't identify EC private key.");
    }

    public static int getOrderBitLength(ProviderConfiguration providerConfiguration, BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = providerConfiguration.getEcImplicitlyCa();
            if (eCParameterSpec == null) {
                return bigInteger2.bitLength();
            }
            return eCParameterSpec.getN().bitLength();
        }
        return bigInteger.bitLength();
    }

    public static ASN1ObjectIdentifier getNamedCurveOid(String string) {
        String string2 = string;
        int n = string2.indexOf(32);
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        try {
            if (string2.charAt(0) >= '0' && string2.charAt(0) <= '2') {
                return new ASN1ObjectIdentifier(string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ECNamedCurveTable.getOID((String)string2);
    }

    public static ASN1ObjectIdentifier getNamedCurveOid(org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        Enumeration enumeration = ECNamedCurveTable.getNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            X9ECParameters x9ECParameters = ECNamedCurveTable.getByName((String)string);
            if (!x9ECParameters.getN().equals(eCParameterSpec.getN()) || !x9ECParameters.getH().equals(eCParameterSpec.getH()) || !x9ECParameters.getCurve().equals(eCParameterSpec.getCurve()) || !x9ECParameters.getG().equals(eCParameterSpec.getG())) continue;
            return ECNamedCurveTable.getOID((String)string);
        }
        return null;
    }

    public static X9ECParameters getNamedCurveByOid(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    public static X9ECParameters getNamedCurveByName(String string) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByName((String)string);
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByName((String)string);
        }
        return x9ECParameters;
    }

    public static String getCurveName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return ECNamedCurveTable.getName((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
    }

    public static String privateKeyToString(String string, BigInteger bigInteger, org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = Strings.lineSeparator();
        org.bouncycastle.math.ec.ECPoint eCPoint = new FixedPointCombMultiplier().multiply(eCParameterSpec.getG(), bigInteger).normalize();
        stringBuffer.append(string);
        stringBuffer.append(" Private Key [").append(ECUtil.generateKeyFingerprint((org.bouncycastle.math.ec.ECPoint)eCPoint, (org.bouncycastle.jce.spec.ECParameterSpec)eCParameterSpec)).append("]").append(string2);
        stringBuffer.append("            X: ").append(eCPoint.getAffineXCoord().toBigInteger().toString(16)).append(string2);
        stringBuffer.append("            Y: ").append(eCPoint.getAffineYCoord().toBigInteger().toString(16)).append(string2);
        return stringBuffer.toString();
    }

    public static String publicKeyToString(String string, org.bouncycastle.math.ec.ECPoint eCPoint, org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = Strings.lineSeparator();
        stringBuffer.append(string);
        stringBuffer.append(" Public Key [").append(ECUtil.generateKeyFingerprint((org.bouncycastle.math.ec.ECPoint)eCPoint, (org.bouncycastle.jce.spec.ECParameterSpec)eCParameterSpec)).append("]").append(string2);
        stringBuffer.append("            X: ").append(eCPoint.getAffineXCoord().toBigInteger().toString(16)).append(string2);
        stringBuffer.append("            Y: ").append(eCPoint.getAffineYCoord().toBigInteger().toString(16)).append(string2);
        return stringBuffer.toString();
    }

    public static String generateKeyFingerprint(org.bouncycastle.math.ec.ECPoint eCPoint, org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        ECCurve eCCurve = eCParameterSpec.getCurve();
        org.bouncycastle.math.ec.ECPoint eCPoint2 = eCParameterSpec.getG();
        if (eCCurve != null) {
            return new Fingerprint(Arrays.concatenate((byte[])eCPoint.getEncoded(false), (byte[])eCCurve.getA().getEncoded(), (byte[])eCCurve.getB().getEncoded(), (byte[])eCPoint2.getEncoded(false))).toString();
        }
        return new Fingerprint(eCPoint.getEncoded(false)).toString();
    }

    public static String getNameFrom(AlgorithmParameterSpec algorithmParameterSpec) {
        return (String)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }
}

