/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.util.cms;

import cn.com.westone.wcspsdk.impl.base.Utils;
import cn.com.westone.wcspsdk.util.ConversionUtils;
import cn.com.westone.wcspsdk.util.DigestUtils;
import cn.com.westone.wcspsdk.util.SignatureUtils;
import cn.com.westone.wcspsdk.util.cms.CMSException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.encoders.Base64;

public class CMSSignedData {
    private final SignedData signedData;

    public static CMSSignedData getInstance(byte[] signedDataData) {
        ContentInfo contentInfo = ContentInfo.getInstance((Object)signedDataData);
        if (!contentInfo.getContentType().equals((ASN1Primitive)new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.2")) && !contentInfo.getContentType().equals((ASN1Primitive)CMSObjectIdentifiers.signedData)) {
            throw new IllegalArgumentException("Argument \"signedDataData\" is illegal");
        }
        return new CMSSignedData(SignedData.getInstance((Object)contentInfo.getContent()));
    }

    public static CMSSignedData getInstance(String signedDataData) {
        return CMSSignedData.getInstance(Base64.decode((String)signedDataData));
    }

    public int getVersion() {
        return this.signedData.getVersion().intValueExact();
    }

    public byte[] getContent() throws CMSException {
        ContentInfo contentInfo = this.signedData.getEncapContentInfo();
        if (!contentInfo.getContentType().equals((ASN1Primitive)new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1")) && !contentInfo.getContentType().equals((ASN1Primitive)CMSObjectIdentifiers.data)) {
            throw new CMSException("Invalid content");
        }
        if (null == contentInfo.getContent() || contentInfo.getContent() instanceof ASN1Null) {
            return null;
        }
        return ((ASN1OctetString)contentInfo.getContent()).getOctets();
    }

    public byte[][] getCertificates() throws CMSException {
        ASN1Set certificates = this.signedData.getCertificates();
        if (null == certificates || certificates.size() < 1) {
            throw new CMSException("There is no certificate");
        }
        byte[][] certificateDatas = new byte[certificates.size()][];
        for (int i = 0; i < certificates.size(); ++i) {
            try {
                certificateDatas[i] = certificates.getObjectAt(i).toASN1Primitive().getEncoded("DER");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
        }
        return certificateDatas;
    }

    public byte[] getSignature(byte[] signerCertificateData) throws CMSException {
        Certificate signerCertificate = Certificate.getInstance((Object)signerCertificateData);
        CMSSignedData.checkSignerCertificate(signerCertificate);
        for (ASN1Encodable element : this.signedData.getSignerInfos()) {
            SignerInfo signerInfo = SignerInfo.getInstance((Object)element);
            if (signerInfo.getSID().isTagged()) {
                throw new CMSException("Invalid signer identifier");
            }
            if (!IssuerAndSerialNumber.getInstance((Object)signerInfo.getSID().getId()).equals((Object)new IssuerAndSerialNumber(signerCertificate))) continue;
            byte[] signatureData = signerInfo.getEncryptedDigest().getOctets();
            if (signerInfo.getDigestEncryptionAlgorithm().getAlgorithm().equals((ASN1Primitive)GMObjectIdentifiers.sm2sign)) {
                try {
                    signatureData = ConversionUtils.SM2SignatureData.fromGMT0009(signatureData);
                }
                catch (Exception e) {
                    throw new CMSException("Invalid signer signature");
                }
            }
            return signatureData;
        }
        throw new CMSException("No signer found");
    }

    public boolean verify(byte[] signerCertificateData) throws CMSException {
        byte[] content = this.getContent();
        if (null == content) {
            throw new CMSException("Content not encapsulated in CMSSignedData");
        }
        return this.verify(content, signerCertificateData, verifyParameters -> {
            try {
                return SignatureUtils.sm2Verify(verifyParameters[0], verifyParameters[1], verifyParameters[2]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public boolean verify(byte[] content, byte[] signerCertificateData) throws CMSException {
        return this.verify(content, signerCertificateData, verifyParameters -> {
            try {
                return SignatureUtils.sm2Verify(verifyParameters[0], verifyParameters[1], verifyParameters[2]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public boolean verify(byte[] content, byte[] signerCertificateData, Function<byte[][], Boolean> verifierFunction) throws CMSException {
        byte[] signedContent = content;
        Certificate signerCertificate = Certificate.getInstance((Object)signerCertificateData);
        CMSSignedData.checkSignerCertificate(signerCertificate);
        byte[] signerPublicKeyData = CMSSignedData.getSignerPublicKeyData(signerCertificate);
        for (ASN1Encodable element1 : this.signedData.getSignerInfos()) {
            byte[] signatureData;
            SignerInfo signerInfo = SignerInfo.getInstance((Object)element1);
            if (1 != signerInfo.getVersion().intValueExact()) {
                throw new CMSException("Invalid signer info");
            }
            if (signerInfo.getSID().isTagged()) {
                throw new CMSException("Invalid signer identifier");
            }
            if (!IssuerAndSerialNumber.getInstance((Object)signerInfo.getSID().getId()).equals((Object)new IssuerAndSerialNumber(signerCertificate))) continue;
            if (!signerInfo.getDigestAlgorithm().getAlgorithm().equals((ASN1Primitive)GMObjectIdentifiers.sm3)) {
                throw new CMSException("Invalid signer digest algorithm");
            }
            ASN1Set signedAttributes = signerInfo.getAuthenticatedAttributes();
            if (null != signedAttributes) {
                boolean contentTypeChecked = false;
                boolean messageDigestChecked = false;
                for (ASN1Encodable element2 : signedAttributes) {
                    Attribute attribute = Attribute.getInstance((Object)element2);
                    ASN1ObjectIdentifier attributeType = attribute.getAttrType();
                    ASN1Set attributeValues = attribute.getAttrValues();
                    if (attributeType.equals((ASN1Primitive)CMSAttributes.contentType)) {
                        if (1 != attributeValues.size()) {
                            throw new CMSException("The content-type attribute MUST have a single attribute value");
                        }
                        ASN1ObjectIdentifier contentType = ASN1ObjectIdentifier.getInstance((Object)attributeValues.getObjectAt(0));
                        if (!contentType.equals((ASN1Primitive)new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1"))) {
                            throw new CMSException("Content-type attribute value does not match ContentType");
                        }
                        contentTypeChecked = true;
                        continue;
                    }
                    if (!attributeType.equals((ASN1Primitive)CMSAttributes.messageDigest)) continue;
                    if (1 != attributeValues.size()) {
                        throw new CMSException("The message-digest attribute MUST have a single attribute value");
                    }
                    ASN1OctetString messageDigest = ASN1OctetString.getInstance((Object)attributeValues.getObjectAt(0));
                    if (!Utils.arrayEquals(messageDigest.getOctets(), DigestUtils.sm3(content))) {
                        throw new CMSException("Message-digest attribute value does not match calculated digest");
                    }
                    messageDigestChecked = true;
                }
                if (!contentTypeChecked) {
                    throw new CMSException("The content-type attribute MUST be present whenever signed attributes are present");
                }
                if (!messageDigestChecked) {
                    throw new CMSException("The message-digest attribute MUST be present whenever signed attributes are present");
                }
                try {
                    signedContent = signedAttributes.getEncoded("DER");
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
            if (!signerInfo.getDigestEncryptionAlgorithm().getAlgorithm().equals((ASN1Primitive)GMObjectIdentifiers.sm2sign)) {
                throw new CMSException("Invalid signer signature algorithm");
            }
            try {
                signatureData = ConversionUtils.SM2SignatureData.fromGMT0009(signerInfo.getEncryptedDigest().getOctets());
            }
            catch (Exception e) {
                throw new CMSException("Invalid signer signature");
            }
            try {
                return verifierFunction.apply(new byte[][]{signerPublicKeyData, signedContent, signatureData});
            }
            catch (Exception e) {
                throw new RuntimeException("Verify failed", e);
            }
        }
        throw new CMSException("No signer found");
    }

    public byte[] getEncoded() {
        try {
            return new ContentInfo(new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.2"), (ASN1Encodable)this.signedData).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private static void checkSignerCertificate(Certificate signerCertificate) throws CMSException {
        if (!signerCertificate.getSignatureAlgorithm().equals((Object)signerCertificate.getTBSCertificate().getSignature())) {
            throw new CMSException("Invalid signer certificate");
        }
        if (!KeyUsage.fromExtensions((Extensions)signerCertificate.getTBSCertificate().getExtensions()).hasUsages(128)) {
            throw new CMSException("Invalid public key usage of signer certificate");
        }
    }

    private static byte[] getSignerPublicKeyData(Certificate signerCertificate) throws CMSException {
        byte[] publicKeyData = signerCertificate.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        AlgorithmIdentifier algorithmIdentifier = signerCertificate.getSubjectPublicKeyInfo().getAlgorithm();
        if (algorithmIdentifier.getAlgorithm().equals((ASN1Primitive)X9ObjectIdentifiers.id_ecPublicKey) && (algorithmIdentifier.getParameters() instanceof ASN1ObjectIdentifier ? algorithmIdentifier.getParameters().equals(GMObjectIdentifiers.sm2p256v1) : algorithmIdentifier.getParameters().equals(new X962Parameters(GMNamedCurves.getByOID((ASN1ObjectIdentifier)GMObjectIdentifiers.sm2p256v1))))) {
            if (!ConversionUtils.SM2PublicKeyData.check(publicKeyData)) {
                throw new CMSException("Invalid public key of signer certificate");
            }
        } else {
            throw new CMSException("Invalid public key algorithm of signer certificate");
        }
        return publicKeyData;
    }

    private CMSSignedData(SignedData signedData) {
        this.signedData = signedData;
    }

    public static class Generator {
        private ArrayList<Certificate> signerCertificates = new ArrayList();
        private ArrayList<byte[]> signerPublicKeyDatas = new ArrayList();
        private ArrayList<Certificate> relatedCertificates = new ArrayList();

        public Generator addSigner(byte[] signerCertificateData) throws CMSException {
            Certificate signerCertificate = Certificate.getInstance((Object)signerCertificateData);
            CMSSignedData.checkSignerCertificate(signerCertificate);
            this.signerCertificates.add(signerCertificate);
            this.signerPublicKeyDatas.add(CMSSignedData.getSignerPublicKeyData(signerCertificate));
            return this;
        }

        public Generator addSigner(String signerCertificateData) throws CMSException {
            return this.addSigner(Base64.decode((String)signerCertificateData));
        }

        public Generator addRelatedCertificate(byte[] certificateData) {
            this.relatedCertificates.add(Certificate.getInstance((Object)certificateData));
            return this;
        }

        public Generator addRelatedCertificate(String certificateData) {
            return this.addRelatedCertificate(Base64.decode((String)certificateData));
        }

        public CMSSignedData generate(byte[] content, BiFunction<Integer, byte[], byte[]> signerFunction, boolean encapsulated) throws CMSException {
            if (this.signerCertificates.isEmpty()) {
                throw new CMSException("There is no signer");
            }
            ASN1EncodableVector digestAlgorithms = new ASN1EncodableVector();
            digestAlgorithms.add((ASN1Encodable)new AlgorithmIdentifier(GMObjectIdentifiers.sm3));
            ASN1EncodableVector certificates = new ASN1EncodableVector();
            for (Certificate certificate : this.signerCertificates) {
                certificates.add((ASN1Encodable)certificate);
            }
            for (Certificate certificate : this.relatedCertificates) {
                certificates.add((ASN1Encodable)certificate);
            }
            ASN1EncodableVector signerInfos = new ASN1EncodableVector();
            for (int i = 0; i < this.signerCertificates.size(); ++i) {
                byte[] signatureData;
                try {
                    signatureData = signerFunction.apply(i, this.signerPublicKeyDatas.get(i));
                }
                catch (Exception e) {
                    throw new RuntimeException("Sign failed", e);
                }
                if (!SignatureUtils.sm2Verify(this.signerPublicKeyDatas.get(i), content, signatureData)) {
                    throw new RuntimeException("Sign failed");
                }
                signatureData = ConversionUtils.SM2SignatureData.toGMT0009(signatureData);
                signerInfos.add((ASN1Encodable)new SignerInfo(new SignerIdentifier(new IssuerAndSerialNumber(this.signerCertificates.get(i))), new AlgorithmIdentifier(GMObjectIdentifiers.sm3), (ASN1Set)null, new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign), (ASN1OctetString)new DEROctetString(signatureData), (ASN1Set)null));
            }
            return new CMSSignedData(new SignedData((ASN1Set)new DERSet(digestAlgorithms), new ContentInfo(new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1"), (ASN1Encodable)(encapsulated ? new BEROctetString(content) : null)), (ASN1Set)new BERSet(certificates), null, (ASN1Set)new DERSet(signerInfos)));
        }
    }
}

