/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.util.cms;

import cn.com.westone.wcspsdk.util.ConversionUtils;
import cn.com.westone.wcspsdk.util.SignatureUtils;
import cn.com.westone.wcspsdk.util.cms.CMSException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.encoders.Base64;

public class CMSSignedAndEnvelopedData {
    private final SignedAndEnvelopedData signedAndEnvelopedData;

    public static CMSSignedAndEnvelopedData getInstance(byte[] signedAndEnvelopedDataData) {
        ContentInfo contentInfo = ContentInfo.getInstance((Object)signedAndEnvelopedDataData);
        if (!contentInfo.getContentType().equals((ASN1Primitive)new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.4")) && !contentInfo.getContentType().equals((ASN1Primitive)CMSObjectIdentifiers.signedAndEnvelopedData)) {
            throw new IllegalArgumentException("Argument \"signedAndEnvelopedDataData\" is illegal");
        }
        return new CMSSignedAndEnvelopedData(SignedAndEnvelopedData.getInstance(contentInfo.getContent()));
    }

    public static CMSSignedAndEnvelopedData getInstance(String signedAndEnvelopedDataData) {
        return CMSSignedAndEnvelopedData.getInstance(Base64.decode((String)signedAndEnvelopedDataData));
    }

    public int getVersion() {
        return this.signedAndEnvelopedData.version.intValueExact();
    }

    public byte[][] getCertificates() throws CMSException {
        ASN1Set certificates = this.signedAndEnvelopedData.certificates;
        if (null == certificates || certificates.size() < 1) {
            throw new CMSException("There is no certificate");
        }
        byte[][] certificateDatas = new byte[certificates.size()][];
        for (int i = 0; i < certificates.size(); ++i) {
            try {
                certificateDatas[i] = certificates.getObjectAt(i).toASN1Primitive().getEncoded("DER");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
        }
        return certificateDatas;
    }

    public byte[] getContent(byte[] signerCertificateData, byte[] recipientCertificateData, Function<byte[][], Boolean> verifierFunction, Function<byte[][], byte[][]> cipherFunction) throws CMSException {
        Certificate recipientCertificate = Certificate.getInstance((Object)recipientCertificateData);
        CMSSignedAndEnvelopedData.checkRecipientCertificate(recipientCertificate);
        CMSSignedAndEnvelopedData.getRecipientPublicKeyData(recipientCertificate);
        Certificate signerCertificate = Certificate.getInstance((Object)signerCertificateData);
        CMSSignedAndEnvelopedData.checkSignerCertificate(signerCertificate);
        byte[] signerPublicKeyData = CMSSignedAndEnvelopedData.getSignerPublicKeyData(signerCertificate);
        for (ASN1Encodable element1 : this.signedAndEnvelopedData.recipientInfos) {
            byte[] encryptedKey;
            ASN1Encodable recipientInfo = RecipientInfo.getInstance((Object)element1).getInfo();
            if (!(recipientInfo instanceof KeyTransRecipientInfo)) {
                throw new CMSException("Invalid recipient info");
            }
            KeyTransRecipientInfo keyTransRecipientInfo = (KeyTransRecipientInfo)recipientInfo;
            if (0 != keyTransRecipientInfo.getVersion().intValueExact()) {
                throw new CMSException("Invalid key trans recipient info");
            }
            if (keyTransRecipientInfo.getRecipientIdentifier().isTagged()) {
                throw new CMSException("Invalid recipient identifier");
            }
            if (!IssuerAndSerialNumber.getInstance((Object)keyTransRecipientInfo.getRecipientIdentifier().getId()).equals((Object)new IssuerAndSerialNumber(recipientCertificate))) continue;
            if (!keyTransRecipientInfo.getKeyEncryptionAlgorithm().getAlgorithm().equals((ASN1Primitive)GMObjectIdentifiers.sm2encrypt)) {
                throw new CMSException("Invalid key encryption algorithm");
            }
            try {
                encryptedKey = ConversionUtils.SM2CipherData.fromGMT0009(keyTransRecipientInfo.getEncryptedKey().getOctets());
            }
            catch (Exception e) {
                throw new CMSException("Invalid encrypted key data");
            }
            EncryptedContentInfo encryptedContentInfo = this.signedAndEnvelopedData.encryptedContentInfo;
            if (!encryptedContentInfo.getContentType().equals((ASN1Primitive)new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1"))) {
                throw new CMSException("Invalid content");
            }
            if (!encryptedContentInfo.getContentEncryptionAlgorithm().getAlgorithm().equals((ASN1Primitive)GMObjectIdentifiers.sms4_cbc)) {
                throw new CMSException("Invalid content encryption algorithm");
            }
            ASN1Encodable parameter = encryptedContentInfo.getContentEncryptionAlgorithm().getParameters();
            if (null == parameter || parameter instanceof ASN1Null || !(parameter instanceof ASN1OctetString)) {
                throw new CMSException("Invalid content encryption algorithm iv");
            }
            byte[] iv = ((ASN1OctetString)parameter).getOctets();
            byte[] encryptedContent = encryptedContentInfo.getEncryptedContent().getOctets();
            if (null == iv || iv.length < 1 || null == encryptedContent || encryptedContent.length < 1 || encryptedContent.length % iv.length != 0) {
                throw new CMSException("Invalid encrypted content");
            }
            for (ASN1Encodable element2 : this.signedAndEnvelopedData.signerInfos) {
                byte[] signatureData;
                byte[][] decryptedDatas;
                SignerInfo signerInfo = SignerInfo.getInstance((Object)element2);
                if (1 != signerInfo.getVersion().intValueExact()) {
                    throw new CMSException("Invalid signer info");
                }
                if (signerInfo.getSID().isTagged()) {
                    throw new CMSException("Invalid signer identifier");
                }
                if (!IssuerAndSerialNumber.getInstance((Object)signerInfo.getSID().getId()).equals((Object)new IssuerAndSerialNumber(signerCertificate))) continue;
                if (!signerInfo.getDigestAlgorithm().getAlgorithm().equals((ASN1Primitive)GMObjectIdentifiers.sm3)) {
                    throw new CMSException("Invalid signer digest algorithm");
                }
                if (null != signerInfo.getAuthenticatedAttributes()) {
                    throw new CMSException("Signed attributes MUST not be present");
                }
                if (!signerInfo.getDigestEncryptionAlgorithm().getAlgorithm().equals((ASN1Primitive)GMObjectIdentifiers.sm2sign)) {
                    throw new CMSException("Invalid signer signature algorithm");
                }
                byte[] encryptedSignatureData = signerInfo.getEncryptedDigest().getOctets();
                if (encryptedSignatureData.length % iv.length != 0) {
                    throw new CMSException("Invalid signer encrypted signature");
                }
                try {
                    decryptedDatas = cipherFunction.apply(new byte[][]{encryptedKey, iv, encryptedContent, encryptedSignatureData});
                }
                catch (Exception e) {
                    throw new RuntimeException("Unwrap and decrypt failed", e);
                }
                try {
                    signatureData = ConversionUtils.SM2SignatureData.fromGMT0009(decryptedDatas[1]);
                }
                catch (Exception e) {
                    throw new CMSException("Invalid signer signature");
                }
                try {
                    if (!verifierFunction.apply(new byte[][]{signerPublicKeyData, decryptedDatas[0], signatureData}).booleanValue()) {
                        throw new CMSException("Verify signer signature failed");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Verify failed", e);
                }
                return decryptedDatas[0];
            }
            throw new CMSException("No signer found");
        }
        throw new CMSException("No recipient found");
    }

    public byte[] getEncoded() {
        try {
            return new ContentInfo(new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.4"), (ASN1Encodable)this.signedAndEnvelopedData).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private static void checkRecipientCertificate(Certificate recipientCertificate) throws CMSException {
        if (!recipientCertificate.getSignatureAlgorithm().equals((Object)recipientCertificate.getTBSCertificate().getSignature())) {
            throw new CMSException("Invalid recipient certificate");
        }
        if (!KeyUsage.fromExtensions((Extensions)recipientCertificate.getTBSCertificate().getExtensions()).hasUsages(32)) {
            throw new CMSException("Invalid public key usage of recipient certificate");
        }
    }

    private static byte[] getRecipientPublicKeyData(Certificate recipientCertificate) throws CMSException {
        byte[] publicKeyData = recipientCertificate.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        AlgorithmIdentifier algorithmIdentifier = recipientCertificate.getSubjectPublicKeyInfo().getAlgorithm();
        if (algorithmIdentifier.getAlgorithm().equals((ASN1Primitive)X9ObjectIdentifiers.id_ecPublicKey) || (algorithmIdentifier.getParameters() instanceof ASN1ObjectIdentifier ? algorithmIdentifier.getParameters().equals(GMObjectIdentifiers.sm2p256v1) : algorithmIdentifier.getParameters().equals(new X962Parameters(GMNamedCurves.getByOID((ASN1ObjectIdentifier)GMObjectIdentifiers.sm2p256v1))))) {
            if (!ConversionUtils.SM2PublicKeyData.check(publicKeyData)) {
                throw new CMSException("Invalid public key of recipient certificate");
            }
        } else {
            throw new CMSException("Invalid public key algorithm of recipient certificate");
        }
        return publicKeyData;
    }

    private static void checkSignerCertificate(Certificate signerCertificate) throws CMSException {
        if (!signerCertificate.getSignatureAlgorithm().equals((Object)signerCertificate.getTBSCertificate().getSignature())) {
            throw new CMSException("Invalid signer certificate");
        }
        if (!KeyUsage.fromExtensions((Extensions)signerCertificate.getTBSCertificate().getExtensions()).hasUsages(128)) {
            throw new CMSException("Invalid public key usage of signer certificate");
        }
    }

    private static byte[] getSignerPublicKeyData(Certificate signerCertificate) throws CMSException {
        byte[] publicKeyData = signerCertificate.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        AlgorithmIdentifier algorithmIdentifier = signerCertificate.getSubjectPublicKeyInfo().getAlgorithm();
        if (algorithmIdentifier.getAlgorithm().equals((ASN1Primitive)X9ObjectIdentifiers.id_ecPublicKey) && (algorithmIdentifier.getParameters() instanceof ASN1ObjectIdentifier ? algorithmIdentifier.getParameters().equals(GMObjectIdentifiers.sm2p256v1) : algorithmIdentifier.getParameters().equals(new X962Parameters(GMNamedCurves.getByOID((ASN1ObjectIdentifier)GMObjectIdentifiers.sm2p256v1))))) {
            if (!ConversionUtils.SM2PublicKeyData.check(publicKeyData)) {
                throw new CMSException("Invalid public key of signer certificate");
            }
        } else {
            throw new CMSException("Invalid public key algorithm of signer certificate");
        }
        return publicKeyData;
    }

    private CMSSignedAndEnvelopedData(SignedAndEnvelopedData signedAndEnvelopedData) {
        this.signedAndEnvelopedData = signedAndEnvelopedData;
    }

    private static class SignedAndEnvelopedData
    extends ASN1Object {
        private final ASN1Integer version;
        private final ASN1Set recipientInfos;
        private final ASN1Set digestAlgorithms;
        private final EncryptedContentInfo encryptedContentInfo;
        private final ASN1Set certificates;
        private final ASN1Set crls;
        private final ASN1Set signerInfos;

        public static SignedAndEnvelopedData getInstance(Object object) {
            if (object instanceof SignedAndEnvelopedData) {
                return (SignedAndEnvelopedData)((Object)object);
            }
            if (null != object) {
                return new SignedAndEnvelopedData(ASN1Sequence.getInstance((Object)object));
            }
            return null;
        }

        public SignedAndEnvelopedData(ASN1Set recipientInfos, ASN1Set digestAlgorithms, EncryptedContentInfo encryptedContentInfo, ASN1Set certificates, ASN1Set crls, ASN1Set signerInfos) {
            this.version = new ASN1Integer(1L);
            this.recipientInfos = recipientInfos;
            this.digestAlgorithms = digestAlgorithms;
            this.encryptedContentInfo = encryptedContentInfo;
            this.certificates = certificates;
            this.crls = crls;
            this.signerInfos = signerInfos;
        }

        public SignedAndEnvelopedData(ASN1Sequence seq) {
            int i = 0;
            this.version = ASN1Integer.getInstance((Object)seq.getObjectAt(i++));
            this.recipientInfos = ASN1Set.getInstance((Object)seq.getObjectAt(i++));
            this.digestAlgorithms = ASN1Set.getInstance((Object)seq.getObjectAt(i++));
            this.encryptedContentInfo = EncryptedContentInfo.getInstance((Object)seq.getObjectAt(i++));
            ASN1Encodable element = seq.getObjectAt(i++);
            if (element instanceof ASN1TaggedObject && 0 == ((ASN1TaggedObject)element).getTagNo()) {
                this.certificates = ASN1Set.getInstance((ASN1TaggedObject)((ASN1TaggedObject)element), (boolean)false);
                element = seq.getObjectAt(i++);
            } else {
                this.certificates = null;
            }
            if (element instanceof ASN1TaggedObject) {
                this.crls = ASN1Set.getInstance((ASN1TaggedObject)((ASN1TaggedObject)element), (boolean)false);
                element = seq.getObjectAt(i++);
            } else {
                this.crls = null;
            }
            this.signerInfos = ASN1Set.getInstance((Object)element);
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector(7);
            vector.add((ASN1Encodable)this.version);
            vector.add((ASN1Encodable)this.recipientInfos);
            vector.add((ASN1Encodable)this.digestAlgorithms);
            vector.add((ASN1Encodable)this.encryptedContentInfo);
            if (null != this.certificates) {
                if (this.certificates instanceof BERSet) {
                    vector.add((ASN1Encodable)new BERTaggedObject(false, 0, (ASN1Encodable)this.certificates));
                } else {
                    vector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.certificates));
                }
            }
            if (null != this.crls) {
                if (this.crls instanceof BERSet) {
                    vector.add((ASN1Encodable)new BERTaggedObject(false, 1, (ASN1Encodable)this.crls));
                } else {
                    vector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.crls));
                }
            }
            vector.add((ASN1Encodable)this.signerInfos);
            return new BERSequence(vector);
        }
    }

    public static class Generator {
        private ArrayList<Certificate> signerCertificates = new ArrayList();
        private ArrayList<byte[]> signerPublicKeyDatas = new ArrayList();
        private ArrayList<Certificate> recipientCertificates = new ArrayList();
        private ArrayList<byte[]> recipientPublicKeyDatas = new ArrayList();
        private ArrayList<Certificate> relatedCertificates = new ArrayList();

        public Generator addSigner(byte[] signerCertificateData) throws CMSException {
            Certificate signerCertificate = Certificate.getInstance((Object)signerCertificateData);
            CMSSignedAndEnvelopedData.checkSignerCertificate(signerCertificate);
            this.signerCertificates.add(signerCertificate);
            this.signerPublicKeyDatas.add(CMSSignedAndEnvelopedData.getSignerPublicKeyData(signerCertificate));
            return this;
        }

        public Generator addSigner(String signerCertificateData) throws CMSException {
            return this.addSigner(Base64.decode((String)signerCertificateData));
        }

        public Generator addRecipient(byte[] recipientCertificateData) throws CMSException {
            Certificate recipientCertificate = Certificate.getInstance((Object)recipientCertificateData);
            CMSSignedAndEnvelopedData.checkRecipientCertificate(recipientCertificate);
            this.recipientCertificates.add(recipientCertificate);
            this.recipientPublicKeyDatas.add(CMSSignedAndEnvelopedData.getRecipientPublicKeyData(recipientCertificate));
            return this;
        }

        public Generator addRecipient(String recipientCertificateData) throws CMSException {
            return this.addRecipient(Base64.decode((String)recipientCertificateData));
        }

        public Generator addRelatedCertificate(byte[] certificateData) {
            this.relatedCertificates.add(Certificate.getInstance((Object)certificateData));
            return this;
        }

        public Generator addRelatedCertificate(String certificateData) {
            return this.addRelatedCertificate(Base64.decode((String)certificateData));
        }

        public CMSSignedAndEnvelopedData generate(byte[] content, Function<byte[], byte[]> signerFunction, BiFunction<byte[], byte[], byte[][]> cipherFunction) throws CMSException {
            byte[][] encryptedDatas;
            byte[] signatureData;
            if (this.recipientCertificates.isEmpty()) {
                throw new CMSException("There is no recipient");
            }
            if (this.recipientCertificates.size() > 1) {
                throw new CMSException("There are too many recipients");
            }
            if (this.signerCertificates.isEmpty()) {
                throw new CMSException("There is no signer");
            }
            if (this.signerCertificates.size() > 1) {
                throw new CMSException("There are too many signer");
            }
            try {
                signatureData = signerFunction.apply(this.signerPublicKeyDatas.get(0));
            }
            catch (Exception e) {
                throw new RuntimeException("Sign failed", e);
            }
            if (!SignatureUtils.sm2Verify(this.signerPublicKeyDatas.get(0), content, signatureData)) {
                throw new RuntimeException("Sign failed");
            }
            signatureData = ConversionUtils.SM2SignatureData.toGMT0009(signatureData);
            ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
            try {
                encryptedDatas = cipherFunction.apply(this.recipientPublicKeyDatas.get(0), signatureData);
            }
            catch (Exception e) {
                throw new RuntimeException("Encrypt and wrap failed", e);
            }
            try {
                encryptedDatas[0] = ConversionUtils.SM2CipherData.toGMT0009(encryptedDatas[0]);
            }
            catch (Exception e) {
                throw new CMSException("Invalid encrypted key data");
            }
            recipientInfos.add((ASN1Encodable)new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(new IssuerAndSerialNumber(this.recipientCertificates.get(0))), new AlgorithmIdentifier(GMObjectIdentifiers.sm2encrypt), (ASN1OctetString)new DEROctetString(encryptedDatas[0]))));
            ASN1EncodableVector digestAlgorithms = new ASN1EncodableVector();
            digestAlgorithms.add((ASN1Encodable)new AlgorithmIdentifier(GMObjectIdentifiers.sm3));
            if (null == encryptedDatas[1] || encryptedDatas[1].length < 1 || null == encryptedDatas[2] || encryptedDatas[2].length < 1 || encryptedDatas[2].length % encryptedDatas[1].length != 0) {
                throw new CMSException("Invalid encrypted content");
            }
            EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1"), new AlgorithmIdentifier(GMObjectIdentifiers.sms4_cbc, (ASN1Encodable)new DEROctetString(encryptedDatas[1])), (ASN1OctetString)new BEROctetString(encryptedDatas[2]));
            ASN1EncodableVector certificates = new ASN1EncodableVector();
            for (Certificate certificate : this.signerCertificates) {
                certificates.add((ASN1Encodable)certificate);
            }
            for (Certificate certificate : this.relatedCertificates) {
                certificates.add((ASN1Encodable)certificate);
            }
            ASN1EncodableVector signerInfos = new ASN1EncodableVector();
            if (null == encryptedDatas[3] || encryptedDatas[3].length < 1 || encryptedDatas[3].length % encryptedDatas[1].length != 0) {
                throw new CMSException("Invalid encrypted signature");
            }
            signerInfos.add((ASN1Encodable)new SignerInfo(new SignerIdentifier(new IssuerAndSerialNumber(this.signerCertificates.get(0))), new AlgorithmIdentifier(GMObjectIdentifiers.sm3), (ASN1Set)null, new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign), (ASN1OctetString)new DEROctetString(encryptedDatas[3]), (ASN1Set)null));
            return new CMSSignedAndEnvelopedData(new SignedAndEnvelopedData((ASN1Set)new DERSet(recipientInfos), (ASN1Set)new DERSet(digestAlgorithms), encryptedContentInfo, (ASN1Set)new BERSet(certificates), null, (ASN1Set)new DERSet(signerInfos)));
        }

        public CMSSignedAndEnvelopedData generate(byte[] content, BiFunction<Integer, byte[], byte[]> signerFunction, BiFunction<Integer, byte[], byte[]> wrapperFunction, Supplier<byte[][]> cipherFunction, Function<byte[], byte[]> signatureCipherFunction) throws CMSException {
            byte[][] encryptedDatas;
            if (this.recipientCertificates.isEmpty()) {
                throw new CMSException("There is no recipient");
            }
            if (this.signerCertificates.isEmpty()) {
                throw new CMSException("There is no signer");
            }
            ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
            for (int i = 0; i < this.recipientCertificates.size(); ++i) {
                byte[] encryptedKey;
                try {
                    encryptedKey = wrapperFunction.apply(i, this.recipientPublicKeyDatas.get(i));
                }
                catch (Exception e) {
                    throw new RuntimeException("Wrap failed", e);
                }
                try {
                    encryptedKey = ConversionUtils.SM2CipherData.toGMT0009(encryptedKey);
                }
                catch (Exception e) {
                    throw new CMSException("Invalid encrypted key data");
                }
                recipientInfos.add((ASN1Encodable)new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(new IssuerAndSerialNumber(this.recipientCertificates.get(i))), new AlgorithmIdentifier(GMObjectIdentifiers.sm2encrypt), (ASN1OctetString)new DEROctetString(encryptedKey))));
            }
            ASN1EncodableVector digestAlgorithms = new ASN1EncodableVector();
            digestAlgorithms.add((ASN1Encodable)new AlgorithmIdentifier(GMObjectIdentifiers.sm3));
            try {
                encryptedDatas = cipherFunction.get();
            }
            catch (Exception e) {
                throw new RuntimeException("Encrypt failed", e);
            }
            if (null == encryptedDatas[0] || encryptedDatas[0].length < 1 || null == encryptedDatas[1] || encryptedDatas[1].length < 1 || encryptedDatas[1].length % encryptedDatas[0].length != 0) {
                throw new CMSException("Invalid encrypted content");
            }
            EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1"), new AlgorithmIdentifier(GMObjectIdentifiers.sms4_cbc, (ASN1Encodable)new DEROctetString(encryptedDatas[0])), (ASN1OctetString)new BEROctetString(encryptedDatas[1]));
            ASN1EncodableVector certificates = new ASN1EncodableVector();
            for (Certificate certificate : this.signerCertificates) {
                certificates.add((ASN1Encodable)certificate);
            }
            for (Certificate certificate : this.relatedCertificates) {
                certificates.add((ASN1Encodable)certificate);
            }
            ASN1EncodableVector signerInfos = new ASN1EncodableVector();
            for (int i = 0; i < this.signerCertificates.size(); ++i) {
                byte[] encryptedSignatureData;
                byte[] signatureData;
                try {
                    signatureData = signerFunction.apply(i, this.signerPublicKeyDatas.get(i));
                }
                catch (Exception e) {
                    throw new RuntimeException("Sign failed", e);
                }
                if (!SignatureUtils.sm2Verify(this.signerPublicKeyDatas.get(i), content, signatureData)) {
                    throw new RuntimeException("Sign failed");
                }
                signatureData = ConversionUtils.SM2SignatureData.toGMT0009(signatureData);
                try {
                    encryptedSignatureData = signatureCipherFunction.apply(signatureData);
                }
                catch (Exception e) {
                    throw new RuntimeException("Encrypt signature failed", e);
                }
                if (null == encryptedSignatureData || encryptedSignatureData.length < 1 || encryptedSignatureData.length % encryptedDatas[0].length != 0) {
                    throw new CMSException("Invalid encrypted signature");
                }
                signerInfos.add((ASN1Encodable)new SignerInfo(new SignerIdentifier(new IssuerAndSerialNumber(this.signerCertificates.get(i))), new AlgorithmIdentifier(GMObjectIdentifiers.sm3), (ASN1Set)null, new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign), (ASN1OctetString)new DEROctetString(encryptedSignatureData), (ASN1Set)null));
            }
            return new CMSSignedAndEnvelopedData(new SignedAndEnvelopedData((ASN1Set)new DERSet(recipientInfos), (ASN1Set)new DERSet(digestAlgorithms), encryptedContentInfo, (ASN1Set)new BERSet(certificates), null, (ASN1Set)new DERSet(signerInfos)));
        }
    }
}

