/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.util.cert;

import cn.com.westone.wcspsdk.util.ConversionUtils;
import cn.com.westone.wcspsdk.util.SignatureUtils;
import cn.com.westone.wcspsdk.util.cert.CertificateException;
import cn.com.westone.wcspsdk.util.cert.X501DName;
import java.io.IOException;
import java.math.BigInteger;
import java.time.Instant;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.encoders.Base64;

public class X509Certificate {
    private final Certificate certificate;

    public static X509Certificate getInstance(byte[] certificateData) {
        Certificate certificate = Certificate.getInstance((Object)certificateData);
        if (!certificate.getSignatureAlgorithm().equals((Object)certificate.getTBSCertificate().getSignature())) {
            throw new IllegalArgumentException("Argument \"certificateData\" is illegal");
        }
        return new X509Certificate(Certificate.getInstance((Object)certificateData));
    }

    public static X509Certificate getInstance(String certificateData) {
        return X509Certificate.getInstance(Base64.decode((String)certificateData));
    }

    public int getVersion() {
        return this.certificate.getVersionNumber();
    }

    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber().getValue();
    }

    public String getIssuer() {
        return this.getIssuerDN().getAttributeValue(X501DName.AttrType.CN);
    }

    public X501DName getIssuerDN() {
        return new X501DName(this.certificate.getIssuer());
    }

    public Instant getNotBefore() {
        return this.certificate.getStartDate().getDate().toInstant();
    }

    public Instant getNotAfter() {
        return this.certificate.getEndDate().getDate().toInstant();
    }

    public String getSubject() {
        return this.getSubjectDN().getAttributeValue(X501DName.AttrType.CN);
    }

    public X501DName getSubjectDN() {
        return new X501DName(this.certificate.getSubject());
    }

    public byte[] getSubjectPublicKeyData() throws CertificateException {
        byte[] publicKeyData = this.certificate.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        AlgorithmIdentifier algorithmIdentifier = this.certificate.getSubjectPublicKeyInfo().getAlgorithm();
        if (algorithmIdentifier.getAlgorithm().equals((ASN1Primitive)X9ObjectIdentifiers.id_ecPublicKey) && (algorithmIdentifier.getParameters() instanceof ASN1ObjectIdentifier ? algorithmIdentifier.getParameters().equals(GMObjectIdentifiers.sm2p256v1) : algorithmIdentifier.getParameters().equals(new X962Parameters(GMNamedCurves.getByOID((ASN1ObjectIdentifier)GMObjectIdentifiers.sm2p256v1)))) && !ConversionUtils.SM2PublicKeyData.check(publicKeyData)) {
            throw new CertificateException("Invalid subject public key");
        }
        return publicKeyData;
    }

    public String getSigAlgName() {
        String algOID;
        switch (algOID = this.getSigAlgOID()) {
            case "1.2.156.10197.1.501": {
                return "SM3withSM2";
            }
            case "1.2.156.10197.1.504": {
                return "SM3withRSA";
            }
        }
        return algOID;
    }

    public String getSigAlgOID() {
        return this.certificate.getSignatureAlgorithm().getAlgorithm().getId();
    }

    public byte[] getSignature() throws CertificateException {
        byte[] signatureData = this.certificate.getSignature().getOctets();
        ASN1ObjectIdentifier algorithmOID = this.certificate.getSignatureAlgorithm().getAlgorithm();
        if (algorithmOID.equals((ASN1Primitive)GMObjectIdentifiers.sm2sign_with_sm3) || algorithmOID.equals((ASN1Primitive)GMObjectIdentifiers.sm2sign_with_sha512)) {
            try {
                signatureData = ConversionUtils.SM2SignatureData.fromGMT0009(signatureData);
            }
            catch (Exception e) {
                throw new CertificateException("Invalid signature");
            }
        }
        return signatureData;
    }

    public boolean checkValidity() {
        return this.checkValidity(Instant.now());
    }

    public boolean checkValidity(Instant date) {
        return date.isAfter(this.getNotBefore()) && date.isBefore(this.getNotAfter());
    }

    public boolean verify(byte[] issuerPublicKeyData) throws CertificateException {
        byte[] tbsCertificateData;
        if (!this.certificate.getSignatureAlgorithm().getAlgorithm().equals((ASN1Primitive)GMObjectIdentifiers.sm2sign_with_sm3)) {
            throw new CertificateException("Invalid signature algorithm");
        }
        try {
            tbsCertificateData = this.certificate.getTBSCertificate().getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        byte[] signatureData = ConversionUtils.SM2SignatureData.fromGMT0009(this.certificate.getSignature().getOctets());
        return SignatureUtils.sm2Verify(issuerPublicKeyData, tbsCertificateData, signatureData);
    }

    public byte[] getEncoded() {
        try {
            return this.certificate.getEncoded("DER");
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private X509Certificate(Certificate certificate) {
        this.certificate = certificate;
    }
}

