/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.util.cert;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public class X501DName {
    private final X500Name x500Name;

    public static X501DName getInstance(String name) {
        return new X501DName(new X500Name(BCStyle.INSTANCE, name));
    }

    public String getAttributeValue(AttrType type) {
        RDN[] rdns = this.x500Name.getRDNs(type.oid);
        if (null == rdns || rdns.length < 1) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (RDN rdn : rdns) {
            AttributeTypeAndValue[] attrs;
            for (AttributeTypeAndValue attr : attrs = rdn.getTypesAndValues()) {
                if (!attr.getType().equals((ASN1Primitive)type.oid)) continue;
                builder.append(IETFUtils.valueToString((ASN1Encodable)attr.getValue()));
                builder.append(',');
            }
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    public String toString() {
        return this.x500Name.toString();
    }

    X501DName(X500Name x500Name) {
        this.x500Name = x500Name;
    }

    X500Name x500Name() {
        return this.x500Name;
    }

    public static class Builder {
        private X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);

        public Builder addAttribute(AttrType type, String value) {
            this.x500NameBuilder.addRDN(type.oid, value);
            return this;
        }

        public X501DName build() {
            return new X501DName(this.x500NameBuilder.build());
        }
    }

    public static enum AttrType {
        C(BCStyle.C),
        O(BCStyle.O),
        OU(BCStyle.OU),
        CN(BCStyle.CN),
        L(BCStyle.L),
        ST(BCStyle.ST),
        STREET(BCStyle.STREET),
        E(BCStyle.E);

        private final ASN1ObjectIdentifier oid;

        public String toString() {
            return this.oid.getId();
        }

        private AttrType(ASN1ObjectIdentifier oid) {
            this.oid = oid;
        }
    }
}

