/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.util;

import cn.com.westone.wcspsdk.CryptoService;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.baseservice.co.Identifier;
import cn.com.westone.wcspsdk.baseservice.co.PublicKey;
import cn.com.westone.wcspsdk.util.ConversionUtils;

public final class KeyUtils {
    public static PublicKey createPublicKeySM2(String usage, byte[] publicKeyData) throws InvalidParameterException {
        if (null == usage || usage.isEmpty() || null == publicKeyData) {
            throw new IllegalArgumentException("Argument \"usage\" or \"publicKeyData\" is null");
        }
        switch (usage) {
            case "SIGN": 
            case "ENC": {
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid usage: " + usage);
            }
        }
        if (!ConversionUtils.SM2PublicKeyData.checkGMT0016(publicKeyData)) {
            throw new InvalidParameterException("Invalid publicKeyData");
        }
        return new PublicKeySM2(publicKeyData, usage);
    }

    public static PublicKey createPublicKeySM9(String usage, String identity) throws InvalidParameterException {
        if (null == usage || usage.isEmpty() || null == identity || identity.isEmpty()) {
            throw new IllegalArgumentException("Argument \"usage\" or \"identity\" is null");
        }
        switch (usage) {
            case "SIGN": 
            case "ENC": {
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid usage: " + usage);
            }
        }
        return new PublicKeySM9(identity, 0, usage);
    }

    public static PublicKey createPublicKeySM9(String usage, String identity, int version) throws InvalidParameterException {
        if (null == usage || usage.isEmpty() || null == identity || identity.isEmpty()) {
            throw new IllegalArgumentException("Argument \"usage\" or \"identity\" is null");
        }
        if (version < 1) {
            throw new IllegalArgumentException("Argument \"version\" is illegal");
        }
        switch (usage) {
            case "SIGN": 
            case "ENC": {
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid usage: " + usage);
            }
        }
        return new PublicKeySM9(identity, version, usage);
    }

    private KeyUtils() {
    }

    private static final class PublicKeySM9
    implements Identifier,
    PublicKey {
        private final String identity;
        private final int version;
        private final String usage;

        @Override
        public String identity() {
            return this.identity;
        }

        @Override
        public int version() {
            return this.version;
        }

        @Override
        public byte[] getKeyData() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public byte[] getEncoded() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String type() {
            return "Identifier";
        }

        @Override
        public String usage() {
            return this.usage;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int length() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String algorithm() {
            return "SM9";
        }

        @Override
        public CryptoService service() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }

        private PublicKeySM9(String identity, int version, String usage) {
            this.identity = identity;
            this.version = version;
            this.usage = usage;
        }
    }

    private static final class PublicKeySM2
    implements PublicKey {
        private final byte[] keyData;
        private final String usage;

        @Override
        public byte[] getKeyData() {
            return this.keyData;
        }

        @Override
        @Deprecated
        public byte[] getEncoded() {
            return this.keyData;
        }

        @Override
        public String type() {
            return "PublicKey";
        }

        @Override
        public String usage() {
            return this.usage;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int length() {
            return 132;
        }

        @Override
        public String algorithm() {
            return "SM2";
        }

        @Override
        public CryptoService service() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }

        private PublicKeySM2(byte[] keyData, String usage) {
            this.keyData = (byte[])keyData.clone();
            this.usage = usage;
        }
    }
}

