/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.util;

import cn.com.westone.wcspsdk.impl.base.Utils;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;

public final class ConversionUtils {
    private static int checkDERTag(int tag, byte[] buf, int[] pOffset) {
        int length;
        int offset = pOffset[0];
        if (tag != buf[offset++]) {
            return 0;
        }
        if ((length = buf[offset++] & 0xFF) > 127) {
            int size = length & 0x7F;
            if (size < 1 || size > 4 || 4 == size && buf[offset] < 0) {
                return 0;
            }
            length = 0;
            for (int i = 0; i < size; ++i) {
                length = (length << 8) + (buf[offset++] & 0xFF);
            }
        }
        if (pOffset[0] + (length = offset - pOffset[0] + length) > buf.length) {
            return 0;
        }
        pOffset[0] = offset;
        return length;
    }

    private static boolean checkDERElement(int tag, byte[] buf, int[] pOffset) {
        int length;
        int offset = pOffset[0];
        if (tag != buf[offset++]) {
            return false;
        }
        if ((length = buf[offset++] & 0xFF) > 127) {
            int size = length & 0x7F;
            if (size < 1 || size > 4 || 4 == size && buf[offset] < 0) {
                return false;
            }
            length = 0;
            for (int i = 0; i < size; ++i) {
                length = (length << 8) + (buf[offset++] & 0xFF);
            }
        }
        if (pOffset[0] + (length = offset - pOffset[0] + length) > buf.length) {
            return false;
        }
        pOffset[0] = pOffset[0] + length;
        return true;
    }

    private ConversionUtils() {
    }

    public static final class CSRData {
        public static void toPEM(byte[] csrData, Writer writer) throws IOException {
            PemWriter pemWriter = new PemWriter(writer);
            pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE REQUEST", csrData));
            pemWriter.flush();
        }

        public static byte[] fromPEM(Reader reader) throws IOException {
            PemReader pemReader = new PemReader(reader);
            PemObject pemObject = pemReader.readPemObject();
            if (null == pemObject) {
                throw new IOException("Invalid PEM reader");
            }
            if (!pemObject.getType().equals("CERTIFICATE REQUEST")) {
                throw new IOException("Invalid PEM object type");
            }
            return pemObject.getContent();
        }

        private CSRData() {
        }
    }

    public static final class CertData {
        public static void toPEM(byte[] certData, Writer writer) throws IOException {
            PemWriter pemWriter = new PemWriter(writer);
            pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", certData));
            pemWriter.flush();
        }

        public static byte[] fromPEM(Reader reader) throws IOException {
            PemReader pemReader = new PemReader(reader);
            PemObject pemObject = pemReader.readPemObject();
            if (null == pemObject) {
                throw new IOException("Invalid PEM reader");
            }
            if (!pemObject.getType().equals("CERTIFICATE")) {
                throw new IOException("Invalid PEM object type");
            }
            return pemObject.getContent();
        }

        private CertData() {
        }
    }

    public static final class SM2EnvelopedKeyPairData {
        public static boolean check(byte[] envelopedKeyPairData) {
            throw new UnsupportedOperationException();
        }

        public static boolean checkGMT0009(byte[] envelopedKeyPairDataGMT0009) {
            throw new UnsupportedOperationException();
        }

        public static byte[] toGMT0009(byte[] envelopedKeyPairData) {
            throw new UnsupportedOperationException();
        }

        public static byte[] fromGMT0009(byte[] envelopedKeyPairDataGMT0009) {
            throw new UnsupportedOperationException();
        }

        public static boolean checkGMT0016(byte[] envelopedKeyPairDataGMT0016) {
            throw new UnsupportedOperationException();
        }

        public static byte[] toGMT0016(byte[] envelopedKeyPairData) {
            throw new UnsupportedOperationException();
        }

        public static byte[] fromGMT0016(byte[] envelopedKeyPairDataGMT0016) {
            throw new UnsupportedOperationException();
        }

        public static boolean checkGMT0018(byte[] envelopedKeyPairDataGMT0018) {
            throw new UnsupportedOperationException();
        }

        public static byte[] toGMT0018(byte[] envelopedKeyPairData) {
            throw new UnsupportedOperationException();
        }

        public static byte[] fromGMT0018(byte[] envelopedKeyPairDataGMT0018) {
            throw new UnsupportedOperationException();
        }

        private SM2EnvelopedKeyPairData() {
        }
    }

    public static final class SM2SignatureData {
        public static boolean check(byte[] signatureData) {
            return 64 == signatureData.length;
        }

        public static boolean checkGMT0009(byte[] signatureDataGMT0009) {
            int[] pOffset = new int[]{0};
            int length = ConversionUtils.checkDERTag(48, signatureDataGMT0009, pOffset);
            if (length < 2 || signatureDataGMT0009.length != length) {
                return false;
            }
            if (!ConversionUtils.checkDERElement(2, signatureDataGMT0009, pOffset)) {
                return false;
            }
            return ConversionUtils.checkDERElement(2, signatureDataGMT0009, pOffset) && signatureDataGMT0009.length == pOffset[0];
        }

        public static byte[] toGMT0009(byte[] signatureData) {
            if (!SM2SignatureData.check(signatureData)) {
                throw new IllegalArgumentException("Argument \"signatureData\" is illegal");
            }
            ASN1EncodableVector vector = new ASN1EncodableVector(2);
            BigInteger n = GMNamedCurves.getByOID((ASN1ObjectIdentifier)GMObjectIdentifiers.sm2p256v1).getN();
            BigInteger r = new BigInteger(1, Arrays.copyOfRange(signatureData, 0, 32));
            if (r.compareTo(n) >= 0) {
                throw new IllegalArgumentException("Illegal signature R value");
            }
            vector.add((ASN1Encodable)new ASN1Integer(r));
            BigInteger s = new BigInteger(1, Arrays.copyOfRange(signatureData, 32, 64));
            if (s.compareTo(n) >= 0) {
                throw new IllegalArgumentException("Illegal signature S value");
            }
            vector.add((ASN1Encodable)new ASN1Integer(s));
            try {
                return new DERSequence(vector).getEncoded("DER");
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
        }

        public static byte[] fromGMT0009(byte[] signatureDataGMT0009) {
            if (!SM2SignatureData.checkGMT0009(signatureDataGMT0009)) {
                throw new IllegalArgumentException("Argument \"signatureDataGMT0009\" is illegal");
            }
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)signatureDataGMT0009);
            if (2 != sequence.size()) {
                throw new IllegalArgumentException("Malformed signature");
            }
            BigInteger n = GMNamedCurves.getByOID((ASN1ObjectIdentifier)GMObjectIdentifiers.sm2p256v1).getN();
            byte[] signatureData = new byte[64];
            BigInteger r = ASN1Integer.getInstance((Object)sequence.getObjectAt(0)).getValue();
            if (r.compareTo(n) >= 0) {
                throw new IllegalArgumentException("Illegal signature R value");
            }
            byte[] rData = r.toByteArray();
            if (rData.length > 0 && rData.length < 33) {
                System.arraycopy(rData, 0, signatureData, 32 - rData.length, rData.length);
            } else if (rData.length > 32 && Utils.arrayEquals(rData, 0, rData.length - 32, (byte)0)) {
                System.arraycopy(rData, rData.length - 32, signatureData, 0, 32);
            } else {
                throw new IllegalArgumentException("Illegal signature R");
            }
            BigInteger s = ASN1Integer.getInstance((Object)sequence.getObjectAt(1)).getValue();
            if (s.compareTo(n) >= 0) {
                throw new IllegalArgumentException("Illegal signature S value");
            }
            byte[] sData = s.toByteArray();
            if (sData.length > 0 && sData.length < 33) {
                System.arraycopy(sData, 0, signatureData, 64 - sData.length, sData.length);
            } else if (sData.length > 32 && Utils.arrayEquals(sData, 0, sData.length - 32, (byte)0)) {
                System.arraycopy(sData, sData.length - 32, signatureData, 32, 32);
            } else {
                throw new IllegalArgumentException("Illegal signature S");
            }
            return signatureData;
        }

        public static boolean checkGMT0016(byte[] signatureDataGMT0016) {
            return 128 == signatureDataGMT0016.length && Utils.arrayEquals(signatureDataGMT0016, 0, 32, (byte)0) && Utils.arrayEquals(signatureDataGMT0016, 64, 32, (byte)0);
        }

        public static byte[] toGMT0016(byte[] signatureData) {
            if (!SM2SignatureData.check(signatureData)) {
                throw new IllegalArgumentException("Argument \"signatureData\" is illegal");
            }
            byte[] signatureDataGMT0016 = new byte[128];
            System.arraycopy(signatureData, 0, signatureDataGMT0016, 32, 32);
            System.arraycopy(signatureData, 32, signatureDataGMT0016, 96, 32);
            return signatureDataGMT0016;
        }

        public static byte[] fromGMT0016(byte[] signatureDataGMT0016) {
            if (!SM2SignatureData.checkGMT0016(signatureDataGMT0016)) {
                throw new IllegalArgumentException("Argument \"signatureDataGMT0016\" is illegal");
            }
            byte[] signatureData = new byte[64];
            System.arraycopy(signatureDataGMT0016, 32, signatureData, 0, 32);
            System.arraycopy(signatureDataGMT0016, 96, signatureData, 32, 32);
            return signatureData;
        }

        public static boolean checkGMT0018(byte[] signatureDataGMT0018) {
            return SM2SignatureData.checkGMT0016(signatureDataGMT0018);
        }

        public static byte[] toGMT0018(byte[] signatureData) {
            return SM2SignatureData.toGMT0016(signatureData);
        }

        public static byte[] fromGMT0018(byte[] signatureDataGMT0018) {
            return SM2SignatureData.fromGMT0016(signatureDataGMT0018);
        }

        private SM2SignatureData() {
        }
    }

    public static final class SM2CipherData {
        public static boolean check(byte[] cipherData) {
            switch (cipherData[0]) {
                case 4: {
                    return cipherData.length - 1 - 32 - 32 - 32 >= 1;
                }
                default: {
                    return false;
                }
            }
        }

        public static boolean checkGMT0009(byte[] cipherDataGMT0009) {
            int[] pOffset = new int[]{0};
            int length = ConversionUtils.checkDERTag(48, cipherDataGMT0009, pOffset);
            if (length < 2 || cipherDataGMT0009.length != length) {
                return false;
            }
            if (!ConversionUtils.checkDERElement(2, cipherDataGMT0009, pOffset)) {
                return false;
            }
            if (!ConversionUtils.checkDERElement(2, cipherDataGMT0009, pOffset)) {
                return false;
            }
            if (!ConversionUtils.checkDERElement(4, cipherDataGMT0009, pOffset)) {
                return false;
            }
            return ConversionUtils.checkDERElement(4, cipherDataGMT0009, pOffset) && cipherDataGMT0009.length == pOffset[0];
        }

        public static byte[] toGMT0009(byte[] cipherData) {
            if (!SM2CipherData.check(cipherData)) {
                throw new IllegalArgumentException("Argument \"cipherData\" is illegal");
            }
            ASN1EncodableVector vector = new ASN1EncodableVector(4);
            vector.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, Arrays.copyOfRange(cipherData, 1, 33))));
            vector.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, Arrays.copyOfRange(cipherData, 33, 65))));
            vector.add((ASN1Encodable)new DEROctetString(Arrays.copyOfRange(cipherData, 65, 97)));
            vector.add((ASN1Encodable)new DEROctetString(Arrays.copyOfRange(cipherData, 97, cipherData.length)));
            try {
                return new DERSequence(vector).getEncoded("DER");
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
        }

        public static byte[] fromGMT0009(byte[] cipherDataGMT0009) {
            if (!SM2CipherData.checkGMT0009(cipherDataGMT0009)) {
                throw new IllegalArgumentException("Argument \"cipherDataGMT0009\" is illegal");
            }
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)cipherDataGMT0009);
            if (4 != sequence.size()) {
                throw new IllegalArgumentException("Malformed cipher");
            }
            byte[] data = DEROctetString.getInstance((Object)sequence.getObjectAt(3)).getOctets();
            if (data.length < 1) {
                throw new IllegalArgumentException("Illegal cipher CipherText");
            }
            byte[] cipherData = new byte[97 + data.length];
            cipherData[0] = 4;
            System.arraycopy(data, 0, cipherData, 97, data.length);
            data = ASN1Integer.getInstance((Object)sequence.getObjectAt(0)).getValue().toByteArray();
            if (data.length > 0 && data.length < 33) {
                System.arraycopy(data, 0, cipherData, 33 - data.length, data.length);
            } else if (data.length > 32 && Utils.arrayEquals(data, 0, data.length - 32, (byte)0)) {
                System.arraycopy(data, data.length - 32, cipherData, 1, 32);
            } else {
                throw new IllegalArgumentException("Illegal cipher X");
            }
            data = ASN1Integer.getInstance((Object)sequence.getObjectAt(1)).getValue().toByteArray();
            if (data.length > 0 && data.length < 33) {
                System.arraycopy(data, 0, cipherData, 65 - data.length, data.length);
            } else if (data.length > 32 && Utils.arrayEquals(data, 0, data.length - 32, (byte)0)) {
                System.arraycopy(data, data.length - 32, cipherData, 33, 32);
            } else {
                throw new IllegalArgumentException("Illegal cipher Y");
            }
            data = DEROctetString.getInstance((Object)sequence.getObjectAt(2)).getOctets();
            if (32 != data.length) {
                throw new IllegalArgumentException("Illegal cipher HASH");
            }
            System.arraycopy(data, 0, cipherData, 65, 32);
            return cipherData;
        }

        public static boolean checkGMT0016(byte[] cipherDataGMT0016) {
            int dataLength = cipherDataGMT0016.length - 64 - 64 - 32 - 4;
            return dataLength >= 1 && Utils.arrayEquals(cipherDataGMT0016, 0, 32, (byte)0) && Utils.arrayEquals(cipherDataGMT0016, 64, 32, (byte)0) && (Utils.byteArrayToIntB(cipherDataGMT0016, 160) == dataLength || Utils.byteArrayToIntL(cipherDataGMT0016, 160) == dataLength);
        }

        public static byte[] toGMT0016(byte[] cipherData) {
            if (!SM2CipherData.check(cipherData)) {
                throw new IllegalArgumentException("Argument \"cipherData\" is illegal");
            }
            int dataLength = cipherData.length - 1 - 32 - 32 - 32;
            byte[] cipherDataGMT0016 = new byte[164 + dataLength];
            System.arraycopy(cipherData, 1, cipherDataGMT0016, 32, 32);
            System.arraycopy(cipherData, 33, cipherDataGMT0016, 96, 32);
            System.arraycopy(cipherData, 65, cipherDataGMT0016, 128, 32);
            System.arraycopy(Utils.intToByteArrayL(dataLength), 0, cipherDataGMT0016, 160, 4);
            System.arraycopy(cipherData, 97, cipherDataGMT0016, 164, dataLength);
            return cipherDataGMT0016;
        }

        public static byte[] fromGMT0016(byte[] cipherDataGMT0016) {
            if (!SM2CipherData.checkGMT0016(cipherDataGMT0016)) {
                throw new IllegalArgumentException("Argument \"cipherDataGMT0016\" is illegal");
            }
            int dataLength = cipherDataGMT0016.length - 64 - 64 - 32 - 4;
            byte[] cipherData = new byte[97 + dataLength];
            cipherData[0] = 4;
            System.arraycopy(cipherDataGMT0016, 32, cipherData, 1, 32);
            System.arraycopy(cipherDataGMT0016, 96, cipherData, 33, 32);
            System.arraycopy(cipherDataGMT0016, 128, cipherData, 65, 32);
            System.arraycopy(cipherDataGMT0016, 164, cipherData, 97, dataLength);
            return cipherData;
        }

        public static boolean checkGMT0018(byte[] cipherDataGMT0018) {
            return SM2CipherData.checkGMT0016(cipherDataGMT0018);
        }

        public static byte[] toGMT0018(byte[] cipherData) {
            return SM2CipherData.toGMT0016(cipherData);
        }

        public static byte[] fromGMT0018(byte[] cipherDataGMT0018) {
            return SM2CipherData.fromGMT0016(cipherDataGMT0018);
        }

        private SM2CipherData() {
        }
    }

    public static final class SM2PublicKeyData {
        public static boolean check(byte[] publicKeyData) {
            switch (publicKeyData[0]) {
                case 4: {
                    return 65 == publicKeyData.length;
                }
                default: {
                    return false;
                }
            }
        }

        public static boolean checkGMT0009(byte[] publicKeyDataGMT0009) {
            int[] pOffset = new int[]{0};
            return ConversionUtils.checkDERElement(3, publicKeyDataGMT0009, pOffset);
        }

        public static byte[] toGMT0009(byte[] publicKeyData) {
            if (!SM2PublicKeyData.check(publicKeyData)) {
                throw new IllegalArgumentException("Argument \"publicKeyData\" is illegal");
            }
            try {
                return new DERBitString(publicKeyData).getEncoded("DER");
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
        }

        public static byte[] fromGMT0009(byte[] publicKeyDataGMT0009) {
            if (!SM2PublicKeyData.checkGMT0009(publicKeyDataGMT0009)) {
                throw new IllegalArgumentException("Argument \"publicKeyDataGMT0009\" is illegal");
            }
            byte[] publicKeyData = DERBitString.getInstance((Object)publicKeyDataGMT0009).getOctets();
            if (!SM2PublicKeyData.check(publicKeyData)) {
                throw new IllegalArgumentException("Illegal public key");
            }
            return publicKeyData;
        }

        public static boolean checkGMT0016(byte[] publicKeyDataGMT0016) {
            return 132 == publicKeyDataGMT0016.length && (Utils.byteArrayToIntB(publicKeyDataGMT0016) == 256 || Utils.byteArrayToIntL(publicKeyDataGMT0016) == 256) && Utils.arrayEquals(publicKeyDataGMT0016, 4, 32, (byte)0) && Utils.arrayEquals(publicKeyDataGMT0016, 68, 32, (byte)0);
        }

        public static byte[] toGMT0016(byte[] publicKeyData) {
            if (!SM2PublicKeyData.check(publicKeyData)) {
                throw new IllegalArgumentException("Argument \"publicKeyData\" is illegal");
            }
            byte[] publicKeyDataGMT0016 = new byte[132];
            System.arraycopy(Utils.intToByteArrayL(256), 0, publicKeyDataGMT0016, 0, 4);
            System.arraycopy(publicKeyData, 1, publicKeyDataGMT0016, 36, 32);
            System.arraycopy(publicKeyData, 33, publicKeyDataGMT0016, 100, 32);
            return publicKeyDataGMT0016;
        }

        public static byte[] fromGMT0016(byte[] publicKeyDataGMT0016) {
            if (!SM2PublicKeyData.checkGMT0016(publicKeyDataGMT0016)) {
                throw new IllegalArgumentException("Argument \"publicKeyDataGMT0016\" is illegal");
            }
            byte[] publicKeyData = new byte[65];
            publicKeyData[0] = 4;
            System.arraycopy(publicKeyDataGMT0016, 36, publicKeyData, 1, 32);
            System.arraycopy(publicKeyDataGMT0016, 100, publicKeyData, 33, 32);
            return publicKeyData;
        }

        public static boolean checkGMT0018(byte[] publicKeyDataGMT0018) {
            return SM2PublicKeyData.checkGMT0016(publicKeyDataGMT0018);
        }

        public static byte[] toGMT0018(byte[] publicKeyData) {
            return SM2PublicKeyData.toGMT0016(publicKeyData);
        }

        public static byte[] fromGMT0018(byte[] publicKeyDataGMT0018) {
            return SM2PublicKeyData.fromGMT0016(publicKeyDataGMT0018);
        }

        private SM2PublicKeyData() {
        }
    }

    public static final class Data {
        public static String toBase64String(byte[] data) {
            return Base64.toBase64String((byte[])data);
        }

        public static byte[] fromBase64String(String data) {
            return Base64.decode((String)data);
        }

        public static String toHexString(byte[] data) {
            return Hex.toHexString((byte[])data);
        }

        public static byte[] fromHexString(String data) {
            return Hex.decode((String)data);
        }

        public static String toUTF8String(byte[] data) {
            return new String(data, StandardCharsets.UTF_8);
        }

        public static byte[] fromUTF8String(String data) {
            return data.getBytes(StandardCharsets.UTF_8);
        }

        private Data() {
        }
    }
}

