/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.typicalservice;

import cn.com.westone.wcspsdk.AuthAppUserParameterSpec;
import cn.com.westone.wcspsdk.AuthSecretParameterSpec;
import cn.com.westone.wcspsdk.CryptoService;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.MacImpl;
import cn.com.westone.wcspsdk.impl.co.ShortDataMacImpl;
import cn.com.westone.wcspsdk.impl.km.KMSecretKeyImpl;
import cn.com.westone.wcspsdk.impl.km.KMServiceImpl;
import cn.com.westone.wcspsdk.util.ConversionUtils;
import java.util.Map;

public class RecordSecurityService
implements CryptoService {
    public static final String SERVICE_TYPE_RECORDSECURITY = "RecordSecurity";
    private static final String TEMPLATE_LOG_PROTECT_KEY = "TEMPLATE_LOG_PROTECT_KEY";
    private KMServiceImpl kmService = null;
    private COServiceImpl coService = null;
    private final PlatformImpl platform;
    private String keyId;

    public static RecordSecurityService getInstance(CryptoServicePlatform platform) throws WCSPException {
        return RecordSecurityService.getInstance(platform, null);
    }

    public static RecordSecurityService getInstance(CryptoServicePlatform platform, String keyId) throws WCSPException {
        if (platform instanceof PlatformImpl) {
            RecordSecurityService service = new RecordSecurityService((PlatformImpl)platform, keyId);
            service.init(new Object[0]);
            return service;
        }
        throw new UnsupportedOperationException("Unsupport CryptoServicePlatform");
    }

    public static RecordSecurityService getInstance(String tenantId, String appId, Map<String, Object> params, String secret) throws InvalidParameterException, WCSPException {
        return RecordSecurityService.getInstance(tenantId, appId, params, secret, null);
    }

    public static RecordSecurityService getInstance(String tenantId, String appId, Map<String, Object> params, String secret, String keyId) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthSecretParameterSpec.Builder().setSecret(secret).build());
        RecordSecurityService service = new RecordSecurityService(platform, keyId);
        service.init(new Object[0]);
        return service;
    }

    public static RecordSecurityService getInstance(String tenantId, String appId, Map<String, Object> params, String userId, String authCode, String keyId) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthAppUserParameterSpec.Builder().setAuthCode(userId, authCode).build());
        RecordSecurityService service = new RecordSecurityService(platform, keyId);
        service.init(new Object[0]);
        return service;
    }

    @Override
    public void init(Object ... args) throws WCSPException {
        if (null == this.kmService) {
            this.kmService = KMServiceImpl.getInstance(this.platform);
            this.kmService.init(new Object[0]);
            if (null == this.keyId || this.keyId.isEmpty()) {
                KMSecretKeyImpl[] kmSecretKeys = this.kmService.getSecretKeyList(TEMPLATE_LOG_PROTECT_KEY, 1);
                if (null == kmSecretKeys || kmSecretKeys.length == 0) {
                    throw new WCSPException("kmSecretKey is null");
                }
                this.keyId = kmSecretKeys[0].keyId();
            }
        }
        if (null == this.coService) {
            if (this.platform.isServerSDK()) {
                try {
                    this.coService = COServiceImpl.getInstance("CO-REMOTE", this.platform);
                }
                catch (InvalidParameterException e) {
                    throw new RuntimeException("Unexpected exception", e);
                }
                this.coService.init(new Object[0]);
            } else {
                this.coService = COServiceImpl.getInstance(this.platform);
                this.coService.init(new Object[0]);
                this.coService.verifyPIN("123456");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String calculateMAC(String ... fields) throws WCSPException {
        String string;
        if (null == fields) throw new IllegalArgumentException("Argument \"fields\" is null");
        if (fields.length == 0) {
            throw new IllegalArgumentException("Argument \"fields\" is null");
        }
        KMSecretKeyImpl kmSecretKey = this.kmService.getSecretKey(this.keyId);
        byte[] iv = new byte[16];
        StringBuilder sb = new StringBuilder();
        for (String field : fields) {
            sb.append(field);
        }
        byte[] fieldsArray = ConversionUtils.Data.fromUTF8String(sb.toString());
        if (fieldsArray.length > 1023) {
            try (MacImpl mac = this.coService.getCBCMac(kmSecretKey, iv, "PKCS7Padding");){
                string = ConversionUtils.Data.toBase64String(mac.doFinal(fieldsArray));
                return string;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        try (ShortDataMacImpl shortDataMac = this.coService.getShortDataCBCMac(kmSecretKey, iv, "PKCS7Padding");){
            string = ConversionUtils.Data.toBase64String(shortDataMac.mac(fieldsArray));
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean verifyMAC(String macData, String ... fields) throws WCSPException {
        String cbcMac = this.calculateMAC(fields);
        return macData.equals(cbcMac);
    }

    public String keyId() {
        return this.keyId;
    }

    @Override
    public String type() {
        return SERVICE_TYPE_RECORDSECURITY;
    }

    @Override
    public CryptoServicePlatform platform() {
        return this.platform;
    }

    private RecordSecurityService(PlatformImpl platform, String keyId) {
        this.platform = platform;
        this.keyId = keyId;
    }
}

