/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.typicalservice;

import cn.com.westone.wcspsdk.AuthSecretParameterSpec;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.ServiceImpl;
import cn.com.westone.wcspsdk.impl.base.WCSPKE;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class KeyEscrowService
extends ServiceImpl {
    public static final String SERVICE_TYPE_KEYESCROW = "KeyEscrow";

    public static KeyEscrowService getInstance(CryptoServicePlatform platform) throws WCSPException {
        if (null == platform) {
            throw new IllegalArgumentException("Argument \"platform\" is null");
        }
        if (platform instanceof PlatformImpl) {
            KeyEscrowService service = new KeyEscrowService((PlatformImpl)platform);
            service.init(new Object[0]);
            return service;
        }
        throw new UnsupportedOperationException("Unsupport CryptoServicePlatform");
    }

    public static KeyEscrowService getInstance(String tenantId, String appId, Map<String, Object> params, String secret) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthSecretParameterSpec.Builder().setSecret(secret).build());
        KeyEscrowService service = new KeyEscrowService(platform);
        service.init(new Object[0]);
        return service;
    }

    @Override
    public void init(Object ... args) {
    }

    public KeyPairHolder requestSignKeyPair(String pin) throws WCSPException {
        if (null == pin || pin.isEmpty()) {
            throw new IllegalArgumentException("Argument \"pin\" is null");
        }
        String[] pKeyId = new String[1];
        byte[][] pPublicKeyData = new byte[][]{null};
        WCSPKE.WCSP_KE_RequestSignKeyPair(this.handle(), pin, pKeyId, pPublicKeyData);
        return new KeyPairHolder(pKeyId[0], pPublicKeyData[0], null);
    }

    public KeyPairHolder requestSignKeyPair(String pin, String subjectDN, String attributes) throws WCSPException {
        if (null == pin || pin.isEmpty() || null == subjectDN || subjectDN.isEmpty()) {
            throw new IllegalArgumentException("Argument \"pin\" or \"subjectDN\" is null");
        }
        if (null == attributes) {
            attributes = "";
        }
        String[] pKeyId = new String[1];
        byte[][] pPublicKeyData = new byte[][]{null};
        byte[][] pCSRData = new byte[][]{null};
        WCSPKE.WCSP_KE_RequestSignKeyPairWithP10(this.handle(), pin, subjectDN, attributes, pKeyId, pPublicKeyData, pCSRData);
        return new KeyPairHolder(pKeyId[0], pPublicKeyData[0], pCSRData[0]);
    }

    public KeyPairHolder requestSignKeyPairByLabel(String label, String pin) throws WCSPException {
        if (null == label || label.isEmpty() || null == pin || pin.isEmpty()) {
            throw new IllegalArgumentException("Argument \"label\" or \"pin\" is null");
        }
        String[] pKeyId = new String[1];
        byte[][] pPublicKeyData = new byte[][]{null};
        WCSPKE.WCSP_KE_RequestSignKeyPairByKeyLabel(this.handle(), label, pin, pKeyId, pPublicKeyData);
        return new KeyPairHolder(pKeyId[0], pPublicKeyData[0], null);
    }

    public KeyPairHolder requestSignKeyPairByLabel(String label, String pin, String subjectDN, String attributes) throws WCSPException {
        if (null == label || label.isEmpty() || null == pin || pin.isEmpty() || null == subjectDN || subjectDN.isEmpty()) {
            throw new IllegalArgumentException("Argument \"label\" or \"pin\" or \"subjectDN\" is null");
        }
        if (null == attributes) {
            attributes = "";
        }
        String[] pKeyId = new String[1];
        byte[][] pPublicKeyData = new byte[][]{null};
        byte[][] pCSRData = new byte[][]{null};
        WCSPKE.WCSP_KE_RequestSignKeyPairWithP10ByKeyLabel(this.handle(), label, pin, subjectDN, attributes, pKeyId, pPublicKeyData, pCSRData);
        return new KeyPairHolder(pKeyId[0], pPublicKeyData[0], pCSRData[0]);
    }

    public void modifyPIN(String keyId, String oldPIN, String newPIN) throws WCSPException {
        if (null == keyId || keyId.isEmpty() || null == oldPIN || oldPIN.isEmpty() || null == newPIN || newPIN.isEmpty()) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"oldPIN\" or \"newPIN\" is null");
        }
        WCSPKE.WCSP_KE_ModifyPin(this.handle(), keyId, oldPIN, newPIN);
    }

    public void modifyPINByLabel(String label, String oldPIN, String newPIN) throws WCSPException {
        if (null == label || label.isEmpty() || null == oldPIN || oldPIN.isEmpty() || null == newPIN || newPIN.isEmpty()) {
            throw new IllegalArgumentException("Argument \"label\" or \"oldPIN\" or \"newPIN\" is null");
        }
        WCSPKE.WCSP_KE_ModifyPinByKeyLabel(this.handle(), label, oldPIN, newPIN);
    }

    public void uploadSignCert(String keyId, byte[] signCertData) throws WCSPException {
        if (keyId == null || keyId.isEmpty() || null == signCertData || signCertData.length < 1) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"signCertData\" is null");
        }
        WCSPKE.WCSP_KE_UploadCert(this.handle(), keyId, signCertData);
    }

    public void uploadSignCertByLabel(String label, byte[] signCertData) throws WCSPException {
        if (label == null || label.isEmpty() || null == signCertData || signCertData.length < 1) {
            throw new IllegalArgumentException("Argument \"label\" or \"signCertData\" is null");
        }
        WCSPKE.WCSP_KE_UploadCertByKeyLabel(this.handle(), label, signCertData);
    }

    public void uploadSignAndEncCert(String keyId, String pin, byte[] signCertData, byte[] encCertData, byte[] envelopedEncKeyPairData) throws WCSPException {
        if (keyId == null || keyId.isEmpty() || pin == null || pin.isEmpty() || null == signCertData || signCertData.length < 1 || null == encCertData || encCertData.length < 1 || null == envelopedEncKeyPairData || envelopedEncKeyPairData.length < 1) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"pin\" or \"signCertData\" or \"encCertData\" or \"envelopedEncKeyPairData\" is null");
        }
        WCSPKE.WCSP_KE_UploadSignAndEncCert(this.handle(), keyId, pin, signCertData, encCertData, envelopedEncKeyPairData);
    }

    public void uploadSignAndEncCertByLabel(String label, String pin, byte[] signCertData, byte[] encCertData, byte[] envelopedEncKeyPairData) throws WCSPException {
        if (label == null || label.isEmpty() || pin == null || pin.isEmpty() || null == signCertData || signCertData.length < 1 || null == encCertData || encCertData.length < 1 || null == envelopedEncKeyPairData || envelopedEncKeyPairData.length < 1) {
            throw new IllegalArgumentException("Argument \"label\" or \"pin\" or \"signCertData\" or \"encCertData\" or \"envelopedEncKeyPairData\" is null");
        }
        WCSPKE.WCSP_KE_UploadSignAndEncCertByKeyLabel(this.handle(), label, pin, signCertData, encCertData, envelopedEncKeyPairData);
    }

    public byte[] sign(String keyId, String pin, byte[] data) throws WCSPException {
        if (keyId == null || keyId.isEmpty() || pin == null || pin.isEmpty() || null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"pin\" or \"data\" is null");
        }
        byte[][] pSignatureData = new byte[][]{new byte[0]};
        WCSPKE.WCSP_KE_Sign(this.handle(), keyId, pin, data, pSignatureData);
        return pSignatureData[0];
    }

    public byte[] signByLabel(String label, String pin, byte[] data) throws WCSPException {
        if (label == null || label.isEmpty() || pin == null || pin.isEmpty() || null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"label\" or \"pin\" or \"data\" is null");
        }
        byte[][] pSignatureData = new byte[][]{new byte[0]};
        WCSPKE.WCSP_KE_SignByKeyLabel(this.handle(), label, pin, data, pSignatureData);
        return pSignatureData[0];
    }

    public byte[] signDigest(String keyId, String pin, byte[] digestData) throws WCSPException {
        if (keyId == null || keyId.isEmpty() || pin == null || pin.isEmpty() || null == digestData || digestData.length < 1) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"pin\" or \"digestData\" is null");
        }
        byte[][] pSignatureData = new byte[][]{new byte[0]};
        WCSPKE.WCSP_KE_SignDigest(this.handle(), keyId, pin, digestData, pSignatureData);
        return pSignatureData[0];
    }

    public byte[] signDigestByLabel(String label, String pin, byte[] digestData) throws WCSPException {
        if (label == null || label.isEmpty() || null == digestData || digestData.length < 1) {
            throw new IllegalArgumentException("Argument \"label\" or \"pin\" or \"digestData\" is null");
        }
        byte[][] pSignatureData = new byte[][]{new byte[0]};
        WCSPKE.WCSP_KE_SignDigestByKeyLabel(this.handle(), label, pin, digestData, pSignatureData);
        return pSignatureData[0];
    }

    public byte[] encrypt(String keyId, byte[] data) throws WCSPException {
        if (keyId == null || keyId.isEmpty() || null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"data\" is null");
        }
        byte[][] outData = new byte[][]{new byte[0]};
        WCSPKE.WCSP_KE_Encrypt(this.handle(), keyId, data, outData);
        return outData[0];
    }

    public byte[] encryptByLabel(String label, byte[] data) throws WCSPException {
        if (label == null || label.isEmpty() || null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"label\" or \"data\" is null");
        }
        byte[][] outData = new byte[][]{new byte[0]};
        WCSPKE.WCSP_KE_EncryptByKeyLabel(this.handle(), label, data, outData);
        return outData[0];
    }

    public byte[] decrypt(String keyId, String pin, byte[] encData) throws WCSPException {
        if (keyId == null || keyId.isEmpty() || pin == null || pin.isEmpty() || null == encData || encData.length < 1) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"pin\" or \"encData\" is null");
        }
        byte[][] pData = new byte[][]{new byte[0]};
        WCSPKE.WCSP_KE_Decrypt(this.handle(), keyId, pin, encData, pData);
        return pData[0];
    }

    public byte[] decryptByLabel(String label, String pin, byte[] encData) throws WCSPException {
        if (label == null || label.isEmpty() || pin == null || pin.isEmpty() || null == encData || encData.length < 1) {
            throw new IllegalArgumentException("Argument \"label\" or \"pin\" or \"encData\" is null");
        }
        byte[][] pData = new byte[][]{new byte[0]};
        WCSPKE.WCSP_KE_DecryptByKeyLabel(this.handle(), label, pin, encData, pData);
        return pData[0];
    }

    public CertHolder getCert(String keyId) throws WCSPException {
        if (keyId == null || keyId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"keyId\" is null");
        }
        byte[][] pSignCertData = new byte[][]{null};
        byte[][] pEncCertData = new byte[][]{null};
        WCSPKE.WCSP_KE_GetCert(this.handle(), keyId, pSignCertData, pEncCertData);
        return new CertHolder(keyId, pSignCertData[0], pEncCertData[0]);
    }

    public CertHolder getCertByLabel(String label) throws WCSPException {
        if (label == null || label.isEmpty()) {
            throw new IllegalArgumentException("Argument \"label\" is null");
        }
        String[] pKeyId = new String[]{null};
        byte[][] pSignCertData = new byte[][]{null};
        byte[][] pEncCertData = new byte[][]{null};
        WCSPKE.WCSP_KE_GetCertByKeyLabel(this.handle(), label, pKeyId, pSignCertData, pEncCertData);
        return new CertHolder(pKeyId[0], pSignCertData[0], pEncCertData[0]);
    }

    public int getCertCount() throws WCSPException {
        int[] pCertCount = new int[]{0};
        WCSPKE.WCSP_KE_GetCertCount(this.handle(), pCertCount);
        return pCertCount[0];
    }

    public CertInfoHolder[] getCertInfoList() throws WCSPException {
        int certCount = this.getCertCount();
        CertInfoHolder[] certInfoHolders = new CertInfoHolder[certCount];
        int pages = certCount / 100 + 1;
        for (int i = 0; i < pages; ++i) {
            int remainder = certCount - 100 * i;
            int pageSize = remainder > 100 ? 100 : remainder % 100;
            CertInfoHolder[] certInfoListByPage = this.getCertInfoList(pageSize, i);
            System.arraycopy(certInfoListByPage, 0, certInfoHolders, 100 * i, certInfoListByPage.length);
        }
        return certInfoHolders;
    }

    public CertInfoHolder[] getCertInfoList(int pageSize, int pageIndex) throws WCSPException {
        String[][] keyID = new String[1][];
        String[][] signSn = new String[1][];
        String[][] signIssuer = new String[1][];
        String[][] signUser = new String[1][];
        String[][] signValidStart = new String[1][];
        String[][] signValidEnd = new String[1][];
        String[][] encSn = new String[1][];
        String[][] encIssuer = new String[1][];
        String[][] encUser = new String[1][];
        String[][] encValidStart = new String[1][];
        String[][] encValidEnd = new String[1][];
        WCSPKE.WCSP_KE_GetCertList(this.handle(), pageSize, pageIndex, keyID, signSn, signIssuer, signUser, signValidStart, signValidEnd, encSn, encIssuer, encUser, encValidStart, encValidEnd);
        CertInfoHolder[] certInfoHolders = new CertInfoHolder[]{};
        if (null != keyID[0] && keyID[0].length != 0) {
            certInfoHolders = new CertInfoHolder[keyID[0].length];
            try {
                for (int i = 0; i < keyID[0].length; ++i) {
                    CertInfoHolder certInfoHolder;
                    CertInfoHolder.CertInfo encCertInfo = null;
                    CertInfoHolder.CertInfo signCertInfo = null;
                    if (!signSn[0][i].isEmpty()) {
                        signCertInfo = new CertInfoHolder.CertInfo(new BigInteger(signSn[0][i], 16), signIssuer[0][i], signUser[0][i], KeyEscrowService.StringToInstant(signValidStart[0][i]), KeyEscrowService.StringToInstant(signValidEnd[0][i]));
                    }
                    if (!encSn[0][i].isEmpty()) {
                        encCertInfo = new CertInfoHolder.CertInfo(new BigInteger(encSn[0][i], 16), signIssuer[0][i], signUser[0][i], KeyEscrowService.StringToInstant(encValidStart[0][i]), KeyEscrowService.StringToInstant(encValidEnd[0][i]));
                    }
                    certInfoHolders[i] = certInfoHolder = new CertInfoHolder(keyID[0][i], signCertInfo, encCertInfo);
                }
            }
            catch (Exception e) {
                throw new WCSPException(e.getMessage());
            }
        }
        return certInfoHolders;
    }

    private static Instant StringToInstant(String time) throws InvalidParameterException {
        try {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime ldt = LocalDateTime.parse(time, df);
            return ldt.atZone(ZoneId.systemDefault()).toInstant();
        }
        catch (Exception e) {
            throw new InvalidParameterException(e.getMessage());
        }
    }

    private KeyEscrowService(PlatformImpl platform) throws WCSPException {
        super(7, SERVICE_TYPE_KEYESCROW, platform);
    }

    public static final class CertInfoHolder {
        private final String keyId;
        private final CertInfo signCertInfo;
        private final CertInfo encCertInfo;

        public String keyId() {
            return this.keyId;
        }

        public CertInfo signCertInfo() {
            return this.signCertInfo;
        }

        public CertInfo encCertInfo() {
            return this.encCertInfo;
        }

        public CertInfoHolder(String keyId, CertInfo signCertInfo, CertInfo encCertInfo) {
            this.keyId = keyId;
            this.signCertInfo = signCertInfo;
            this.encCertInfo = encCertInfo;
        }

        public static final class CertInfo {
            private final BigInteger serialNumber;
            private final String issuer;
            private final String subject;
            private final Instant notBefore;
            private final Instant notAfter;

            public BigInteger serialNumber() {
                return this.serialNumber;
            }

            public String issuer() {
                return this.issuer;
            }

            public String subject() {
                return this.subject;
            }

            public Instant notBefore() {
                return this.notBefore;
            }

            public Instant notAfter() {
                return this.notAfter;
            }

            public CertInfo(BigInteger serialNumber, String issuer, String subject, Instant notBefore, Instant notAfter) {
                this.serialNumber = serialNumber;
                this.issuer = issuer;
                this.subject = subject;
                this.notBefore = notBefore;
                this.notAfter = notAfter;
            }
        }
    }

    public static final class CertHolder {
        private final String keyId;
        private final byte[] signCertData;
        private final byte[] encCertData;

        public String keyId() {
            return this.keyId;
        }

        public byte[] signCertData() {
            return this.signCertData;
        }

        public byte[] encCertData() {
            return this.encCertData;
        }

        public CertHolder(String keyId, byte[] signCertData, byte[] encCertData) {
            this.keyId = keyId;
            this.signCertData = signCertData;
            this.encCertData = encCertData;
        }
    }

    public static final class KeyPairHolder {
        private final String keyId;
        private final byte[] publicKeyData;
        private final byte[] csrData;

        public String keyId() {
            return this.keyId;
        }

        public byte[] publicKeyData() {
            return this.publicKeyData;
        }

        public byte[] csrData() {
            return this.csrData;
        }

        public KeyPairHolder(String keyId, byte[] publicKeyData, byte[] csrData) {
            this.keyId = keyId;
            this.publicKeyData = publicKeyData;
            this.csrData = csrData;
        }
    }
}

