/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.km;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.PublicKey;
import cn.com.westone.wcspsdk.baseservice.km.KMService;
import cn.com.westone.wcspsdk.baseservice.km.KeyNoUpdateStrategySpec;
import cn.com.westone.wcspsdk.baseservice.km.KeyPeriodicUpdateStrategySpec;
import cn.com.westone.wcspsdk.baseservice.km.KeyUpdateStrategySpec;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.ServiceImpl;
import cn.com.westone.wcspsdk.impl.base.WCSPKM;
import cn.com.westone.wcspsdk.impl.jni.JNIUtils;
import cn.com.westone.wcspsdk.impl.jni.KMServiceJNI;
import cn.com.westone.wcspsdk.impl.km.KMIdentifierImpl;
import cn.com.westone.wcspsdk.impl.km.KMKeyPairImpl;
import cn.com.westone.wcspsdk.impl.km.KMKeyPairImportHelperImpl;
import cn.com.westone.wcspsdk.impl.km.KMSecretKeyImpl;
import cn.com.westone.wcspsdk.impl.km.KMSecretKeyImportHelperImpl;
import cn.com.westone.wcspsdk.util.KeyUtils;
import java.util.Arrays;

public class KMServiceImpl
extends ServiceImpl
implements KMService {
    public static KMServiceImpl getInstance(PlatformImpl platform) throws WCSPException {
        if (null == platform) {
            throw new IllegalArgumentException("Argument \"platform\" is null");
        }
        return new KMServiceImpl(platform);
    }

    @Override
    public void init(Object ... args) {
    }

    @Override
    public KMKeyPairImpl createKeyPair(String algorithm, String usage, String alias, String description, KeyUpdateStrategySpec keyUpdateStrategySpec) throws InvalidParameterException, WCSPException {
        int keyUpdateStrategy;
        int algorithmId;
        if (null == algorithm || algorithm.isEmpty() || null == usage || usage.isEmpty() || null == keyUpdateStrategySpec) {
            throw new IllegalArgumentException("Argument \"algorithm\" or \"usage\" or \"keyUpdateStrategySpec\" is null");
        }
        if (null == alias) {
            alias = "";
        }
        if (null == description) {
            description = "";
        }
        switch (algorithm) {
            case "SM2": {
                algorithmId = 2;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + algorithm);
            }
        }
        switch (usage) {
            case "ENC": {
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid usage: " + usage);
            }
        }
        int cycleInDays = 0;
        int aheadInDays = 0;
        if (keyUpdateStrategySpec instanceof KeyNoUpdateStrategySpec) {
            keyUpdateStrategy = 0;
        } else if (keyUpdateStrategySpec instanceof KeyPeriodicUpdateStrategySpec) {
            keyUpdateStrategy = 1;
            KeyPeriodicUpdateStrategySpec keyPeriodicUpdateStrategySpec = (KeyPeriodicUpdateStrategySpec)keyUpdateStrategySpec;
            if (keyPeriodicUpdateStrategySpec.cycleInDays() < 1 || keyPeriodicUpdateStrategySpec.aheadInDays() < 0) {
                throw new IllegalArgumentException("Argument \"cycleInDays\" or \"aheadInDays\" is illegal");
            }
            if (keyPeriodicUpdateStrategySpec.cycleInDays() <= keyPeriodicUpdateStrategySpec.aheadInDays()) {
                throw new InvalidParameterException("Invalid cycleInDays and aheadInDays");
            }
            cycleInDays = keyPeriodicUpdateStrategySpec.cycleInDays();
            aheadInDays = keyPeriodicUpdateStrategySpec.aheadInDays();
        } else {
            throw new InvalidParameterException("Unknown keyUpdateStrategySpec object");
        }
        String[] pKeyId = new String[]{null};
        WCSPKM.WCSP_KM_CreateKeyPair(this.handle(), algorithmId, alias, description, keyUpdateStrategy, cycleInDays, aheadInDays, pKeyId);
        return new KMKeyPairImpl(pKeyId[0], usage, algorithm, this);
    }

    @Override
    public KMKeyPairImpl getKeyPair(String keyId) throws WCSPException {
        if (null == keyId || keyId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"keyId\" is null");
        }
        return new KMKeyPairImpl(keyId, "ENC", "SM2", this);
    }

    @Override
    public KMKeyPairImpl getKeyPair(String name, int version) throws WCSPException {
        if (null == name || name.isEmpty()) {
            throw new IllegalArgumentException("Argument \"name\" is null");
        }
        if (version < 1) {
            throw new IllegalArgumentException("Argument \"version\" is illegal");
        }
        String[] pKeyId = new String[]{null};
        WCSPKM.WCSP_KM_ObjectToKeyIdString(name, version, pKeyId);
        return new KMKeyPairImpl(pKeyId[0], "ENC", "SM2", this);
    }

    public KMKeyPairImpl[] getKeyPairList(String alias, int maxCount) throws WCSPException {
        if (null == alias || alias.isEmpty()) {
            throw new IllegalArgumentException("Argument \"alias\" is null");
        }
        if (maxCount < 1) {
            throw new IllegalArgumentException("Argument \"maxCount\" is illegal");
        }
        String[][] pKeyIds = new String[][]{null};
        WCSPKM.WCSP_KM_GetKeyPairListByAlias(this.handle(), alias, maxCount, pKeyIds);
        KMKeyPairImpl[] kmKeyPairs = new KMKeyPairImpl[pKeyIds[0].length];
        for (int i = 0; i < pKeyIds[0].length; ++i) {
            kmKeyPairs[i] = new KMKeyPairImpl(pKeyIds[0][i], "ENC", "SM2", this);
        }
        return kmKeyPairs;
    }

    public KMKeyPairImpl[] getKeyPairList(String alias) throws WCSPException {
        if (null == alias || alias.isEmpty()) {
            throw new IllegalArgumentException("Argument \"alias\" is null");
        }
        String[][] pKeyIds = new String[][]{null};
        WCSPKM.WCSP_KM_GetKeyPairListByAlias(this.handle(), alias, pKeyIds);
        KMKeyPairImpl[] kmKeyPairs = new KMKeyPairImpl[pKeyIds[0].length];
        for (int i = 0; i < pKeyIds[0].length; ++i) {
            kmKeyPairs[i] = new KMKeyPairImpl(pKeyIds[0][i], "ENC", "SM2", this);
        }
        return kmKeyPairs;
    }

    public KMKeyPairImpl[] getKeyPairList(int pageSize, int pageIndex) throws WCSPException {
        if (pageSize < 1 || pageIndex < 0) {
            throw new IllegalArgumentException("Argument \"pageSize\" or \"pageIndex\" is illegal");
        }
        String[][] pKeyIds = new String[][]{null};
        JNIUtils.WCSP_LOG_D("WCSP_KM_GetKeyPairList IN hKMService[{}{}] offset[{}] count[{}]", "0x", this.handle(), pageSize * pageIndex, pageSize);
        JNIUtils.WCSP_CHECK("WCSP_KM_GetKeyPairList", KMServiceJNI.wcsp_KM_GetKeyPairList(this.handle(), pageSize * pageIndex, pageSize, pKeyIds), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_KM_GetKeyPairList OUT keyIds[{}]", pKeyIds[0]);
        KMKeyPairImpl[] kmKeyPairs = new KMKeyPairImpl[pKeyIds[0].length];
        for (int i = 0; i < pKeyIds[0].length; ++i) {
            kmKeyPairs[i] = new KMKeyPairImpl(pKeyIds[0][i], "ENC", "SM2", this);
        }
        return kmKeyPairs;
    }

    public KMKeyPairImpl[] getKeyPairList() throws WCSPException {
        KMKeyPairImpl[] kmKeyPairsPage;
        KMKeyPairImpl[] kmKeyPairs = this.getKeyPairList(100, 0);
        int i = 1;
        while (kmKeyPairs.length == 100 * i && (kmKeyPairsPage = this.getKeyPairList(100, i)).length >= 1) {
            kmKeyPairs = Arrays.copyOf(kmKeyPairs, kmKeyPairs.length + kmKeyPairsPage.length);
            System.arraycopy(kmKeyPairsPage, 0, kmKeyPairs, 100 * i, kmKeyPairsPage.length);
            ++i;
        }
        return kmKeyPairs;
    }

    @Override
    public byte[] getEnvelopedKeyPair(String keyId, PublicKey protectionKey) throws InvalidKeyException, WCSPException {
        if (null == keyId || keyId.isEmpty() || null == protectionKey) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"protectionKey\" is null");
        }
        switch (protectionKey.algorithm()) {
            case "SM2": {
                break;
            }
            default: {
                throw new InvalidKeyException("Invalid protectionKey algorithm: " + protectionKey.algorithm());
            }
        }
        switch (protectionKey.usage()) {
            case "SIGN": 
            case "ENC": {
                break;
            }
            default: {
                throw new InvalidKeyException("Invalid protectionKey usage: " + protectionKey.usage());
            }
        }
        byte[] protectionKeyData = protectionKey.getKeyData();
        byte[][] pEnvelopedKeyPairData = new byte[][]{null};
        WCSPKM.WCSP_KM_GetEnvelopedKeyPair(this.handle(), keyId, protectionKeyData, pEnvelopedKeyPairData);
        return pEnvelopedKeyPairData[0];
    }

    @Override
    public byte[][] getEnvelopedKeyPair(String keyId, PublicKey[] protectionKeys) throws InvalidKeyException, WCSPException {
        if (null == keyId || keyId.isEmpty() || null == protectionKeys || protectionKeys.length < 1 || null == protectionKeys[0]) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"protectionKeys\" is null");
        }
        String[] seqNums = new String[protectionKeys.length];
        byte[][] protectionKeyDatas = new byte[protectionKeys.length][];
        for (int i = 0; i < protectionKeys.length; ++i) {
            switch (protectionKeys[i].algorithm()) {
                case "SM2": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid protectionKey algorithm: " + protectionKeys[i].algorithm());
                }
            }
            switch (protectionKeys[i].usage()) {
                case "SIGN": 
                case "ENC": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid protectionKey usage: " + protectionKeys[i].usage());
                }
            }
            seqNums[i] = Integer.toString(i);
            protectionKeyDatas[i] = protectionKeys[i].getKeyData();
        }
        String[][] pSeqNums = new String[][]{null};
        byte[][][] pEnvelopedKeyPairDatas = new byte[][][]{(byte[][])null};
        WCSPKM.WCSP_KM_GetEnvelopedKeyPairs(this.handle(), keyId, seqNums, protectionKeyDatas, pSeqNums, pEnvelopedKeyPairDatas);
        byte[][] envelopedKeyPairDatas = new byte[protectionKeys.length][];
        for (int i = 0; i < protectionKeys.length; ++i) {
            for (int j = 0; j < pSeqNums[0].length; ++j) {
                if (!seqNums[i].equals(pSeqNums[0][j])) continue;
                envelopedKeyPairDatas[i] = pEnvelopedKeyPairDatas[0][j];
            }
        }
        return envelopedKeyPairDatas;
    }

    @Override
    public byte[][] getEnvelopedKeyPair(String keyId, int[] versions, PublicKey protectionKey) throws InvalidKeyException, WCSPException {
        throw new UnsupportedOperationException();
    }

    @Override
    public KMSecretKeyImpl createSecretKey(String algorithm, String usage, String alias, String description, KeyUpdateStrategySpec keyUpdateStrategySpec) throws InvalidParameterException, WCSPException {
        int keyUpdateStrategy;
        int algorithmId;
        if (null == algorithm || algorithm.isEmpty() || null == usage || usage.isEmpty() || null == keyUpdateStrategySpec) {
            throw new IllegalArgumentException("Argument \"algorithm\" or \"usage\" or \"keyUpdateStrategySpec\" is null");
        }
        if (null == alias) {
            alias = "";
        }
        if (null == description) {
            description = "";
        }
        switch (algorithm) {
            case "SM4": {
                algorithmId = 1;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + algorithm);
            }
        }
        switch (usage) {
            case "ENC": {
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid usage: " + usage);
            }
        }
        int cycleInDays = 0;
        int aheadInDays = 0;
        if (keyUpdateStrategySpec instanceof KeyNoUpdateStrategySpec) {
            keyUpdateStrategy = 0;
        } else if (keyUpdateStrategySpec instanceof KeyPeriodicUpdateStrategySpec) {
            keyUpdateStrategy = 1;
            KeyPeriodicUpdateStrategySpec keyPeriodicUpdateStrategySpec = (KeyPeriodicUpdateStrategySpec)keyUpdateStrategySpec;
            if (keyPeriodicUpdateStrategySpec.cycleInDays() < 1 || keyPeriodicUpdateStrategySpec.aheadInDays() < 0) {
                throw new IllegalArgumentException("Argument \"cycleInDays\" or \"aheadInDays\" is illegal");
            }
            if (keyPeriodicUpdateStrategySpec.cycleInDays() <= keyPeriodicUpdateStrategySpec.aheadInDays()) {
                throw new InvalidParameterException("Invalid cycleInDays and aheadInDays");
            }
            cycleInDays = keyPeriodicUpdateStrategySpec.cycleInDays();
            aheadInDays = keyPeriodicUpdateStrategySpec.aheadInDays();
        } else {
            throw new InvalidParameterException("Unknown keyUpdateStrategySpec object");
        }
        String[] pKeyId = new String[]{null};
        WCSPKM.WCSP_KM_CreateSecretKey(this.handle(), algorithmId, alias, description, keyUpdateStrategy, cycleInDays, aheadInDays, pKeyId);
        return new KMSecretKeyImpl(pKeyId[0], usage, algorithm, this);
    }

    @Override
    public KMSecretKeyImpl getSecretKey(String keyId) throws WCSPException {
        if (null == keyId || keyId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"keyId\" is null");
        }
        return new KMSecretKeyImpl(keyId, "ENC", "SM4", this);
    }

    @Override
    public KMSecretKeyImpl getSecretKey(String name, int version) throws WCSPException {
        if (null == name || name.isEmpty()) {
            throw new IllegalArgumentException("Argument \"name\" is null");
        }
        if (version < 1) {
            throw new IllegalArgumentException("Argument \"version\" is illegal");
        }
        String[] pKeyId = new String[]{null};
        WCSPKM.WCSP_KM_ObjectToKeyIdString(name, version, pKeyId);
        return new KMSecretKeyImpl(pKeyId[0], "ENC", "SM4", this);
    }

    public KMSecretKeyImpl[] getSecretKeyList(String alias, int maxCount) throws WCSPException {
        if (null == alias || alias.isEmpty()) {
            throw new IllegalArgumentException("Argument \"alias\" is null");
        }
        if (maxCount < 1) {
            throw new IllegalArgumentException("Argument \"maxCount\" is illegal");
        }
        String[][] pKeyIds = new String[][]{null};
        WCSPKM.WCSP_KM_GetSecretKeyListByAlias(this.handle(), alias, maxCount, pKeyIds);
        KMSecretKeyImpl[] kmKeyPairs = new KMSecretKeyImpl[pKeyIds[0].length];
        for (int i = 0; i < pKeyIds[0].length; ++i) {
            kmKeyPairs[i] = new KMSecretKeyImpl(pKeyIds[0][i], "ENC", "SM4", this);
        }
        return kmKeyPairs;
    }

    public KMSecretKeyImpl[] getSecretKeyList(String alias) throws WCSPException {
        if (null == alias || alias.isEmpty()) {
            throw new IllegalArgumentException("Argument \"alias\" is null");
        }
        String[][] pKeyIds = new String[][]{null};
        WCSPKM.WCSP_KM_GetSecretKeyListByAlias(this.handle(), alias, pKeyIds);
        KMSecretKeyImpl[] kmKeyPairs = new KMSecretKeyImpl[pKeyIds[0].length];
        for (int i = 0; i < pKeyIds[0].length; ++i) {
            kmKeyPairs[i] = new KMSecretKeyImpl(pKeyIds[0][i], "ENC", "SM4", this);
        }
        return kmKeyPairs;
    }

    public KMSecretKeyImpl[] getSecretKeyList(int pageSize, int pageIndex) throws WCSPException {
        if (pageSize < 1 || pageIndex < 0) {
            throw new IllegalArgumentException("Argument \"pageSize\" or \"pageIndex\" is illegal");
        }
        String[][] pKeyIds = new String[][]{null};
        JNIUtils.WCSP_LOG_D("WCSP_KM_GetSecretKeyList IN hKMService[{}{}] offset[{}] count[{}]", "0x", this.handle(), pageSize * pageIndex, pageSize);
        JNIUtils.WCSP_CHECK("WCSP_KM_GetSecretKeyList", KMServiceJNI.wcsp_KM_GetSecretKeyList(this.handle(), pageSize * pageIndex, pageSize, pKeyIds), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_KM_GetSecretKeyList OUT keyIds[{}]", pKeyIds[0]);
        KMSecretKeyImpl[] kmSecretKeys = new KMSecretKeyImpl[pKeyIds[0].length];
        for (int i = 0; i < pKeyIds[0].length; ++i) {
            kmSecretKeys[i] = new KMSecretKeyImpl(pKeyIds[0][i], "ENC", "SM4", this);
        }
        return kmSecretKeys;
    }

    public KMSecretKeyImpl[] getSecretKeyList() throws WCSPException {
        KMSecretKeyImpl[] kmSecretKeyPage;
        KMSecretKeyImpl[] kmSecretKeys = this.getSecretKeyList(100, 0);
        int i = 1;
        while (kmSecretKeys.length == 100 * i && (kmSecretKeyPage = this.getSecretKeyList(100, i)).length >= 1) {
            kmSecretKeys = Arrays.copyOf(kmSecretKeys, kmSecretKeys.length + kmSecretKeyPage.length);
            System.arraycopy(kmSecretKeyPage, 0, kmSecretKeys, 100 * i, kmSecretKeyPage.length);
            ++i;
        }
        return kmSecretKeys;
    }

    @Override
    public byte[] getWrappedSecretKey(String keyId, PublicKey protectionKey) throws InvalidKeyException, WCSPException {
        if (null == keyId || keyId.isEmpty() || null == protectionKey) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"protectionKey\" is null");
        }
        switch (protectionKey.algorithm()) {
            case "SM2": {
                break;
            }
            default: {
                throw new InvalidKeyException("Invalid protectionKey algorithm: " + protectionKey.algorithm());
            }
        }
        switch (protectionKey.usage()) {
            case "ENC": {
                break;
            }
            default: {
                throw new InvalidKeyException("Invalid protectionKey usage: " + protectionKey.usage());
            }
        }
        byte[] protectionKeyData = protectionKey.getKeyData();
        byte[][] pWrappedKeyData = new byte[][]{null};
        WCSPKM.WCSP_KM_GetWrappedSecretKey(this.handle(), keyId, protectionKeyData, pWrappedKeyData);
        return pWrappedKeyData[0];
    }

    @Override
    @Deprecated
    public byte[] getWrappedSecretKey(String keyId, String protectionKeyId, byte[] protectionIV) throws WCSPException {
        if (null == keyId || keyId.isEmpty() || null == protectionKeyId || protectionKeyId.isEmpty() || null == protectionIV || protectionIV.length < 1) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"protectionKeyId\" or \"protectionIV\" is null");
        }
        byte[][] pWrappedKeyData = new byte[][]{null};
        WCSPKM.WCSP_KM_GetWrappedSecretKeyBySecretKey(this.handle(), keyId, protectionKeyId, protectionIV, pWrappedKeyData);
        return pWrappedKeyData[0];
    }

    @Override
    public byte[][] getWrappedSecretKey(String keyId, PublicKey[] protectionKeys) throws InvalidKeyException, WCSPException {
        if (null == keyId || keyId.isEmpty() || null == protectionKeys || protectionKeys.length < 1 || null == protectionKeys[0]) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"protectionKeys\" is null");
        }
        String[] seqNums = new String[protectionKeys.length];
        byte[][] protectionKeyDatas = new byte[protectionKeys.length][];
        for (int i = 0; i < protectionKeys.length; ++i) {
            switch (protectionKeys[i].algorithm()) {
                case "SM2": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid protectionKey algorithm: " + protectionKeys[i].algorithm());
                }
            }
            switch (protectionKeys[i].usage()) {
                case "ENC": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid protectionKey usage: " + protectionKeys[i].usage());
                }
            }
            seqNums[i] = Integer.toString(i);
            protectionKeyDatas[i] = protectionKeys[i].getKeyData();
        }
        String[][] pSeqNums = new String[][]{null};
        byte[][][] pWrappedKeyDatas = new byte[][][]{(byte[][])null};
        WCSPKM.WCSP_KM_GetWrappedSecretKeys(this.handle(), keyId, seqNums, protectionKeyDatas, pSeqNums, pWrappedKeyDatas);
        byte[][] wrappedKeyDatas = new byte[protectionKeys.length][];
        for (int i = 0; i < protectionKeys.length; ++i) {
            for (int j = 0; j < pSeqNums[0].length; ++j) {
                if (!seqNums[i].equals(pSeqNums[0][j])) continue;
                wrappedKeyDatas[i] = pWrappedKeyDatas[0][j];
            }
        }
        return wrappedKeyDatas;
    }

    @Override
    public byte[][] getWrappedSecretKey(String keyId, int[] versions, PublicKey protectionKey) throws InvalidKeyException, WCSPException {
        if (null == keyId || keyId.isEmpty() || null == versions || versions.length < 1 || null == protectionKey) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"versions\" or \"protectionKey\" is null");
        }
        for (int i = 0; i < versions.length; ++i) {
            if (versions[i] >= 1) continue;
            throw new IllegalArgumentException("Argument \"versions\" is illegal");
        }
        switch (protectionKey.algorithm()) {
            case "SM2": {
                break;
            }
            default: {
                throw new InvalidKeyException("Invalid protectionKey algorithm: " + protectionKey.algorithm());
            }
        }
        switch (protectionKey.usage()) {
            case "ENC": {
                break;
            }
            default: {
                throw new InvalidKeyException("Invalid protectionKey usage: " + protectionKey.usage());
            }
        }
        byte[] protectionKeyData = protectionKey.getKeyData();
        int[][] pVersions = new int[][]{null};
        byte[][][] pWrappedKeyDatas = new byte[][][]{(byte[][])null};
        WCSPKM.WCSP_KM_GetVersionedWrappedSecretKeys(this.handle(), keyId, versions, protectionKeyData, pVersions, pWrappedKeyDatas);
        byte[][] wrappedKeyDatas = new byte[versions.length][];
        for (int i = 0; i < versions.length; ++i) {
            for (int j = 0; j < pVersions[0].length; ++j) {
                if (versions[i] != pVersions[0][j]) continue;
                wrappedKeyDatas[i] = pWrappedKeyDatas[0][j];
            }
        }
        return wrappedKeyDatas;
    }

    @Override
    public int getKeyLatestVersion(String keyId) throws WCSPException {
        if (null == keyId || keyId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"keyId\" is null");
        }
        int[] pVersion = new int[]{0};
        WCSPKM.WCSP_KM_GetKeyLatestVersion(this.handle(), keyId, pVersion);
        return pVersion[0];
    }

    @Override
    public void updateKeyAuthority(String keyId, String[] addAuthUserList, String[] removeAuthUserList) throws WCSPException {
        if (null == keyId || keyId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"keyId\" is null");
        }
        if (null == addAuthUserList) {
            addAuthUserList = new String[]{};
        }
        if (null == removeAuthUserList) {
            removeAuthUserList = new String[]{};
        }
        if (addAuthUserList.length < 1 && removeAuthUserList.length < 1) {
            throw new IllegalArgumentException("Argument \"addAuthUserList\" and \"removeAuthUserList\" is null");
        }
        WCSPKM.WCSP_KM_UpdateKeyAuthority(this.handle(), keyId, addAuthUserList, removeAuthUserList);
    }

    @Override
    public void addKeyAuthority(String keyId) throws WCSPException {
        if (null == keyId || keyId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"keyId\" is null");
        }
        WCSPKM.WCSP_KM_UpdateAppKeyAuthority(this.handle(), keyId, 0);
    }

    @Override
    public void removeKeyAuthority(String keyId) throws WCSPException {
        if (null == keyId || keyId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"keyId\" is null");
        }
        WCSPKM.WCSP_KM_RemoveKeyAuthority(this.handle(), keyId);
        WCSPKM.WCSP_KM_UpdateAppKeyAuthority(this.handle(), keyId, 1);
    }

    @Override
    public void setKeyUpdateStrategy(String keyId, KeyUpdateStrategySpec keyUpdateStrategySpec) throws InvalidParameterException, WCSPException {
        int keyUpdateStrategy;
        if (null == keyId || keyId.isEmpty() || null == keyUpdateStrategySpec) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"keyUpdateStrategySpec\" is null");
        }
        int cycleInDays = 0;
        int aheadInDays = 0;
        if (keyUpdateStrategySpec instanceof KeyNoUpdateStrategySpec) {
            keyUpdateStrategy = 0;
        } else if (keyUpdateStrategySpec instanceof KeyPeriodicUpdateStrategySpec) {
            keyUpdateStrategy = 1;
            KeyPeriodicUpdateStrategySpec keyPeriodicUpdateStrategySpec = (KeyPeriodicUpdateStrategySpec)keyUpdateStrategySpec;
            if (keyPeriodicUpdateStrategySpec.cycleInDays() < 1 || keyPeriodicUpdateStrategySpec.aheadInDays() < 0) {
                throw new IllegalArgumentException("Argument \"cycleInDays\" or \"aheadInDays\" is illegal");
            }
            if (keyPeriodicUpdateStrategySpec.cycleInDays() <= keyPeriodicUpdateStrategySpec.aheadInDays()) {
                throw new InvalidParameterException("Invalid cycleInDays and aheadInDays");
            }
            cycleInDays = keyPeriodicUpdateStrategySpec.cycleInDays();
            aheadInDays = keyPeriodicUpdateStrategySpec.aheadInDays();
        } else {
            throw new InvalidParameterException("Unknown keyUpdateStrategySpec object");
        }
        JNIUtils.WCSP_LOG_D("WCSP_KM_UpdateKeyPolicy IN hKMService[{}{}] keyId[{}] keyUpdateStrategy[{}] cycleInDays[{}] aheadInDays[{}]", "0x", this.handle(), keyId, keyUpdateStrategy, cycleInDays, aheadInDays);
        JNIUtils.WCSP_CHECK("WCSP_KM_UpdateKeyPolicy", KMServiceJNI.wcsp_KM_UpdateKeyPolicy(this.handle(), keyId, keyUpdateStrategy, cycleInDays, aheadInDays), new int[0]);
    }

    @Override
    public void disableKey(String keyId) throws WCSPException {
        if (null == keyId || keyId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"keyId\" is null");
        }
        JNIUtils.WCSP_LOG_D("WCSP_KM_DisableKey IN hKMService[{}{}] keyId[{}]", "0x", this.handle(), keyId);
        JNIUtils.WCSP_CHECK("WCSP_KM_DisableKey", KMServiceJNI.wcsp_KM_DisableKey(this.handle(), keyId), new int[0]);
    }

    @Override
    public void enableKey(String keyId) throws WCSPException {
        if (null == keyId || keyId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"keyId\" is null");
        }
        JNIUtils.WCSP_LOG_D("WCSP_KM_EnableKey IN hKMService[{}{}] keyId[{}]", "0x", this.handle(), keyId);
        JNIUtils.WCSP_CHECK("WCSP_KM_EnableKey", KMServiceJNI.wcsp_KM_EnableKey(this.handle(), keyId), new int[0]);
    }

    @Override
    public void scheduleKeyDeletion(String keyId, int pendingInDays) throws WCSPException {
        if (null == keyId || keyId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"keyId\" is null");
        }
        if (pendingInDays < 0) {
            throw new IllegalArgumentException("Argument \"pendingInDays\" is illegal");
        }
        JNIUtils.WCSP_LOG_D("WCSP_KM_ScheduleKeyDeletion IN hKMService[{}{}] keyId[{}] pendingInDays[{}]", "0x", this.handle(), keyId, pendingInDays);
        JNIUtils.WCSP_CHECK("WCSP_KM_ScheduleKeyDeletion", KMServiceJNI.wcsp_KM_ScheduleKeyDeletion(this.handle(), keyId, pendingInDays), new int[0]);
    }

    @Override
    public void cancleKeyDeletion(String keyId) throws WCSPException {
        if (null == keyId || keyId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"keyId\" is null");
        }
        JNIUtils.WCSP_LOG_D("WCSP_KM_CancleKeyDeletion IN hKMService[{}{}] keyId[{}]", "0x", this.handle(), keyId);
        JNIUtils.WCSP_CHECK("WCSP_KM_CancleKeyDeletion", KMServiceJNI.wcsp_KM_CancleKeyDeletion(this.handle(), keyId), new int[0]);
    }

    @Override
    public void registerIdentifier(String algorithm, String identity) throws InvalidParameterException, WCSPException {
        if (null == algorithm || algorithm.isEmpty() || null == identity || identity.isEmpty()) {
            throw new IllegalArgumentException("Argument \"keyId\" or \"identity\" is null");
        }
        switch (algorithm) {
            case "SM9": {
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + algorithm);
            }
        }
        JNIUtils.WCSP_LOG_D("WCSP_KM_InitSM9Id IN hKMService[{}{}] identity[{}]", "0x", this.handle(), identity);
        JNIUtils.WCSP_CHECK("WCSP_KM_InitSM9Id", KMServiceJNI.wcsp_KM_InitSM9Id(this.handle(), identity), new int[0]);
    }

    @Override
    public KMIdentifierImpl getIdentifier(String usage, String identity) throws InvalidParameterException, WCSPException {
        int usageId;
        if (null == usage || usage.isEmpty() || null == identity || identity.isEmpty()) {
            throw new IllegalArgumentException("Argument \"usage\" or \"identity\" is null");
        }
        switch (usage) {
            case "SIGN": {
                usageId = 0;
                break;
            }
            case "ENC": {
                usageId = 1;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid usage: " + usage);
            }
        }
        String[] pKeyId = new String[]{null};
        JNIUtils.WCSP_LOG_D("WCSP_KM_GetSM9KeyId IN hKMService[{}{}] identity[{}] usageId[{}]", "0x", this.handle(), identity, usageId);
        JNIUtils.WCSP_CHECK("WCSP_KM_GetSM9KeyId", KMServiceJNI.wcsp_KM_GetSM9KeyId(this.handle(), identity, usageId, pKeyId), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_KM_GetSM9KeyId OUT keyId[{}]", pKeyId[0]);
        return new KMIdentifierImpl(identity, pKeyId[0], usage, this);
    }

    @Override
    public KMIdentifierImpl getIdentifier(String usage, String identity, int version) throws InvalidParameterException, WCSPException {
        int usageId;
        if (null == usage || usage.isEmpty() || null == identity || identity.isEmpty()) {
            throw new IllegalArgumentException("Argument \"usage\" or \"identity\" is null");
        }
        if (version < 1) {
            throw new IllegalArgumentException("Argument \"version\" is illegal");
        }
        switch (usage) {
            case "SIGN": {
                usageId = 0;
                break;
            }
            case "ENC": {
                usageId = 1;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid usage: " + usage);
            }
        }
        String[] pKeyId = new String[]{null};
        JNIUtils.WCSP_LOG_D("WCSP_KM_GetSM9KeyId IN hKMService[{}{}] identity[{}] usageId[{}]", "0x", this.handle(), identity, usageId);
        JNIUtils.WCSP_CHECK("WCSP_KM_GetSM9KeyId", KMServiceJNI.wcsp_KM_GetSM9KeyId(this.handle(), identity, usageId, pKeyId), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_KM_GetSM9KeyId OUT keyId[{}]", pKeyId[0]);
        String[] pName = new String[]{null};
        int[] pVersion = new int[]{0};
        WCSPKM.WCSP_KM_KeyIdStringToObject(pKeyId[0], pName, pVersion);
        if (pVersion[0] < version) {
            throw new InvalidParameterException("Invalid version: " + version);
        }
        pKeyId[0] = null;
        WCSPKM.WCSP_KM_ObjectToKeyIdString(pName[0], version, pKeyId);
        return new KMIdentifierImpl(identity, pKeyId[0], usage, this);
    }

    @Override
    public int getIdentifierLatestVersion(String usage, String identity) throws InvalidParameterException, WCSPException {
        int usageId;
        if (null == usage || usage.isEmpty() || null == identity || identity.isEmpty()) {
            throw new IllegalArgumentException("Argument \"usage\" or \"identity\" is null");
        }
        switch (usage) {
            case "SIGN": {
                usageId = 0;
                break;
            }
            case "ENC": {
                usageId = 1;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid usage: " + usage);
            }
        }
        int[] pVersion = new int[]{0};
        JNIUtils.WCSP_LOG_D("WCSP_KM_GetSM9IdLatestVersion IN hKMService[{}{}] identity[{}] usageId[{}]", "0x", this.handle(), identity, usageId);
        JNIUtils.WCSP_CHECK("WCSP_KM_GetSM9IdLatestVersion", KMServiceJNI.wcsp_KM_GetSM9IdLatestVersion(this.handle(), identity, usageId, pVersion), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_KM_GetSM9IdLatestVersion OUT version[{}]", pVersion[0]);
        return 0;
    }

    @Override
    public KMKeyPairImportHelperImpl getKMKeyPairImportHelper() throws WCSPException {
        String[] pKeyId = new String[]{null};
        String[] pToken = new String[]{null};
        byte[][] pPublicKeyData = new byte[][]{null};
        this.getImportKeyParams(pKeyId, pToken, pPublicKeyData);
        try {
            return new KMKeyPairImportHelperImpl(this.handle(), pKeyId[0], pToken[0], KeyUtils.createPublicKeySM2("ENC", pPublicKeyData[0]), this);
        }
        catch (InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    @Override
    public KMSecretKeyImportHelperImpl getKMSecretKeyImportHelper() throws WCSPException {
        String[] pKeyId = new String[]{null};
        String[] pToken = new String[]{null};
        byte[][] pPublicKeyData = new byte[][]{null};
        this.getImportKeyParams(pKeyId, pToken, pPublicKeyData);
        try {
            return new KMSecretKeyImportHelperImpl(this.handle(), pKeyId[0], pToken[0], KeyUtils.createPublicKeySM2("ENC", pPublicKeyData[0]), this);
        }
        catch (InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private void getImportKeyParams(String[] pKeyId, String[] pToken, byte[][] pPublicKeyData) throws WCSPException {
        WCSPKM.WCSP_KM_GetImportKeyParams(this.handle(), pKeyId, pToken, pPublicKeyData);
    }

    @Override
    protected long handle() {
        return super.handle();
    }

    private KMServiceImpl(PlatformImpl platform) throws WCSPException {
        super(1, "KM", platform);
    }
}

