/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.km;

import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.km.KMKey;
import cn.com.westone.wcspsdk.baseservice.km.KeyNoUpdateStrategySpec;
import cn.com.westone.wcspsdk.baseservice.km.KeyPeriodicUpdateStrategySpec;
import cn.com.westone.wcspsdk.baseservice.km.KeyUpdateStrategySpec;
import cn.com.westone.wcspsdk.impl.base.WCSPKM;
import cn.com.westone.wcspsdk.impl.km.KMServiceImpl;
import java.time.Instant;

public abstract class KMKeyImpl
implements KMKey {
    private String keyId;
    private String alias = null;
    private String description = null;
    private String origin = null;
    private KMKey.KeyStatus status = null;
    private Instant createTime = null;
    private Instant destroyTime = null;
    private KeyUpdateStrategySpec keyUpdateStrategy = null;
    private final String usage;
    private final String algorithm;
    private final KMServiceImpl kmService;

    @Override
    public String keyId() {
        return this.keyId;
    }

    @Override
    public String alias() throws WCSPException {
        if (this.alias == null) {
            this.getMetadata();
        }
        return this.alias;
    }

    @Override
    public String description() throws WCSPException {
        if (this.description == null) {
            this.getMetadata();
        }
        return this.description;
    }

    @Override
    public String origin() throws WCSPException {
        if (this.origin == null) {
            this.getMetadata();
        }
        return this.origin;
    }

    @Override
    public KMKey.KeyStatus status() throws WCSPException {
        this.getMetadata();
        return this.status;
    }

    @Override
    public Instant createTime() throws WCSPException {
        if (this.createTime == null) {
            this.getMetadata();
        }
        return this.createTime;
    }

    @Override
    public Instant destroyTime() throws WCSPException {
        if (this.destroyTime == null) {
            this.getMetadata();
        }
        return this.destroyTime;
    }

    @Override
    public KeyUpdateStrategySpec keyUpdateStrategy() throws WCSPException {
        this.getMetadata();
        return this.keyUpdateStrategy;
    }

    @Override
    public int version() {
        int[] pVersion = new int[]{0};
        try {
            WCSPKM.WCSP_KM_KeyIdStringToObject(this.keyId, new String[1], pVersion);
        }
        catch (WCSPException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        return pVersion[0];
    }

    @Override
    public int getLatestVersion() throws WCSPException {
        return this.kmService.getKeyLatestVersion(this.keyId);
    }

    @Override
    public void updateKeyAuthority(String[] addAuthUserList, String[] removeAuthUserList) throws WCSPException {
        this.kmService.updateKeyAuthority(this.keyId, addAuthUserList, removeAuthUserList);
    }

    @Override
    public void addKeyAuthority() throws WCSPException {
        this.kmService.addKeyAuthority(this.keyId);
    }

    @Override
    public void removeKeyAuthority() throws WCSPException {
        this.kmService.removeKeyAuthority(this.keyId);
    }

    @Override
    public void setKeyUpdateStrategy(KeyUpdateStrategySpec keyUpdateStrategySpec) throws InvalidParameterException, WCSPException {
        this.kmService.setKeyUpdateStrategy(this.keyId, keyUpdateStrategySpec);
    }

    @Override
    public void disableKey() throws WCSPException {
        this.kmService.disableKey(this.keyId);
    }

    @Override
    public void enableKey() throws WCSPException {
        this.kmService.enableKey(this.keyId);
    }

    @Override
    public void scheduleKeyDeletion(int pendingInDays) throws WCSPException {
        this.kmService.scheduleKeyDeletion(this.keyId, pendingInDays);
    }

    @Override
    public void cancleKeyDeletion() throws WCSPException {
        this.kmService.cancleKeyDeletion(this.keyId);
    }

    @Override
    public String usage() {
        return this.usage;
    }

    @Override
    public String name() {
        String[] pName = new String[]{null};
        try {
            WCSPKM.WCSP_KM_KeyIdStringToObject(this.keyId, pName, new int[1]);
        }
        catch (WCSPException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        return pName[0];
    }

    @Override
    public String algorithm() {
        return this.algorithm;
    }

    @Override
    public KMServiceImpl service() {
        return this.kmService;
    }

    @Override
    public void close() {
    }

    KMKeyImpl(String keyId, String usage, String algorithm, KMServiceImpl kmService) {
        this.keyId = keyId;
        this.usage = usage;
        this.algorithm = algorithm;
        this.kmService = kmService;
    }

    void keyId(String keyId) {
        this.keyId = keyId;
    }

    private void getMetadata() throws WCSPException {
        int[] pAlgorithm = new int[]{0};
        int[] pUsage = new int[]{0};
        String[] pAlias = new String[]{null};
        String[] pDescription = new String[]{null};
        String[] pOrigin = new String[]{null};
        int[] pStatus = new int[]{0};
        long[] pCreateTime = new long[]{0L};
        long[] pDestroyTime = new long[]{0L};
        int[] pKeyUpdateStrategy = new int[]{0};
        int[] pCycleInDays = new int[]{0};
        int[] pAheadInDays = new int[]{0};
        int[] pLatestVersion = new int[]{0};
        WCSPKM.WCSP_KM_GetKeyMeta(this.kmService.handle(), this.keyId, pAlgorithm, pUsage, pAlias, pDescription, pOrigin, pStatus, pCreateTime, pDestroyTime, pKeyUpdateStrategy, pCycleInDays, pAheadInDays, pLatestVersion);
        if (!(this.alias != null || this.algorithm.equals("SM4") && pAlgorithm[0] == 1 || this.algorithm.equals("SM2") && pAlgorithm[0] == 2)) {
            throw new WCSPException("WCSP_KM_GetKeyMeta failed, unSupported_alg", 655379);
        }
        if (!(this.alias != null || this.usage.equals("ENC") && pUsage[0] == 1)) {
            throw new WCSPException("WCSP_KM_GetKeyMeta failed, usage_error", 655381);
        }
        this.alias = pAlias[0];
        this.description = pDescription[0];
        this.origin = pOrigin[0];
        switch (pStatus[0]) {
            case 1: {
                this.status = KMKey.KeyStatus.ENABLE;
                break;
            }
            case 0: {
                this.status = KMKey.KeyStatus.DISABLE;
                break;
            }
            case 2: {
                this.status = KMKey.KeyStatus.SCHEDULE_DESTROY;
                break;
            }
            default: {
                throw new WCSPException("invalid status:" + pStatus[0]);
            }
        }
        this.createTime = Instant.ofEpochMilli(pCreateTime[0]);
        Instant instant = this.destroyTime = pDestroyTime[0] == 0L ? null : Instant.ofEpochMilli(pDestroyTime[0]);
        if (pKeyUpdateStrategy[0] == 1) {
            this.keyUpdateStrategy = new KeyPeriodicUpdateStrategySpec.Builder().setCycleInDays(pCycleInDays[0]).setAheadInDays(pAheadInDays[0]).build();
        } else if (pKeyUpdateStrategy[0] == 0) {
            this.keyUpdateStrategy = new KeyNoUpdateStrategySpec.Builder().build();
        }
    }
}

