/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.jni;

import cn.com.westone.wcspsdk.WCSPException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JNIUtils {
    public static final int WCSP_OK = 0;
    private static final Logger LOG = LoggerFactory.getLogger((String)"WCSP");

    public static void WCSP_CHECK(String func, int rc, int ... args) throws WCSPException {
        if (rc == 0) {
            return;
        }
        for (int arg : args) {
            if (rc != arg) continue;
            return;
        }
        throw new WCSPException(func + " failed", rc);
    }

    public static void WCSP_LOG_D(String fmt, Object ... args) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        boolean hexFlag = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof String && ((String)args[i]).equals("0x")) {
                hexFlag = true;
                continue;
            }
            if (hexFlag) {
                if (args[i] instanceof Long) {
                    args[i] = String.format("%016x", args[i]);
                } else if (args[i] instanceof Integer) {
                    args[i] = String.format("%08x", args[i]);
                }
            } else if (args[i] instanceof byte[]) {
                args[i] = JNIUtils.toString((byte[])args[i]);
            } else if (args[i] instanceof String[]) {
                args[i] = JNIUtils.toString((String[])args[i]);
            } else if (args[i] instanceof byte[][]) {
                args[i] = JNIUtils.toString((byte[][])args[i]);
            } else if (args[i] instanceof Instant) {
                args[i] = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.ofInstant((Instant)args[i], ZoneId.systemDefault()));
            }
            hexFlag = false;
        }
        LOG.debug(fmt, args);
    }

    public static void WCSP_LOG_D(String fmt, String[] p1) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug(fmt, (Object)JNIUtils.toString(p1));
    }

    private static String toString(byte[] data) {
        if (null == data || data.length < 1) {
            return "0{}";
        }
        StringBuilder builder = new StringBuilder(data.length * 3 + 5);
        builder.append(data.length).append('{');
        for (byte e : data) {
            builder.append(String.format("%02x ", e));
        }
        builder.setCharAt(builder.length() - 1, '}');
        return builder.toString();
    }

    private static String toString(String[] data) {
        if (null == data || data.length < 1) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String e : data) {
            builder.append(e);
            builder.append(" ");
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    private static String toString(byte[][] data) {
        if (null == data || data.length < 1) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (byte[] e : data) {
            builder.append(JNIUtils.toString(e));
            builder.append(" ");
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }
}

