/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.SecretKey;
import cn.com.westone.wcspsdk.baseservice.co.ShortDataEncryptor;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.SymmCipherImpl;
import java.util.Arrays;

public class SymmShortDataEncryptorImpl
extends SymmCipherImpl
implements ShortDataEncryptor {
    private long hContext = 0L;
    private byte[] remainedData;
    private int missingDataLen;

    @Override
    public byte[] encrypt(byte[] data) throws InvalidParameterException, WCSPException {
        if (null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"data\" is null");
        }
        if (data.length > 1023) {
            throw new InvalidParameterException("Input data is too long");
        }
        byte[][] pEncryptedData = new byte[][]{null};
        WCSPCO.WCSP_CO_SymmEncrypt(this.hSecretKey(), this.iv(), this.paddingType(), data, pEncryptedData);
        return pEncryptedData[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[][] encrypt(byte[][] datas) throws InvalidParameterException, WCSPException {
        if (null == datas || datas.length < 1) {
            throw new IllegalArgumentException("Argument \"datas\" is null");
        }
        byte[][] encryptedDatas = new byte[datas.length][];
        if (this.mode().equals("CBC")) {
            for (int i = 0; i < datas.length; ++i) {
                encryptedDatas[i] = this.encrypt(datas[i]);
            }
            return encryptedDatas;
        }
        try {
            long[] phContext = new long[]{0L};
            WCSPCO.WCSP_CO_SymmEncryptInit(this.hSecretKey(), this.iv(), 0, phContext);
            this.hContext = phContext[0];
            boolean isECBNoPadding = this.mode().equals("ECB") && this.paddingType() == 0;
            boolean isECBPadding = this.mode().equals("ECB") && this.paddingType() == 1;
            int wholeLength = 0;
            int lastIndex = 0;
            int[] lastIndexOutput = new int[1];
            for (int i = 0; i < datas.length; ++i) {
                byte[] tempData = datas[i];
                if (null == tempData || tempData.length < 1) {
                    throw new IllegalArgumentException("\u8f93\u5165\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5");
                }
                if (tempData.length > 1023) {
                    throw new InvalidParameterException("Input data is too long");
                }
                int tempLength = tempData.length;
                if (isECBNoPadding && tempLength % 16 != 0) {
                    throw new WCSPException("\u8f93\u5165\u6570\u636e\u957f\u5ea6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5");
                }
                if (isECBPadding) {
                    int difL = 16 - tempLength % 16;
                    tempLength += difL;
                }
                if ((wholeLength += tempLength) <= 64512) continue;
                this.encryptECBSplicedData(lastIndex, i - 1, lastIndexOutput, wholeLength -= tempLength, datas, encryptedDatas);
                lastIndex = i;
                wholeLength = tempLength;
            }
            this.encryptECBSplicedData(lastIndex, datas.length - 1, lastIndexOutput, wholeLength, datas, encryptedDatas);
        }
        finally {
            if (0L != this.hContext) {
                try {
                    WCSPCO.WCSP_CO_FreeContext(this.hContext);
                }
                finally {
                    this.hContext = 0L;
                }
            }
        }
        return encryptedDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encryptECBSplicedData(int startIndexInput, int endIndex, int[] startIndexOutput, int wholeLength, byte[][] datas, byte[][] encryptedDatas) throws WCSPException {
        int tempLength;
        byte[] tempData;
        boolean isECBNoPadding = this.mode().equals("ECB") && this.paddingType() == 0;
        boolean isECBPadding = this.mode().equals("ECB") && this.paddingType() == 1;
        int currentGroups = endIndex - startIndexInput + 1;
        int offset = 0;
        int[] dataLengths = new int[currentGroups];
        byte[] splicedData = new byte[wholeLength];
        if (isECBNoPadding) {
            int i = 0;
            int k = startIndexInput;
            while (k <= endIndex) {
                tempData = datas[k];
                dataLengths[i] = tempLength = tempData.length;
                System.arraycopy(tempData, 0, splicedData, offset, tempLength);
                offset += tempLength;
                ++k;
                ++i;
            }
        } else if (isECBPadding) {
            int i = 0;
            int k = startIndexInput;
            while (k <= endIndex) {
                tempData = datas[k];
                tempLength = tempData.length;
                int difL = 16 - tempLength % 16;
                dataLengths[i] = tempLength += difL;
                byte[] tempPadding = new byte[difL];
                for (int j = 0; j < difL; ++j) {
                    tempPadding[j] = (byte)difL;
                }
                System.arraycopy(tempData, 0, splicedData, offset, tempData.length);
                System.arraycopy(tempPadding, 0, splicedData, offset + tempData.length, tempPadding.length);
                offset += tempLength;
                ++k;
                ++i;
            }
        }
        offset = 0;
        if (0L == this.hContext) {
            throw new IllegalStateException("Encryptor object has been finished");
        }
        byte[][] pEncryptedData = new byte[][]{null};
        WCSPCO.WCSP_CO_SymmEncryptUpdate(this.hContext, splicedData, pEncryptedData);
        byte[] encryptedData = pEncryptedData[0];
        if (startIndexOutput[0] == 0) {
            startIndexOutput[0] = startIndexInput;
        }
        if (null != this.remainedData) {
            byte[] missingData = Arrays.copyOfRange(encryptedData, 0, this.missingDataLen);
            tempData = Arrays.copyOf(this.remainedData, this.missingDataLen + this.remainedData.length);
            System.arraycopy(missingData, 0, tempData, this.remainedData.length, this.missingDataLen);
            encryptedDatas[startIndexOutput[0]] = tempData;
            startIndexOutput[0] = startIndexOutput[0] + 1;
            offset += this.missingDataLen;
            this.remainedData = null;
        }
        for (int dataLength : dataLengths) {
            if (encryptedData.length >= offset + dataLength) {
                encryptedDatas[startIndexOutput[0]] = Arrays.copyOfRange(encryptedData, offset, offset + dataLength);
                offset += dataLength;
                startIndexOutput[0] = startIndexOutput[0] + 1;
                continue;
            }
            this.missingDataLen = offset + dataLength - encryptedData.length;
            this.remainedData = Arrays.copyOfRange(encryptedData, offset, encryptedData.length);
        }
        if (datas.length - 1 == endIndex) {
            try {
                tempData = Arrays.copyOfRange(encryptedData, offset, encryptedData.length);
                int lastGroupLen = tempData.length;
                WCSPCO.WCSP_CO_SymmEncryptFinal(this.hContext, pEncryptedData);
                encryptedData = pEncryptedData[0];
                if (encryptedData.length != 0) {
                    tempData = Arrays.copyOf(tempData, lastGroupLen + encryptedData.length);
                    System.arraycopy(encryptedData, 0, tempData, lastGroupLen, encryptedData.length);
                    encryptedDatas[startIndexOutput[0]] = tempData;
                }
            }
            finally {
                this.hContext = 0L;
                this.remainedData = null;
            }
        }
    }

    @Override
    public void close() {
        super.close();
    }

    SymmShortDataEncryptorImpl(String padding, String mode, String algorithm, COServiceImpl coService) {
        super(padding, mode, algorithm, coService);
    }

    @Override
    void init(SecretKey secretKey, byte[] iv) throws InvalidParameterException, InvalidKeyException, WCSPException {
        super.init(secretKey, iv);
    }
}

