/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.SecretKey;
import cn.com.westone.wcspsdk.baseservice.co.ShortDataDecryptor;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.SymmCipherImpl;
import java.util.Arrays;

public class SymmShortDataDecryptorImpl
extends SymmCipherImpl
implements ShortDataDecryptor {
    private long hContext = 0L;
    private byte[] remainedData;
    private int missingDataLen;

    @Override
    public byte[] decrypt(byte[] encData) throws InvalidParameterException, WCSPException {
        if (null == encData || encData.length < 1) {
            throw new IllegalArgumentException("Argument \"encData\" is null");
        }
        if (encData.length > 1024) {
            throw new InvalidParameterException("Input data is too long");
        }
        byte[][] pData = new byte[][]{null};
        WCSPCO.WCSP_CO_SymmDecrypt(this.hSecretKey(), this.iv(), this.paddingType(), encData, pData);
        return pData[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[][] decrypt(byte[][] encDatas) throws InvalidParameterException, WCSPException {
        if (null == encDatas || encDatas.length < 1) {
            throw new IllegalArgumentException("Argument \"encDatas\" is null");
        }
        byte[][] plainDatas = new byte[encDatas.length][];
        if (this.mode().equals("CBC")) {
            for (int i = 0; i < encDatas.length; ++i) {
                plainDatas[i] = this.decrypt(encDatas[i]);
            }
            return plainDatas;
        }
        try {
            long[] phContext = new long[]{0L};
            WCSPCO.WCSP_CO_SymmDecryptInit(this.hSecretKey(), this.iv(), 0, phContext);
            this.hContext = phContext[0];
            int wholeLength = 0;
            int lastIndex = 0;
            int[] lastIndexOutput = new int[1];
            for (int i = 0; i < encDatas.length; ++i) {
                byte[] tempData = encDatas[i];
                if (null == tempData || tempData.length < 1) {
                    throw new IllegalArgumentException("\u8f93\u5165\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5");
                }
                if (tempData.length > 1024) {
                    throw new InvalidParameterException("Input data is too long");
                }
                int tempLength = tempData.length;
                if (tempLength % 16 != 0) {
                    throw new WCSPException("\u8f93\u5165\u6570\u636e\u957f\u5ea6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5");
                }
                if ((wholeLength += tempLength) <= 64512) continue;
                this.decryptECBSplicedData(lastIndex, i - 1, lastIndexOutput, wholeLength -= tempLength, encDatas, plainDatas);
                lastIndex = i;
                wholeLength = tempLength;
            }
            this.decryptECBSplicedData(lastIndex, encDatas.length - 1, lastIndexOutput, wholeLength, encDatas, plainDatas);
        }
        finally {
            if (0L != this.hContext) {
                try {
                    WCSPCO.WCSP_CO_FreeContext(this.hContext);
                }
                finally {
                    this.hContext = 0L;
                }
            }
        }
        return plainDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decryptECBSplicedData(int startIndexInput, int endIndex, int[] startIndexOutput, int wholeLength, byte[][] datas, byte[][] plainDatas) throws WCSPException {
        byte[] tempData;
        boolean isECBNoPadding = this.mode().equals("ECB") && this.paddingType() == 0;
        boolean isECBPadding = this.mode().equals("ECB") && this.paddingType() == 1;
        int currentGroups = endIndex - startIndexInput + 1;
        int offset = 0;
        int[] encDataLengths = new int[currentGroups];
        byte[] splicedData = new byte[wholeLength];
        int i = 0;
        int k = startIndexInput;
        while (k <= endIndex) {
            int tempLength;
            tempData = datas[k];
            encDataLengths[i] = tempLength = tempData.length;
            System.arraycopy(tempData, 0, splicedData, offset, tempLength);
            offset += tempLength;
            ++k;
            ++i;
        }
        offset = 0;
        if (0L == this.hContext) {
            throw new IllegalStateException("Decryptor object has been finalized");
        }
        byte[][] pDecryptedData = new byte[][]{null};
        WCSPCO.WCSP_CO_SymmDecryptUpdate(this.hContext, splicedData, pDecryptedData);
        byte[] decryptedData = pDecryptedData[0];
        if (startIndexOutput[0] == 0) {
            startIndexOutput[0] = startIndexInput;
        }
        if (null != this.remainedData) {
            byte[] byArray = Arrays.copyOfRange(decryptedData, 0, this.missingDataLen);
            tempData = Arrays.copyOf(this.remainedData, this.missingDataLen + this.remainedData.length);
            System.arraycopy(byArray, 0, tempData, this.remainedData.length, this.missingDataLen);
            plainDatas[startIndexOutput[0]] = tempData;
            startIndexOutput[0] = startIndexOutput[0] + 1;
            offset += this.missingDataLen;
            this.remainedData = null;
        }
        if (isECBNoPadding) {
            for (int encDataLength : encDataLengths) {
                if (decryptedData.length >= offset + encDataLength) {
                    plainDatas[startIndexOutput[0]] = Arrays.copyOfRange(decryptedData, offset, offset + encDataLength);
                    startIndexOutput[0] = startIndexOutput[0] + 1;
                    offset += encDataLength;
                    continue;
                }
                this.missingDataLen = offset + encDataLength - decryptedData.length;
                this.remainedData = Arrays.copyOfRange(decryptedData, offset, decryptedData.length);
            }
        } else if (isECBPadding) {
            for (int dataOriLen : encDataLengths) {
                if (decryptedData.length >= offset + dataOriLen) {
                    int paddingLen = decryptedData[offset + dataOriLen - 1];
                    if (paddingLen < 1 || paddingLen > 16) {
                        throw new WCSPException("\u89e3\u5bc6\u5bc6\u6587\u5f02\u5e38");
                    }
                    int realL = dataOriLen - paddingLen;
                    for (int j = 0; j < paddingLen; ++j) {
                        if ((byte)paddingLen == decryptedData[offset + realL + j]) continue;
                        throw new WCSPException("\u89e3\u5bc6\u5bc6\u6587\u5f02\u5e38");
                    }
                    plainDatas[startIndexOutput[0]] = Arrays.copyOfRange(decryptedData, offset, offset + realL);
                    startIndexOutput[0] = startIndexOutput[0] + 1;
                    offset += dataOriLen;
                    continue;
                }
                this.missingDataLen = offset + dataOriLen - decryptedData.length;
                this.remainedData = Arrays.copyOfRange(decryptedData, offset, decryptedData.length);
            }
        }
        if (datas.length - 1 == endIndex) {
            try {
                tempData = Arrays.copyOfRange(decryptedData, offset, decryptedData.length);
                int n = tempData.length;
                WCSPCO.WCSP_CO_SymmDecryptFinal(this.hContext, pDecryptedData);
                decryptedData = pDecryptedData[0];
                if (decryptedData.length != 0) {
                    tempData = Arrays.copyOf(tempData, n + decryptedData.length);
                    System.arraycopy(decryptedData, 0, tempData, n, decryptedData.length);
                    if (isECBPadding) {
                        byte paddingLen = tempData[tempData.length - 1];
                        if (paddingLen < 1 || paddingLen > 16) {
                            throw new WCSPException("\u89e3\u5bc6\u5bc6\u6587\u5f02\u5e38");
                        }
                        plainDatas[startIndexOutput[0]] = Arrays.copyOfRange(tempData, 0, tempData.length - paddingLen);
                    } else {
                        plainDatas[startIndexOutput[0]] = tempData;
                    }
                }
            }
            finally {
                this.hContext = 0L;
                this.remainedData = null;
            }
        }
    }

    @Override
    public void close() {
        super.close();
    }

    SymmShortDataDecryptorImpl(String padding, String mode, String algorithm, COServiceImpl coService) {
        super(padding, mode, algorithm, coService);
    }

    @Override
    void init(SecretKey secretKey, byte[] iv) throws InvalidParameterException, InvalidKeyException, WCSPException {
        super.init(secretKey, iv);
    }
}

