/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.ShortDataVerifier;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.SignatureImpl;

public class ShortDataVerifierImpl
extends SignatureImpl
implements ShortDataVerifier {
    ShortDataVerifierImpl(String algorithm, COServiceImpl coService) {
        super(algorithm, coService);
    }

    @Override
    public boolean verify(byte[] data, byte[] signatureData) throws InvalidParameterException, WCSPException {
        if (null == data || data.length < 1 || null == signatureData || signatureData.length < 1) {
            throw new IllegalArgumentException("Argument \"data\" or \"signatureData\" is null");
        }
        if (data.length > 1023) {
            throw new InvalidParameterException("Input data is too long");
        }
        int[] pResult = new int[]{0};
        WCSPCO.WCSP_CO_Verify(this.hPublicKey(), data, signatureData, pResult);
        return pResult[0] == 1;
    }

    @Override
    public void close() {
        super.close();
    }
}

