/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.Identifier;
import cn.com.westone.wcspsdk.baseservice.co.Key;
import cn.com.westone.wcspsdk.baseservice.co.PublicKey;
import cn.com.westone.wcspsdk.baseservice.co.SessionKey;
import cn.com.westone.wcspsdk.baseservice.km.KMKey;
import cn.com.westone.wcspsdk.baseservice.km.KMPublicKey;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.PrivateKeyImpl;
import cn.com.westone.wcspsdk.impl.co.PublicKeyImpl;
import cn.com.westone.wcspsdk.impl.co.SecretKeyImpl;
import cn.com.westone.wcspsdk.impl.jni.COServiceJNI;
import cn.com.westone.wcspsdk.impl.jni.JNIUtils;

public class SessionKeyImpl
extends SecretKeyImpl
implements SessionKey {
    private final byte[] wrappedKeyData;
    private final Key protectionKey;

    @Override
    public String name() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getWrapped() {
        return this.wrappedKeyData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getWrapped(PublicKey otherProtectionKey) throws InvalidKeyException, WCSPException {
        Object phPublicKey;
        Object hProtectionKey;
        long hDeProtectionKey;
        byte[][] pWrappedKeyData = new byte[][]{null};
        long[] phPrivateKey = new long[]{0L};
        if (this.protectionKey instanceof PrivateKeyImpl) {
            hDeProtectionKey = ((PrivateKeyImpl)this.protectionKey).handle();
        } else if (this.protectionKey instanceof KMKey) {
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPrivateKeyHandleFromKms IN hCOService[{}{}] privateKeyId[{}]", "0x", this.service().handle(), ((KMKey)this.protectionKey).keyId());
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPrivateKeyHandleFromKms", COServiceJNI.wcsp_CO_GetPrivateKeyHandleFromKms(this.service().handle(), ((KMKey)this.protectionKey).keyId(), phPrivateKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPrivateKeyHandleFromKms OUT hPrivateKey[{}{}]", "0x", phPrivateKey[0]);
            hDeProtectionKey = phPrivateKey[0];
        } else if (this.protectionKey instanceof Identifier) {
            JNIUtils.WCSP_LOG_D("wcsp_CO_GetPrivateKeyHandleFromSM9IdByVersion IN hCOService[{}{}] algorithmId[{}{}] usage[{}] version[{}] identity[{}]", "0x", this.service().handle(), "0x", 264192, 1, ((Identifier)this.protectionKey).version(), ((Identifier)this.protectionKey).identity());
            JNIUtils.WCSP_CHECK("wcsp_CO_GetPrivateKeyHandleFromSM9IdByVersion", COServiceJNI.wcsp_CO_GetPrivateKeyHandleFromSM9IdByVersion(this.service().handle(), 264192, 1, ((Identifier)this.protectionKey).version(), ((Identifier)this.protectionKey).identity(), phPrivateKey), new int[0]);
            JNIUtils.WCSP_LOG_D("wcsp_CO_GetPrivateKeyHandleFromSM9IdByVersion OUT hPrivateKey[{}{}]", "0x", phPrivateKey[0]);
            hDeProtectionKey = phPrivateKey[0];
        } else if (this.protectionKey instanceof PublicKeyImpl) {
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPrivateKeyHandle IN hCOService[{}{}] name[{}] usageId[{}]", "0x", this.service().handle(), this.protectionKey.name(), 1);
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPrivateKeyHandle", COServiceJNI.wcsp_CO_GetPrivateKeyHandle(this.service().handle(), this.protectionKey.name(), 1, phPrivateKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPrivateKeyHandle OUT hPrivateKey[{}{}]", "0x", phPrivateKey[0]);
            hDeProtectionKey = phPrivateKey[0];
        } else {
            throw new InvalidKeyException("Invalid privateKey object");
        }
        if (null == otherProtectionKey) {
            throw new IllegalArgumentException("Argument \"otherProtectionKey\" is null");
        }
        switch (otherProtectionKey.usage()) {
            case "ENC": {
                break;
            }
            default: {
                throw new InvalidKeyException("Invalid publicKey usage: " + otherProtectionKey.usage());
            }
        }
        if (otherProtectionKey instanceof PublicKeyImpl) {
            hProtectionKey = ((PublicKeyImpl)otherProtectionKey).handle();
        } else if (otherProtectionKey instanceof KMPublicKey) {
            phPublicKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromKms IN hCOService[{}{}] publicKeyId[{}]", "0x", this.service().handle(), ((KMPublicKey)otherProtectionKey).keyId());
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPublicKeyHandleFromKms", COServiceJNI.wcsp_CO_GetPublicKeyHandleFromKms(this.service().handle(), ((KMPublicKey)otherProtectionKey).keyId(), (long[])phPublicKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromKms OUT hPublicKey[{}{}]", "0x", (long)phPublicKey[0]);
            hProtectionKey = phPublicKey[0];
        } else if (otherProtectionKey instanceof Identifier) {
            switch (otherProtectionKey.algorithm()) {
                case "SM9": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid publicKey algorithm: " + otherProtectionKey.algorithm());
                }
            }
            phPublicKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("wcsp_CO_GetPublicKeyHandleFromSM9IdByVersion IN hCOService[{}{}] algorithmId[{}{}] usage[{}] version[{}] identity[{}]", "0x", this.service().handle(), "0x", 264192, 1, ((Identifier)((Object)otherProtectionKey)).version(), ((Identifier)((Object)otherProtectionKey)).identity());
            JNIUtils.WCSP_CHECK("wcsp_CO_GetPublicKeyHandleFromSM9IdByVersion", COServiceJNI.wcsp_CO_GetPublicKeyHandleFromSM9IdByVersion(this.service().handle(), 264192, 1, ((Identifier)((Object)otherProtectionKey)).version(), ((Identifier)((Object)otherProtectionKey)).identity(), (long[])phPublicKey), new int[0]);
            JNIUtils.WCSP_LOG_D("wcsp_CO_GetPublicKeyHandleFromSM9IdByVersion OUT hPublicKey[{}{}]", "0x", (long)phPublicKey[0]);
            hProtectionKey = phPublicKey[0];
        } else {
            phPublicKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromData IN hCOService[{}{}] publicKeyData[{}]", "0x", this.service().handle(), otherProtectionKey.getKeyData());
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPublicKeyHandleFromData", COServiceJNI.wcsp_CO_GetPublicKeyHandleFromData(this.service().handle(), otherProtectionKey.getKeyData(), (long[])phPublicKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromData OUT hPublicKey[{}{}]", "0x", (long)phPublicKey[0]);
            hProtectionKey = phPublicKey[0];
        }
        try {
            WCSPCO.WCSP_CO_WrapKey(hDeProtectionKey, this.wrappedKeyData, hProtectionKey, pWrappedKeyData);
        }
        finally {
            this.closeHandle(hDeProtectionKey, (long)hProtectionKey, otherProtectionKey);
        }
        return pWrappedKeyData[0];
    }

    private void closeHandle(long hDeProtectionKey, long hProtectionKey, PublicKey otherProtectionKey) {
        try {
            if (!(this.protectionKey instanceof PrivateKeyImpl)) {
                WCSPCO.WCSP_CO_CloseHandle(hDeProtectionKey);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (0L != hProtectionKey && !(otherProtectionKey instanceof PublicKeyImpl)) {
                WCSPCO.WCSP_CO_CloseHandle(hProtectionKey);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void remove() throws WCSPException {
        super.remove();
    }

    SessionKeyImpl(long handle, String algorithm, COServiceImpl coService, byte[] wrappedKeyData, Key protectionKey) {
        super(handle, "ENC", null, algorithm, coService);
        this.wrappedKeyData = wrappedKeyData;
        this.protectionKey = protectionKey;
    }
}

