/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.FileEncryptor;
import cn.com.westone.wcspsdk.baseservice.co.PublicKey;
import cn.com.westone.wcspsdk.baseservice.co.SecretKey;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.FileCipherImpl;
import java.util.Arrays;

public class FileTransformEncryptorImpl
extends FileCipherImpl
implements FileEncryptor {
    private long hContext = 0L;
    private long updated = 0L;

    @Override
    public byte[] update(byte[] input) throws WCSPException {
        return this.update(input, 0, input.length);
    }

    @Override
    public byte[] update(byte[] input, int offset, int length) throws WCSPException {
        if (null == input || input.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (offset < 0) {
            offset += input.length;
        }
        if (offset < 0 || input.length <= offset || length < 1 || offset + length > input.length) {
            throw new IllegalArgumentException("Argument \"offset\" or \"length\" is illegal");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("FileTransformEncryptor object has been finished");
        }
        if (FileTransformEncryptorImpl.needTrunc(input.length, length)) {
            input = Arrays.copyOfRange(input, offset, offset + length);
            offset = 0;
        }
        byte[][] pOutput = new byte[][]{null};
        WCSPCO.WCSP_CO_Stream_TransformUpdate(this.hContext, input, offset, length, pOutput);
        this.updated += (long)length;
        return pOutput[0];
    }

    @Override
    public byte[] doFinal() throws WCSPException {
        if (this.updated < 1L) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("FileTransformEncryptor object has been finished");
        }
        byte[][] pOutput = new byte[][]{null};
        try {
            WCSPCO.WCSP_CO_Stream_TransformFinal(this.hContext, pOutput);
        }
        finally {
            this.updated = 0L;
            this.hContext = 0L;
        }
        return pOutput[0];
    }

    @Override
    public byte[] doFinal(byte[] input) throws WCSPException {
        return this.doFinal(input, 0, input.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] doFinal(byte[] input, int offset, int length) throws WCSPException {
        if (null == input || input.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (offset < 0) {
            offset += input.length;
        }
        if (offset < 0 || input.length <= offset || length < 1 || offset + length > input.length) {
            throw new IllegalArgumentException("Argument \"offset\" or \"length\" is illegal");
        }
        if (0L == this.hContext) {
            throw new IllegalStateException("FileTransformEncryptor object has been finished");
        }
        if (FileTransformEncryptorImpl.needTrunc(input.length, length)) {
            input = Arrays.copyOfRange(input, offset, offset + length);
            offset = 0;
        }
        byte[][] pOutput = new byte[][]{null};
        try {
            WCSPCO.WCSP_CO_Stream_TransformFinal(this.hContext, input, offset, length, pOutput);
        }
        finally {
            this.updated = 0L;
            this.hContext = 0L;
        }
        return pOutput[0];
    }

    @Override
    public void reset() throws WCSPException {
        if (0L == this.hKey()) {
            throw new IllegalStateException("FileTransformEncryptor object has been finalized");
        }
        if (0L != this.hContext) {
            if (this.updated < 1L) {
                return;
            }
            try {
                WCSPCO.WCSP_CO_FreeContext(this.hContext);
            }
            finally {
                this.updated = 0L;
                this.hContext = 0L;
            }
        }
        long[] phContext = new long[]{0L};
        WCSPCO.WCSP_CO_Stream_TransformInit(this.hKey(), phContext);
        this.hContext = phContext[0];
        this.updated = 0L;
    }

    @Override
    public void close() {
        if (0L != this.hContext) {
            try {
                WCSPCO.WCSP_CO_FreeContext(this.hContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updated = 0L;
            this.hContext = 0L;
        }
        super.close();
    }

    FileTransformEncryptorImpl(String algorithm, COServiceImpl coService) {
        super(algorithm, coService);
    }

    @Override
    void init(SecretKey secretKey) throws InvalidKeyException, WCSPException {
        super.init(secretKey);
        long[] phContext = new long[]{0L};
        WCSPCO.WCSP_CO_Stream_TransformInit(this.hKey(), phContext);
        this.hContext = phContext[0];
        this.updated = 0L;
    }

    @Override
    void init(PublicKey publicKey) throws InvalidKeyException, WCSPException {
        super.init(publicKey);
        long[] phContext = new long[]{0L};
        WCSPCO.WCSP_CO_Stream_TransformInit(this.hKey(), phContext);
        this.hContext = phContext[0];
        this.updated = 0L;
    }
}

