/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.Identifier;
import cn.com.westone.wcspsdk.baseservice.co.Key;
import cn.com.westone.wcspsdk.baseservice.co.PublicKey;
import cn.com.westone.wcspsdk.baseservice.co.SecretKey;
import cn.com.westone.wcspsdk.baseservice.km.KMPublicKey;
import cn.com.westone.wcspsdk.baseservice.km.KMSecretKey;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.COObjectImpl;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.KeyImpl;
import cn.com.westone.wcspsdk.impl.co.PublicKeyImpl;
import cn.com.westone.wcspsdk.impl.co.SecretKeyImpl;
import cn.com.westone.wcspsdk.impl.co.TriStageOperator;
import cn.com.westone.wcspsdk.impl.jni.COServiceJNI;
import cn.com.westone.wcspsdk.impl.jni.JNIUtils;

public abstract class FileCipherImpl
extends COObjectImpl
implements TriStageOperator {
    private long hKey = 0L;
    private Key key = null;

    public Key key() {
        return this.key;
    }

    @Override
    public void close() {
        if (0L != this.hKey) {
            try {
                if (!(this.key instanceof KeyImpl)) {
                    WCSPCO.WCSP_CO_CloseHandle(this.hKey);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hKey = 0L;
        }
    }

    static boolean needTrunc(int totalLength, int needLength) {
        return totalLength >> 1 > needLength;
    }

    FileCipherImpl(String algorithm, COServiceImpl coService) {
        super(algorithm, coService);
    }

    void init(SecretKey secretKey) throws InvalidKeyException, WCSPException {
        if (null == secretKey) {
            throw new IllegalArgumentException("Argument \"secretKey\" is null");
        }
        switch (secretKey.usage()) {
            case "ENC": {
                break;
            }
            default: {
                throw new InvalidKeyException("Invalid secretKey usage: " + secretKey.usage());
            }
        }
        if (secretKey instanceof SecretKeyImpl) {
            switch (secretKey.algorithm()) {
                case "SM4_ECB": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid secretKey algorithm: " + secretKey.algorithm());
                }
            }
            this.hKey = ((SecretKeyImpl)secretKey).handle();
        } else if (secretKey instanceof KMSecretKey) {
            switch (secretKey.algorithm()) {
                case "SM4": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid secretKey algorithm: " + secretKey.algorithm());
                }
            }
            long[] phSecretKey = new long[]{0L};
            WCSPCO.WCSP_CO_ImportSessionKeyFromKms(this.service().handle(), 1025, ((KMSecretKey)secretKey).keyId(), phSecretKey);
            this.hKey = phSecretKey[0];
        } else {
            throw new InvalidKeyException("Invalid secretKey object");
        }
        this.key = secretKey;
    }

    void init(PublicKey publicKey) throws InvalidKeyException, WCSPException {
        Object phPublicKey;
        if (null == publicKey) {
            throw new IllegalArgumentException("Argument \"publicKey\" is null");
        }
        switch (publicKey.usage()) {
            case "ENC": {
                break;
            }
            default: {
                throw new InvalidKeyException("Invalid publicKey usage: " + publicKey.usage());
            }
        }
        if (publicKey instanceof PublicKeyImpl) {
            switch (publicKey.algorithm()) {
                case "SM2": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid publicKey algorithm: " + publicKey.algorithm());
                }
            }
            this.hKey = ((PublicKeyImpl)publicKey).handle();
        } else if (publicKey instanceof KMPublicKey) {
            switch (publicKey.algorithm()) {
                case "SM2": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid publicKey algorithm: " + publicKey.algorithm());
                }
            }
            phPublicKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromKms IN hCOService[{}{}] publicKeyId[{}]", "0x", this.service().handle(), ((KMPublicKey)publicKey).keyId());
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPublicKeyHandleFromKms", COServiceJNI.wcsp_CO_GetPublicKeyHandleFromKms(this.service().handle(), ((KMPublicKey)publicKey).keyId(), (long[])phPublicKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromKms OUT hPublicKey[{}{}]", "0x", (long)phPublicKey[0]);
            this.hKey = (long)phPublicKey[0];
        } else if (publicKey instanceof Identifier) {
            switch (publicKey.algorithm()) {
                case "SM9": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid publicKey algorithm: " + publicKey.algorithm());
                }
            }
            phPublicKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromSM9IdByVersion IN hCOService[{}{}] algorithmId[{}{}] usage[{}] version[{}] identity[{}]", "0x", this.service().handle(), "0x", 264192, 1, ((Identifier)((Object)publicKey)).version(), ((Identifier)((Object)publicKey)).identity());
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPublicKeyHandleFromSM9IdByVersion", COServiceJNI.wcsp_CO_GetPublicKeyHandleFromSM9IdByVersion(this.service().handle(), 264192, 1, ((Identifier)((Object)publicKey)).version(), ((Identifier)((Object)publicKey)).identity(), (long[])phPublicKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromSM9IdByVersion OUT hPublicKey[{}{}]", "0x", (long)phPublicKey[0]);
            this.hKey = (long)phPublicKey[0];
        } else {
            switch (publicKey.algorithm()) {
                case "SM2": {
                    break;
                }
                default: {
                    throw new InvalidKeyException("Invalid publicKey algorithm: " + publicKey.algorithm());
                }
            }
            phPublicKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromData IN hCOService[{}{}] publicKeyData[{}]", "0x", this.service().handle(), publicKey.getKeyData());
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPublicKeyHandleFromData", COServiceJNI.wcsp_CO_GetPublicKeyHandleFromData(this.service().handle(), publicKey.getKeyData(), (long[])phPublicKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromData OUT hPublicKey[{}{}]", "0x", (long)phPublicKey[0]);
            this.hKey = (long)phPublicKey[0];
        }
        this.key = publicKey;
    }

    long hKey() {
        return this.hKey;
    }
}

