/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.Encryptor;
import cn.com.westone.wcspsdk.baseservice.co.PublicKey;
import cn.com.westone.wcspsdk.impl.base.Utils;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.AsymCipherImpl;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;

public class AsymEncryptorImpl
extends AsymCipherImpl
implements Encryptor {
    private byte[] cache = null;

    @Override
    public byte[] update(byte[] input) {
        if (null == input || input.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hPublicKey()) {
            throw new IllegalStateException("Encryptor object has been finalized");
        }
        this.cache = null == this.cache || this.cache.length < 1 ? input : Utils.arrayConcatenate(this.cache, input, new byte[0][]);
        return new byte[0];
    }

    @Override
    public byte[] doFinal() throws WCSPException {
        if (null == this.cache || this.cache.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hPublicKey()) {
            throw new IllegalStateException("Encryptor object has been finalized");
        }
        byte[][] pEncryptedData = new byte[][]{null};
        try {
            WCSPCO.WCSP_CO_AsymEncrypt(this.hPublicKey(), this.cache, pEncryptedData);
        }
        finally {
            this.cache = null;
        }
        return pEncryptedData[0];
    }

    @Override
    public byte[] doFinal(byte[] input) throws WCSPException {
        if (null == input || input.length < 1) {
            throw new IllegalArgumentException("Argument \"input\" is null");
        }
        if (0L == this.hPublicKey()) {
            throw new IllegalStateException("Encryptor object has been finalized");
        }
        this.cache = null == this.cache || this.cache.length < 1 ? input : Utils.arrayConcatenate(this.cache, input, new byte[0][]);
        byte[][] pEncryptedData = new byte[][]{null};
        try {
            WCSPCO.WCSP_CO_AsymEncrypt(this.hPublicKey(), this.cache, pEncryptedData);
        }
        finally {
            this.cache = null;
        }
        return pEncryptedData[0];
    }

    @Override
    public void reset() throws WCSPException {
        if (0L == this.hPublicKey()) {
            throw new IllegalStateException("Encryptor object has been finalized");
        }
        this.cache = null;
    }

    @Override
    public PublicKey key() {
        return this.publicKey();
    }

    @Override
    public void close() {
        this.cache = null;
        super.close();
    }

    AsymEncryptorImpl(String mode, String algorithm, COServiceImpl coService) {
        super(mode, algorithm, coService);
    }

    @Override
    void init(PublicKey publicKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        super.init(publicKey);
        this.cache = null;
    }
}

