/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.co;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.Identifier;
import cn.com.westone.wcspsdk.baseservice.co.Key;
import cn.com.westone.wcspsdk.baseservice.co.PrivateKey;
import cn.com.westone.wcspsdk.baseservice.co.PublicKey;
import cn.com.westone.wcspsdk.baseservice.km.KMPrivateKey;
import cn.com.westone.wcspsdk.baseservice.km.KMPublicKey;
import cn.com.westone.wcspsdk.impl.base.WCSPCO;
import cn.com.westone.wcspsdk.impl.co.COObjectImpl;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.PrivateKeyImpl;
import cn.com.westone.wcspsdk.impl.co.PublicKeyImpl;
import cn.com.westone.wcspsdk.impl.jni.COServiceJNI;
import cn.com.westone.wcspsdk.impl.jni.JNIUtils;

abstract class AsymCipherImpl
extends COObjectImpl {
    private long hPublicKey = 0L;
    private long hPrivateKey = 0L;
    private PublicKey publicKey = null;
    private PrivateKey privateKey = null;
    private final String mode;

    public byte[] iv() {
        throw new UnsupportedOperationException();
    }

    public String padding() {
        throw new UnsupportedOperationException();
    }

    public String mode() {
        return this.mode;
    }

    AsymCipherImpl(String mode, String algorithm, COServiceImpl coService) {
        super(algorithm, coService);
        if (null == mode || mode.isEmpty()) {
            throw new IllegalArgumentException("Argument \"mode\" is null");
        }
        this.mode = mode;
    }

    void init(PublicKey publicKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == publicKey) {
            throw new IllegalArgumentException("Argument \"publicKey\" is null");
        }
        if (publicKey instanceof PublicKeyImpl) {
            this.getAlgorithmId(publicKey);
            this.hPublicKey = ((PublicKeyImpl)publicKey).handle();
        } else if (publicKey instanceof KMPublicKey) {
            this.getAlgorithmId(publicKey);
            long[] phPublicKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromKms IN hCOService[{}{}] publicKeyId[{}]", "0x", this.service().handle(), ((KMPublicKey)publicKey).keyId());
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPublicKeyHandleFromKms", COServiceJNI.wcsp_CO_GetPublicKeyHandleFromKms(this.service().handle(), ((KMPublicKey)publicKey).keyId(), phPublicKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromKms OUT hPublicKey[{}{}]", "0x", phPublicKey[0]);
            this.hPublicKey = phPublicKey[0];
        } else if (publicKey instanceof Identifier) {
            int algorithmId = this.getAlgorithmId((Identifier)((Object)publicKey));
            long[] phPublicKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("wcsp_CO_GetPublicKeyHandleFromSM9IdByVersion IN hCOService[{}{}] algorithmId[{}{}] usage[{}] version[{}] identity[{}]", "0x", this.service().handle(), "0x", algorithmId, 1, ((Identifier)((Object)publicKey)).version(), ((Identifier)((Object)publicKey)).identity());
            JNIUtils.WCSP_CHECK("wcsp_CO_GetPublicKeyHandleFromSM9IdByVersion", COServiceJNI.wcsp_CO_GetPublicKeyHandleFromSM9IdByVersion(this.service().handle(), algorithmId, 1, ((Identifier)((Object)publicKey)).version(), ((Identifier)((Object)publicKey)).identity(), phPublicKey), new int[0]);
            JNIUtils.WCSP_LOG_D("wcsp_CO_GetPublicKeyHandleFromSM9IdByVersion OUT hPublicKey[{}{}]", "0x", phPublicKey[0]);
            this.hPublicKey = phPublicKey[0];
        } else {
            this.getAlgorithmId(publicKey);
            long[] phPublicKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromData IN hCOService[{}{}] publicKeyData[{}]", "0x", this.service().handle(), publicKey.getKeyData());
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPublicKeyHandleFromData", COServiceJNI.wcsp_CO_GetPublicKeyHandleFromData(this.service().handle(), publicKey.getKeyData(), phPublicKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPublicKeyHandleFromData OUT hPublicKey[{}{}]", "0x", phPublicKey[0]);
            this.hPublicKey = phPublicKey[0];
        }
        this.publicKey = publicKey;
    }

    void init(PrivateKey privateKey) throws InvalidParameterException, InvalidKeyException, WCSPException {
        if (null == privateKey) {
            throw new IllegalArgumentException("Argument \"privateKey\" is null");
        }
        if (privateKey instanceof PrivateKeyImpl) {
            this.getAlgorithmId(privateKey);
            this.hPrivateKey = ((PrivateKeyImpl)privateKey).handle();
        } else if (privateKey instanceof KMPrivateKey) {
            this.getAlgorithmId(privateKey);
            long[] phPrivateKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPrivateKeyHandleFromKms IN hCOService[{}{}] privateKeyId[{}]", "0x", this.service().handle(), ((KMPrivateKey)privateKey).keyId());
            JNIUtils.WCSP_CHECK("WCSP_CO_GetPrivateKeyHandleFromKms", COServiceJNI.wcsp_CO_GetPrivateKeyHandleFromKms(this.service().handle(), ((KMPrivateKey)privateKey).keyId(), phPrivateKey), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CO_GetPrivateKeyHandleFromKms OUT hPrivateKey[{}{}]", "0x", phPrivateKey[0]);
            this.hPrivateKey = phPrivateKey[0];
        } else if (privateKey instanceof Identifier) {
            int algorithmId = this.getAlgorithmId((Identifier)((Object)privateKey));
            long[] phPrivateKey = new long[]{0L};
            JNIUtils.WCSP_LOG_D("wcsp_CO_GetPrivateKeyHandleFromSM9IdByVersion IN hCOService[{}{}] algorithmId[{}{}] usage[{}] version[{}] identity[{}]", "0x", this.service().handle(), "0x", algorithmId, 1, ((Identifier)((Object)privateKey)).version(), ((Identifier)((Object)privateKey)).identity());
            JNIUtils.WCSP_CHECK("wcsp_CO_GetPrivateKeyHandleFromSM9IdByVersion", COServiceJNI.wcsp_CO_GetPrivateKeyHandleFromSM9IdByVersion(this.service().handle(), algorithmId, 1, ((Identifier)((Object)privateKey)).version(), ((Identifier)((Object)privateKey)).identity(), phPrivateKey), new int[0]);
            JNIUtils.WCSP_LOG_D("wcsp_CO_GetPrivateKeyHandleFromSM9IdByVersion OUT hPrivateKey[{}{}]", "0x", phPrivateKey[0]);
            this.hPrivateKey = phPrivateKey[0];
        } else {
            throw new InvalidKeyException("Invalid privateKey object");
        }
        this.privateKey = privateKey;
    }

    long hPublicKey() {
        return this.hPublicKey;
    }

    long hPrivateKey() {
        return this.hPrivateKey;
    }

    PublicKey publicKey() {
        return this.publicKey;
    }

    PrivateKey privateKey() {
        return this.privateKey;
    }

    @Override
    void close() {
        if (0L != this.hPublicKey) {
            try {
                if (!(this.publicKey instanceof PublicKeyImpl)) {
                    WCSPCO.WCSP_CO_CloseHandle(this.hPublicKey);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hPublicKey = 0L;
        }
        if (0L != this.hPrivateKey) {
            try {
                if (!(this.privateKey instanceof PrivateKeyImpl)) {
                    WCSPCO.WCSP_CO_CloseHandle(this.hPrivateKey);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hPrivateKey = 0L;
        }
        super.close();
    }

    private int getAlgorithmId(Key key) throws InvalidParameterException, InvalidKeyException {
        int algorithmId;
        block3 : switch (this.algorithm()) {
            case "SM2_ENC": {
                switch (this.mode) {
                    case "XOR": {
                        algorithmId = 133120;
                        break;
                    }
                    default: {
                        throw new InvalidParameterException("Invalid mode: " + this.mode);
                    }
                }
                switch (key.algorithm()) {
                    case "SM2": {
                        break;
                    }
                    default: {
                        throw new InvalidKeyException("Invalid key algorithm: " + key.algorithm());
                    }
                }
                switch (key.usage()) {
                    case "ENC": {
                        break block3;
                    }
                }
                throw new InvalidKeyException("Invalid key usage: " + key.usage());
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + this.algorithm());
            }
        }
        return algorithmId;
    }

    private int getAlgorithmId(Identifier key) throws InvalidParameterException, InvalidKeyException {
        int algorithmId;
        block3 : switch (this.algorithm()) {
            case "SM9_ENC": {
                switch (this.mode) {
                    case "XOR": {
                        algorithmId = 264192;
                        break;
                    }
                    case "ECB": {
                        algorithmId = 264193;
                        break;
                    }
                    default: {
                        throw new InvalidParameterException("Invalid mode: " + this.mode);
                    }
                }
                switch (key.algorithm()) {
                    case "SM9": {
                        break;
                    }
                    default: {
                        throw new InvalidKeyException("Invalid key algorithm: " + key.algorithm());
                    }
                }
                switch (key.usage()) {
                    case "ENC": {
                        break block3;
                    }
                }
                throw new InvalidKeyException("Invalid key usage: " + key.usage());
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + this.algorithm());
            }
        }
        return algorithmId;
    }
}

