/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.ca;

import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.ca.CAService;
import cn.com.westone.wcspsdk.baseservice.co.COService;
import cn.com.westone.wcspsdk.baseservice.co.KeyPair;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.ServiceImpl;
import cn.com.westone.wcspsdk.impl.jni.CAServiceJNI;
import cn.com.westone.wcspsdk.impl.jni.JNIUtils;
import cn.com.westone.wcspsdk.util.ConversionUtils;
import cn.com.westone.wcspsdk.util.SignatureUtils;
import cn.com.westone.wcspsdk.util.cert.PKCS10CSRequest;
import cn.com.westone.wcspsdk.util.cert.X501DName;
import java.math.BigInteger;
import java.time.Instant;

public class CAServiceImpl
extends ServiceImpl
implements CAService {
    public static CAService.PKCS10CSRequestBuilder getPKCS10CSRequestBuilder() {
        return new PKCS10CSRequestBuilderImpl();
    }

    public static CAServiceImpl getInstance(PlatformImpl platform) throws WCSPException {
        if (null == platform) {
            throw new IllegalArgumentException("Argument \"platform\" is null");
        }
        return new CAServiceImpl(platform);
    }

    @Override
    public void init(Object ... args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CAService.SignCertHolder issueSignCert(byte[] csrData, Instant notBefore, Instant notAfter) throws InvalidParameterException, WCSPException {
        if (null == csrData || csrData.length < 1 || null == notBefore || null == notAfter) {
            throw new IllegalArgumentException("Argument \"csrData\" or \"notBefore\" or \"notAfter\" is null");
        }
        if (notBefore.isAfter(notAfter) || notBefore.equals(notAfter)) {
            throw new InvalidParameterException("Invalid validity period");
        }
        long[] phSignCert = new long[]{0L};
        JNIUtils.WCSP_LOG_D("WCSP_CA_IssueSignCert IN hCAService[{}{}] csrData[{}] notBefore[{}] notAfter[{}]", "0x", this.handle(), csrData, notBefore, notAfter);
        JNIUtils.WCSP_CHECK("WCSP_CA_IssueSignCert", CAServiceJNI.wcsp_CA_IssueSignCert(this.handle(), csrData, notBefore.getEpochSecond(), notAfter.getEpochSecond(), phSignCert), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_CA_IssueSignCert OUT hSignCert[{}{}]", "0x", phSignCert[0]);
        byte[][] pSignCertData = new byte[][]{null};
        String[] pSn = new String[]{null};
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial IN hCert[{}{}]", "0x", phSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertSerial", CAServiceJNI.wcsp_CA_GetCertSerial(phSignCert[0], pSn), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial OUT pSn[{}]", pSn[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData IN hCert[{}{}]", "0x", phSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertData", CAServiceJNI.wcsp_CA_GetCertData(phSignCert[0], pSignCertData), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData OUT certData[{}]", new Object[]{pSignCertData[0]});
        }
        catch (Throwable throwable) {
            try {
                JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hCert[{}{}]", "0x", phSignCert[0]);
                JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phSignCert[0]), new int[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hCert[{}{}]", "0x", phSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phSignCert[0]), new int[0]);
        }
        catch (Exception exception) {}
        return new CAService.SignCertHolder(new BigInteger(pSn[0], 16), pSignCertData[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CAService.SignCertHolder updateSignCert(BigInteger sn, byte[] csrData, Instant notBefore, Instant notAfter) throws InvalidParameterException, WCSPException {
        if (null == sn || null == csrData || csrData.length < 1 || null == notBefore || null == notAfter) {
            throw new IllegalArgumentException("Argument \"sn\" or \"csrData\" or \"notBefore\" or \"notAfter\" is null");
        }
        if (notBefore.isAfter(notAfter) || notBefore.equals(notAfter)) {
            throw new InvalidParameterException("Invalid validity period");
        }
        long[] phSignCert = new long[]{0L};
        JNIUtils.WCSP_LOG_D("WCSP_CA_UpdateSignCert IN hCAService[{}{}] sn[{}] csrData[{}] notBefore[{}] notAfter[{}] ", "0x", this.handle(), csrData, notBefore, notAfter);
        JNIUtils.WCSP_CHECK("WCSP_CA_UpdateSignCert", CAServiceJNI.wcsp_CA_UpdateSignCert(this.handle(), sn.toString(16), csrData, notBefore.getEpochSecond(), notAfter.getEpochSecond(), phSignCert), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_CA_UpdateSignCert OUT hSignCert[{}{}]", "0x", phSignCert[0]);
        byte[][] pSignCertData = new byte[][]{null};
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData IN hCert[{}{}]", "0x", phSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertData", CAServiceJNI.wcsp_CA_GetCertData(phSignCert[0], pSignCertData), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData OUT certData[{}]", new Object[]{pSignCertData[0]});
        }
        catch (Throwable throwable) {
            try {
                JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hCert[{}{}]", "0x", phSignCert[0]);
                JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phSignCert[0]), new int[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hCert[{}{}]", "0x", phSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phSignCert[0]), new int[0]);
        }
        catch (Exception exception) {}
        return new CAService.SignCertHolder(sn, pSignCertData[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CAService.SignAndEncCertHolder issueSignAndEncCert(byte[] csrData, Instant notBefore, Instant notAfter) throws InvalidParameterException, WCSPException {
        if (null == csrData || csrData.length < 1 || null == notBefore || null == notAfter) {
            throw new IllegalArgumentException("Argument \"csrData\" \"notBefore\" or \"notAfter\" is null");
        }
        if (notBefore.isAfter(notAfter) || notBefore.equals(notAfter)) {
            throw new InvalidParameterException("Invalid validity period");
        }
        long[] phSignCert = new long[]{0L};
        long[] phEncCert = new long[]{0L};
        byte[][] pEnvelopedKeyPairData = new byte[][]{null};
        JNIUtils.WCSP_LOG_D("WCSP_CA_IssueSignAndEncCert IN hCAService[{}{}] csrData[{}] notBefore[{}] notAfter[{}]", "0x", this.handle(), csrData, notBefore, notAfter);
        JNIUtils.WCSP_CHECK("WCSP_CA_IssueSignAndEncCert", CAServiceJNI.wcsp_CA_IssueSignAndEncCert(this.handle(), csrData, notBefore.getEpochSecond(), notAfter.getEpochSecond(), phSignCert, phEncCert, pEnvelopedKeyPairData), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_CA_IssueSignAndEncCert OUT hSignCert[{}{}] hEncCert[{}{}] pEnvelopedKeyPairData[{}] ", "0x", phSignCert[0], "0x", phEncCert[0], pEnvelopedKeyPairData[0]);
        byte[][] pSignCertData = new byte[][]{null};
        byte[][] pEncCertData = new byte[][]{null};
        String[] pSignSn = new String[]{null};
        String[] pEncSn = new String[]{null};
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial IN hCert[{}{}]", "0x", phSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertSerial", CAServiceJNI.wcsp_CA_GetCertSerial(phSignCert[0], pSignSn), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial OUT pSignSn[{}]", pSignSn[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData IN hCert[{}{}]", "0x", phSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertData", CAServiceJNI.wcsp_CA_GetCertData(phSignCert[0], pSignCertData), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData OUT certData[{}]", new Object[]{pSignCertData[0]});
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial IN hCert[{}{}]", "0x", phEncCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertSerial", CAServiceJNI.wcsp_CA_GetCertSerial(phEncCert[0], pEncSn), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial OUT pEncSn[{}]", pEncSn[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData IN hCert[{}{}]", "0x", phEncCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertData", CAServiceJNI.wcsp_CA_GetCertData(phEncCert[0], pEncCertData), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData OUT certData[{}]", new Object[]{pEncCertData[0]});
        }
        catch (Throwable throwable) {
            try {
                JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hSignCert[{}{}]", "0x", phSignCert[0]);
                JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phSignCert[0]), new int[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hEncCert[{}{}]", "0x", phEncCert[0]);
                JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phEncCert[0]), new int[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hSignCert[{}{}]", "0x", phSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phSignCert[0]), new int[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hEncCert[{}{}]", "0x", phEncCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phEncCert[0]), new int[0]);
        }
        catch (Exception exception) {}
        return new CAService.SignAndEncCertHolder(new BigInteger(pSignSn[0], 16), pSignCertData[0], new BigInteger(pEncSn[0], 16), pEncCertData[0], pEnvelopedKeyPairData[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CAService.SignAndEncCertHolder updateSignAndEncCert(BigInteger sn, byte[] csrData, Instant notBefore, Instant notAfter) throws InvalidParameterException, WCSPException {
        if (null == sn || null == csrData || csrData.length < 1 || null == notBefore || null == notAfter) {
            throw new IllegalArgumentException("Argument \"sn\" or \"csrData\" or \"notBefore\" or \"notAfter\" is null");
        }
        if (notBefore.isAfter(notAfter) || notBefore.equals(notAfter)) {
            throw new InvalidParameterException("Invalid validity period");
        }
        long[] phSignCert = new long[]{0L};
        long[] phEncCert = new long[]{0L};
        byte[][] pEnvelopedKeyPairData = new byte[][]{null};
        JNIUtils.WCSP_LOG_D("WCSP_CA_UpdateSignAndEncCert IN hCAService[{}{}] sn[{}] csrData[{}] notBefore[{}] notAfter[{}] ", "0x", this.handle(), csrData, notBefore, notAfter);
        JNIUtils.WCSP_CHECK("WCSP_CA_UpdateSignAndEncCert", CAServiceJNI.wcsp_CA_UpdateSignAndEncCert(this.handle(), sn.toString(16), csrData, notBefore.getEpochSecond(), notAfter.getEpochSecond(), phSignCert, phEncCert, pEnvelopedKeyPairData), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_CA_UpdateSignAndEncCert OUT hSignCert[{}{}] hEncCert[{}{}] pEnvelopedKeyPairData[{}] ", "0x", phSignCert[0], "0x", phEncCert[0], pEnvelopedKeyPairData[0]);
        byte[][] pSignCertData = new byte[][]{null};
        byte[][] pEncCertData = new byte[][]{null};
        String[] pSignSn = new String[]{null};
        String[] pEncSn = new String[]{null};
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial IN hCert[{}{}]", "0x", phSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertSerial", CAServiceJNI.wcsp_CA_GetCertSerial(phSignCert[0], pSignSn), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial OUT pSignSn[{}]", pSignSn[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData IN hCert[{}{}]", "0x", phSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertData", CAServiceJNI.wcsp_CA_GetCertData(phSignCert[0], pSignCertData), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData OUT certData[{}]", new Object[]{pSignCertData[0]});
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial IN hCert[{}{}]", "0x", phEncCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertSerial", CAServiceJNI.wcsp_CA_GetCertSerial(phEncCert[0], pEncSn), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial OUT pEncSn[{}]", pEncSn[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData IN hCert[{}{}]", "0x", phEncCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertData", CAServiceJNI.wcsp_CA_GetCertData(phEncCert[0], pEncCertData), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData OUT certData[{}]", new Object[]{pEncCertData[0]});
        }
        catch (Throwable throwable) {
            try {
                JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hSignCert[{}{}]", "0x", phSignCert[0]);
                JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phSignCert[0]), new int[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hEncCert[{}{}]", "0x", phEncCert[0]);
                JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phEncCert[0]), new int[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hSignCert[{}{}]", "0x", phSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phSignCert[0]), new int[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hEncCert[{}{}]", "0x", phEncCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phEncCert[0]), new int[0]);
        }
        catch (Exception exception) {}
        return new CAService.SignAndEncCertHolder(new BigInteger(pSignSn[0], 16), pSignCertData[0], new BigInteger(pEncSn[0], 16), pEncCertData[0], pEnvelopedKeyPairData[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CAService.SignCertHolder delaySignCert(BigInteger signSN, Instant notAfter) throws WCSPException {
        if (null == signSN || null == notAfter) {
            throw new IllegalArgumentException("Argument \"signSN\" or \"notAfter\" is null");
        }
        long[] phNewSignCert = new long[]{0L};
        JNIUtils.WCSP_LOG_D("WCSP_CA_DelayCert IN hCAService[{}{}] sn[{}] notAfter[{}]", "0x", this.handle(), signSN.toString(16), notAfter);
        JNIUtils.WCSP_CHECK("WCSP_CA_DelayCert", CAServiceJNI.wcsp_CA_DelaySignCert(this.handle(), signSN.toString(16), notAfter.getEpochSecond(), phNewSignCert), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_CA_DelayCert OUT hNewSignCert[{}{}]", "0x", phNewSignCert[0]);
        byte[][] pCertData = new byte[][]{null};
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData IN hCert[{}{}]", "0x", phNewSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertData", CAServiceJNI.wcsp_CA_GetCertData(phNewSignCert[0], pCertData), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData OUT certData[{}]", new Object[]{pCertData[0]});
        }
        catch (Throwable throwable) {
            try {
                JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hSignCert[{}{}]", "0x", phNewSignCert[0]);
                JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phNewSignCert[0]), new int[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hSignCert[{}{}]", "0x", phNewSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phNewSignCert[0]), new int[0]);
        }
        catch (Exception exception) {}
        return new CAService.SignCertHolder(signSN, pCertData[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CAService.SignAndEncCertHolder delaySignAndEncCert(BigInteger sn, Instant notAfter) throws WCSPException {
        if (null == sn || null == notAfter) {
            throw new IllegalArgumentException("Argument \"sn\" or \"notAfter\" is null");
        }
        long[] phNewSignCert = new long[]{0L};
        long[] phNewEncCert = new long[]{0L};
        JNIUtils.WCSP_LOG_D("WCSP_CA_DelayCert IN hCAService[{}{}] sn[{}] notAfter[{}]", "0x", this.handle(), sn.toString(16), notAfter);
        JNIUtils.WCSP_CHECK("WCSP_CA_DelayCert", CAServiceJNI.wcsp_CA_DelaySignAndEncCert(this.handle(), sn.toString(16), notAfter.getEpochSecond(), phNewSignCert, phNewEncCert), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_CA_DelayCert OUT hNewSignCert[{}{}] hNewEncCert[{}{}]", "0x", phNewSignCert[0], "0x", phNewEncCert[0]);
        byte[][] pNewSignCertData = new byte[][]{null};
        byte[][] pNewEncCertData = new byte[][]{null};
        String[] pNewSignSn = new String[]{null};
        String[] pNewEncSn = new String[]{null};
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial IN hCert[{}{}]", "0x", phNewSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertSerial", CAServiceJNI.wcsp_CA_GetCertSerial(phNewSignCert[0], pNewSignSn), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial OUT newSignSn[{}]", pNewSignSn[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData IN hNewSignCert[{}{}]", "0x", phNewSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertData", CAServiceJNI.wcsp_CA_GetCertData(phNewSignCert[0], pNewSignCertData), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData OUT newSignCertData[{}]", new Object[]{pNewSignCertData[0]});
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial IN hCert[{}{}]", "0x", phNewEncCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertSerial", CAServiceJNI.wcsp_CA_GetCertSerial(phNewEncCert[0], pNewEncSn), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial OUT newEncSn[{}]", pNewEncSn[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData IN hNewEncCert[{}{}]", "0x", phNewEncCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertData", CAServiceJNI.wcsp_CA_GetCertData(phNewEncCert[0], pNewEncCertData), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData OUT newEncCertData[{}]", new Object[]{pNewEncCertData[0]});
        }
        catch (Throwable throwable) {
            try {
                JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hSignCert[{}{}]", "0x", phNewSignCert[0]);
                JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phNewSignCert[0]), new int[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hEncCert[{}{}]", "0x", phNewEncCert[0]);
                JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phNewEncCert[0]), new int[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hSignCert[{}{}]", "0x", phNewSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phNewSignCert[0]), new int[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hEncCert[{}{}]", "0x", phNewEncCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phNewEncCert[0]), new int[0]);
        }
        catch (Exception exception) {}
        return new CAService.SignAndEncCertHolder(new BigInteger(pNewSignSn[0], 16), pNewSignCertData[0], new BigInteger(pNewEncSn[0], 16), pNewEncCertData[0], null);
    }

    @Override
    public void freezeSignCert(BigInteger signSN) throws WCSPException {
        if (null == signSN) {
            throw new IllegalArgumentException("Argument \"signSN\" is null");
        }
        JNIUtils.WCSP_LOG_D("WCSP_CA_FreezeSignCert IN hCAService[{}{}] sn[{}]", "0x", this.handle(), signSN.toString(16));
        JNIUtils.WCSP_CHECK("WCSP_CA_FreezeSignCert", CAServiceJNI.wcsp_CA_FreezeSignCert(this.handle(), signSN.toString(16)), new int[0]);
    }

    @Override
    public void freezeSignAndEncCert(BigInteger sn) throws WCSPException {
        if (null == sn) {
            throw new IllegalArgumentException("Argument \"sn\" is null");
        }
        JNIUtils.WCSP_LOG_D("WCSP_CA_FreezeSignAndEncCert IN hCAService[{}{}] sn[{}]", "0x", this.handle(), sn.toString(16));
        JNIUtils.WCSP_CHECK("WCSP_CA_FreezeSignAndEncCert", CAServiceJNI.wcsp_CA_FreezeSignAndEncCert(this.handle(), sn.toString(16)), new int[0]);
    }

    @Override
    public void unfreezeSignCert(BigInteger signSN) throws WCSPException {
        if (null == signSN) {
            throw new IllegalArgumentException("Argument \"signSN\" is null");
        }
        JNIUtils.WCSP_LOG_D("WCSP_CA_UnfreezeSignCert IN hCAService[{}{}] sn[{}]", "0x", this.handle(), signSN.toString(16));
        JNIUtils.WCSP_CHECK("WCSP_CA_UnfreezeSignCert", CAServiceJNI.wcsp_CA_UnfreezeSignCert(this.handle(), signSN.toString(16)), new int[0]);
    }

    @Override
    public void unfreezeSignAndEncCert(BigInteger sn) throws WCSPException {
        if (null == sn) {
            throw new IllegalArgumentException("Argument \"sn\" is null");
        }
        JNIUtils.WCSP_LOG_D("WCSP_CA_UnfreezeSignAndEncCert IN hCAService[{}{}] sn[{}]", "0x", this.handle(), sn.toString(16));
        JNIUtils.WCSP_CHECK("WCSP_CA_UnfreezeSignAndEncCert", CAServiceJNI.wcsp_CA_UnfreezeSignAndEncCert(this.handle(), sn.toString(16)), new int[0]);
    }

    @Override
    public void revokeSignCert(BigInteger signSN, CAService.CRLReason reason) throws WCSPException {
        if (null == signSN || null == reason) {
            throw new IllegalArgumentException("Argument \"signSN\" or \"reason\" is null");
        }
        JNIUtils.WCSP_LOG_D("WCSP_CA_RevokeSignCert IN hCAService[{}{}] sn[{}] reason[{}]", "0x", this.handle(), signSN.toString(16), reason.value);
        JNIUtils.WCSP_CHECK("WCSP_CA_RevokeSignCert", CAServiceJNI.wcsp_CA_RevokeSignCert(this.handle(), signSN.toString(16), reason.value), new int[0]);
    }

    @Override
    public void revokeSignAndEncCert(BigInteger sn, CAService.CRLReason reason) throws WCSPException {
        if (null == sn || null == reason) {
            throw new IllegalArgumentException("Argument \"sn\" or \"reason\" is null");
        }
        JNIUtils.WCSP_LOG_D("WCSP_CA_RevokeSignAndEncCert IN hCAService[{}{}] sn[{}] reason[{}]", "0x", this.handle(), sn.toString(16), reason.value);
        JNIUtils.WCSP_CHECK("WCSP_CA_RevokeSignAndEncCert", CAServiceJNI.wcsp_CA_RevokeSignAndEncCert(this.handle(), sn.toString(16), reason.value), new int[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CAService.SignAndEncCertHolder restoreSignAndEncCert(BigInteger sn, byte[] csrData) throws WCSPException {
        if (null == sn || null == csrData || csrData.length < 1) {
            throw new IllegalArgumentException("Argument \"sn\" or \"csrData\" is null");
        }
        long[] phSignCert = new long[]{0L};
        long[] phEncCert = new long[]{0L};
        byte[][] pEnvelopedKeyPairData = new byte[][]{null};
        JNIUtils.WCSP_LOG_D("WCSP_CA_RestoreSignAndEncCert IN hCAService[{}{}] sn[{}] csrData[{}]", "0x", this.handle(), sn.toString(16), csrData);
        JNIUtils.WCSP_CHECK("WCSP_CA_RestoreSignAndEncCert", CAServiceJNI.wcsp_CA_RestoreSignAndEncCert(this.handle(), sn.toString(16), csrData, phSignCert, phEncCert, pEnvelopedKeyPairData), new int[0]);
        byte[][] pSignCertData = new byte[][]{null};
        byte[][] pEncCertData = new byte[][]{null};
        String[] pSignSn = new String[]{null};
        String[] pEncSn = new String[]{null};
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial IN hCert[{}{}]", "0x", phSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertSerial", CAServiceJNI.wcsp_CA_GetCertSerial(phSignCert[0], pSignSn), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial OUT pSignSn[{}]", pSignSn[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData IN hCert[{}{}]", "0x", phSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertData", CAServiceJNI.wcsp_CA_GetCertData(phSignCert[0], pSignCertData), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData OUT certData[{}]", new Object[]{pSignCertData[0]});
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial IN hCert[{}{}]", "0x", phEncCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertSerial", CAServiceJNI.wcsp_CA_GetCertSerial(phEncCert[0], pEncSn), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertSerial OUT pEncSn[{}]", pEncSn[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData IN hCert[{}{}]", "0x", phEncCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertData", CAServiceJNI.wcsp_CA_GetCertData(phEncCert[0], pEncCertData), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertData OUT certData[{}]", new Object[]{pEncCertData[0]});
        }
        catch (Throwable throwable) {
            try {
                JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hSignCert[{}{}]", "0x", phSignCert[0]);
                JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phSignCert[0]), new int[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hEncCert[{}{}]", "0x", phEncCert[0]);
                JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phEncCert[0]), new int[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hSignCert[{}{}]", "0x", phSignCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phSignCert[0]), new int[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hEncCert[{}{}]", "0x", phEncCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertHandle(phEncCert[0]), new int[0]);
        }
        catch (Exception exception) {}
        return new CAService.SignAndEncCertHolder(new BigInteger(pSignSn[0], 16), pSignCertData[0], new BigInteger(pEncSn[0], 16), pEncCertData[0], null);
    }

    @Override
    public CAService.CertStatus checkCertVaild(BigInteger sn) throws WCSPException {
        if (null == sn) {
            throw new IllegalArgumentException("Argument \"sn\" is null");
        }
        int[] pCertState = new int[]{0};
        JNIUtils.WCSP_LOG_D("WCSP_CA_CheckCertVaild IN hCAService[{}{}] sn[{}]", "0x", this.handle(), sn.toString(16));
        JNIUtils.WCSP_CHECK("WCSP_CA_CheckCertVaild", CAServiceJNI.wcsp_CA_CheckCertVaild(this.handle(), sn.toString(16), pCertState), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_CA_CheckCertVaild OUT certState[{}]", pCertState[0]);
        switch (pCertState[0]) {
            case 0: {
                return CAService.CertStatus.GOOD;
            }
            case 1: {
                return CAService.CertStatus.REVOKED;
            }
            case 2: {
                return CAService.CertStatus.UNKNOWN;
            }
        }
        throw new WCSPException("WCSP_CA_CheckCertVaild unknown certState", pCertState[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getCertChain() throws WCSPException {
        long[] phCert = new long[]{0L};
        JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertChain IN hCAService[{}{}]", "0x", this.handle());
        JNIUtils.WCSP_CHECK("WCSP_CA_GetCertChain", CAServiceJNI.wcsp_CA_GetCertChain(this.handle(), phCert), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertChain OUT hCert[{}{}]", "0x", phCert[0]);
        byte[][] pCertData = new byte[][]{null};
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertChainData IN hCert[{}{}]", "0x", phCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_GetCertChainData", CAServiceJNI.wcsp_CA_GetCertChainData(phCert[0], pCertData), new int[0]);
            JNIUtils.WCSP_LOG_D("WCSP_CA_GetCertChainData OUT certData[{}]", new Object[]{pCertData[0]});
        }
        catch (Throwable throwable) {
            try {
                JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hCert[{}{}]", "0x", phCert[0]);
                JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertChainHandle(phCert[0]), new int[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            JNIUtils.WCSP_LOG_D("WCSP_CA_CloseCertHandle IN hCert[{}{}]", "0x", phCert[0]);
            JNIUtils.WCSP_CHECK("WCSP_CA_CloseCertHandle", CAServiceJNI.wcsp_CA_CloseCertChainHandle(phCert[0]), new int[0]);
        }
        catch (Exception exception) {}
        return pCertData[0];
    }

    private CAServiceImpl(PlatformImpl platform) throws WCSPException {
        super(2, "CA", platform);
    }

    public static class PKCS10CSRequestBuilderImpl
    implements CAService.PKCS10CSRequestBuilder {
        private PKCS10CSRequest.Builder builder = new PKCS10CSRequest.Builder();

        @Override
        public CAService.PKCS10CSRequestBuilder addAttribute(String type, String value) {
            if (null == type || type.isEmpty() || null == value || value.isEmpty()) {
                throw new IllegalArgumentException("Argument \"type\" or \"value\" is null");
            }
            this.builder.addAttribute(type, value);
            return this;
        }

        @Override
        public CAService.PKCS10CSRequestBuilder addAttribute(String type, String[] value) {
            if (null == type || type.isEmpty() || null == value || value.length < 1) {
                throw new IllegalArgumentException("Argument \"type\" or \"value\" is null");
            }
            for (String v : value) {
                if (null != v && !v.isEmpty()) continue;
                throw new IllegalArgumentException("Argument \"value\" is null");
            }
            this.builder.addAttribute(type, value);
            return this;
        }

        @Override
        public CAService.PKCS10CSRequestBuilder addAttribute(String type, byte[] value) {
            if (null == type || type.isEmpty() || null == value || value.length < 1) {
                throw new IllegalArgumentException("Argument \"type\" or \"value\" is null");
            }
            this.builder.addAttribute(type, value);
            return this;
        }

        @Override
        public CAService.PKCS10CSRequestBuilder addAttribute(String type, byte[][] value) {
            if (null == type || type.isEmpty() || null == value || value.length < 1) {
                throw new IllegalArgumentException("Argument \"type\" or \"value\" is null");
            }
            for (byte[] v : value) {
                if (null != v && v.length >= 1) continue;
                throw new IllegalArgumentException("Argument \"value\" is null");
            }
            this.builder.addAttribute(type, value);
            return this;
        }

        @Override
        public byte[] build(KeyPair keyPair, String subjectDN) throws InvalidKeyException, WCSPException {
            if (null == subjectDN || subjectDN.isEmpty()) {
                throw new IllegalArgumentException("Argument \"subjectDN\" is null");
            }
            return this.build(keyPair, X501DName.getInstance(subjectDN));
        }

        @Override
        public byte[] build(KeyPair keyPair, X501DName subjectDN) throws InvalidKeyException, WCSPException {
            if (null == keyPair || null == keyPair.publicKey() || null == keyPair.privateKey() || null == subjectDN) {
                throw new IllegalArgumentException("Argument \"keyPair\" or \"subjectDN\" is null");
            }
            if (!(keyPair.service() instanceof COService)) {
                throw new InvalidKeyException("Invalid keyPair object");
            }
            COService coService = (COService)keyPair.service();
            byte[] publicKeyData = ConversionUtils.SM2PublicKeyData.fromGMT0016(keyPair.publicKey().getKeyData());
            return this.builder.build(subjectDN, publicKeyData, data -> {
                try {
                    return ConversionUtils.SM2SignatureData.fromGMT0016(coService.signDigest(keyPair.privateKey(), SignatureUtils.sm2PreprocessSM3(publicKeyData, data)));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).getEncoded();
        }

        private PKCS10CSRequestBuilderImpl() {
        }
    }
}

