/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.base;

import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.impl.base.JNAWCSPSDK;
import cn.com.westone.wcspsdk.impl.base.JNIWCSPKM;
import cn.com.westone.wcspsdk.impl.base.Utils;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;

public final class WCSPKM {
    public static final int WCSP_KM_KUS_NO_UPDATE = 0;
    public static final int WCSP_KM_KUS_PERIODIC_UPDATE = 1;
    public static final int WCSP_KM_ALG_SM2 = 2;
    public static final int WCSP_KM_ALG_SM4 = 1;
    public static final int WCSP_KM_USAGE_SIGN = 0;
    public static final int WCSP_KM_USAGE_ENC = 1;
    public static final int WCSP_KM_STATUS_ENABLE = 1;
    public static final int WCSP_KM_STATUS_DISABLE = 0;
    public static final int WCSP_KM_STATUS_SCHEDULE_DELETION = 2;
    public static final int WCSP_KM_UAA_ADD = 0;
    public static final int WCSP_KM_UAA_REMOVE = 1;

    public static void WCSP_KM_CreateKeyPair(long hKMService, int algorithmId, String alias, String description, int keyUpdateStrategy, int cycleInDays, int aheadInDays, String[] pKeyId) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] algorithmId[{}] alias[{}] description[{}] keyUpdateStrategy[{}] cycleInDays[{}] aheadInDays[{}]", "0x", hKMService, algorithmId, keyUpdateStrategy, cycleInDays, aheadInDays, alias, description);
        Utils.WCSP_CHECK(JNIWCSPKM.WCSP_KM_CreateKeyPair(hKMService, algorithmId, alias, description, keyUpdateStrategy, cycleInDays, aheadInDays, pKeyId), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT keyId[{}]", pKeyId[0]);
    }

    public static void WCSP_KM_GetKeyPairListByAlias(long hKMService, String alias, int maxKeyIdCount, String[][] pKeyIds) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] alias[{}] maxKeyIdCount[{}]", "0x", hKMService, alias, maxKeyIdCount);
        Pointer jnahKMService = new Pointer(hKMService);
        int ALIAS_SIZE = alias.length() + 1;
        int KEYID_SIZE = 64;
        int COUNT_SIZE = 4;
        Memory jnaMemory = new Memory(ALIAS_SIZE + 64 * maxKeyIdCount + 4);
        long offset = 0L;
        Pointer jnaAlias = jnaMemory.share(offset, ALIAS_SIZE);
        jnaAlias.clear(ALIAS_SIZE);
        jnaAlias.setString(0L, alias);
        Pointer jnapKeyIds = jnaMemory.share(offset += (long)ALIAS_SIZE, 64 * maxKeyIdCount);
        jnapKeyIds.clear(64 * maxKeyIdCount);
        Pointer jnapKeyIdCount = jnaMemory.share(offset += (long)(64 * maxKeyIdCount), 4L);
        jnapKeyIdCount.setInt(0L, maxKeyIdCount);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KM_GetKeyPairListByAlias(jnahKMService, jnaAlias, jnapKeyIds, jnapKeyIdCount), 0, new int[0]);
        int keyIdCount = jnapKeyIdCount.getInt(0L);
        if (keyIdCount < 0) {
            throw new WCSPException("WCSP_KM_GetKeyPairListByAlias failed", 655363);
        }
        if (keyIdCount > maxKeyIdCount) {
            throw new WCSPException("WCSP_KM_GetKeyPairListByAlias failed", 655362);
        }
        pKeyIds[0] = new String[keyIdCount];
        offset = 0L;
        for (int i = 0; i < keyIdCount; ++i) {
            pKeyIds[0][i] = jnapKeyIds.getString(offset);
            offset += 64L;
        }
        Utils.WCSP_LOG_D("OUT keyIds[{}] keyIdCount[{}]", pKeyIds[0], keyIdCount);
    }

    public static void WCSP_KM_GetKeyPairListByAlias(long hKMService, String alias, String[][] pKeyIds) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] alias[{}]", "0x", hKMService, alias);
        Pointer jnaHKMService = new Pointer(hKMService);
        int ALIAS_SIZE = alias.length() + 1;
        int KEYID_SIZE = 64;
        int COUNT_SIZE = 4;
        Memory jnaMemory = new Memory(ALIAS_SIZE + 4);
        long offset = 0L;
        Pointer jnaAlias = jnaMemory.share(offset, ALIAS_SIZE);
        jnaAlias.clear(ALIAS_SIZE);
        jnaAlias.setString(0L, alias);
        Pointer jnapKeyIdCount = jnaMemory.share(offset += (long)ALIAS_SIZE, 4L);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KM_GetKeyPairListByAlias(jnaHKMService, jnaAlias, null, jnapKeyIdCount), 0, new int[0]);
        int keyIdCount = jnapKeyIdCount.getInt(0L);
        if (keyIdCount < 0) {
            throw new WCSPException("WCSP_KM_GetKeyPairListByAlias failed", 655363);
        }
        if (keyIdCount > 0) {
            Memory jnaMemory2 = new Memory(64 * keyIdCount);
            Pointer jnapKeyIds = jnaMemory2.share(0L, 64 * keyIdCount);
            jnapKeyIds.clear(64 * keyIdCount);
            Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KM_GetKeyPairListByAlias(jnaHKMService, jnaAlias, jnapKeyIds, jnapKeyIdCount), 0, new int[0]);
            pKeyIds[0] = new String[keyIdCount];
            offset = 0L;
            for (int i = 0; i < keyIdCount; ++i) {
                pKeyIds[0][i] = jnapKeyIds.getString(offset);
                offset += 64L;
            }
        }
        Utils.WCSP_LOG_D("OUT keyIds[{}] keyIdCount[{}]", pKeyIds[0], keyIdCount);
    }

    public static void WCSP_KM_GetEnvelopedKeyPair(long hKMService, String keyId, byte[] protectionKeyData, byte[][] pEnvelopedKeyPairData) throws WCSPException {
        String[] seqNums = new String[]{"0"};
        byte[][] protectionKeyDatas = new byte[][]{protectionKeyData};
        String[][] pSeqNums = new String[][]{null};
        byte[][][] pEnvelopedKeyPairDatas = new byte[][][]{(byte[][])null};
        WCSPKM.WCSP_KM_GetEnvelopedKeyPairs(hKMService, keyId, seqNums, protectionKeyDatas, pSeqNums, pEnvelopedKeyPairDatas);
        pEnvelopedKeyPairData[0] = null;
        if (seqNums[0].equals(pSeqNums[0][0])) {
            pEnvelopedKeyPairData[0] = pEnvelopedKeyPairDatas[0][0];
        }
    }

    public static void WCSP_KM_GetEnvelopedKeyPairs(long hKMService, String keyId, String[] seqNums, byte[][] protectionKeyDatas, String[][] pSeqNums, byte[][][] pEnvelopedKeyPairDatas) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] keyId[{}] seqNums[{}] protectionKeyDatas[{}]", new Object[]{"0x", hKMService, keyId, seqNums, protectionKeyDatas});
        Utils.WCSP_CHECK(JNIWCSPKM.WCSP_KM_GetEnvelopedKeyPairs(hKMService, keyId, seqNums, protectionKeyDatas, pSeqNums, pEnvelopedKeyPairDatas), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT seqNums[{}] envelopedKeyPairDatas[{}]", new Object[]{pSeqNums[0], pEnvelopedKeyPairDatas[0]});
    }

    public static void WCSP_KM_CreateSecretKey(long hKMService, int algorithmId, String alias, String description, int keyUpdateStrategy, int cycleInDays, int aheadInDays, String[] pKeyId) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] algorithmId[{}] alias[{}] description[{}] keyUpdateStrategy[{}] cycleInDays[{}] aheadInDays[{}]", "0x", hKMService, algorithmId, keyUpdateStrategy, cycleInDays, aheadInDays, alias, description);
        Utils.WCSP_CHECK(JNIWCSPKM.WCSP_KM_CreateSecretKey(hKMService, algorithmId, alias, description, keyUpdateStrategy, cycleInDays, aheadInDays, pKeyId), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT keyId[{}]", pKeyId[0]);
    }

    public static void WCSP_KM_GetSecretKeyListByAlias(long hKMService, String alias, int maxKeyIdCount, String[][] pKeyIds) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] alias[{}] maxKeyIdCount[{}]", "0x", hKMService, alias, maxKeyIdCount);
        Pointer jnahKMService = new Pointer(hKMService);
        int ALIAS_SIZE = alias.length() + 1;
        int KEYID_SIZE = 64;
        int COUNT_SIZE = 4;
        Memory jnaMemory = new Memory(ALIAS_SIZE + 64 * maxKeyIdCount + 4);
        long offset = 0L;
        Pointer jnaAlias = jnaMemory.share(offset, ALIAS_SIZE);
        jnaAlias.clear(ALIAS_SIZE);
        jnaAlias.setString(0L, alias);
        Pointer jnapKeyIds = jnaMemory.share(offset += (long)ALIAS_SIZE, 64 * maxKeyIdCount);
        jnapKeyIds.clear(64 * maxKeyIdCount);
        Pointer jnapKeyIdCount = jnaMemory.share(offset += (long)(64 * maxKeyIdCount), 4L);
        jnapKeyIdCount.setInt(0L, maxKeyIdCount);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KM_GetSecretKeyListByAlias(jnahKMService, jnaAlias, jnapKeyIds, jnapKeyIdCount), 0, new int[0]);
        int keyIdCount = jnapKeyIdCount.getInt(0L);
        if (keyIdCount < 0) {
            throw new WCSPException("WCSP_KM_GetSecretKeyListByAlias failed", 655363);
        }
        if (keyIdCount > maxKeyIdCount) {
            throw new WCSPException("WCSP_KM_GetSecretKeyListByAlias failed", 655362);
        }
        pKeyIds[0] = new String[keyIdCount];
        offset = 0L;
        for (int i = 0; i < keyIdCount; ++i) {
            pKeyIds[0][i] = jnapKeyIds.getString(offset);
            offset += 64L;
        }
        Utils.WCSP_LOG_D("OUT keyIds[{}] keyIdCount[{}]", pKeyIds[0], keyIdCount);
    }

    public static void WCSP_KM_GetSecretKeyListByAlias(long hKMService, String alias, String[][] pKeyIds) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] alias[{}]", "0x", hKMService, alias);
        Pointer jnaHKMService = new Pointer(hKMService);
        int ALIAS_SIZE = alias.length() + 1;
        int KEYID_SIZE = 64;
        int COUNT_SIZE = 4;
        Memory jnaMemory = new Memory(ALIAS_SIZE + 4);
        long offset = 0L;
        Pointer jnaAlias = jnaMemory.share(offset, ALIAS_SIZE);
        jnaAlias.clear(ALIAS_SIZE);
        jnaAlias.setString(0L, alias);
        Pointer jnapKeyIdCount = jnaMemory.share(offset += (long)ALIAS_SIZE, 4L);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KM_GetSecretKeyListByAlias(jnaHKMService, jnaAlias, null, jnapKeyIdCount), 0, new int[0]);
        int keyIdCount = jnapKeyIdCount.getInt(0L);
        if (keyIdCount < 0) {
            throw new WCSPException("WCSP_KM_GetSecretKeyListByAlias failed", 655363);
        }
        if (keyIdCount > 0) {
            Memory jnaMemory2 = new Memory(64 * keyIdCount);
            Pointer jnapKeyIds = jnaMemory2.share(0L, 64 * keyIdCount);
            jnapKeyIds.clear(64 * keyIdCount);
            Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KM_GetSecretKeyListByAlias(jnaHKMService, jnaAlias, jnapKeyIds, jnapKeyIdCount), 0, new int[0]);
            pKeyIds[0] = new String[keyIdCount];
            offset = 0L;
            for (int i = 0; i < keyIdCount; ++i) {
                pKeyIds[0][i] = jnapKeyIds.getString(offset);
                offset += 64L;
            }
        }
        Utils.WCSP_LOG_D("OUT keyIds[{}] keyIdCount[{}]", pKeyIds[0], keyIdCount);
    }

    public static void WCSP_KM_GetWrappedSecretKey(long hKMService, String keyId, byte[] protectionKeyData, byte[][] pWrappedKeyData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] keyId[{}] protectionKeyData[{}]", "0x", hKMService, keyId, protectionKeyData);
        Pointer jnahKMService = new Pointer(hKMService);
        int KEYID_SIZE = keyId.length() + 1;
        int PROTECTIONKEYDATA_SIZE = protectionKeyData.length;
        int WRAPPEDKEYDATA_SIZE = 180;
        int LENGTH_SIZE = 4;
        Memory jnaMemory = new Memory(KEYID_SIZE + PROTECTIONKEYDATA_SIZE + 180 + 4);
        long offset = 0L;
        Pointer jnaKeyId = jnaMemory.share(offset, KEYID_SIZE);
        jnaKeyId.clear(KEYID_SIZE);
        jnaKeyId.setString(0L, keyId);
        Pointer jnaProtectionKeyData = jnaMemory.share(offset += (long)KEYID_SIZE, PROTECTIONKEYDATA_SIZE);
        jnaProtectionKeyData.write(0L, protectionKeyData, 0, PROTECTIONKEYDATA_SIZE);
        Pointer jnapWrappedKeyData = jnaMemory.share(offset += (long)PROTECTIONKEYDATA_SIZE, 180L);
        Pointer jnapWrappedKeyDataLength = jnaMemory.share(offset += 180L, 4L);
        jnapWrappedKeyDataLength.setInt(0L, 180);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KM_GetWrappedSecretKey(jnahKMService, jnaKeyId, jnaProtectionKeyData, PROTECTIONKEYDATA_SIZE, jnapWrappedKeyData, jnapWrappedKeyDataLength), 0, new int[0]);
        int wrappedKeyDataLength = jnapWrappedKeyDataLength.getInt(0L);
        if (wrappedKeyDataLength < 0) {
            throw new WCSPException("WCSP_KM_GetWrappedSecretKey failed", 655363);
        }
        if (wrappedKeyDataLength > 180) {
            throw new WCSPException("WCSP_KM_GetWrappedSecretKey failed", 655362);
        }
        pWrappedKeyData[0] = jnapWrappedKeyData.getByteArray(0L, wrappedKeyDataLength);
        Utils.WCSP_LOG_D("OUT wrappedKeyData[{}]", new Object[]{pWrappedKeyData[0]});
    }

    public static void WCSP_KM_GetWrappedSecretKeyBySecretKey(long hKMService, String keyId, String protectionKeyId, byte[] protectionIV, byte[][] pWrappedKeyData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] keyId[{}] protectionKeyId[{}] protectionIV[{}]", "0x", hKMService, keyId, protectionKeyId, protectionIV);
        Pointer jnahKMService = new Pointer(hKMService);
        int KEYID_SIZE = keyId.length() + 1;
        int PROTECTIONKEYID_SIZE = protectionKeyId.length() + 1;
        int PROTECTIONIV_SIZE = protectionIV.length;
        int WRAPPEDKEYDATA_SIZE = 32;
        int LENGTH_SIZE = 4;
        Memory jnaMemory = new Memory(KEYID_SIZE + PROTECTIONKEYID_SIZE + PROTECTIONIV_SIZE + 32 + 4);
        long offset = 0L;
        Pointer jnaKeyId = jnaMemory.share(offset, KEYID_SIZE);
        jnaKeyId.clear(KEYID_SIZE);
        jnaKeyId.setString(0L, keyId);
        Pointer jnaProtectionKeyId = jnaMemory.share(offset += (long)KEYID_SIZE, PROTECTIONKEYID_SIZE);
        jnaProtectionKeyId.clear(PROTECTIONKEYID_SIZE);
        jnaProtectionKeyId.setString(0L, protectionKeyId);
        Pointer jnaProtectionIV = jnaMemory.share(offset += (long)PROTECTIONKEYID_SIZE, PROTECTIONIV_SIZE);
        jnaProtectionIV.write(0L, protectionIV, 0, PROTECTIONIV_SIZE);
        Pointer jnapWrappedKeyData = jnaMemory.share(offset += (long)PROTECTIONIV_SIZE, 32L);
        Pointer jnapWrappedKeyDataLength = jnaMemory.share(offset += 32L, 4L);
        jnapWrappedKeyDataLength.setInt(0L, 32);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KM_GetWrappedSecretKeyBySecretKey(jnahKMService, jnaKeyId, jnaProtectionKeyId, jnaProtectionIV, PROTECTIONIV_SIZE, jnapWrappedKeyData, jnapWrappedKeyDataLength), 0, new int[0]);
        int wrappedKeyDataLength = jnapWrappedKeyDataLength.getInt(0L);
        if (wrappedKeyDataLength < 0) {
            throw new WCSPException("WCSP_KM_GetWrappedSecretKeyBySecretKey failed", 655363);
        }
        if (wrappedKeyDataLength > 32) {
            throw new WCSPException("WCSP_KM_GetWrappedSecretKeyBySecretKey failed", 655362);
        }
        pWrappedKeyData[0] = jnapWrappedKeyData.getByteArray(0L, wrappedKeyDataLength);
        Utils.WCSP_LOG_D("OUT wrappedKeyData[{}]", new Object[]{pWrappedKeyData[0]});
    }

    public static void WCSP_KM_GetWrappedSecretKeys(long hKMService, String keyId, String[] seqNums, byte[][] protectionKeyDatas, String[][] pSeqNums, byte[][][] pWrappedKeyDatas) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] keyId[{}] seqNums[{}] protectionKeyDatas[{}]", new Object[]{"0x", hKMService, keyId, seqNums, protectionKeyDatas});
        Utils.WCSP_CHECK(JNIWCSPKM.WCSP_KM_GetWrappedSecretKeys(hKMService, keyId, seqNums, protectionKeyDatas, pSeqNums, pWrappedKeyDatas), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT seqNums[{}] wrappedKeyDatas[{}]", new Object[]{pSeqNums[0], pWrappedKeyDatas[0]});
    }

    public static void WCSP_KM_GetVersionedWrappedSecretKeys(long hKMService, String keyId, int[] versions, byte[] protectionKeyData, int[][] pVersions, byte[][][] pWrappedKeyDatas) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] keyId[{}] versions[{}] protectionKeyData[{}]", "0x", hKMService, keyId, versions, protectionKeyData);
        Utils.WCSP_CHECK(JNIWCSPKM.WCSP_KM_GetVersionedWrappedSecretKeys(hKMService, keyId, versions, protectionKeyData, pVersions, pWrappedKeyDatas), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT versions[{}] wrappedKeyDatas[{}]", new Object[]{pVersions[0], pWrappedKeyDatas[0]});
    }

    public static void WCSP_KM_KeyIdStringToObject(String keyId, String[] pName, int[] pVersion) throws WCSPException {
        Utils.WCSP_LOG_D("IN keyId[{}]", keyId);
        Utils.WCSP_CHECK(JNIWCSPKM.WCSP_KM_KeyIdStringToObject(keyId, pName, pVersion), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT name[{}] version[{}]", pName[0], pVersion[0]);
    }

    public static void WCSP_KM_ObjectToKeyIdString(String name, int version, String[] pKeyId) throws WCSPException {
        Utils.WCSP_LOG_D("IN name[{}] version[{}]", name, version);
        Utils.WCSP_CHECK(JNIWCSPKM.WCSP_KM_ObjectToKeyIdString(name, version, pKeyId), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT keyId[{}]", pKeyId[0]);
    }

    public static void WCSP_KM_GetKeyLatestVersion(long hKMService, String keyId, int[] pVersion) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] keyId[{}]", "0x", hKMService, keyId);
        Utils.WCSP_CHECK(JNIWCSPKM.WCSP_KM_GetKeyLatestVersion(hKMService, keyId, pVersion), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT version[{}]", pVersion[0]);
    }

    public static void WCSP_KM_GetKeyMeta(long hKMService, String keyId, int[] pAlgorithmId, int[] pUsageId, String[] pAlias, String[] pDescription, String[] pOrigin, int[] pStatus, long[] pCreateTime, long[] pDestroyTime, int[] pKeyUpdateStrategy, int[] pCycleInDays, int[] pAheadInDays, int[] pLatestVersion) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] keyId[{}]", "0x", hKMService, keyId);
        Utils.WCSP_CHECK(JNIWCSPKM.WCSP_KM_GetKeyMeta(hKMService, keyId, pAlgorithmId, pUsageId, pAlias, pDescription, pOrigin, pStatus, pCreateTime, pDestroyTime, pKeyUpdateStrategy, pCycleInDays, pAheadInDays, pLatestVersion), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT algorithmId[{}] usageId[{}] alias[{}] description[{}] origin[{}] status[{}] createTime[{}] destroyTime[{}] keyUpdateStrategy[{}] cycleInDays[{}] aheadInDays[{}] latestVersion[{}]", pAlgorithmId[0], pUsageId[0], pAlias[0], pDescription[0], pOrigin[0], pStatus[0], pCreateTime[0], pDestroyTime[0], pKeyUpdateStrategy[0], pCycleInDays[0], pAheadInDays[0], pLatestVersion[0]);
    }

    public static void WCSP_KM_UpdateKeyAuthority(long hKMService, String keyId, String[] addAuthUserList, String[] removeAuthUserList) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] keyId[{}] addAuthUserList[{}] removeAuthUserList[{}]", "0x", hKMService, keyId, addAuthUserList, removeAuthUserList);
        Utils.WCSP_CHECK(JNIWCSPKM.WCSP_KM_UpdateKeyAuthority(hKMService, keyId, addAuthUserList, removeAuthUserList), 0, new int[0]);
    }

    public static void WCSP_KM_UpdateAppKeyAuthority(long hKMService, String keyId, int action) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] keyId[{}] action[{}] ", "0x", hKMService, keyId, action);
        Pointer jnaHKMService = new Pointer(hKMService);
        int KEY_ID_SIZE = keyId.length() + 1;
        Memory jnaMemory = new Memory(KEY_ID_SIZE);
        long offset = 0L;
        Pointer jnaKeyId = jnaMemory.share(offset, KEY_ID_SIZE);
        jnaKeyId.clear(KEY_ID_SIZE);
        jnaKeyId.setString(0L, keyId);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KM_UpdateAppKeyAuthority(jnaHKMService, jnaKeyId, action), 0, new int[0]);
    }

    public static void WCSP_KM_RemoveKeyAuthority(long hKMService, String keyId) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] keyId[{}]", "0x", hKMService, keyId);
        Pointer jnaHKMService = new Pointer(hKMService);
        int KEY_ID_SIZE = keyId.length() + 1;
        Memory jnaMemory = new Memory(KEY_ID_SIZE);
        long offset = 0L;
        Pointer jnaKeyId = jnaMemory.share(offset, KEY_ID_SIZE);
        jnaKeyId.clear(KEY_ID_SIZE);
        jnaKeyId.setString(0L, keyId);
        Utils.WCSP_CHECK(JNAWCSPSDK.WCSP_KM_RemoveKeyAuthority(jnaHKMService, jnaKeyId), 0, new int[0]);
    }

    public static void WCSP_KM_GetImportKeyParams(long hKMService, String[] pKeyId, String[] pToken, byte[][] pPublicKeyData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}]", "0x", hKMService);
        Utils.WCSP_CHECK(JNIWCSPKM.WCSP_KM_GetImportKeyParams(hKMService, pKeyId, pToken, pPublicKeyData), 0, new int[0]);
        Utils.WCSP_LOG_D("OUT pKeyId[{}] pToken[{}] pPublicKeyData[{}]", pKeyId[0], pToken[0], pPublicKeyData[0]);
    }

    public static void WCSP_KM_ImportSecretKey(long hKMService, String keyId, String token, byte[] publicKeyData, int algorithmId, int usageId, String alias, String description, int expiryInDays, byte[] wrappedKeyData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] keyId[{}] token[{}] publicKeyData[{}] algorithmId[{}{}] usageId[{}] alias[{}] description[{}] expiryInDays[{}] wrappedKeyData[{}]", "0x", hKMService, keyId, token, publicKeyData, algorithmId, usageId, alias, description, expiryInDays, wrappedKeyData);
        Utils.WCSP_CHECK(JNIWCSPKM.WCSP_KM_ImportSecretKey(hKMService, keyId, token, publicKeyData, algorithmId, usageId, alias, description, expiryInDays, wrappedKeyData), 0, new int[0]);
    }

    public static void WCSP_KM_ImportKeyPair(long hKMService, String keyId, String token, byte[] publicKeyData, int algorithmId, int usageId, String alias, String description, int expiryInDays, byte[] envelopedKeyPairData) throws WCSPException {
        Utils.WCSP_LOG_D("IN hKMService[{}{}] keyId[{}] token[{}] publicKeyData[{}] algorithmId[{}{}] usageId[{}] alias[{}] description[{}] expiryInDays[{}] envelopedKeyPairData[{}]", "0x", hKMService, keyId, token, publicKeyData, algorithmId, usageId, alias, description, expiryInDays, envelopedKeyPairData);
        Utils.WCSP_CHECK(JNIWCSPKM.WCSP_KM_ImportKeyPair(hKMService, keyId, token, publicKeyData, algorithmId, usageId, alias, description, expiryInDays, envelopedKeyPairData), 0, new int[0]);
    }

    private WCSPKM() {
    }
}

