/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.base;

import cn.com.westone.wcspsdk.WCSPException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static int firstStack;
    private static final Logger LOG;

    public static void WCSP_LOG_D(String fmt, Object ... args) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        String func = Thread.currentThread().getStackTrace()[2 + firstStack].getMethodName();
        fmt = func + " " + fmt;
        boolean hexFlag = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof String && ((String)args[i]).equals("0x")) {
                hexFlag = true;
                continue;
            }
            if (hexFlag) {
                if (args[i] instanceof Long) {
                    args[i] = String.format("%016x", args[i]);
                } else if (args[i] instanceof Integer) {
                    args[i] = String.format("%08x", args[i]);
                }
            } else if (args[i] instanceof byte[]) {
                args[i] = Utils.toString((byte[])args[i]);
            } else if (args[i] instanceof String[]) {
                args[i] = Utils.toString((String[])args[i]);
            } else if (args[i] instanceof byte[][]) {
                args[i] = Utils.toString((byte[][])args[i]);
            } else if (args[i] instanceof Instant) {
                args[i] = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.ofInstant((Instant)args[i], ZoneId.systemDefault()));
            }
            hexFlag = false;
        }
        LOG.debug(fmt, args);
    }

    public static void WCSP_LOG_D(String fmt, String[] p1) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        String func = Thread.currentThread().getStackTrace()[2 + firstStack].getMethodName();
        fmt = func + " " + fmt;
        LOG.debug(fmt, (Object)Utils.toString(p1));
    }

    public static byte[] intToByteArrayB(int v) {
        return new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
    }

    public static byte[] intToByteArrayL(int value) {
        return new byte[]{(byte)(value >>> 0 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 24 & 0xFF)};
    }

    public static int byteArrayToIntB(byte[] value) {
        return Utils.byteArrayToIntB(value, 0);
    }

    public static int byteArrayToIntB(byte[] value, int offset) {
        return (value[offset + 0] << 24) + (value[offset + 1] << 16) + (value[offset + 2] << 8) + (value[offset + 3] << 0);
    }

    public static int byteArrayToIntL(byte[] value) {
        return Utils.byteArrayToIntL(value, 0);
    }

    public static int byteArrayToIntL(byte[] value, int offset) {
        return (value[offset + 0] << 0) + (value[offset + 1] << 8) + (value[offset + 2] << 16) + (value[offset + 3] << 24);
    }

    public static byte[] arrayConcatenate(byte[] a, byte[] b, byte[] ... cs) {
        int len = a.length + b.length;
        for (byte[] c : cs) {
            len += c.length;
        }
        byte[] d = Arrays.copyOf(a, len);
        System.arraycopy(b, 0, d, a.length, b.length);
        len = a.length + b.length;
        for (byte[] c : cs) {
            System.arraycopy(c, 0, d, len, c.length);
            len += c.length;
        }
        return d;
    }

    @SafeVarargs
    public static <T> T[] arrayConcatenate(T[] a, T[] b, T[] ... cs) {
        int len = a.length + b.length;
        for (T[] c : cs) {
            len += c.length;
        }
        T[] d = Arrays.copyOf(a, len);
        System.arraycopy(b, 0, d, a.length, b.length);
        len = a.length + b.length;
        for (T[] c : cs) {
            System.arraycopy(c, 0, d, len, c.length);
            len += c.length;
        }
        return d;
    }

    public static boolean arrayEquals(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        return Utils.arrayEquals(a, 0, b, 0, a.length);
    }

    public static boolean arrayEquals(byte[] a, int aOff, byte[] b, int bOff, int len) {
        for (int i = 0; i < len; ++i) {
            if (a[aOff + i] == b[bOff + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean arrayEquals(byte[] array, int off, int len, byte e) {
        for (int i = 0; i < len; ++i) {
            if (e == array[off + i]) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean arrayContains(T[] array, T o) {
        for (T e : array) {
            if (!o.equals(e)) continue;
            return true;
        }
        return false;
    }

    static void WCSP_CHECK(int rc, int c, int ... args) throws WCSPException {
        if (c == rc) {
            return;
        }
        for (int arg : args) {
            if (rc != arg) continue;
            return;
        }
        String func = Thread.currentThread().getStackTrace()[2 + firstStack].getMethodName();
        throw new WCSPException(func + " failed", rc);
    }

    private static String toString(byte[] data) {
        if (null == data || data.length < 1) {
            return "0{}";
        }
        StringBuilder builder = new StringBuilder(data.length * 3 - 1 + 2 + 5);
        builder.append(data.length).append('{');
        for (byte e : data) {
            builder.append(String.format("%02x ", e));
        }
        builder.setCharAt(builder.length() - 1, '}');
        return builder.toString();
    }

    private static String toString(String[] data) {
        if (null == data || data.length < 1) {
            return "0{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(data.length).append('{');
        for (String e : data) {
            builder.append("\"");
            builder.append(e);
            builder.append("\" ");
        }
        builder.setCharAt(builder.length() - 1, '}');
        return builder.toString();
    }

    private static String toString(byte[][] data) {
        if (null == data || data.length < 1) {
            return "0{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(data.length).append('{');
        for (byte[] e : data) {
            builder.append(Utils.toString(e));
            builder.append(" ");
        }
        builder.setCharAt(builder.length() - 1, '}');
        return builder.toString();
    }

    private Utils() {
    }

    static {
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        for (firstStack = 0; !(firstStack >= stes.length || stes[firstStack].getClassName().equals("java.lang.Thread") && stes[firstStack].getMethodName().equals("getStackTrace")); ++firstStack) {
        }
        LOG = LoggerFactory.getLogger((String)"WCSP");
    }
}

