/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl;

import cn.com.westone.wcspsdk.AuthAppUserParameterSpec;
import cn.com.westone.wcspsdk.AuthParameterSpec;
import cn.com.westone.wcspsdk.AuthSecretParameterSpec;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.impl.base.Utils;
import cn.com.westone.wcspsdk.impl.base.WCSP;
import cn.com.westone.wcspsdk.util.ConversionUtils;
import cn.com.westone.wcspsdk.util.DigestUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class PlatformImpl
implements CryptoServicePlatform {
    private static final OSType osType;
    private static final String osPrefix;
    private static final boolean nosys;
    private static final Path libraryPath;
    private static final boolean nounpack;
    private static final String ANDROID_WORKDIR_STRING = "AndroidApplication";
    private static final String STATEFILE_NAME = "state";
    private static final String DELETED_MARKER = ".xxx";
    private static final String[] wcspLibraries;
    private static final String[] jnaLibraries;
    private static final String[] skfLibraries;
    private static final String[] scmLibraries;
    private static final String[] hsmLibraries;
    private static final String[] allLibraries;
    private static volatile boolean libraryLoaded;
    private static HashMap<String, Boolean> libraryStateMap;
    private static ConcurrentHashMap<String, WorkdirContext> workdirContextMap;
    private ReentrantReadWriteLock stateLock = new ReentrantReadWriteLock();
    private String url;
    private int httpProtocol;
    private Path workdir;
    private String workdirString;
    private byte[] caCertData;
    private String hsmIP;
    private int hsmPort;
    private String androidPackage;
    private boolean workdirPrepared = false;
    private long handle = 0L;
    private volatile String tenantId = null;
    private volatile String appId = null;

    public static PlatformImpl getInstance() {
        if (OSType.UNSPECIFIED == osType) {
            throw new UnsupportedOperationException("Unsupport Operating System");
        }
        return new PlatformImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String tenantId, String appId, Map<String, Object> params) throws InvalidParameterException, WCSPException {
        if (null == tenantId || tenantId.isEmpty() || null == appId || appId.isEmpty() || null == params || params.size() < 1) {
            throw new IllegalArgumentException("Argument \"tenantId\" or \"appId\" or \"params\" is null");
        }
        if (!libraryLoaded) {
            PlatformImpl.loadLibraries();
        }
        Class<PlatformImpl> clazz = PlatformImpl.class;
        synchronized (PlatformImpl.class) {
            this.stateLock.writeLock().lock();
            try {
                if (null != this.tenantId && null != this.appId) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                this.finalize();
                this.initParams(params);
                this.prepareWordir();
                long[] phPlatform = new long[]{0L};
                if (OSType.ANDROID != osType) {
                    WCSP.WCSP_Init(tenantId, appId, this.workdirString, phPlatform);
                } else {
                    WCSP.WCSP_Init(tenantId, appId, this.androidPackage, phPlatform);
                }
                this.handle = phPlatform[0];
                WCSP.WCSP_SetUrl(this.handle, this.url);
                WCSP.WCSP_SetHttpVersion(this.handle, this.httpProtocol);
                WCSP.WCSP_SetHttpsCert(this.handle, this.caCertData);
                if (this.useHSM()) {
                    WCSP.WCSP_SetHsmInfo(this.handle, this.hsmIP, this.hsmPort);
                }
                this.tenantId = tenantId;
                this.appId = appId;
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalize() {
        Class<PlatformImpl> clazz = PlatformImpl.class;
        synchronized (PlatformImpl.class) {
            this.stateLock.writeLock().lock();
            try {
                this.tenantId = null;
                this.appId = null;
                if (0L != this.handle) {
                    try {
                        WCSP.WCSP_Finalize(this.handle);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.handle = 0L;
                }
                if (this.workdirPrepared) {
                    WorkdirContext context;
                    while (null != (context = workdirContextMap.get(this.workdirString))) {
                        int count = context.referenceCount.get();
                        if (count <= 0 || !context.referenceCount.compareAndSet(count, count - 1)) continue;
                        if (1 != count) break;
                        if (null != context.stateFile) {
                            try {
                                context.stateFile.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        workdirContextMap.remove(this.workdirString, context);
                        break;
                    }
                    this.workdirPrepared = false;
                }
                this.initParams();
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void authorize(AuthParameterSpec authParameterSpec) throws InvalidParameterException, WCSPException {
        if (null == authParameterSpec) {
            throw new IllegalArgumentException("Argument \"authParameterSpec\" is null");
        }
        if (authParameterSpec instanceof AuthSecretParameterSpec) {
            AuthSecretParameterSpec authSecretParameterSpec = (AuthSecretParameterSpec)authParameterSpec;
            if (null == authSecretParameterSpec.secret() || authSecretParameterSpec.secret().isEmpty()) {
                throw new IllegalArgumentException("Argument \"secret\" is null");
            }
            WCSP.WCSP_AuthSecret(this.handle, authSecretParameterSpec.secret());
        } else if (authParameterSpec instanceof AuthAppUserParameterSpec) {
            AuthAppUserParameterSpec authAppUserParameterSpec = (AuthAppUserParameterSpec)authParameterSpec;
            if (null == authAppUserParameterSpec.userId() || null == authAppUserParameterSpec.authCode() || authAppUserParameterSpec.authCode().isEmpty()) {
                throw new IllegalArgumentException("Argument \"userId\" or \"authCode\" is null");
            }
            WCSP.WCSP_AuthAppUser(this.handle, authAppUserParameterSpec.userId(), authAppUserParameterSpec.authCode());
        } else {
            throw new InvalidParameterException("Unknown authParameterSpec object");
        }
    }

    @Override
    public String tenantId() {
        return this.tenantId;
    }

    @Override
    public String appId() {
        return this.appId;
    }

    public boolean isServerSDK() {
        if (!libraryLoaded) {
            throw new IllegalStateException("SDK has not been loaded");
        }
        switch (osType) {
            case WINDOWS: 
            case LINUX: 
            case MAC: {
                return null != libraryStateMap.get(hsmLibraries[0]);
            }
        }
        return false;
    }

    public boolean useHSM() {
        this.stateLock.readLock().lock();
        try {
            boolean bl = null != this.hsmIP && !this.hsmIP.isEmpty() && this.hsmPort > 0;
            return bl;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    long handle() {
        return this.handle;
    }

    private static void delete(final Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Files.deleteIfExists(path);
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                try {
                    Files.deleteIfExists(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException ioe) throws IOException {
                block3: {
                    if (null != ioe) {
                        throw ioe;
                    }
                    try {
                        Files.deleteIfExists(dir);
                    }
                    catch (Exception e) {
                        if (!path.equals(dir)) break block3;
                        throw e;
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void markDeleted(Path path) throws IOException {
        try {
            Path markFile = Paths.get(path.toString() + DELETED_MARKER, new String[0]);
            Files.createFile(markFile, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }

    private static Path getTempDir() throws IOException {
        Path tempDir = null;
        String dir = System.getProperty("wcsp.tmpdir");
        if (null == dir || dir.trim().isEmpty()) {
            switch (osType) {
                case MAC: {
                    tempDir = Paths.get(System.getProperty("user.home").trim(), "Library/Caches/WCSP/temp");
                    try {
                        Files.createDirectories(tempDir, new FileAttribute[0]);
                    }
                    catch (Exception e) {
                        tempDir = null;
                    }
                    break;
                }
                case LINUX: {
                    dir = System.getenv("XDG_CACHE_HOME");
                    tempDir = null == dir || dir.trim().isEmpty() ? Paths.get(System.getProperty("user.home").trim(), ".cache/WCSP/temp") : Paths.get(dir.trim(), "WCSP/temp");
                    try {
                        Files.createDirectories(tempDir, new FileAttribute[0]);
                    }
                    catch (Exception e) {
                        tempDir = null;
                    }
                    break;
                }
            }
            if (null == tempDir) {
                tempDir = Paths.get(System.getProperty("java.io.tmpdir").trim(), "wcsp");
            }
        } else {
            tempDir = Paths.get(dir.trim(), new String[0]);
        }
        Files.createDirectories(tempDir, new FileAttribute[0]);
        return tempDir;
    }

    private static Path[] findFiles(Path start, BiPredicate<Path, BasicFileAttributes> matcher) throws IOException {
        try (Stream<Path> stream = Files.find(start, Integer.MAX_VALUE, matcher, new FileVisitOption[0]);){
            Path[] pathArray = (Path[])stream.toArray(Path[]::new);
            return pathArray;
        }
    }

    private static Path[] findFiles(Path start, BiPredicate<Path, BasicFileAttributes> matcher, FileVisitOption option) throws IOException {
        try (Stream<Path> stream = Files.find(start, Integer.MAX_VALUE, matcher, option);){
            Path[] pathArray = (Path[])stream.toArray(Path[]::new);
            return pathArray;
        }
    }

    private static void clearDeletedDir() throws WCSPException {
        try {
            Path[] markFiles;
            Path tempDir = PlatformImpl.getTempDir();
            for (Path markFile : markFiles = PlatformImpl.findFiles(tempDir, (p, a) -> a.isRegularFile() && p.getFileName().toString().endsWith(DELETED_MARKER))) {
                String markFileName = markFile.getFileName().toString();
                String deletedName = markFileName.substring(0, markFileName.length() - DELETED_MARKER.length());
                try {
                    PlatformImpl.delete(markFile.resolveSibling(deletedName));
                    PlatformImpl.delete(markFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new WCSPException("Clear deleted directory failed", e);
        }
    }

    private static String parseLibraryName(Path file) {
        Matcher matcher = Pattern.compile(System.mapLibraryName("(.*)\\") + ".*").matcher(file.getFileName().toString());
        if (!matcher.matches()) {
            return "";
        }
        String matchedName = matcher.group(1);
        for (String libraryName : allLibraries) {
            if (!matchedName.startsWith(libraryName)) continue;
            return libraryName;
        }
        return matchedName;
    }

    private static InputStream getLibraryStream(String libraryName, Path path) throws IOException {
        if (null == path) {
            URL url = PlatformImpl.class.getResource("/cn/com/westone/wcspsdk/impl/jniLibs/" + osPrefix + "/");
            if (null == url) {
                throw new UnsupportedOperationException("OS " + osPrefix + " is not supported");
            }
            if (nounpack && !url.getProtocol().equalsIgnoreCase("file")) {
                throw new UnsupportedOperationException();
            }
            try {
                return new URL(url, System.mapLibraryName(libraryName)).openStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        Path[] files = PlatformImpl.findFiles(path, (p, a) -> !a.isDirectory() && libraryName.equals(PlatformImpl.parseLibraryName(p)), FileVisitOption.FOLLOW_LINKS);
        if (files.length < 1) {
            return null;
        }
        return Files.newInputStream(files[0], new OpenOption[0]);
    }

    private static void copyLibraries(String[] libraryNames, Path sourcePath, Path targetDir, boolean present) throws WCSPException {
        for (int i = 0; i < libraryNames.length; ++i) {
            try (InputStream sourceFile = PlatformImpl.getLibraryStream(libraryNames[i], sourcePath);){
                if (null == sourceFile) {
                    if (!present || 0 != i) continue;
                    if (null != sourcePath) {
                        throw new WCSPException("Library " + libraryNames[i] + " not found");
                    }
                    throw new WCSPException("Library " + libraryNames[i] + " not found in classpath");
                }
                Files.copy(sourceFile, targetDir.resolve(System.mapLibraryName(libraryNames[i])), StandardCopyOption.REPLACE_EXISTING);
                continue;
            }
            catch (WCSPException | UnsupportedOperationException e) {
                throw e;
            }
            catch (Exception e) {
                if (null != sourcePath) {
                    throw new WCSPException("Copy library " + libraryNames[i] + " failed", e);
                }
                throw new WCSPException("Extract library " + libraryNames[i] + " from classpath failed", e);
            }
        }
    }

    private static void compareLibraries(String[] libraryNames, Path sourcePath, Path targetDir) throws WCSPException {
        for (int i = 0; i < libraryNames.length; ++i) {
            try (InputStream sourceFile = PlatformImpl.getLibraryStream(libraryNames[i], sourcePath);){
                if (null == sourceFile) {
                    if (0 != i) continue;
                    if (null != sourcePath) {
                        throw new WCSPException("Library " + libraryNames[i] + " not found");
                    }
                    throw new WCSPException("Library " + libraryNames[i] + " not found in classpath");
                }
                try (InputStream targetFile = Files.newInputStream(targetDir.resolve(System.mapLibraryName(libraryNames[i])), new OpenOption[0]);){
                    int len1;
                    byte[] buf1 = new byte[8129];
                    byte[] buf2 = new byte[buf1.length];
                    boolean areEqual = true;
                    int len2 = 0;
                    while ((len1 = sourceFile.read(buf1)) > -1) {
                        int r = 0;
                        while (len1 > len2 && (r = targetFile.read(buf2, len2, len1 - len2)) > -1) {
                            len2 += r;
                        }
                        if (len1 != len2 || !Utils.arrayEquals(buf1, 0, buf2, 0, len1)) {
                            areEqual = false;
                            break;
                        }
                        len2 = 0;
                    }
                    if (areEqual && targetFile.read() <= -1) continue;
                    if (null != sourcePath) {
                        throw new WCSPException("Compare library " + libraryNames[i] + " failed");
                    }
                    throw new WCSPException("Compare library " + libraryNames[i] + " from classpath failed");
                }
            }
            catch (WCSPException | UnsupportedOperationException e) {
                throw e;
            }
            catch (Exception e) {
                if (null != sourcePath) {
                    throw new WCSPException("Compare library " + libraryNames[i] + " failed", e);
                }
                throw new WCSPException("Compare library " + libraryNames[i] + " from classpath failed", e);
            }
        }
    }

    private static void loadLibrary(String libraryName) throws WCSPException {
        try {
            if (libraryName.equals(jnaLibraries[0])) {
                WCSP.loadJNA();
            } else {
                if (libraryName.equals(wcspLibraries[0]) && libraryStateMap.getOrDefault(jnaLibraries[0], false).booleanValue()) {
                    WCSP.loadWCSP(libraryName);
                }
                System.loadLibrary(libraryName);
            }
            libraryStateMap.put(libraryName, true);
        }
        catch (UnsatisfiedLinkError e) {
            throw new WCSPException("Cannot load library: " + libraryName, e);
        }
        catch (Exception e) {
            throw new WCSPException("Load library " + libraryName + " from syspath failed", e);
        }
    }

    private static void loadLibrary(String libraryName, Path libraryFile) throws WCSPException {
        try {
            if (libraryName.equals(jnaLibraries[0])) {
                WCSP.loadJNA(libraryFile.getParent().toString());
            } else {
                if (libraryName.equals(wcspLibraries[0]) && libraryStateMap.getOrDefault(jnaLibraries[0], false).booleanValue()) {
                    WCSP.loadWCSP(libraryFile.toAbsolutePath().toString());
                }
                System.load(libraryFile.toAbsolutePath().toString());
            }
            libraryStateMap.put(libraryName, true);
        }
        catch (UnsatisfiedLinkError e) {
            throw new WCSPException("Cannot load library: " + libraryName, e);
        }
        catch (Exception e) {
            throw new WCSPException("Load library " + libraryName + " failed", e);
        }
    }

    private static void loadLibrariesFromSyspath() throws WCSPException {
        try {
            PlatformImpl.loadLibrary(skfLibraries[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PlatformImpl.loadLibrary(jnaLibraries[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlatformImpl.loadLibrary(wcspLibraries[0]);
        try {
            PlatformImpl.loadLibrary(hsmLibraries[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void loadLibrariesFromPath(Path path) throws WCSPException {
        try {
            Path[] files;
            Path skfLibraryFile = null;
            Path skf1LibraryFile = null;
            Path jnaLibraryFile = null;
            Path wcspLibraryFile = null;
            for (Path file : files = PlatformImpl.findFiles(path, (p, a) -> !a.isDirectory(), FileVisitOption.FOLLOW_LINKS)) {
                String libraryName = PlatformImpl.parseLibraryName(file);
                if (libraryName.isEmpty()) continue;
                libraryStateMap.putIfAbsent(libraryName, false);
                if (libraryName.equals(skfLibraries[1])) {
                    skf1LibraryFile = file;
                    continue;
                }
                if (libraryName.equals(skfLibraries[0])) {
                    skfLibraryFile = file;
                    continue;
                }
                if (libraryName.equals(jnaLibraries[0])) {
                    jnaLibraryFile = file;
                    continue;
                }
                if (!libraryName.equals(wcspLibraries[0])) continue;
                wcspLibraryFile = file;
            }
            if (null != skf1LibraryFile) {
                PlatformImpl.loadLibrary(skfLibraries[1], skf1LibraryFile);
            }
            if (null != skfLibraryFile) {
                PlatformImpl.loadLibrary(skfLibraries[0], skfLibraryFile);
            }
            if (null != jnaLibraryFile) {
                PlatformImpl.loadLibrary(jnaLibraries[0], jnaLibraryFile);
            }
            if (null == wcspLibraryFile) {
                throw new WCSPException("Library " + wcspLibraries[0] + " not found");
            }
            PlatformImpl.loadLibrary(wcspLibraries[0], wcspLibraryFile);
        }
        catch (WCSPException | UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WCSPException("Load libraries failed", e);
        }
    }

    private static void loadLibrariesFromClasspath() throws WCSPException {
        Path tempDir;
        try {
            tempDir = PlatformImpl.getTempDir();
            tempDir = Files.createTempDirectory(tempDir, "", new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new WCSPException("Get WCSP runtime temporary directory failed", e);
        }
        try {
            PlatformImpl.copyLibraries(wcspLibraries, null, tempDir, true);
            PlatformImpl.copyLibraries(Utils.arrayConcatenate(jnaLibraries, skfLibraries, scmLibraries, hsmLibraries), null, tempDir, false);
            PlatformImpl.loadLibrariesFromPath(tempDir);
        }
        finally {
            try {
                PlatformImpl.delete(tempDir);
            }
            catch (Exception e1) {
                try {
                    PlatformImpl.markDeleted(tempDir);
                }
                catch (Exception e2) {
                    throw new WCSPException("Mark WCSP runtime temporary directory deleted failed", e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibraries() throws WCSPException {
        HashMap<String, Boolean> hashMap = libraryStateMap;
        synchronized (hashMap) {
            if (libraryLoaded) {
                return;
            }
            if (!nounpack) {
                PlatformImpl.clearDeletedDir();
            }
            if (!nosys) {
                PlatformImpl.loadLibrariesFromSyspath();
            } else if (null != libraryPath) {
                PlatformImpl.loadLibrariesFromPath(libraryPath);
            } else {
                PlatformImpl.loadLibrariesFromClasspath();
            }
            libraryLoaded = true;
        }
    }

    private static Map<String, String> readConfig(String config) throws InvalidParameterException {
        HashMap<String, String> configMap = new HashMap<String, String>();
        try (BufferedReader configReader = new BufferedReader(new FileReader(config));){
            String line;
            boolean inSection = false;
            int lineNo = 1;
            while (null != (line = configReader.readLine())) {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("#")) {
                    if (line.startsWith("[") && line.endsWith("]")) {
                        inSection = line.substring(1, line.length() - 1).trim().equalsIgnoreCase("WCSP");
                    } else if (inSection) {
                        int index = line.indexOf("=");
                        if (index < 0) {
                            throw new InvalidParameterException("Config file format error in line " + lineNo);
                        }
                        String key = line.substring(0, index).trim();
                        if (key.isEmpty() || key.matches(".*[=#\"\\[\\] ].*")) {
                            throw new InvalidParameterException("Config file format error in line " + lineNo);
                        }
                        String value = line.substring(index + 1).trim();
                        if (value.startsWith("\"") && value.endsWith("\"")) {
                            value = value.substring(1, value.length() - 1);
                        } else if (value.matches(".*[=#\"\\[\\] ].*")) {
                            throw new InvalidParameterException("Config file format error in line " + lineNo);
                        }
                        configMap.putIfAbsent(key, value);
                    }
                }
                ++lineNo;
            }
        }
        catch (InvalidParameterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidParameterException("Read config file failed", e);
        }
        return configMap;
    }

    private PlatformImpl() {
        this.initParams();
    }

    private void initParams() {
        this.url = null;
        this.httpProtocol = 2;
        this.workdir = OSType.ANDROID != osType ? Paths.get("", new String[0]) : null;
        this.workdirString = OSType.ANDROID != osType ? "" : ANDROID_WORKDIR_STRING;
        this.caCertData = ConversionUtils.Data.fromBase64String("MIICBDCCAaqgAwIBAgIJAPuNNgWsUsI9MAoGCCqBHM9VAYN1MHgxDjAMBgNVBAMMBWVjY2NhMQswCQYDVQQGEwJDTjELMAkGA1UECAwCU0gxCzAJBgNVBAcMAlNIMRIwEAYDVQQKDAlLb2FsIFNvZnQxDDAKBgNVBAsMA1NTTDEdMBsGCSqGSIb3DQEJARYOZWNjY2FAa29hbC5jb20wHhcNMTcwMTA4MjIyMDE1WhcNMjcwMTA2MjIyMDE1WjB4MQ4wDAYDVQQDDAVlY2NjYTELMAkGA1UEBhMCQ04xCzAJBgNVBAgMAlNIMQswCQYDVQQHDAJTSDESMBAGA1UECgwJS29hbCBTb2Z0MQwwCgYDVQQLDANTU0wxHTAbBgkqhkiG9w0BCQEWDmVjY2NhQGtvYWwuY29tMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE7Xayxv9pyv/AeUiSvVC6odH0rupRbSGdygq7yJrgoNrVi2GJfBQSWVrp+sjJh0odn84e//BxRvZcWCMxqEZE0qMdMBswDAYDVR0TBAUwAwEB/zALBgNVHQ8EBAMCAuQwCgYIKoEcz1UBg3UDSAAwRQIgAVIn9NfHzfdq/oLvSaZZYIX+/Rv0ePD8S2zhlnDxFkoCIQDZ9GBYpPH1GJYdSrLdCgZc88IuCg+XaNIW30QwSdwwxg==");
        this.hsmIP = "";
        this.hsmPort = 0;
        this.androidPackage = "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initParams(Map<String, Object> params) throws InvalidParameterException {
        Object object;
        params = new HashMap<String, Object>(params);
        if (OSType.ANDROID != osType) {
            object = params.get("cfgFile");
            if (null != object) {
                if (!(object instanceof String) || ((String)object).isEmpty()) throw new InvalidParameterException("Invalid parameter INIT_PARAM_CFGFILE");
                Map<String, String> config = PlatformImpl.readConfig((String)object);
                String value = config.get("url");
                if (null != value && !value.isEmpty()) {
                    params.putIfAbsent("url", value);
                }
                if (null != (value = config.get("workdir")) && !value.isEmpty()) {
                    params.putIfAbsent("workdir", value);
                    value = config.get("ca");
                    if (null != value && !value.isEmpty()) {
                        if (Files.isRegularFile(Paths.get(value, new String[0]), new LinkOption[0]) && Files.isReadable(Paths.get(value, new String[0]))) {
                            params.putIfAbsent("caCertFile", value);
                        } else {
                            params.putIfAbsent("caCertFile", Paths.get(config.get("workdir"), value).toString());
                        }
                    }
                }
                if (null != (value = config.get("hsmIP")) && !value.isEmpty()) {
                    params.putIfAbsent("hsmIP", value);
                }
                if (null != (value = config.get("hsmPort")) && !value.isEmpty()) {
                    params.putIfAbsent("hsmPort", Integer.valueOf(value));
                }
            }
            if (null != (object = params.get("workdir"))) {
                if (!(object instanceof String)) throw new InvalidParameterException("Invalid parameter INIT_PARAM_WORKDIR");
                this.workdir = Paths.get((String)object, new String[0]);
            }
            this.workdir = this.workdir.toAbsolutePath();
            if (!(Files.isDirectory(this.workdir, new LinkOption[0]) && Files.isReadable(this.workdir) && Files.isWritable(this.workdir))) {
                throw new InvalidParameterException("Parameter INIT_PARAM_WORKDIR is a invalid directory");
            }
            this.workdirString = this.workdir.toString();
        } else {
            object = params.get("androidPackage");
            if (null == object) throw new InvalidParameterException("Missing parameter INIT_PARAM_ANDROID_PACKAGE");
            if (!(object instanceof String) || ((String)object).isEmpty()) throw new InvalidParameterException("Invalid parameter INIT_PARAM_ANDROID_PACKAGE");
            this.androidPackage = (String)object;
        }
        object = params.get("url");
        if (null == object) throw new InvalidParameterException("Missing parameter INIT_PARAM_URL");
        if (!(object instanceof String) || ((String)object).isEmpty()) {
            throw new InvalidParameterException("Invalid parameter INIT_PARAM_URL");
        }
        this.url = (String)object;
        object = params.get("httpProtocol");
        if (null != object) {
            if (!(object instanceof Integer) || (Integer)object <= 0) throw new InvalidParameterException("Invalid parameter INIT_PARAM_HTTP_PROTOCOL");
            this.httpProtocol = (Integer)object;
        }
        if (null != (object = params.get("caCertData"))) {
            if (object instanceof byte[] && ((byte[])object).length > 0) {
                this.caCertData = (byte[])object;
            } else {
                if (!(object instanceof String) || ((String)object).isEmpty()) throw new InvalidParameterException("Invalid parameter INIT_PARAM_CACERTDATA");
                this.caCertData = ConversionUtils.Data.fromBase64String((String)object);
            }
        } else {
            object = params.get("caCertFile");
            if (null != object) {
                if (!(object instanceof String) || ((String)object).isEmpty()) throw new InvalidParameterException("Invalid parameter INIT_PARAM_CACERTFILE");
                try (FileReader reader = new FileReader((String)object);){
                    this.caCertData = ConversionUtils.CertData.fromPEM(reader);
                }
                catch (Exception e) {
                    throw new InvalidParameterException("Invalid parameter INIT_PARAM_CACERTFILE", e);
                }
            }
        }
        object = params.get("hsmIP");
        if (null != object) {
            if (!(object instanceof String) || ((String)object).isEmpty()) throw new InvalidParameterException("Invalid parameter INIT_PARAM_HSM_IP");
            this.hsmIP = (String)object;
        }
        if (null == (object = params.get("hsmPort"))) return;
        if (!(object instanceof Integer) || (Integer)object <= 0) throw new InvalidParameterException("Invalid parameter INIT_PARAM_HSM_PORT");
        this.hsmPort = (Integer)object;
    }

    private byte[] getWordirFingerprint() {
        return DigestUtils.sm3(ConversionUtils.Data.fromUTF8String(this.url + this.hsmIP + this.hsmPort + this.androidPackage));
    }

    private String[] getSKFDeviceLibraries() {
        if (!libraryStateMap.getOrDefault(skfLibraries[0], false).booleanValue()) {
            return new String[0];
        }
        if (null != this.hsmIP && !this.hsmIP.isEmpty() && this.hsmPort > 0) {
            return hsmLibraries;
        }
        return scmLibraries;
    }

    private void initWordir(WorkdirContext context) throws WCSPException {
        try {
            WorkdirContext.access$202(context, this.getWordirFingerprint());
            if (OSType.ANDROID == osType) {
                return;
            }
            context.stateFile = FileChannel.open(this.workdir.resolve(STATEFILE_NAME), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            if (null != context.stateFile.tryLock()) {
                context.stateFile.truncate(0L);
                context.stateFile.write(ByteBuffer.wrap(context.fingerprint));
                if (nosys) {
                    for (String libraryName : Utils.arrayConcatenate(scmLibraries, hsmLibraries, new String[0][])) {
                        try {
                            PlatformImpl.delete(this.workdir.resolve(System.mapLibraryName(libraryName)));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    PlatformImpl.copyLibraries(this.getSKFDeviceLibraries(), libraryPath, this.workdir, true);
                }
            }
            context.stateFile.close();
            context.stateFile = null;
            context.stateFile = FileChannel.open(this.workdir.resolve(STATEFILE_NAME), new OpenOption[0]);
            context.stateFile.lock(0L, Long.MAX_VALUE, true);
            byte[] buf = new byte[context.fingerprint.length];
            if (context.stateFile.size() != (long)context.fingerprint.length || context.stateFile.read(ByteBuffer.wrap(buf)) != context.fingerprint.length || !Utils.arrayEquals(buf, context.fingerprint)) {
                throw new WCSPException("Workdir is being used by different process");
            }
            if (nosys) {
                PlatformImpl.compareLibraries(this.getSKFDeviceLibraries(), libraryPath, this.workdir);
            }
        }
        catch (WCSPException | UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WCSPException("Initialize workdir failed", e);
        }
    }

    private void prepareWordir() throws WCSPException {
        block11: {
            WorkdirContext context;
            int count;
            if (this.workdirPrepared) {
                return;
            }
            WorkdirContext initContext = new WorkdirContext();
            do {
                if (null != (context = workdirContextMap.putIfAbsent(this.workdirString, initContext))) continue;
                try {
                    this.initWordir(initContext);
                    if (!initContext.referenceCount.compareAndSet(0, 1)) {
                        throw new RuntimeException("Unexpected failure");
                    }
                    break block11;
                }
                catch (Exception e1) {
                    if (null != initContext.stateFile) {
                        try {
                            initContext.stateFile.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    workdirContextMap.remove(this.workdirString, initContext);
                    throw e1;
                }
            } while ((count = context.referenceCount.get()) <= 0 || !context.referenceCount.compareAndSet(count, count + 1));
            try {
                if (!Utils.arrayEquals(this.getWordirFingerprint(), context.fingerprint)) {
                    throw new WCSPException("Workdir is being used by different instances");
                }
            }
            catch (Exception e) {
                context.referenceCount.decrementAndGet();
                throw e;
            }
        }
        this.workdirPrepared = true;
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            osType = OSType.WINDOWS;
            osPrefix = "win32-" + System.getProperty("os.arch");
        } else if (osName.startsWith("Linux")) {
            if ("dalvik".equals(System.getProperty("java.vm.name").toLowerCase())) {
                osType = OSType.ANDROID;
                osPrefix = "android-" + System.getProperty("os.arch");
            } else {
                osType = OSType.LINUX;
                osPrefix = "linux-" + System.getProperty("os.arch");
            }
        } else if (osName.startsWith("Mac") || osName.startsWith("Darwin")) {
            osType = OSType.MAC;
            osPrefix = "darwin";
        } else {
            osType = OSType.UNSPECIFIED;
            osPrefix = null;
        }
        String value = System.getProperty("wcsp.library.path", "").trim();
        libraryPath = value.isEmpty() ? null : Paths.get(value, new String[0]);
        switch (osType) {
            case WINDOWS: 
            case LINUX: 
            case MAC: {
                nosys = Boolean.parseBoolean(System.getProperty("wcsp.library.nosys", "true").trim());
                nounpack = Boolean.parseBoolean(System.getProperty("wcsp.library.nounpack", "").trim());
                break;
            }
            case ANDROID: {
                nosys = false;
                nounpack = true;
                break;
            }
            default: {
                nosys = true;
                nounpack = true;
            }
        }
        wcspLibraries = new String[]{"WCSPApi"};
        jnaLibraries = new String[]{"jnidispatch"};
        skfLibraries = new String[]{"SKFApi", "wvcmUtil"};
        scmLibraries = new String[]{"scmsdk"};
        hsmLibraries = new String[]{"hsmapi", "syslog"};
        allLibraries = Utils.arrayConcatenate(wcspLibraries, jnaLibraries, skfLibraries, scmLibraries, hsmLibraries);
        libraryLoaded = false;
        libraryStateMap = new HashMap();
        workdirContextMap = new ConcurrentHashMap();
    }

    private static class WorkdirContext {
        private AtomicInteger referenceCount = new AtomicInteger(0);
        private volatile byte[] fingerprint = null;
        private volatile FileChannel stateFile = null;

        private WorkdirContext() {
        }

        static /* synthetic */ byte[] access$202(WorkdirContext x0, byte[] x1) {
            x0.fingerprint = x1;
            return x1;
        }
    }

    private static enum OSType {
        WINDOWS,
        LINUX,
        MAC,
        ANDROID,
        UNSPECIFIED;

    }
}

