/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.baseservice.co;

import cn.com.westone.wcspsdk.CryptoService;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.Decryptor;
import cn.com.westone.wcspsdk.baseservice.co.Digest;
import cn.com.westone.wcspsdk.baseservice.co.DigestSigner;
import cn.com.westone.wcspsdk.baseservice.co.DigestVerifier;
import cn.com.westone.wcspsdk.baseservice.co.Encryptor;
import cn.com.westone.wcspsdk.baseservice.co.FPEDecryptor;
import cn.com.westone.wcspsdk.baseservice.co.FPEEncryptor;
import cn.com.westone.wcspsdk.baseservice.co.KeyPair;
import cn.com.westone.wcspsdk.baseservice.co.Mac;
import cn.com.westone.wcspsdk.baseservice.co.PrivateKey;
import cn.com.westone.wcspsdk.baseservice.co.PublicKey;
import cn.com.westone.wcspsdk.baseservice.co.SecretKey;
import cn.com.westone.wcspsdk.baseservice.co.SessionKey;
import cn.com.westone.wcspsdk.baseservice.co.ShortDataDecryptor;
import cn.com.westone.wcspsdk.baseservice.co.ShortDataEncryptor;
import cn.com.westone.wcspsdk.baseservice.co.ShortDataMac;
import cn.com.westone.wcspsdk.baseservice.co.ShortDataSigner;
import cn.com.westone.wcspsdk.baseservice.co.ShortDataVerifier;
import cn.com.westone.wcspsdk.baseservice.co.Sign;
import cn.com.westone.wcspsdk.baseservice.co.Signer;
import cn.com.westone.wcspsdk.baseservice.co.Verifier;
import cn.com.westone.wcspsdk.baseservice.co.Verify;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.util.cert.X501DName;
import cn.com.westone.wcspsdk.util.cms.CMSException;

public interface COService
extends CryptoService {
    public static final String SERVICE_TYPE_CO = "CO";
    public static final String SERVICE_TYPE_CO_LOCAL = "CO-LOCAL";
    public static final String SERVICE_TYPE_CO_REMOTE = "CO-REMOTE";
    public static final String ALGORITHM_SM2 = "SM2";
    public static final String ALGORITHM_SM4_ECB = "SM4_ECB";
    public static final String ALGORITHM_SM4_CBC = "SM4_CBC";
    public static final String ALGORITHM_SM4_MAC = "SM4_MAC";
    public static final String ALGORITHM_SM9 = "SM9";
    public static final String KEY_USAGE_SIGN = "SIGN";
    public static final String KEY_USAGE_ENC = "ENC";
    public static final String ALGORITHM_SM2_SIGN = "SM2_SIGN";
    public static final String ALGORITHM_SM2_ENC = "SM2_ENC";
    public static final String ALGORITHM_SM3 = "SM3";
    public static final String ALGORITHM_SM4 = "SM4";
    public static final String ALGORITHM_SM9_SIGN = "SM9_SIGN";
    public static final String ALGORITHM_SM9_ENC = "SM9_ENC";
    public static final String ALGORITHM_SM3_SM2_SIGN = "SM3_SM2_SIGN";
    public static final String ALGORITHM_SM3_SM9_SIGN = "SM3_SM9_SIGN";
    public static final String ALGORITHM_MODE_XOR = "XOR";
    public static final String ALGORITHM_MODE_ECB = "ECB";
    public static final String ALGORITHM_MODE_CBC = "CBC";
    public static final String ALGORITHM_PADDING_NO = "NoPadding";
    public static final String ALGORITHM_PADDING_PKCS7 = "PKCS7Padding";

    public static COService getInstance(CryptoServicePlatform platform) throws WCSPException {
        if (platform instanceof PlatformImpl) {
            return COServiceImpl.getInstance((PlatformImpl)platform);
        }
        throw new UnsupportedOperationException("Unsupport CryptoServicePlatform");
    }

    public static COService getInstance(String type, CryptoServicePlatform platform) throws InvalidParameterException, WCSPException {
        if (platform instanceof PlatformImpl) {
            return COServiceImpl.getInstance(type, (PlatformImpl)platform);
        }
        throw new UnsupportedOperationException("Unsupport CryptoServicePlatform");
    }

    @Override
    public void init(Object ... var1);

    public void verifyPIN(String var1) throws WCSPException;

    public KeyPair generateKeyPair(String var1, String var2, String var3) throws InvalidParameterException, WCSPException;

    public KeyPair importKeyPair(String var1, String var2, byte[] var3, PrivateKey var4) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public KeyPair getKeyPair(String var1, String var2, String var3) throws InvalidParameterException, WCSPException;

    public KeyPair getKeyPair(String var1, String var2) throws InvalidParameterException, WCSPException;

    public SessionKey generateSessionKey(String var1, PublicKey var2) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public SessionKey importSessionKey(String var1, byte[] var2, PrivateKey var3) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Encryptor getEncryptor(SecretKey var1, String var2) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Decryptor getDecryptor(SecretKey var1, String var2) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Encryptor getEncryptor(SecretKey var1, byte[] var2, String var3) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Decryptor getDecryptor(SecretKey var1, byte[] var2, String var3) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Encryptor getEncryptor(SecretKey var1, byte[] var2, String var3, String var4) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Decryptor getDecryptor(SecretKey var1, byte[] var2, String var3, String var4) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Encryptor getEncryptor(PublicKey var1) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Decryptor getDecryptor(PrivateKey var1) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Encryptor getEncryptor(PublicKey var1, String var2) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Decryptor getDecryptor(PrivateKey var1, String var2) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public ShortDataEncryptor getShortDataEncryptor(SecretKey var1, byte[] var2, String var3, String var4) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public ShortDataDecryptor getShortDataDecryptor(SecretKey var1, byte[] var2, String var3, String var4) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public ShortDataEncryptor getShortDataEncryptor(PublicKey var1, String var2) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public ShortDataDecryptor getShortDataDecryptor(PrivateKey var1, String var2) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public byte[] encryptShortData(SecretKey var1, String var2, byte[] var3) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public byte[] decryptShortData(SecretKey var1, String var2, byte[] var3) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public byte[] encryptShortData(SecretKey var1, byte[] var2, String var3, byte[] var4) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public byte[] decryptShortData(SecretKey var1, byte[] var2, String var3, byte[] var4) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public byte[] encryptShortData(SecretKey var1, byte[] var2, String var3, String var4, byte[] var5) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public byte[] decryptShortData(SecretKey var1, byte[] var2, String var3, String var4, byte[] var5) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public byte[] encryptShortData(PublicKey var1, byte[] var2) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public byte[] decryptShortData(PrivateKey var1, byte[] var2) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public byte[] encryptShortData(PublicKey var1, String var2, byte[] var3) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public byte[] decryptShortData(PrivateKey var1, String var2, byte[] var3) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public FPEEncryptor getFPEEncryptor(SecretKey var1) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public FPEDecryptor getFPEDecryptor(SecretKey var1) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Mac getCBCMac(SecretKey var1, byte[] var2, String var3) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public ShortDataMac getShortDataCBCMac(SecretKey var1, byte[] var2, String var3) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Signer getSigner(PrivateKey var1) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Verifier getVerifier(PublicKey var1) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public ShortDataSigner getShortDataSigner(PrivateKey var1) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public ShortDataVerifier getShortDataVerifier(PublicKey var1) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public byte[] signShortData(PrivateKey var1, byte[] var2) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public boolean verifyShortData(PublicKey var1, byte[] var2, byte[] var3) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public DigestSigner getDigestSigner(PrivateKey var1) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public DigestVerifier getDigestVerifier(PublicKey var1) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public byte[] signDigest(PrivateKey var1, byte[] var2) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public boolean verifyDigest(PublicKey var1, byte[] var2, byte[] var3) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Sign getSign(PrivateKey var1) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Verify getVerify(PublicKey var1) throws InvalidParameterException, InvalidKeyException, WCSPException;

    public Digest getDigest(String var1) throws InvalidParameterException, WCSPException;

    public byte[] digestShortData(String var1, byte[] var2) throws InvalidParameterException, WCSPException;

    public byte[] generateRandom(int var1) throws WCSPException;

    public byte[] buildPKCS10CSRequest(KeyPair var1, String var2) throws WCSPException;

    public byte[] buildPKCS10CSRequest(KeyPair var1, X501DName var2) throws WCSPException;

    public void importSignCert(String var1, byte[] var2) throws WCSPException;

    public void importEncCert(String var1, byte[] var2) throws WCSPException;

    public byte[] exportSignCert(String var1) throws WCSPException;

    public byte[] exportEncCert(String var1) throws WCSPException;

    public byte[] generateCMSAttachedSignedData(byte[] var1, PrivateKey var2, byte[] var3) throws CMSException;

    public byte[] generateCMSDetachedSignedData(byte[] var1, PrivateKey var2, byte[] var3) throws CMSException;

    public boolean verifyCMSSignedData(byte[] var1) throws CMSException;

    public boolean verifyCMSSignedData(byte[] var1, byte[] var2) throws CMSException;

    public byte[] encryptCMSEnvelopedData(byte[] var1, byte[] var2) throws CMSException;

    public byte[] decryptCMSEnvelopedData(byte[] var1, PrivateKey var2, byte[] var3) throws CMSException;

    public byte[] encryptCMSSignedAndEnvelopedData(byte[] var1, PrivateKey var2, byte[] var3, byte[] var4) throws CMSException;

    public byte[] decryptCMSSignedAndEnvelopedData(byte[] var1, PrivateKey var2, byte[] var3) throws CMSException;
}

