/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk;

import cn.com.westone.wcspsdk.impl.base.WCSP;

public class WCSPException
extends Exception {
    int errorCode;
    String errorCodeDescription;
    private static final long serialVersionUID = 3832032448074928903L;

    public WCSPException(String message, int errorCode) {
        super(message);
        this.errorCode = errorCode;
        this.errorCodeDescription = WCSP.WCSP_GetErrMessage(errorCode);
    }

    public WCSPException(String message, Throwable cause) {
        super(message, cause);
        this.errorCode = 0;
    }

    public WCSPException(String message) {
        super(message);
        this.errorCode = 0;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        if (0 == this.errorCode) {
            return super.getMessage();
        }
        return super.getMessage() + String.format(" (0x%08x: %s)", this.errorCode, this.errorCodeDescription);
    }
}

