/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.Driver;
import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.TypeInfo;
import com.kingbase8.jdbc.BooleanTypeUtil;
import com.kingbase8.jdbc.EsBlob;
import com.kingbase8.jdbc.EsClob;
import com.kingbase8.jdbc.KbArray;
import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.jdbc.KbSQLXML;
import com.kingbase8.jdbc.PrimitiveArraySupport;
import com.kingbase8.util.HStoreConverter;
import com.kingbase8.util.KBbytea;
import com.kingbase8.util.KBobject;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Map;

public class KbStruct
implements Struct {
    private BaseConnection baseConnection;
    private Object[] attributes;
    private String fieldString;
    private String typeNameT;

    public KbStruct(BaseConnection baseConnection, String typeNameT, int oid, String contents) throws SQLException {
        this.baseConnection = baseConnection;
        this.typeNameT = typeNameT;
        this.attributes = this.getAttributesImpl(oid, contents);
        this.fieldString = contents;
    }

    public KbStruct(BaseConnection baseConnection, String typeNameT, Object[] attributesT) {
        this.baseConnection = baseConnection;
        this.attributes = attributesT;
        this.typeNameT = typeNameT;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.typeNameT;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getAttributes(Map)");
        }
        return this.attributes;
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.attributes;
    }

    private Object[] getAttributesImpl(int oid, String contents) throws SQLException {
        Integer[] oids = this.getElementTypeOfStruct(oid);
        Object[] attributes = new Object[oids.length];
        if (contents.startsWith("(") && contents.endsWith(")")) {
            contents = contents.substring(1, contents.length() - 1);
        }
        char[] aChars = contents.toCharArray();
        int start = 0;
        int j = 0;
        block4: for (int i = 0; i < aChars.length; ++i) {
            char aChar = aChars[i];
            switch (aChar) {
                case '\"': {
                    i = KbStruct.parseDoubleQuotes(aChars, i);
                    continue block4;
                }
                case ',': {
                    String content = new String(aChars, start, i - start);
                    attributes[j] = this.getValue(oids[j], content);
                    ++j;
                    start = i + 1;
                    continue block4;
                }
            }
        }
        if (start < aChars.length) {
            String content = new String(aChars, start, aChars.length - start);
            attributes[j] = this.getValue(oids[j], content);
        }
        return attributes;
    }

    private Integer[] getElementTypeOfStruct(int oid) throws SQLException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        PreparedStatement pst = this.baseConnection.prepareStatement("select a.atttypid from pg_attribute a join pg_type t on a.attrelid = t.typrelid and oid = ? and a.attnum > 0");
        pst.setInt(1, oid);
        ResultSet resultSet = pst.executeQuery();
        while (resultSet.next()) {
            list.add(resultSet.getInt(1));
        }
        return list.toArray(new Integer[0]);
    }

    private static int parseDoubleQuotes(char[] str, int _offset) {
        int _count = 1;
        while (++_offset < str.length && str[_offset] == '\"') {
            ++_count;
        }
        int _count2 = 0;
        while (++_offset < str.length) {
            if (str[_offset] == '\"') {
                if (++_count2 != _count || ++_offset >= str.length || str[_offset] == '\"') continue;
                break;
            }
            _count2 = 0;
        }
        return _offset - 1;
    }

    private Object getValue(int oid, String content) throws SQLException {
        if (content.startsWith("\"") && content.endsWith("\"")) {
            content = content.substring(1, content.length() - 1);
        }
        TypeInfo typeInfo = this.baseConnection.getTypeInfo();
        String kbType = typeInfo.getKBType(oid);
        int type = typeInfo.getSQLType(oid);
        switch (type) {
            case -7: {
                if ("oracle".equals(this.baseConnection.getCompatibleLevel()) || "mysql".equals(this.baseConnection.getCompatibleLevel())) {
                    try {
                        return BooleanTypeUtil.castToBoolean(content, this.baseConnection.getCompatibleLevel());
                    }
                    catch (Exception e) {
                        return content;
                    }
                }
            }
            case 6: 
            case 8: {
                return KbResultSet.toDouble(content);
            }
            case 16: {
                return BooleanTypeUtil.castToBoolean(content, this.baseConnection.getCompatibleLevel());
            }
            case 2009: {
                content = content.replace("\"\"", "\"").replace("\\\\", "\\");
                return new KbSQLXML(this.baseConnection, content);
            }
            case -5: {
                return KbResultSet.toLong(content);
            }
            case 2: 
            case 3: {
                return KbResultSet.toBigDecimal(content);
            }
            case 7: {
                return Float.valueOf(KbResultSet.toFloat(content));
            }
            case -1: 
            case 1: 
            case 12: {
                content = content.replace("\"\"", "\"").replace("\\\\", "\\");
                return content;
            }
            case 91: {
                return this.baseConnection.getTimestampUtils().toDate(null, content);
            }
            case 92: {
                return this.baseConnection.getTimestampUtils().toTime(null, content);
            }
            case 93: {
                return this.baseConnection.getTimestampUtils().toTimestamp(null, content);
            }
            case -6: 
            case 4: 
            case 5: {
                return KbResultSet.toInt(content);
            }
            case -4: 
            case -3: 
            case -2: {
                content = content.replace("\"\"", "\"").replace("\\\\", "\\");
                return KBbytea.toBytes(content.getBytes());
            }
            case 2003: {
                content = content.replace("\"\"", "\"").replace("\\\\", "\\");
                return new KbArray(this.baseConnection, oid, content);
            }
            case 2005: {
                content = content.replace("\"\"", "\"").replace("\\\\", "\\");
                return new EsClob(content.toCharArray());
            }
            case 2004: {
                content = content.replace("\"\"", "\"").replace("\\\\", "\\");
                return new EsBlob(KBbytea.toBytes(content.getBytes()));
            }
            case 2002: {
                while (content.startsWith("\"") && content.endsWith("\"")) {
                    content = content.substring(1, content.length() - 1);
                }
                content = content.replace("\"\"", "\"").replace("\\\\", "\\");
                return new KbStruct(this.baseConnection, kbType, oid, content);
            }
        }
        return content;
    }

    public String toString() {
        if (this.fieldString != null) {
            return this.fieldString;
        }
        this.fieldString = "(";
        for (Object x : this.attributes) {
            if (x == null) {
                this.fieldString = this.fieldString + ",";
                continue;
            }
            if (x instanceof SQLXML) {
                try {
                    this.fieldString = this.fieldString + ((SQLXML)x).getString().replace("\\", "\\\\").replace("\"", "\\\"") + ",";
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (x instanceof byte[]) {
                this.fieldString = this.fieldString + KBbytea.toKBString((byte[])x) + ",";
                continue;
            }
            if (x instanceof Date) {
                this.fieldString = this.fieldString + this.baseConnection.getTimestampUtils().toString(null, (Date)x) + ",";
                continue;
            }
            if (x instanceof Time) {
                this.fieldString = this.fieldString + this.baseConnection.getTimestampUtils().toString(null, (Time)x) + ",";
                continue;
            }
            if (x instanceof Timestamp) {
                this.fieldString = this.fieldString + this.baseConnection.getTimestampUtils().toString(null, (Timestamp)x) + ",";
                continue;
            }
            if (x instanceof Boolean) {
                this.fieldString = this.fieldString + ((Boolean)x != false ? "1" : "0") + ",";
                continue;
            }
            if (x instanceof Blob) {
                try {
                    this.fieldString = this.fieldString + KBbytea.toKBString(((Blob)x).getBytes(1L, (int)((Blob)x).length())) + ",";
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (x instanceof Clob) {
                try {
                    this.fieldString = this.fieldString + ((Clob)x).getSubString(1L, (int)((Clob)x).length()).replace("\\", "\\\\").replace("\"", "\\\"") + ",";
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (x instanceof Array) {
                this.fieldString = this.fieldString + "\"" + x.toString().replace("\"", "\"\"").replace("\\", "\\\\") + "\",";
                continue;
            }
            if (x instanceof KBobject) {
                this.fieldString = this.fieldString + ((KBobject)x).getValue() + ",";
                continue;
            }
            if (x instanceof LocalDate) {
                this.fieldString = this.fieldString + this.baseConnection.getTimestampUtils().toString((LocalDate)x) + ",";
                continue;
            }
            if (x instanceof LocalTime) {
                this.fieldString = this.fieldString + this.baseConnection.getTimestampUtils().toString((LocalTime)x) + ",";
                continue;
            }
            if (x instanceof LocalDateTime) {
                this.fieldString = this.fieldString + this.baseConnection.getTimestampUtils().toString((LocalDateTime)x) + ",";
                continue;
            }
            if (x instanceof OffsetDateTime) {
                this.fieldString = this.fieldString + this.baseConnection.getTimestampUtils().toString((OffsetDateTime)x) + ",";
                continue;
            }
            if (x instanceof Map) {
                this.fieldString = this.fieldString + HStoreConverter.toString((Map)x) + ",";
                continue;
            }
            if (PrimitiveArraySupport.isSupportedPrimitiveArray(x)) {
                PrimitiveArraySupport<Object> arrayToString = PrimitiveArraySupport.getArraySupport(x);
                TypeInfo typeInfo = this.baseConnection.getTypeInfo();
                int oid = arrayToString.getDefaultArrayTypeOid(typeInfo);
                char delimiter = ',';
                try {
                    delimiter = typeInfo.getArrayDelimiter(oid);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.fieldString = this.fieldString + "\"" + arrayToString.toArrayString(delimiter, x).replace("\"", "\"\"").replace("\\", "\\\\") + "\",";
                continue;
            }
            this.fieldString = x instanceof Struct ? this.fieldString + "\"" + x.toString().replace("\"", "\"\"").replace("\\", "\\\\") + "\"," : this.fieldString + x.toString().replace("\\", "\\\\").replace("\"", "\\\"") + ",";
        }
        this.fieldString = (this.fieldString.endsWith(",") ? this.fieldString.substring(0, this.fieldString.length() - 1) : this.fieldString) + ")";
        return this.fieldString;
    }
}

