/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class Oid {
    public static final int UNSPECIFIED = 0;
    public static final int INT2 = 21;
    public static final int INT2_ARRAY = 1005;
    public static final int INT4 = 23;
    public static final int INT4_ARRAY = 1007;
    public static final int INT8 = 20;
    public static final int INT8_ARRAY = 1016;
    public static final int TEXT = 25;
    public static final int TEXT_ARRAY = 1009;
    public static final int NUMERIC = 1700;
    public static final int NUMERIC_ARRAY = 1231;
    public static final int FLOAT4 = 700;
    public static final int FLOAT4_ARRAY = 1021;
    public static final int FLOAT8 = 701;
    public static final int FLOAT8_ARRAY = 1022;
    public static final int BOOL = 16;
    public static final int BOOL_ARRAY = 1000;
    public static final int DATE = 1082;
    public static final int DATE_ARRAY = 1182;
    public static final int TIME = 1083;
    public static final int TIME_ARRAY = 1183;
    public static final int TIMETZ = 1266;
    public static final int TIMETZ_ARRAY = 1270;
    public static final int TIMESTAMP = 1114;
    public static final int TIMESTAMP_ARRAY = 1115;
    public static final int TIMESTAMPTZ = 1184;
    public static final int TIMESTAMPTZ_ARRAY = 1185;
    public static final int BYTEA = 17;
    public static final int BYTEA_ARRAY = 1001;
    public static final int VARCHAR = 1043;
    public static final int VARCHAR_ARRAY = 1015;
    public static final int OID = 26;
    public static final int OID_ARRAY = 1028;
    public static final int BPCHAR = 1042;
    public static final int BPCHAR_ARRAY = 1014;
    public static final int MONEY = 790;
    public static final int MONEY_ARRAY = 791;
    public static final int NAME = 19;
    public static final int NAME_ARRAY = 1003;
    public static final int BIT = 1560;
    public static final int BIT_ARRAY = 1561;
    public static final int VOID = 2278;
    public static final int INTERVAL = 1186;
    public static final int INTERVAL_ARRAY = 1187;
    public static final int CHAR = 18;
    public static final int CHAR_ARRAY = 1002;
    public static final int VARBIT = 1562;
    public static final int VARBIT_ARRAY = 1563;
    public static final int UUID = 2950;
    public static final int UUID_ARRAY = 2951;
    public static final int XML = 142;
    public static final int XML_ARRAY = 143;
    public static final int POINT = 600;
    public static final int POINT_ARRAY = 1017;
    public static final int BOX = 603;
    public static final int JSONB_ARRAY = 3807;
    public static final int JSON = 114;
    public static final int JSON_ARRAY = 199;
    public static final int REF_CURSOR = 1790;
    public static final int REF_CURSOR_ARRAY = 2201;
    public static final int BLOB = 8013;
    public static final int CLOB = 8014;
    public static final int NCLOB = 8015;
    public static final int BPCHARBYTE = 8016;
    public static final int BPCHARBYTE_ARRAY = 8017;
    public static final int VARCHARBYTE = 8018;
    public static final int VARCHARBYTE_ARRAY = 8019;
    public static final int ORA_DATE = 8020;
    public static final int ORA_DATE_ARRAY = 8021;
    public static final int TINYINT = 8100;
    public static final int TINYINT_ARRAY = 8101;
    public static final int TID = 27;
    public static final int TID_ARRAY = 1010;
    public static final int YMINTERVAL = 7002;
    public static final int YMINTERVAL_ARRAY = 7003;
    public static final int DSINTERVAL = 7000;
    public static final int DSINTERVAL_ARRAY = 7001;
    public static final int ROWID = 6123;
    public static final int ROWID_ARRAY = 6124;
    public static final int MEDIUMINT = 7016;
    public static final int MYSQL_DATE = 7944;
    public static final int MYSQL_DATE_ARRAY = -1;
    public static final int MYSQL_TIME = 7950;
    public static final int MYSQL_TIME_ARRAY = 7951;
    public static final int MYSQL_DATETIME = 7952;
    public static final int MYSQL_DATETIME_ARRAY = 7953;
    public static final int MYSQL_TIMESTAMP = 7954;
    public static final int MYSQL_TIMESTAMP_ARRAY = 7955;
    public static final int MEDIUMINT_ARRAY = -1;
    public static final int MIDDLEINT = 7017;
    public static final int MIDDLEINT_ARRAY = -1;
    public static final int INT1 = 7014;
    public static final int INT1_ARRAY = -1;
    public static final int INT3 = 7015;
    public static final int INT3_ARRAY = -1;
    public static final int LONGTEXT = 7018;
    public static final int LONGTEXT_ARRAY = -1;
    public static final int MEDIUMTEXT = 7019;
    public static final int MEDIUMTEXT_ARRAY = -1;
    public static final int TINYTEXT = 7020;
    public static final int TINYTEXT_ARRAY = -1;
    public static final int TINYBLOB = 7023;
    public static final int MEDIUMBLOB = 7022;
    public static final int LONGBLOB = 7021;
    private static final Map<Integer, String> OID_TO_NAME_MAP = new HashMap<Integer, String>(100);
    private static final Map<String, Integer> NAME_TO_OID_MAP = new HashMap<String, Integer>(100);

    public static String toString(int _oid) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String name = OID_TO_NAME_MAP.get(_oid);
        if (name == null) {
            name = "<unknown:" + _oid + ">";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return name;
    }

    public static int valueOf(String _oid) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_oid.length() > 0 && !Character.isDigit(_oid.charAt(0))) {
            Integer id = NAME_TO_OID_MAP.get(_oid);
            if (id == null) {
                id = NAME_TO_OID_MAP.get(_oid.toUpperCase());
            }
            if (id != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return id;
            }
        } else {
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return (int)Long.parseLong(_oid);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("_oid type {0} not known and not a number", _oid), KSQLState.INVALID_PARAMETER_VALUE);
    }

    static {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (Field _field : Oid.class.getFields()) {
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int _oid = _field.getInt(null);
                String name = _field.getName().toUpperCase();
                OID_TO_NAME_MAP.put(_oid, name);
                NAME_TO_OID_MAP.put(name, _oid);
            }
            catch (IllegalAccessException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
    }
}

