/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.zhipu.oapi.service.v4.deserialize.MessageDeserializeFactory;
import com.zhipu.oapi.utils.StringUtils;
import java.util.concurrent.ExecutorService;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public abstract class ClientBaseService {
    protected static final Logger logger = LoggerFactory.getLogger(ClientBaseService.class);
    protected static final ObjectMapper mapper = MessageDeserializeFactory.defaultObjectMapper();
    protected final Retrofit retrofit;

    public ClientBaseService(OkHttpClient client, String baseUrl) {
        this.retrofit = ClientBaseService.defaultRetrofit(baseUrl, client, mapper);
        ExecutorService executorService = client.dispatcher().executorService();
    }

    private static Retrofit defaultRetrofit(String baseUrl, OkHttpClient client, ObjectMapper mapper) {
        return new Retrofit.Builder().baseUrl(StringUtils.isEmpty(baseUrl) ? "https://open.bigmodel.cn/api/paas/v4/" : baseUrl).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
    }
}

