/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.utils;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StringUtils {
    public static boolean isEmpty(String str) {
        return null == str || "".equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return null != str && !"".equals(str.trim());
    }

    public static String formatString(String tpl, Map<String, String> params) {
        List paramWrappers = params.entrySet().stream().map(StringUtils::toWrapper).collect(Collectors.toList());
        paramWrappers.stream().forEach(x -> {
            int idx;
            String placeHolderName = String.format("{%s}", x.key);
            x.idxInTpl = idx = tpl.indexOf(placeHolderName);
        });
        List sortedValues = paramWrappers.stream().sorted(Comparator.comparing(KvWrapper::getIdxInTpl)).map(x -> x.getValue()).collect(Collectors.toList());
        String standardTpl = tpl;
        for (String s : params.keySet()) {
            String.format("{%s}", s);
            String placeHolderName = String.format("{%s}", s);
            standardTpl = standardTpl.replace(placeHolderName, "%s");
        }
        return String.format(standardTpl, sortedValues.toArray());
    }

    public static String formatString(String tpl, String placeHolderPrefix, String placeHolderSuffix, Map<String, String> params) {
        List paramWrappers = params.entrySet().stream().map(StringUtils::toWrapper).collect(Collectors.toList());
        paramWrappers.stream().forEach(x -> {
            int idx;
            String placeHolderName = placeHolderPrefix + x.key + placeHolderSuffix;
            x.idxInTpl = idx = tpl.indexOf(placeHolderName);
        });
        List sortedValues = paramWrappers.stream().sorted(Comparator.comparing(KvWrapper::getIdxInTpl)).map(x -> x.getValue()).collect(Collectors.toList());
        String standardTpl = tpl;
        for (String s : params.keySet()) {
            String placeHolderName = placeHolderPrefix + s + placeHolderSuffix;
            standardTpl = standardTpl.replace(placeHolderName, "%s");
        }
        return String.format(standardTpl, sortedValues.toArray());
    }

    private static KvWrapper toWrapper(Map.Entry<String, String> kv) {
        KvWrapper wrapper = new KvWrapper();
        wrapper.key = kv.getKey();
        wrapper.value = kv.getValue();
        return wrapper;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("name", "wangxiaodong");
        String result = StringUtils.formatString("My name is {name}", params1);
        System.out.println(result);
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("name", "kunkun");
        params2.put("like1", "sing");
        params2.put("like2", "hop");
        params2.put("like3", "basketball");
        result = StringUtils.formatString("My name is {name}, I like {like1}, {like2}, {like3}", params2);
        System.out.println(result);
        result = StringUtils.formatString("My name is {name}, I like {like1}, {like2}, {like3}", "{", "}", params2);
        System.out.println(result);
    }

    private static class KvWrapper {
        String key;
        String value;
        int idxInTpl;

        private KvWrapper() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public int getIdxInTpl() {
            return this.idxInTpl;
        }

        public void setIdxInTpl(int idxInTpl) {
            this.idxInTpl = idxInTpl;
        }
    }
}

